/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.shedlock.spring.aop;

import java.time.Duration;
import net.javacrumbs.shedlock.core.LockProvider;
import org.springframework.aop.framework.autoproxy.AbstractBeanFactoryAwareAdvisingPostProcessor;
import org.springframework.aop.support.AbstractPointcutAdvisor;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.context.EmbeddedValueResolverAware;
import org.springframework.util.StringValueResolver;

abstract class AbstractProxyScheduledLockAopBeanPostProcessor
extends AbstractBeanFactoryAwareAdvisingPostProcessor
implements BeanPostProcessor,
EmbeddedValueResolverAware,
InitializingBean {
    private final String defaultLockAtMostFor;
    private final String defaultLockAtLeastFor;
    private BeanFactory beanFactory;
    private StringValueResolver resolver;
    private LockProvider lockProvider;

    AbstractProxyScheduledLockAopBeanPostProcessor(String defaultLockAtMostFor, String defaultLockAtLeastFor) {
        this.defaultLockAtMostFor = defaultLockAtMostFor;
        this.defaultLockAtLeastFor = defaultLockAtLeastFor;
    }

    public void setEmbeddedValueResolver(StringValueResolver resolver) {
        this.resolver = resolver;
    }

    public void setBeanFactory(BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) {
        this.advisor = this.getAdvisor(this.lockProvider);
        return super.postProcessAfterInitialization(bean, beanName);
    }

    protected abstract AbstractPointcutAdvisor getAdvisor(LockProvider var1);

    protected Duration defaultLockAtLeastForDuration() {
        return this.toDuration(this.defaultLockAtLeastFor);
    }

    protected Duration defaultLockAtMostForDuration() {
        return this.toDuration(this.defaultLockAtMostFor);
    }

    protected StringValueResolver getResolver() {
        return this.resolver;
    }

    public void afterPropertiesSet() {
        if (this.lockProvider == null) {
            this.lockProvider = (LockProvider)this.beanFactory.getBean(LockProvider.class);
        }
    }

    private Duration toDuration(String string) {
        return Duration.parse(this.resolver.resolveStringValue(string));
    }

    public LockProvider getLockProvider() {
        return this.lockProvider;
    }

    public void setLockProvider(LockProvider lockProvider) {
        this.lockProvider = lockProvider;
    }
}

