/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.swagger2.mappers;

import io.swagger.models.ArrayModel;
import io.swagger.models.Model;
import io.swagger.models.ModelImpl;
import io.swagger.models.RefModel;
import io.swagger.models.parameters.BodyParameter;
import io.swagger.models.parameters.Parameter;
import io.swagger.models.properties.FileProperty;
import io.swagger.models.properties.Property;
import org.mapstruct.Mapper;
import springfox.documentation.schema.ModelReference;
import springfox.documentation.schema.Types;
import springfox.documentation.swagger2.mappers.EnumMapper;
import springfox.documentation.swagger2.mappers.Properties;
import springfox.documentation.swagger2.mappers.SerializableParameterFactories;

@Mapper
public class ParameterMapper {
    public Parameter mapParameter(springfox.documentation.service.Parameter source) {
        Parameter bodyParameter = this.bodyParameter(source);
        return (Parameter)SerializableParameterFactories.create(source).or((Object)bodyParameter);
    }

    private Parameter bodyParameter(springfox.documentation.service.Parameter source) {
        BodyParameter parameter = new BodyParameter().description(source.getDescription()).name(source.getName()).schema(this.fromModelRef(source.getModelRef()));
        parameter.setIn(source.getParamType());
        parameter.setAccess(source.getParamAccess());
        parameter.setPattern(source.getPattern());
        parameter.setRequired(source.isRequired().booleanValue());
        return parameter;
    }

    Model fromModelRef(ModelReference modelRef) {
        if (modelRef.isCollection()) {
            if (modelRef.getItemType().equals("byte")) {
                ModelImpl baseModel = new ModelImpl();
                baseModel.setType("string");
                baseModel.setFormat("byte");
                return EnumMapper.maybeAddAllowableValuesToParameter(baseModel, modelRef.getAllowableValues());
            }
            if (modelRef.getItemType().equals("file")) {
                ArrayModel files = new ArrayModel();
                files.items((Property)new FileProperty());
                return files;
            }
            ModelReference itemModel = (ModelReference)modelRef.itemModel().get();
            return new ArrayModel().items(EnumMapper.maybeAddAllowableValues(Properties.itemTypeProperty(itemModel), itemModel.getAllowableValues()));
        }
        if (modelRef.isMap()) {
            ModelImpl baseModel = new ModelImpl();
            ModelReference itemModel = (ModelReference)modelRef.itemModel().get();
            baseModel.additionalProperties(EnumMapper.maybeAddAllowableValues(Properties.itemTypeProperty(itemModel), itemModel.getAllowableValues()));
            return baseModel;
        }
        if (Types.isBaseType((String)modelRef.getType())) {
            Property property = Properties.property(modelRef.getType());
            ModelImpl baseModel = new ModelImpl();
            baseModel.setType(property.getType());
            baseModel.setFormat(property.getFormat());
            return EnumMapper.maybeAddAllowableValuesToParameter(baseModel, modelRef.getAllowableValues());
        }
        return new RefModel(modelRef.getType());
    }
}

