/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.schema.property;

import com.fasterxml.classmate.ResolvedType;
import com.google.common.base.Optional;
import springfox.documentation.schema.ResolvedTypes;
import springfox.documentation.schema.property.ModelProperty;
import springfox.documentation.service.AllowableValues;
import springfox.documentation.spi.schema.AlternateTypeProvider;

public abstract class BaseModelProperty
implements ModelProperty {
    private final String name;
    protected final AlternateTypeProvider alternateTypeProvider;

    public BaseModelProperty(String name, AlternateTypeProvider alternateTypeProvider) {
        this.name = name;
        this.alternateTypeProvider = alternateTypeProvider;
    }

    protected abstract ResolvedType realType();

    @Override
    public ResolvedType getType() {
        return this.alternateTypeProvider.alternateFor(this.realType());
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String qualifiedTypeName() {
        if (this.getType().getTypeParameters().size() > 0) {
            return this.getType().toString();
        }
        return ResolvedTypes.simpleQualifiedTypeName(this.getType());
    }

    @Override
    public AllowableValues allowableValues() {
        Optional allowableValues = Optional.fromNullable((Object)ResolvedTypes.allowableValues(this.getType()));
        if (allowableValues.isPresent()) {
            return (AllowableValues)allowableValues.get();
        }
        return null;
    }

    @Override
    public boolean isRequired() {
        return false;
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public String propertyDescription() {
        return null;
    }

    @Override
    public int position() {
        return 0;
    }
}

