/*
 * Decompiled with CFR 0.152.
 */
package springfox.bean.validators.plugins.parameter;

import java.util.Optional;
import javax.validation.constraints.NotBlank;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spi.service.ExpandedParameterBuilderPlugin;
import springfox.documentation.spi.service.contexts.ParameterExpansionContext;

@Component
@Order(value=-2147483148)
public class ExpandedParameterNotBlankAnnotationPlugin
implements ExpandedParameterBuilderPlugin {
    private static final Logger LOG = LoggerFactory.getLogger(ExpandedParameterNotBlankAnnotationPlugin.class);

    public boolean supports(DocumentationType delimiter) {
        return true;
    }

    public void apply(ParameterExpansionContext context) {
        Optional notBlank = context.findAnnotation(NotBlank.class);
        if (notBlank.isPresent()) {
            LOG.debug("@NotBlank present: setting parameter as required and not allowing empty values");
            context.getParameterBuilder().required(true);
        }
    }
}

