/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.redis.datasource.search;

import io.quarkus.redis.datasource.RedisCommandExtraArguments;
import io.quarkus.redis.datasource.search.FieldOptions;
import io.quarkus.redis.datasource.search.FieldType;
import io.quarkus.redis.datasource.search.IndexedField;
import io.quarkus.redis.runtime.datasource.Validation;
import io.smallrye.mutiny.helpers.ParameterValidation;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class CreateArgs
implements RedisCommandExtraArguments {
    private boolean onJson;
    private boolean onHash;
    private String[] prefixes;
    private String filter;
    private String language;
    private String languageField;
    private double score = -1.0;
    private String scoreField;
    private String payloadField;
    private boolean maxTextFields;
    private boolean noOffsets;
    private Duration temporary;
    private boolean noHl;
    private boolean noFields;
    private boolean noFreqs;
    private String[] stopWords;
    private boolean skipInitialScan;
    private final List<IndexedField> schema = new ArrayList<IndexedField>();

    public CreateArgs onHash() {
        this.onHash = true;
        return this;
    }

    public CreateArgs onJson() {
        this.onJson = true;
        return this;
    }

    public CreateArgs prefixes(String ... prefixes) {
        this.prefixes = (String[])ParameterValidation.doesNotContainNull((Object[])Validation.notNullOrEmpty(prefixes, "prefixes"), (String)"prefixes");
        return this;
    }

    public CreateArgs filter(String filter) {
        this.filter = Validation.notNullOrBlank(filter, "filter");
        return this;
    }

    public CreateArgs language(String language) {
        this.language = Validation.notNullOrBlank(language, "language");
        return this;
    }

    public CreateArgs languageField(String languageField) {
        this.languageField = Validation.notNullOrBlank(languageField, "languageField");
        return this;
    }

    public CreateArgs score(double score) {
        Validation.positive(score, "score");
        this.score = score;
        return this;
    }

    public CreateArgs scoreField(String field) {
        this.scoreField = Validation.notNullOrBlank(field, "field");
        return this;
    }

    public CreateArgs payloadField(String field) {
        this.payloadField = Validation.notNullOrBlank(field, "field");
        return this;
    }

    public CreateArgs maxTextFields() {
        this.maxTextFields = true;
        return this;
    }

    public CreateArgs noOffsets() {
        this.noOffsets = true;
        return this;
    }

    public CreateArgs temporary(Duration duration) {
        this.temporary = ParameterValidation.validate((Duration)duration, (String)"duration");
        return this;
    }

    public CreateArgs noHl() {
        this.noHl = true;
        return this;
    }

    public CreateArgs noFields() {
        this.noFields = true;
        return this;
    }

    public CreateArgs noFreqs() {
        this.noFreqs = true;
        return this;
    }

    public CreateArgs stopWords(String ... words) {
        this.stopWords = (String[])ParameterValidation.doesNotContainNull((Object[])Validation.notNullOrEmpty(words, "words"), (String)"words");
        return this;
    }

    public CreateArgs skipInitialScan() {
        this.skipInitialScan = true;
        return this;
    }

    public CreateArgs indexedField(String field, String alias, FieldType type, FieldOptions options) {
        this.schema.add(new IndexedField(field, alias, type, options));
        return this;
    }

    public CreateArgs indexedField(String field, FieldType type, FieldOptions options) {
        return this.indexedField(field, null, type, options);
    }

    public CreateArgs indexedField(String field, FieldType type) {
        return this.indexedField(field, null, type, null);
    }

    public CreateArgs indexedField(String field, String alias, FieldType type) {
        return this.indexedField(field, alias, type, null);
    }

    @Override
    public List<Object> toArgs() {
        ArrayList<Object> list = new ArrayList<Object>();
        if (this.onHash) {
            if (this.onJson) {
                throw new IllegalArgumentException("Cannot use `ON HASH` and `ON JSON` at the same time");
            }
            list.add("ON");
            list.add("HASH");
        }
        if (this.onJson) {
            list.add("ON");
            list.add("JSON");
        }
        if (this.prefixes != null && this.prefixes.length > 0) {
            list.add("PREFIX");
            list.add(Integer.toString(this.prefixes.length));
            list.addAll(Arrays.asList(this.prefixes));
        }
        if (this.filter != null) {
            list.add("FILTER");
            list.add(this.filter);
        }
        if (this.language != null) {
            list.add("LANGUAGE");
            list.add(this.language);
        }
        if (this.languageField != null) {
            list.add("LANGUAGE_FIELD");
            list.add(this.languageField);
        }
        if (this.score > 0.0) {
            list.add("SCORE");
            list.add(Double.toString(this.score));
        }
        if (this.scoreField != null) {
            list.add("SCORE_FIELD");
            list.add(this.scoreField);
        }
        if (this.payloadField != null) {
            list.add("PAYLOAD_FIELD");
            list.add(this.payloadField);
        }
        if (this.maxTextFields) {
            list.add("MAXTEXTFIELDS");
        }
        if (this.temporary != null) {
            list.add("TEMPORARY");
            list.add(Long.toString(this.temporary.toSeconds()));
        }
        if (this.noOffsets) {
            list.add("NOOFFSETS");
        }
        if (this.noHl) {
            list.add("NOHL");
        }
        if (this.noFields) {
            list.add("NOFIELDS");
        }
        if (this.noFreqs) {
            list.add("NOFREQS");
        }
        if (this.stopWords != null && this.stopWords.length > 0) {
            list.add("STOPWORDS");
            list.add(Integer.toString(this.stopWords.length));
            Collections.addAll(list, this.stopWords);
        }
        if (this.skipInitialScan) {
            list.add("SKIPINITIALSCAN");
        }
        if (this.schema.isEmpty()) {
            throw new IllegalArgumentException("The schema cannot be empty, you configure the indexed fields");
        }
        list.add("SCHEMA");
        for (IndexedField field : this.schema) {
            list.addAll(field.toArgs());
        }
        return list;
    }
}

