/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.test.junit;

import io.quarkus.test.common.TestResourceManager;
import io.quarkus.test.junit.QuarkusTestExtension;
import java.io.Closeable;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.concurrent.atomic.AtomicBoolean;
import org.junit.jupiter.api.extension.ExtensionContext;

public class QuarkusTestExtensionState
implements ExtensionContext.Store.CloseableResource {
    private final AtomicBoolean closed = new AtomicBoolean();
    protected final Closeable testResourceManager;
    protected final Closeable resource;
    private Thread shutdownHook;
    private final Runnable clearCallbacks;
    private Throwable testErrorCause;

    public static QuarkusTestExtensionState clone(Object state) {
        try {
            Class<?> clazz = state.getClass();
            Method trmm = clazz.getMethod("getTestResourceManager", new Class[0]);
            Closeable trm = (Closeable)trmm.invoke(state, new Object[0]);
            Method rmm = clazz.getMethod("getResource", new Class[0]);
            Closeable resource = (Closeable)rmm.invoke(state, new Object[0]);
            Method shm = clazz.getMethod("getShutdownHook", new Class[0]);
            Thread shutdownHook = (Thread)shm.invoke(state, new Object[0]);
            Method ccm = clazz.getMethod("getClearCallbacksRunner", new Class[0]);
            Runnable clearCallbacks = (Runnable)ccm.invoke(state, new Object[0]);
            if (clazz.getName().equals(QuarkusTestExtension.ExtensionState.class.getName())) {
                QuarkusTestExtension.ExtensionState answer = new QuarkusTestExtension.ExtensionState(trm, resource, clearCallbacks, shutdownHook);
                return answer;
            }
            if (clazz.getName().equals(QuarkusTestExtensionState.class.getName())) {
                QuarkusTestExtensionState answer = new QuarkusTestExtensionState(trm, resource, clearCallbacks, shutdownHook);
                return answer;
            }
            throw new UnsupportedOperationException("Not implemented. Cannot clone a state subclass of " + String.valueOf(clazz));
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public Closeable getTestResourceManager() {
        return this.testResourceManager;
    }

    public Closeable getResource() {
        return this.resource;
    }

    public Thread getShutdownHook() {
        return this.shutdownHook;
    }

    public Runnable getClearCallbacksRunner() {
        return this.clearCallbacks;
    }

    public QuarkusTestExtensionState(Closeable testResourceManager, Closeable resource, Runnable clearCallbacks) {
        this.testResourceManager = testResourceManager;
        this.resource = resource;
        this.clearCallbacks = clearCallbacks;
        this.shutdownHook = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    QuarkusTestExtensionState.this.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }, "Quarkus Test Cleanup Shutdown task");
        Runtime.getRuntime().addShutdownHook(this.shutdownHook);
    }

    public QuarkusTestExtensionState(Closeable testResourceManager, Closeable resource, Runnable clearCallbacks, Thread shutdownHook) {
        this.testResourceManager = testResourceManager;
        this.resource = resource;
        this.clearCallbacks = clearCallbacks;
        this.shutdownHook = shutdownHook;
    }

    public Throwable getTestErrorCause() {
        return this.testErrorCause;
    }

    public void close() throws IOException {
        if (this.closed.compareAndSet(false, true)) {
            this.doClose();
            this.clearCallbacks.run();
            try {
                Runtime.getRuntime().removeShutdownHook(this.shutdownHook);
            }
            catch (Throwable throwable) {
            }
            finally {
                this.shutdownHook = null;
            }
        }
    }

    protected void setTestFailed(Throwable failure) {
        try {
            this.testErrorCause = failure;
            if (this.testResourceManager instanceof TestResourceManager) {
                ((TestResourceManager)this.testResourceManager).setTestErrorCause(this.testErrorCause);
            } else {
                this.testResourceManager.getClass().getClassLoader().loadClass(TestResourceManager.class.getName()).getMethod("setTestErrorCause", Throwable.class).invoke((Object)this.testResourceManager, this.testErrorCause);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected void doClose() throws IOException {
    }
}

