/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.cache.runtime.dev.ui;

import io.quarkus.cache.Cache;
import io.quarkus.cache.CacheManager;
import io.quarkus.cache.CaffeineCache;
import io.quarkus.cache.runtime.caffeine.CaffeineCacheImpl;
import io.smallrye.common.annotation.NonBlocking;
import io.smallrye.mutiny.Uni;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Optional;

@ApplicationScoped
public class CacheJsonRPCService {
    @Inject
    CacheManager manager;

    @NonBlocking
    public JsonArray getAll() {
        Collection names = this.manager.getCacheNames();
        ArrayList<CaffeineCache> allCaches = new ArrayList<CaffeineCache>(names.size());
        for (String name : names) {
            Optional cache = this.manager.getCache(name);
            if (!cache.isPresent() || !(cache.get() instanceof CaffeineCache)) continue;
            allCaches.add((CaffeineCache)cache.get());
        }
        allCaches.sort(Comparator.comparing(Cache::getName));
        JsonArray array = new JsonArray();
        for (CaffeineCache cc : allCaches) {
            array.add((Object)this.getJsonRepresentationForCache((Cache)cc));
        }
        return array;
    }

    private JsonObject getJsonRepresentationForCache(Cache cc) {
        return new JsonObject().put("name", (Object)cc.getName()).put("size", (Object)((CaffeineCacheImpl)cc).getSize());
    }

    public Uni<JsonObject> clear(String name) {
        Optional cache = this.manager.getCache(name);
        if (cache.isPresent()) {
            return ((Cache)cache.get()).invalidateAll().map(t -> this.getJsonRepresentationForCache((Cache)cache.get()));
        }
        return Uni.createFrom().item((Object)new JsonObject().put("name", (Object)name).put("size", (Object)-1));
    }

    @NonBlocking
    public JsonObject refresh(String name) {
        Optional cache = this.manager.getCache(name);
        if (cache.isPresent()) {
            return this.getJsonRepresentationForCache((Cache)cache.get());
        }
        return new JsonObject().put("name", (Object)name).put("size", (Object)-1);
    }

    public JsonArray getKeys(String name) {
        Optional cache = this.manager.getCache(name);
        if (cache.isPresent()) {
            CaffeineCache caffeineCache = (CaffeineCache)cache.get();
            JsonArray keys = new JsonArray();
            for (Object key : caffeineCache.keySet()) {
                keys.add((Object)key.toString());
            }
            return keys;
        }
        return JsonArray.of((Object[])new Object[0]);
    }
}

