/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.dns;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.socket.DatagramPacket;
import io.netty.handler.codec.MessageToMessageEncoder;
import io.netty.handler.codec.dns.DnsHeader;
import io.netty.handler.codec.dns.DnsQuery;
import io.netty.handler.codec.dns.DnsQuestion;
import io.netty.handler.codec.dns.DnsResource;
import io.netty.util.CharsetUtil;
import io.netty.util.internal.StringUtil;
import java.nio.charset.Charset;
import java.util.List;

@ChannelHandler.Sharable
public class DnsQueryEncoder
extends MessageToMessageEncoder<DnsQuery> {
    @Override
    protected void encode(ChannelHandlerContext ctx, DnsQuery query, List<Object> out) throws Exception {
        ByteBuf buf = ctx.alloc().buffer();
        DnsQueryEncoder.encodeHeader(query.header(), buf);
        List<DnsQuestion> questions = query.questions();
        for (DnsQuestion question : questions) {
            DnsQueryEncoder.encodeQuestion(question, CharsetUtil.US_ASCII, buf);
        }
        for (DnsResource resource : query.additionalResources()) {
            DnsQueryEncoder.encodeResource(resource, CharsetUtil.US_ASCII, buf);
        }
        out.add(new DatagramPacket(buf, query.recipient(), null));
    }

    private static void encodeHeader(DnsHeader header, ByteBuf buf) {
        buf.writeShort(header.id());
        int flags = 0;
        flags |= header.type() << 15;
        flags |= header.opcode() << 14;
        buf.writeShort(flags |= header.isRecursionDesired() ? 256 : 0);
        buf.writeShort(header.questionCount());
        buf.writeShort(0);
        buf.writeShort(0);
        buf.writeShort(header.additionalResourceCount());
    }

    private static void encodeQuestion(DnsQuestion question, Charset charset, ByteBuf buf) {
        DnsQueryEncoder.encodeName(question.name(), charset, buf);
        buf.writeShort(question.type().intValue());
        buf.writeShort(question.dnsClass().intValue());
    }

    private static void encodeResource(DnsResource resource, Charset charset, ByteBuf buf) {
        DnsQueryEncoder.encodeName(resource.name(), charset, buf);
        buf.writeShort(resource.type().intValue());
        buf.writeShort(resource.dnsClass().intValue());
        buf.writeInt((int)resource.timeToLive());
        ByteBuf content = resource.content();
        int contentLen = content.readableBytes();
        buf.writeShort(contentLen);
        buf.writeBytes(content, content.readerIndex(), contentLen);
    }

    private static void encodeName(String name, Charset charset, ByteBuf buf) {
        String[] parts;
        for (String part : parts = StringUtil.split(name, '.')) {
            int partLen = part.length();
            if (partLen == 0) continue;
            buf.writeByte(partLen);
            buf.writeBytes(part.getBytes(charset));
        }
        buf.writeByte(0);
    }
}

