/*
 * Decompiled with CFR 0.152.
 */
package ink.aos.module.dingtalk.service;

import com.fasterxml.jackson.databind.ObjectMapper;
import ink.aos.module.dingtalk.dto.AccessToken;
import ink.aos.module.dingtalk.dto.UserInfo;
import ink.aos.module.dingtalk.util.HttpClient;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.Cache;
import org.springframework.cache.CacheManager;

public class DingtalkService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private ObjectMapper objectMapper = new ObjectMapper();
    @Autowired
    private CacheManager cacheManager;

    public AccessToken getAccessToken(String appkey, String appsecret) {
        Cache.ValueWrapper valueWrapper = this.cacheManager.getCache("_aos_dingtalk_" + appkey).get((Object)"access_token");
        if (valueWrapper != null) {
            AccessToken accessToken = (AccessToken)valueWrapper.get();
            if (System.currentTimeMillis() < accessToken.getEndTime()) {
                return accessToken;
            }
        }
        return this.newAccessToken(appkey, appsecret);
    }

    private AccessToken newAccessToken(String appkey, String appsecret) {
        AccessToken accessToken = null;
        String _url = "https://oapi.dingtalk.com/gettoken?appkey=APPKEY&appsecret=APPSECRET".replaceAll("APPKEY", appkey).replaceAll("APPSECRET", appsecret);
        String re = HttpClient.doGet(_url);
        try {
            accessToken = (AccessToken)this.objectMapper.readValue(re, AccessToken.class);
            Long time = System.currentTimeMillis() + 7140000L;
            accessToken.setEndTime(time);
        }
        catch (IOException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
        return accessToken;
    }

    public UserInfo getUserInfo(AccessToken accessToken, String code) {
        String _url = "https://oapi.dingtalk.com/user/getuserinfo?access_token=ACCESS_TOKEN&code=CODE".replaceAll("ACCESS_TOKEN", accessToken.getAccessToken()).replaceAll("CODE", code);
        String re = HttpClient.doGet(_url);
        UserInfo userInfo = null;
        try {
            userInfo = (UserInfo)this.objectMapper.readValue(re, UserInfo.class);
        }
        catch (IOException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
        return userInfo;
    }
}

