/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.boot.admin.server.web;

import com.fasterxml.jackson.annotation.JsonInclude;
import de.codecentric.boot.admin.server.domain.entities.Instance;
import de.codecentric.boot.admin.server.domain.values.InstanceId;
import de.codecentric.boot.admin.server.web.client.InstanceWebClient;
import de.codecentric.boot.admin.server.web.client.exception.ResolveEndpointException;
import io.netty.handler.timeout.ReadTimeoutException;
import java.io.IOException;
import java.net.URI;
import java.util.concurrent.TimeoutException;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.client.reactive.ClientHttpRequest;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.BodyInserter;
import org.springframework.web.reactive.function.client.ClientResponse;
import org.springframework.web.reactive.function.client.ExchangeStrategies;
import org.springframework.web.reactive.function.client.WebClient;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.util.function.Tuples;

public class InstanceWebProxy {
    private static final Logger log = LoggerFactory.getLogger(InstanceWebProxy.class);
    private final InstanceWebClient instanceWebClient;
    private final ExchangeStrategies strategies = ExchangeStrategies.withDefaults();

    public InstanceWebProxy(InstanceWebClient instanceWebClient) {
        this.instanceWebClient = instanceWebClient;
    }

    public Mono<ClientResponse> forward(Mono<Instance> instance, URI uri, HttpMethod method, HttpHeaders headers, BodyInserter<?, ? super ClientHttpRequest> bodyInserter) {
        return instance.flatMap(i -> this.forward((Instance)i, uri, method, headers, bodyInserter)).switchIfEmpty(Mono.fromSupplier(() -> ClientResponse.create((HttpStatus)HttpStatus.SERVICE_UNAVAILABLE, (ExchangeStrategies)this.strategies).build()));
    }

    public Mono<ClientResponse> forward(Instance instance, URI uri, HttpMethod method, HttpHeaders headers, BodyInserter<?, ? super ClientHttpRequest> bodyInserter) {
        WebClient.RequestBodySpec bodySpec;
        log.trace("Proxy-Request for instance {} with URL '{}'", (Object)instance.getId(), (Object)uri);
        WebClient.RequestBodySpec headersSpec = bodySpec = (WebClient.RequestBodySpec)((WebClient.RequestBodySpec)this.instanceWebClient.instance(instance).method(method).uri(uri)).headers(h -> h.addAll((MultiValueMap)headers));
        if (this.requiresBody(method)) {
            headersSpec = bodySpec.body(bodyInserter);
        }
        return headersSpec.exchange().onErrorResume(ex -> ex instanceof ReadTimeoutException || ex instanceof TimeoutException, ex -> Mono.fromSupplier(() -> {
            log.trace("Timeout for Proxy-Request for instance {} with URL '{}'", (Object)instance.getId(), (Object)uri);
            return ClientResponse.create((HttpStatus)HttpStatus.GATEWAY_TIMEOUT, (ExchangeStrategies)this.strategies).build();
        })).onErrorResume(ResolveEndpointException.class, ex -> Mono.fromSupplier(() -> {
            log.trace("No Endpoint found for Proxy-Request for instance {} with URL '{}'", (Object)instance.getId(), (Object)uri);
            return ClientResponse.create((HttpStatus)HttpStatus.NOT_FOUND, (ExchangeStrategies)this.strategies).build();
        })).onErrorResume(IOException.class, ex -> Mono.fromSupplier(() -> {
            log.trace("Proxy-Request for instance {} with URL '{}' errored", new Object[]{instance.getId(), uri, ex});
            return ClientResponse.create((HttpStatus)HttpStatus.BAD_GATEWAY, (ExchangeStrategies)this.strategies).build();
        }));
    }

    public Flux<InstanceResponse> forward(Flux<Instance> instances, URI uri, HttpMethod method, HttpHeaders headers, BodyInserter<?, ? super ClientHttpRequest> bodyInserter) {
        return instances.flatMap(instance -> this.forward((Instance)instance, uri, method, headers, bodyInserter).map(clientResponse -> Tuples.of((Object)instance.getId(), (Object)clientResponse))).flatMap(t -> {
            ClientResponse clientResponse = (ClientResponse)t.getT2();
            InstanceResponse.Builder response = InstanceResponse.builder().instanceId((InstanceId)t.getT1()).status(clientResponse.rawStatusCode()).contentType(String.join((CharSequence)", ", clientResponse.headers().header("Content-Type")));
            return clientResponse.bodyToMono(String.class).map(response::body).defaultIfEmpty((Object)response).map(InstanceResponse.Builder::build);
        });
    }

    private boolean requiresBody(HttpMethod method) {
        switch (method) {
            case PUT: 
            case POST: 
            case PATCH: {
                return true;
            }
        }
        return false;
    }

    public static class InstanceResponse {
        private final InstanceId instanceId;
        private final int status;
        @Nullable
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        private final String body;
        @Nullable
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        private final String contentType;

        InstanceResponse(InstanceId instanceId, int status, @Nullable String body, @Nullable String contentType) {
            this.instanceId = instanceId;
            this.status = status;
            this.body = body;
            this.contentType = contentType;
        }

        public static Builder builder() {
            return new Builder();
        }

        public InstanceId getInstanceId() {
            return this.instanceId;
        }

        public int getStatus() {
            return this.status;
        }

        @Nullable
        public String getBody() {
            return this.body;
        }

        @Nullable
        public String getContentType() {
            return this.contentType;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof InstanceResponse)) {
                return false;
            }
            InstanceResponse other = (InstanceResponse)o;
            if (!other.canEqual(this)) {
                return false;
            }
            InstanceId this$instanceId = this.getInstanceId();
            InstanceId other$instanceId = other.getInstanceId();
            if (this$instanceId == null ? other$instanceId != null : !((Object)this$instanceId).equals(other$instanceId)) {
                return false;
            }
            if (this.getStatus() != other.getStatus()) {
                return false;
            }
            String this$body = this.getBody();
            String other$body = other.getBody();
            if (this$body == null ? other$body != null : !this$body.equals(other$body)) {
                return false;
            }
            String this$contentType = this.getContentType();
            String other$contentType = other.getContentType();
            return !(this$contentType == null ? other$contentType != null : !this$contentType.equals(other$contentType));
        }

        protected boolean canEqual(Object other) {
            return other instanceof InstanceResponse;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            InstanceId $instanceId = this.getInstanceId();
            result = result * 59 + ($instanceId == null ? 43 : ((Object)$instanceId).hashCode());
            result = result * 59 + this.getStatus();
            String $body = this.getBody();
            result = result * 59 + ($body == null ? 43 : $body.hashCode());
            String $contentType = this.getContentType();
            result = result * 59 + ($contentType == null ? 43 : $contentType.hashCode());
            return result;
        }

        public String toString() {
            return "InstanceWebProxy.InstanceResponse(instanceId=" + this.getInstanceId() + ", status=" + this.getStatus() + ", body=" + this.getBody() + ", contentType=" + this.getContentType() + ")";
        }

        public static class Builder {
            private InstanceId instanceId;
            private int status;
            private String body;
            private String contentType;

            Builder() {
            }

            public Builder instanceId(InstanceId instanceId) {
                this.instanceId = instanceId;
                return this;
            }

            public Builder status(int status) {
                this.status = status;
                return this;
            }

            public Builder body(@Nullable String body) {
                this.body = body;
                return this;
            }

            public Builder contentType(@Nullable String contentType) {
                this.contentType = contentType;
                return this;
            }

            public InstanceResponse build() {
                return new InstanceResponse(this.instanceId, this.status, this.body, this.contentType);
            }

            public String toString() {
                return "InstanceWebProxy.InstanceResponse.Builder(instanceId=" + this.instanceId + ", status=" + this.status + ", body=" + this.body + ", contentType=" + this.contentType + ")";
            }
        }
    }
}

