/*
 * Decompiled with CFR 0.152.
 */
package com.zenjava.javafx.maven.plugin;

import com.oracle.tools.packager.Bundler;
import com.oracle.tools.packager.IOUtils;
import com.oracle.tools.packager.RelativeFileSet;
import com.oracle.tools.packager.StandardBundlerParam;
import com.zenjava.javafx.maven.plugin.JavaDetectionTools;
import com.zenjava.javafx.maven.plugin.MacAppBundlerWithAdditionalResources;
import com.zenjava.javafx.maven.plugin.NativeLauncher;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.apache.maven.plugin.logging.Log;

public class Workarounds {
    private static final String JNLP_JAR_PATTERN = "(.*)href=(\".*?\")(.*)size=(\".*?\")(.*)";
    private static final String CONFIG_FILE_EXTENSION = ".cfg";
    private Log logger;
    private File nativeOutputDir;

    public Workarounds(File nativeOutputDir, Log logger) {
        this.logger = logger;
        this.nativeOutputDir = nativeOutputDir;
    }

    public Log getLog() {
        return this.logger;
    }

    public boolean isWorkaroundForBug124Needed() {
        return JavaDetectionTools.IS_JAVA_8 && JavaDetectionTools.isAtLeastOracleJavaUpdateVersion(40) || JavaDetectionTools.IS_JAVA_9;
    }

    public boolean isWorkaroundForBug167Needed() {
        return JavaDetectionTools.IS_JAVA_8 && JavaDetectionTools.isAtLeastOracleJavaUpdateVersion(60) && !JavaDetectionTools.isAtLeastOracleJavaUpdateVersion(92);
    }

    public boolean isWorkaroundForBug182Needed() {
        return File.separator.equals("\\");
    }

    public boolean isWorkaroundForBug185Needed(Map<String, Object> params) {
        return params.containsKey("jnlp.allPermisions") && Boolean.parseBoolean(String.valueOf(params.get("jnlp.allPermisions")));
    }

    public boolean isWorkaroundForBug205Needed() {
        return JavaDetectionTools.IS_JAVA_8 && JavaDetectionTools.isAtLeastOracleJavaUpdateVersion(40) || JavaDetectionTools.IS_JAVA_9;
    }

    protected void applyNativeLauncherWorkaround(String appName) {
        boolean needsWorkaround = appName.contains(".");
        if (!needsWorkaround) {
            return;
        }
        String newConfigFileName = appName.substring(0, appName.lastIndexOf("."));
        Path appPath = this.nativeOutputDir.toPath().resolve(appName).resolve("app");
        Path oldConfigFile = appPath.resolve(appName + CONFIG_FILE_EXTENSION);
        try {
            Files.move(oldConfigFile, appPath.resolve(newConfigFileName + CONFIG_FILE_EXTENSION), StandardCopyOption.ATOMIC_MOVE);
        }
        catch (IOException ex) {
            this.getLog().warn((CharSequence)"Couldn't rename configfile. Please see issue #124 of the javafx-maven-plugin for further details.", (Throwable)ex);
        }
    }

    protected Map<String, Long> getFileSizes(List<String> files) {
        HashMap<String, Long> fileSizes = new HashMap<String, Long>();
        files.stream().forEach(relativeFilePath -> {
            File file = new File(this.nativeOutputDir, (String)relativeFilePath);
            fileSizes.put((String)relativeFilePath, file.length());
        });
        return fileSizes;
    }

    public void fixFileSizesWithinGeneratedJNLPFiles() {
        List<String> jarFiles = this.getJARFilesFromJNLPFiles();
        Map<String, Long> newFileSizes = this.getFileSizes(jarFiles);
        List<File> generatedJNLPFiles = this.getGeneratedJNLPFiles();
        Pattern pattern = Pattern.compile(JNLP_JAR_PATTERN);
        generatedJNLPFiles.forEach(file -> {
            try {
                List<String> allLines = Files.readAllLines(file.toPath());
                ArrayList newLines = new ArrayList();
                allLines.stream().forEach(line -> {
                    if (line.matches(JNLP_JAR_PATTERN)) {
                        Matcher matcher = pattern.matcher((CharSequence)line);
                        matcher.find();
                        String rawJarName = matcher.group(2);
                        String jarName = rawJarName.substring(1, rawJarName.length() - 1);
                        if (newFileSizes.containsKey(jarName)) {
                            newLines.add(line.replace(matcher.group(4), "\"" + newFileSizes.get(jarName) + "\""));
                        } else {
                            newLines.add(line);
                        }
                    } else {
                        newLines.add(line);
                    }
                });
                Files.write(file.toPath(), newLines, StandardOpenOption.TRUNCATE_EXISTING);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        });
    }

    public List<File> getGeneratedJNLPFiles() {
        ArrayList<File> generatedFiles = new ArrayList<File>();
        try (Stream<Path> walkstream = Files.walk(this.nativeOutputDir.toPath(), new FileVisitOption[0]);){
            walkstream.forEach(fileEntry -> {
                File possibleJNLPFile = fileEntry.toFile();
                String fileName = possibleJNLPFile.getName();
                if (fileName.endsWith(".jnlp")) {
                    generatedFiles.add(possibleJNLPFile);
                }
            });
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return generatedFiles;
    }

    public List<String> getJARFilesFromJNLPFiles() {
        ArrayList<String> jarFiles = new ArrayList<String>();
        this.getGeneratedJNLPFiles().stream().map(jnlpFile -> jnlpFile.toPath()).forEach(jnlpPath -> {
            try {
                List<String> allLines = Files.readAllLines(jnlpPath);
                allLines.stream().filter(line -> line.trim().startsWith("<jar href=")).forEach(line -> {
                    String jarFile = line.replaceAll(JNLP_JAR_PATTERN, "$2");
                    jarFiles.add(jarFile.substring(1, jarFile.length() - 1));
                });
            }
            catch (IOException iOException) {
                // empty catch block
            }
        });
        return jarFiles;
    }

    public void fixPathsInsideJNLPFiles() {
        List<File> generatedJNLPFiles = this.getGeneratedJNLPFiles();
        Pattern pattern = Pattern.compile(JNLP_JAR_PATTERN);
        generatedJNLPFiles.forEach(file -> {
            try {
                List<String> allLines = Files.readAllLines(file.toPath());
                ArrayList newLines = new ArrayList();
                allLines.stream().forEach(line -> {
                    if (line.matches(JNLP_JAR_PATTERN)) {
                        Matcher matcher = pattern.matcher((CharSequence)line);
                        matcher.find();
                        String rawJarName = matcher.group(2);
                        newLines.add(line.replace(rawJarName, rawJarName.replaceAll("\\\\", "\\/")));
                    } else {
                        newLines.add(line);
                    }
                });
                Files.write(file.toPath(), newLines, StandardOpenOption.TRUNCATE_EXISTING);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        });
    }

    public void applyWorkaround124(String appName, List<NativeLauncher> secondaryLaunchers) {
        this.applyNativeLauncherWorkaround(appName);
        if (secondaryLaunchers != null && !secondaryLaunchers.isEmpty()) {
            secondaryLaunchers.stream().map(launcher -> launcher.getAppName()).filter(launcherAppName -> launcherAppName.contains(".")).forEach(launcherAppname -> this.applyNativeLauncherWorkaround((String)launcherAppname));
        }
    }

    public void applyWorkaround185(boolean skipSizeRecalculationForJNLP185) {
        if (!skipSizeRecalculationForJNLP185) {
            this.getLog().info((CharSequence)"Fixing sizes of JAR files within JNLP-files");
            this.fixFileSizesWithinGeneratedJNLPFiles();
        } else {
            this.getLog().info((CharSequence)"Skipped fixing sizes of JAR files within JNLP-files");
        }
    }

    public void applyWorkaround167(Map<String, Object> params) {
        if (params.containsKey("runtime")) {
            this.getLog().info((CharSequence)"Applying workaround for oracle-jdk-bug since 1.8.0u60 regarding cfg-file-format");
            params.put("launcher-cfg-format", "prop");
        }
    }

    public void applyWorkaround205(String appName, List<NativeLauncher> secondaryLaunchers, Map<String, Object> params) {
        HashSet<File> filenameFixedConfigFiles = new HashSet<File>();
        Path appPath = this.nativeOutputDir.toPath().resolve(appName).resolve("app").toAbsolutePath();
        if (appName.contains(".")) {
            String newConfigFileName = appName.substring(0, appName.lastIndexOf("."));
            File mainAppNameCfgFile = appPath.resolve(newConfigFileName + CONFIG_FILE_EXTENSION).toFile();
            if (mainAppNameCfgFile.exists()) {
                this.getLog().info((CharSequence)("Found main native application configuration file (" + mainAppNameCfgFile.toString() + ")."));
            }
            filenameFixedConfigFiles.add(mainAppNameCfgFile);
        }
        Optional.ofNullable(secondaryLaunchers).ifPresent(launchers -> launchers.stream().map(launcher -> launcher.getAppName()).forEach(secondaryLauncherAppName -> {
            if (secondaryLauncherAppName.contains(".")) {
                String newSecondaryLauncherConfigFileName = secondaryLauncherAppName.substring(0, secondaryLauncherAppName.lastIndexOf("."));
                filenameFixedConfigFiles.add(appPath.resolve(newSecondaryLauncherConfigFileName + CONFIG_FILE_EXTENSION).toFile());
            }
        }));
        if (filenameFixedConfigFiles.isEmpty()) {
            this.getLog().info((CharSequence)"No workaround for native launcher issue 205 needed. Continuing.");
            return;
        }
        this.getLog().info((CharSequence)"Applying workaround for native launcher issue 205 by modifying application resources.");
        ArrayList<RelativeFileSet> appResourcesList = new ArrayList<RelativeFileSet>();
        RelativeFileSet appResources = (RelativeFileSet)StandardBundlerParam.APP_RESOURCES.fetchFrom(params);
        appResourcesList.add(appResources);
        appResourcesList.add(new RelativeFileSet(appPath.toFile(), filenameFixedConfigFiles));
        if (JavaDetectionTools.IS_JAVA_8 && !JavaDetectionTools.isAtLeastOracleJavaUpdateVersion(60)) {
            try {
                Path tempResourcesDirectory = Files.createTempDirectory("jfxmp-workaround205-", new FileAttribute[0]).toAbsolutePath();
                File tempResourcesDirAsFile = tempResourcesDirectory.toFile();
                this.getLog().info((CharSequence)("Modifying application resources for native launcher issue 205 by copying into temporary folder (" + tempResourcesDirAsFile.toString() + ")."));
                for (RelativeFileSet sources : appResourcesList) {
                    File baseDir = sources.getBaseDirectory();
                    for (String fname : appResources.getIncludedFiles()) {
                        IOUtils.copyFile((File)new File(baseDir, fname), (File)new File(tempResourcesDirAsFile, fname));
                    }
                }
                tempResourcesDirAsFile.deleteOnExit();
                HashSet fixedResourceFiles = new HashSet();
                try (Stream<Path> walkstream = Files.walk(tempResourcesDirectory, new FileVisitOption[0]);){
                    walkstream.map(p -> p.toFile()).filter(File::isFile).filter(File::canRead).forEach(f -> {
                        this.getLog().info((CharSequence)String.format("Add %s file to application resources.", f));
                        fixedResourceFiles.add(f);
                    });
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                params.put(StandardBundlerParam.APP_RESOURCES.getID(), new RelativeFileSet(tempResourcesDirAsFile, fixedResourceFiles));
            }
            catch (IOException ex) {
                this.getLog().warn((Throwable)ex);
            }
            return;
        }
        params.put(StandardBundlerParam.APP_RESOURCES.getID() + "List", appResourcesList);
    }

    public boolean isWorkaroundForNativeMacBundlerNeeded(File additionalBundlerResources) {
        boolean isMac = System.getProperty("os.name").toLowerCase().contains("os x");
        boolean hasBundlerResources = additionalBundlerResources != null && additionalBundlerResources.isDirectory() && additionalBundlerResources.exists();
        return isMac && hasBundlerResources;
    }

    public Bundler applyWorkaroundForNativeMacBundler(Bundler b, String currentRunningBundlerID, Map<String, Object> params, File additionalBundlerResources) {
        String workaroundForNativeMacBundlerDoneMarker = "WorkaroundForNativeMacBundler.done";
        if ("mac.app".equals(currentRunningBundlerID) && !params.containsKey(workaroundForNativeMacBundlerDoneMarker)) {
            MacAppBundlerWithAdditionalResources specialMacBundler = new MacAppBundlerWithAdditionalResources();
            this.getLog().info((CharSequence)"Setting replacement of the 'mac.app'-bundler.");
            params.put("mac.app.bundler", (Object)specialMacBundler);
            params.put(workaroundForNativeMacBundlerDoneMarker, true);
            Path specificFolder = additionalBundlerResources.toPath().resolve("mac.app");
            if (Files.exists(specificFolder, new LinkOption[0]) && Files.isDirectory(specificFolder, new LinkOption[0])) {
                this.getLog().info((CharSequence)"Using special 'mac.app' bundler-folder.");
                params.put(MacAppBundlerWithAdditionalResources.ADDITIONAL_BUNDLER_RESOURCES.getID(), specificFolder.toAbsolutePath().toFile());
            } else {
                params.put(MacAppBundlerWithAdditionalResources.ADDITIONAL_BUNDLER_RESOURCES.getID(), additionalBundlerResources);
            }
            return specialMacBundler;
        }
        return b;
    }
}

