/*
 * Decompiled with CFR 0.152.
 */
package com.zenjava.javafx.maven.plugin;

import com.oracle.tools.packager.AbstractBundler;
import com.oracle.tools.packager.Bundler;
import com.oracle.tools.packager.Bundlers;
import com.oracle.tools.packager.ConfigException;
import com.oracle.tools.packager.RelativeFileSet;
import com.oracle.tools.packager.StandardBundlerParam;
import com.oracle.tools.packager.UnsupportedPlatformException;
import com.oracle.tools.packager.linux.LinuxDebBundler;
import com.oracle.tools.packager.linux.LinuxRpmBundler;
import com.oracle.tools.packager.windows.WinExeBundler;
import com.oracle.tools.packager.windows.WinMsiBundler;
import com.sun.javafx.tools.packager.PackagerException;
import com.sun.javafx.tools.packager.SignJarParams;
import com.zenjava.javafx.maven.plugin.AbstractJfxToolsMojo;
import com.zenjava.javafx.maven.plugin.FileAssociation;
import com.zenjava.javafx.maven.plugin.NativeLauncher;
import com.zenjava.javafx.maven.plugin.Workarounds;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.jar.JarFile;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;

public class NativeMojo
extends AbstractJfxToolsMojo {
    protected String identifier;
    protected String vendor;
    protected File nativeOutputDir;
    private String bundler;
    private Map<String, String> jvmProperties;
    private List<String> jvmArgs;
    private Map<String, String> userJvmArgs;
    private List<String> launcherArguments;
    private String nativeReleaseVersion;
    protected boolean needShortcut;
    protected boolean needMenu;
    protected Map<String, String> bundleArguments;
    protected String appName;
    protected boolean jfxCallFromCLI;
    protected File additionalAppResources;
    protected File additionalBundlerResources;
    protected boolean skipNativeLauncherWorkaround124;
    protected List<NativeLauncher> secondaryLaunchers;
    protected boolean skipNativeLauncherWorkaround167;
    private List<FileAssociation> fileAssociations;
    protected boolean skipJNLPRessourcePathWorkaround182;
    protected File keyStore;
    protected String keyStoreAlias;
    protected String keyStorePassword;
    protected String keyPassword;
    protected String keyStoreType;
    protected boolean skipSigningJarFilesJNLP185;
    protected boolean skipSizeRecalculationForJNLP185;
    protected boolean noBlobSigning;
    protected List<String> customBundlers;
    protected boolean skipNativeLauncherWorkaround205;
    protected boolean skipMacBundlerWorkaround = false;
    protected boolean failOnError = false;
    protected boolean onlyCustomBundlers = false;
    protected boolean skipJNLP = false;
    protected boolean skipNativeVersionNumberSanitizing = false;
    protected List<String> additionalJarsignerParameters = new ArrayList<String>();
    protected boolean skipMainClassScanning = false;
    protected Workarounds workarounds = null;
    private static final String CFG_WORKAROUND_MARKER = "cfgWorkaroundMarker";
    private static final String CFG_WORKAROUND_DONE_MARKER = "cfgWorkaroundMarker.done";

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.jfxCallFromCLI) {
            this.getLog().info((CharSequence)"call from CLI - skipping creation of Native Installers");
            return;
        }
        if (this.skip) {
            this.getLog().info((CharSequence)"Skipping execution of NativeMojo MOJO.");
            return;
        }
        this.getLog().info((CharSequence)"Building Native Installers");
        this.workarounds = new Workarounds(this.nativeOutputDir, this.getLog());
        try {
            boolean mainClassInsideResourceJarFile;
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put(StandardBundlerParam.VERBOSE.getID(), this.verbose);
            Optional.ofNullable(this.identifier).ifPresent(id -> params.put(StandardBundlerParam.IDENTIFIER.getID(), id));
            params.put(StandardBundlerParam.APP_NAME.getID(), this.appName);
            params.put(StandardBundlerParam.VERSION.getID(), this.nativeReleaseVersion);
            if (!this.skipNativeVersionNumberSanitizing && this.nativeReleaseVersion != null) {
                params.put(StandardBundlerParam.VERSION.getID(), this.nativeReleaseVersion.replaceAll("[^\\d.]", ""));
            }
            params.put(StandardBundlerParam.VENDOR.getID(), this.vendor);
            params.put(StandardBundlerParam.SHORTCUT_HINT.getID(), this.needShortcut);
            params.put(StandardBundlerParam.MENU_HINT.getID(), this.needMenu);
            params.put(StandardBundlerParam.MAIN_CLASS.getID(), this.mainClass);
            Optional.ofNullable(this.jvmProperties).ifPresent(jvmProps -> params.put(StandardBundlerParam.JVM_PROPERTIES.getID(), new HashMap(jvmProps)));
            Optional.ofNullable(this.jvmArgs).ifPresent(jvmOptions -> params.put(StandardBundlerParam.JVM_OPTIONS.getID(), new ArrayList(jvmOptions)));
            Optional.ofNullable(this.userJvmArgs).ifPresent(userJvmOptions -> params.put(StandardBundlerParam.USER_JVM_OPTIONS.getID(), new HashMap(userJvmOptions)));
            Optional.ofNullable(this.launcherArguments).ifPresent(arguments -> params.put(StandardBundlerParam.ARGUMENTS.getID(), new ArrayList(arguments)));
            Optional.ofNullable(this.additionalAppResources).filter(File::exists).ifPresent(appResources -> {
                try {
                    Path targetFolder = this.jfxAppOutputDir.toPath();
                    Path sourceFolder = appResources.toPath();
                    this.copyRecursive(sourceFolder, targetFolder);
                }
                catch (IOException e) {
                    this.getLog().warn((Throwable)e);
                }
            });
            HashSet resourceFiles = new HashSet();
            try {
                Files.walk(this.jfxAppOutputDir.toPath(), new FileVisitOption[0]).map(p -> p.toFile()).filter(File::isFile).filter(File::canRead).forEach(f -> {
                    this.getLog().info((CharSequence)String.format("Add %s file to application resources.", f));
                    resourceFiles.add(f);
                });
            }
            catch (IOException e) {
                this.getLog().warn((Throwable)e);
            }
            params.put(StandardBundlerParam.APP_RESOURCES.getID(), new RelativeFileSet(this.jfxAppOutputDir, resourceFiles));
            HashSet duplicateKeys = new HashSet();
            Optional.ofNullable(this.bundleArguments).ifPresent(bArguments -> {
                duplicateKeys.addAll(params.keySet());
                duplicateKeys.retainAll(bArguments.keySet());
                params.putAll((Map<String, Object>)bArguments);
            });
            if (!duplicateKeys.isEmpty()) {
                throw new MojoExecutionException("The following keys in <bundleArguments> duplicate other settings, please remove one or the other: " + ((Object)duplicateKeys).toString());
            }
            if (!this.skipMainClassScanning && !(mainClassInsideResourceJarFile = resourceFiles.stream().filter(resourceFile -> resourceFile.toString().endsWith(".jar")).filter(resourceJarFile -> this.isClassInsideJarFile(this.mainClass, (File)resourceJarFile)).findFirst().isPresent())) {
                this.getLog().warn((CharSequence)String.format("Class with name %s was not found inside provided jar files!! JavaFX-application might not be working !!", this.mainClass));
            }
            ArrayList<String> launcherNames = new ArrayList<String>();
            launcherNames.add(this.appName);
            AtomicBoolean nullLauncherNameFound = new AtomicBoolean(false);
            Optional.ofNullable(this.secondaryLaunchers).filter(list -> !list.isEmpty()).ifPresent(launchers -> {
                this.getLog().info((CharSequence)"Adding configuration for secondary native launcher");
                nullLauncherNameFound.set(launchers.stream().anyMatch(launcher -> launcher.getAppName() == null));
                if (!nullLauncherNameFound.get()) {
                    launcherNames.addAll(launchers.stream().map(launcher -> launcher.getAppName()).collect(Collectors.toList()));
                    params.put(StandardBundlerParam.SECONDARY_LAUNCHERS.getID(), launchers.stream().map(launcher -> {
                        this.getLog().info((CharSequence)("Adding secondary launcher: " + launcher.getAppName()));
                        HashMap<String, Object> secondaryLauncher = new HashMap<String, Object>();
                        this.addToMapWhenNotNull(launcher.getAppName(), StandardBundlerParam.APP_NAME.getID(), secondaryLauncher);
                        this.addToMapWhenNotNull(launcher.getMainClass(), StandardBundlerParam.MAIN_CLASS.getID(), secondaryLauncher);
                        this.addToMapWhenNotNull(launcher.getJfxMainAppJarName(), StandardBundlerParam.MAIN_JAR.getID(), secondaryLauncher);
                        this.addToMapWhenNotNull(launcher.getNativeReleaseVersion(), StandardBundlerParam.VERSION.getID(), secondaryLauncher);
                        this.addToMapWhenNotNull(launcher.getVendor(), StandardBundlerParam.VENDOR.getID(), secondaryLauncher);
                        this.addToMapWhenNotNull(launcher.getIdentifier(), StandardBundlerParam.IDENTIFIER.getID(), secondaryLauncher);
                        this.addToMapWhenNotNull(launcher.isNeedMenu(), StandardBundlerParam.MENU_HINT.getID(), secondaryLauncher);
                        this.addToMapWhenNotNull(launcher.isNeedShortcut(), StandardBundlerParam.SHORTCUT_HINT.getID(), secondaryLauncher);
                        this.addToMapWhenNotNull(launcher.getClasspath(), StandardBundlerParam.CLASSPATH.getID(), secondaryLauncher);
                        Optional.ofNullable(launcher.getJvmArgs()).ifPresent(jvmOptions -> secondaryLauncher.put(StandardBundlerParam.JVM_OPTIONS.getID(), new ArrayList(jvmOptions)));
                        Optional.ofNullable(launcher.getJvmProperties()).ifPresent(jvmProps -> secondaryLauncher.put(StandardBundlerParam.JVM_PROPERTIES.getID(), new HashMap(jvmProps)));
                        Optional.ofNullable(launcher.getUserJvmArgs()).ifPresent(userJvmOptions -> secondaryLauncher.put(StandardBundlerParam.USER_JVM_OPTIONS.getID(), new HashMap(userJvmOptions)));
                        Optional.ofNullable(launcher.getLauncherArguments()).ifPresent(arguments -> secondaryLauncher.put(StandardBundlerParam.ARGUMENTS.getID(), new ArrayList(arguments)));
                        return secondaryLauncher;
                    }).collect(Collectors.toList()));
                }
            });
            if (nullLauncherNameFound.get()) {
                throw new MojoExecutionException("Not all secondary launchers have been configured properly.");
            }
            HashSet duplicateLauncherNamesCheckSet = new HashSet();
            launcherNames.stream().forEach(launcherName -> duplicateLauncherNamesCheckSet.add(launcherName));
            if (duplicateLauncherNamesCheckSet.size() != launcherNames.size()) {
                throw new MojoExecutionException("Secondary launcher needs to have different name, please adjust appName inside your configuration.");
            }
            Optional.ofNullable(this.fileAssociations).ifPresent(associations -> {
                ArrayList allAssociations = new ArrayList();
                associations.stream().forEach(association -> {
                    HashMap<String, Object> settings = new HashMap<String, Object>();
                    settings.put(StandardBundlerParam.FA_DESCRIPTION.getID(), association.getDescription());
                    settings.put(StandardBundlerParam.FA_ICON.getID(), association.getIcon());
                    settings.put(StandardBundlerParam.FA_EXTENSIONS.getID(), association.getExtensions());
                    settings.put(StandardBundlerParam.FA_CONTENT_TYPE.getID(), association.getContentType());
                    allAssociations.add(settings);
                });
                params.put(StandardBundlerParam.FILE_ASSOCIATIONS.getID(), allAssociations);
            });
            if (this.workarounds.isWorkaroundForBug167Needed()) {
                if (!this.skipNativeLauncherWorkaround167) {
                    this.workarounds.applyWorkaround167(params);
                } else {
                    this.getLog().info((CharSequence)"Skipped workaround for native launcher regarding cfg-file-format.");
                }
            }
            Bundlers bundlers = Bundlers.createBundlersInstance();
            Collection loadedBundlers = bundlers.getBundlers();
            if (this.onlyCustomBundlers) {
                loadedBundlers.clear();
            }
            List existingBundlerIds = loadedBundlers.stream().map(existingBundler -> existingBundler.getID()).collect(Collectors.toList());
            Optional.ofNullable(this.customBundlers).ifPresent(customBundlerList -> customBundlerList.stream().map(customBundlerClassName -> {
                try {
                    Class<?> customBundlerClass = Class.forName(customBundlerClassName);
                    Bundler newCustomBundler = (Bundler)customBundlerClass.newInstance();
                    if (existingBundlerIds.contains(newCustomBundler.getID())) {
                        return null;
                    }
                    return newCustomBundler;
                }
                catch (ClassCastException | ClassNotFoundException | IllegalAccessException | InstantiationException ex) {
                    this.getLog().warn((CharSequence)("There was an exception while creating a new instance of custom bundler: " + customBundlerClassName), (Throwable)ex);
                    return null;
                }
            }).filter(customBundler -> customBundler != null).forEach(customBundler -> {
                if (this.onlyCustomBundlers) {
                    loadedBundlers.add(customBundler);
                } else {
                    bundlers.loadBundler(customBundler);
                }
            }));
            boolean foundBundler = false;
            if (loadedBundlers.isEmpty()) {
                throw new MojoExecutionException("There were no bundlers registered. Please make sure to add your custom bundlers as dependency to the plugin.");
            }
            for (Bundler b : bundlers.getBundlers()) {
                String currentRunningBundlerID = b.getID();
                if (!this.shouldBundlerRun(this.bundler, currentRunningBundlerID, params)) continue;
                foundBundler = true;
                try {
                    HashMap<String, Object> paramsToBundleWith;
                    if (this.workarounds.isWorkaroundForNativeMacBundlerNeeded(this.additionalBundlerResources)) {
                        if (!this.skipMacBundlerWorkaround) {
                            b = this.workarounds.applyWorkaroundForNativeMacBundler(b, currentRunningBundlerID, params, this.additionalBundlerResources);
                        } else {
                            this.getLog().info((CharSequence)"Skipping replacement of the 'mac.app'-bundler. Please make sure you know what you are doing!");
                        }
                    }
                    if (!b.validate(paramsToBundleWith = new HashMap<String, Object>(params))) continue;
                    this.doPrepareBeforeBundling(currentRunningBundlerID, paramsToBundleWith);
                    if ("jnlp".equals(currentRunningBundlerID) && !paramsToBundleWith.containsKey("jnlp.outfile")) {
                        if (this.failOnError) {
                            throw new MojoExecutionException("You missed to specify some bundleArguments-entry, please set 'jnlp.outfile', e.g. using appName.");
                        }
                        this.getLog().warn((CharSequence)"You missed to specify some bundleArguments-entry, please set 'jnlp.outfile', e.g. using appName.");
                        continue;
                    }
                    b.execute(paramsToBundleWith, this.nativeOutputDir);
                    this.applyWorkaroundsAfterBundling(currentRunningBundlerID, params);
                }
                catch (UnsupportedPlatformException paramsToBundleWith) {
                }
                catch (ConfigException e) {
                    if (this.failOnError) {
                        throw new MojoExecutionException("Skipping '" + b.getName() + "' because of configuration error '" + e.getMessage() + "'\nAdvice to fix: " + e.getAdvice());
                    }
                    this.getLog().info((CharSequence)("Skipping '" + b.getName() + "' because of configuration error '" + e.getMessage() + "'\nAdvice to fix: " + e.getAdvice()));
                }
            }
            if (!foundBundler) {
                if (this.failOnError) {
                    throw new MojoExecutionException("No bundler found for given id " + this.bundler + ". Please check your configuration.");
                }
                this.getLog().warn((CharSequence)("No bundler found for given id " + this.bundler + ". Please check your configuration."));
            }
        }
        catch (RuntimeException e) {
            throw new MojoExecutionException("An error occurred while generating native deployment bundles", (Exception)e);
        }
        catch (PackagerException ex) {
            throw new MojoExecutionException("An error occurred while generating native deployment bundles", (Exception)((Object)ex));
        }
    }

    private void applyWorkaroundsAfterBundling(String currentRunningBundlerID, Map<String, ? super Object> params) throws PackagerException, MojoFailureException, MojoExecutionException {
        if (this.workarounds.isWorkaroundForBug124Needed() && "linux.app".equals(currentRunningBundlerID)) {
            this.getLog().info((CharSequence)"Applying workaround for oracle-jdk-bug since 1.8.0u40 regarding native linux launcher(s).");
            if (!this.skipNativeLauncherWorkaround124) {
                this.workarounds.applyWorkaround124(this.appName, this.secondaryLaunchers);
                if (Boolean.parseBoolean(String.valueOf(params.get(CFG_WORKAROUND_MARKER))) && !Boolean.parseBoolean((String)params.get(CFG_WORKAROUND_DONE_MARKER))) {
                    this.getLog().info((CharSequence)"Preparing workaround for oracle-jdk-bug since 1.8.0u40 regarding native linux launcher(s) inside native linux installers.");
                    this.workarounds.applyWorkaround205(this.appName, this.secondaryLaunchers, params);
                    params.put(CFG_WORKAROUND_DONE_MARKER, "true");
                }
            } else {
                this.getLog().info((CharSequence)"Skipped workaround for native linux launcher(s).");
            }
        }
        if ("jnlp".equals(currentRunningBundlerID)) {
            if (this.workarounds.isWorkaroundForBug182Needed()) {
                this.getLog().info((CharSequence)"Applying workaround for oracle-jdk-bug since 1.8.0u60 regarding jar-path inside generated JNLP-files.");
                if (!this.skipJNLPRessourcePathWorkaround182) {
                    this.workarounds.fixPathsInsideJNLPFiles();
                } else {
                    this.getLog().info((CharSequence)"Skipped workaround for jar-paths jar-path inside generated JNLP-files.");
                }
            }
            if (this.workarounds.isWorkaroundForBug185Needed(params)) {
                this.getLog().info((CharSequence)"Signing jar-files referenced inside generated JNLP-files.");
                if (!this.skipSigningJarFilesJNLP185) {
                    if (!this.noBlobSigning) {
                        this.getLog().info((CharSequence)"Signing jar-files using BLOB method.");
                        this.signJarFilesUsingBlobSigning();
                    } else {
                        this.getLog().info((CharSequence)"Signing jar-files using jarsigner.");
                        this.signJarFiles();
                    }
                    this.workarounds.applyWorkaround185(this.skipSizeRecalculationForJNLP185);
                } else {
                    this.getLog().info((CharSequence)"Skipped signing jar-files referenced inside JNLP-files.");
                }
            }
        }
    }

    private void doPrepareBeforeBundling(String currentRunningBundlerID, Map<String, ? super Object> paramsToBundleWith) {
        if (this.additionalBundlerResources != null && this.additionalBundlerResources.exists()) {
            boolean skipCopyAdditionalBundlerResources = false;
            Path additionalBundlerResourcesPath = this.additionalBundlerResources.toPath();
            Path resolvedBundlerFolder = additionalBundlerResourcesPath.resolve(currentRunningBundlerID);
            if (this.verbose.booleanValue()) {
                this.getLog().info((CharSequence)("Additional bundler resources are specified, trying to copy all files into build root, using:" + this.additionalBundlerResources.getAbsolutePath()));
            }
            File bundlerImageRoot = (File)AbstractBundler.IMAGES_ROOT.fetchFrom(paramsToBundleWith);
            Path targetFolder = bundlerImageRoot.toPath();
            Path sourceFolder = additionalBundlerResourcesPath;
            switch (currentRunningBundlerID) {
                case "windows.app": {
                    skipCopyAdditionalBundlerResources = true;
                    break;
                }
                case "windows.service": {
                    skipCopyAdditionalBundlerResources = true;
                    break;
                }
                case "mac.app": {
                    if (this.skipMacBundlerWorkaround) {
                        this.getLog().warn((CharSequence)"The bundler with ID 'mac.app' is not supported, as that bundler does not provide any way to copy additional bundler-files.");
                    }
                    skipCopyAdditionalBundlerResources = true;
                    break;
                }
                case "mac.daemon": {
                    this.getLog().warn((CharSequence)"The bundler with ID 'mac.daemon' is not supported, as that bundler does not provide any way to copy additional bundler-files.");
                    skipCopyAdditionalBundlerResources = true;
                    break;
                }
                case "linux.app": {
                    skipCopyAdditionalBundlerResources = true;
                }
            }
            if (!skipCopyAdditionalBundlerResources) {
                if (Files.exists(resolvedBundlerFolder, new LinkOption[0])) {
                    if (this.verbose.booleanValue()) {
                        this.getLog().info((CharSequence)("Found additional bundler resources for bundler " + currentRunningBundlerID));
                    }
                    sourceFolder = resolvedBundlerFolder;
                    switch (currentRunningBundlerID) {
                        case "exe": {
                            File exeBundlerFolder = (File)WinExeBundler.EXE_IMAGE_DIR.fetchFrom(paramsToBundleWith);
                            targetFolder = exeBundlerFolder.toPath();
                            break;
                        }
                        case "msi": {
                            File msiBundlerFolder = (File)WinMsiBundler.MSI_IMAGE_DIR.fetchFrom(paramsToBundleWith);
                            targetFolder = msiBundlerFolder.toPath();
                            break;
                        }
                        case "mac.appStore": {
                            if (this.skipMacBundlerWorkaround) {
                                this.getLog().warn((CharSequence)"The bundler with ID 'mac.appStore' is not supported for using 'additionalBundlerResources', as that bundler does not provide any way to copy additional bundler-files.");
                            }
                            skipCopyAdditionalBundlerResources = true;
                            break;
                        }
                        case "dmg": {
                            if (this.skipMacBundlerWorkaround) {
                                this.getLog().warn((CharSequence)"The bundler with ID 'dmg' is not supported for using 'additionalBundlerResources', as that bundler does not provide any way to copy additional bundler-files.");
                            }
                            skipCopyAdditionalBundlerResources = true;
                            break;
                        }
                        case "pkg": {
                            if (this.skipMacBundlerWorkaround) {
                                this.getLog().warn((CharSequence)"The bundler with ID 'pkg' is not supported for using 'additionalBundlerResources', as that bundler does not provide any way to copy additional bundler-files.");
                            }
                            skipCopyAdditionalBundlerResources = true;
                            break;
                        }
                        case "deb": {
                            File linuxDebBundlerFolder = (File)LinuxDebBundler.DEB_IMAGE_DIR.fetchFrom(paramsToBundleWith);
                            targetFolder = linuxDebBundlerFolder.toPath();
                            break;
                        }
                        case "rpm": {
                            File linuxRpmBundlerFolder = (File)LinuxRpmBundler.RPM_IMAGE_DIR.fetchFrom(paramsToBundleWith);
                            targetFolder = linuxRpmBundlerFolder.toPath();
                            break;
                        }
                        default: {
                            this.getLog().warn((CharSequence)"Unknown bundler-ID found, copying from root of additionalBundlerResources into IMAGES_ROOT.");
                            sourceFolder = this.additionalBundlerResources.toPath();
                            break;
                        }
                    }
                } else if (this.verbose.booleanValue()) {
                    this.getLog().info((CharSequence)("No additional bundler resources for bundler " + currentRunningBundlerID + " were found, copying all files instead."));
                }
                if (!skipCopyAdditionalBundlerResources) {
                    try {
                        if (this.verbose.booleanValue()) {
                            this.getLog().info((CharSequence)("Copying additional bundler resources into: " + targetFolder.toFile().getAbsolutePath()));
                        }
                        this.copyRecursive(sourceFolder, targetFolder);
                    }
                    catch (IOException e) {
                        this.getLog().warn((CharSequence)"Couldn't copy additional bundler resource-file(s).", (Throwable)e);
                    }
                }
            }
        }
        if (System.getProperty("os.name").toLowerCase().startsWith("linux") && "deb".equals(currentRunningBundlerID)) {
            AtomicBoolean needsWarningAboutSlowPerformance = new AtomicBoolean(false);
            this.nativeOutputDir.toPath().getFileSystem().getFileStores().forEach(store -> {
                if ("ext4".equals(store.type())) {
                    needsWarningAboutSlowPerformance.set(true);
                }
                if ("btrfs".equals(store.type())) {
                    needsWarningAboutSlowPerformance.set(true);
                }
            });
            if (needsWarningAboutSlowPerformance.get()) {
                this.getLog().info((CharSequence)"This bundler might take some while longer than expected.");
                this.getLog().info((CharSequence)"For details about this, please go to: https://wiki.debian.org/Teams/Dpkg/FAQ#Q:_Why_is_dpkg_so_slow_when_using_new_filesystems_such_as_btrfs_or_ext4.3F");
            }
        }
    }

    private boolean shouldBundlerRun(String requestedBundler, String currentRunningBundlerID, Map<String, ? super Object> params) {
        if (requestedBundler != null && !"ALL".equalsIgnoreCase(requestedBundler) && !requestedBundler.equalsIgnoreCase(currentRunningBundlerID)) {
            return false;
        }
        if (this.skipJNLP && "jnlp".equalsIgnoreCase(currentRunningBundlerID)) {
            this.getLog().info((CharSequence)"Skipped JNLP-bundling as requested.");
            return false;
        }
        boolean runBundler = true;
        if (System.getProperty("os.name").toLowerCase().startsWith("linux") && this.workarounds.isWorkaroundForBug205Needed() && !"jnlp".equalsIgnoreCase(requestedBundler) && !"linux.app".equalsIgnoreCase(requestedBundler) && "linux.app".equalsIgnoreCase(currentRunningBundlerID)) {
            if (!this.skipNativeLauncherWorkaround205) {
                this.getLog().info((CharSequence)"Detected linux application bundler ('linux.app') needs to run before installer bundlers are executed.");
                runBundler = true;
                params.put(CFG_WORKAROUND_MARKER, "true");
            } else {
                this.getLog().info((CharSequence)"Skipped workaround for native linux installer bundlers.");
            }
        }
        return runBundler;
    }

    private void addToMapWhenNotNull(Object value, String key, Map<String, Object> map) {
        if (value == null) {
            return;
        }
        map.put(key, value);
    }

    private void signJarFilesUsingBlobSigning() throws MojoFailureException, PackagerException, MojoExecutionException {
        this.checkSigningConfiguration();
        SignJarParams signJarParams = new SignJarParams();
        signJarParams.setVerbose(this.verbose.booleanValue());
        signJarParams.setKeyStore(this.keyStore);
        signJarParams.setAlias(this.keyStoreAlias);
        signJarParams.setStorePass(this.keyStorePassword);
        signJarParams.setKeyPass(this.keyPassword);
        signJarParams.setStoreType(this.keyStoreType);
        signJarParams.addResource(this.nativeOutputDir, this.jfxMainAppJarName);
        this.workarounds.getJARFilesFromJNLPFiles().forEach(jarFile -> signJarParams.addResource(this.nativeOutputDir, jarFile));
        this.getLog().info((CharSequence)"Signing JAR files for jnlp bundle using BLOB-method");
        this.getPackagerLib().signJar(signJarParams);
    }

    private void signJarFiles() throws MojoFailureException, PackagerException, MojoExecutionException {
        this.checkSigningConfiguration();
        AtomicReference exception = new AtomicReference();
        this.workarounds.getJARFilesFromJNLPFiles().stream().map(relativeJarFilePath -> new File(this.nativeOutputDir, (String)relativeJarFilePath)).forEach(jarFile -> {
            try {
                if (exception.get() == null) {
                    this.signJar(jarFile.getAbsoluteFile());
                }
            }
            catch (MojoExecutionException ex) {
                exception.set(ex);
            }
        });
        if (exception.get() != null) {
            throw (MojoExecutionException)((Object)exception.get());
        }
    }

    private void checkSigningConfiguration() throws MojoFailureException {
        if (!this.keyStore.exists()) {
            throw new MojoFailureException("Keystore does not exist, use 'jfx:generate-key-store' command to make one (expected at: " + this.keyStore + ")");
        }
        if (this.keyStoreAlias == null || this.keyStoreAlias.isEmpty()) {
            throw new MojoFailureException("A 'keyStoreAlias' is required for signing JARs");
        }
        if (this.keyStorePassword == null || this.keyStorePassword.isEmpty()) {
            throw new MojoFailureException("A 'keyStorePassword' is required for signing JARs");
        }
        if (this.keyPassword == null) {
            this.keyPassword = this.keyStorePassword;
        }
    }

    private void signJar(File jarFile) throws MojoExecutionException {
        ArrayList<String> command = new ArrayList<String>();
        command.add(this.getEnvironmentRelativeExecutablePath() + "jarsigner");
        Optional.ofNullable(this.additionalJarsignerParameters).ifPresent(jarsignerParameters -> command.addAll((Collection<String>)jarsignerParameters));
        command.add("-strict");
        command.add("-keystore");
        command.add(this.keyStore.getAbsolutePath());
        command.add("-storepass");
        command.add(this.keyStorePassword);
        command.add("-keypass");
        command.add(this.keyPassword);
        command.add(jarFile.getAbsolutePath());
        command.add(this.keyStoreAlias);
        if (this.verbose.booleanValue()) {
            command.add("-verbose");
        }
        try {
            ProcessBuilder pb = new ProcessBuilder(new String[0]).inheritIO().directory(this.project.getBasedir()).command(command);
            if (this.verbose.booleanValue()) {
                this.getLog().info((CharSequence)("Running command: " + String.join((CharSequence)" ", command)));
            }
            this.getLog().info((CharSequence)"Signing JAR files for jnlp bundle using jarsigner-method");
            Process p = pb.start();
            p.waitFor();
            if (p.exitValue() != 0) {
                throw new MojoExecutionException("Signing jar using jarsigner wasn't successful! Please check build-log.");
            }
        }
        catch (IOException | InterruptedException ex) {
            throw new MojoExecutionException("There was an exception while signing jar-file: " + jarFile.getAbsolutePath(), ex);
        }
    }

    private boolean isClassInsideJarFile(String classname, File jarFile) {
        String requestedJarEntryName = classname.replace(".", "/") + ".class";
        try {
            JarFile jarFileToSearchIn = new JarFile(jarFile, false, 1);
            return ((Stream)jarFileToSearchIn.stream().parallel()).filter(jarEntry -> jarEntry.getName().equals(requestedJarEntryName)).findAny().isPresent();
        }
        catch (IOException iOException) {
            return false;
        }
    }
}

