/*
 * Decompiled with CFR 0.152.
 */
package com.xxl.rpc.serialize.impl;

import com.caucho.hessian.io.HessianInput;
import com.caucho.hessian.io.HessianOutput;
import com.xxl.rpc.serialize.Serializer;
import com.xxl.rpc.util.XxlRpcException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class Hessian1Serializer
extends Serializer {
    @Override
    public <T> byte[] serialize(T obj) {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        HessianOutput ho = new HessianOutput((OutputStream)os);
        try {
            byte[] result;
            ho.writeObject(obj);
            ho.flush();
            byte[] byArray = result = os.toByteArray();
            return byArray;
        }
        catch (IOException e) {
            throw new XxlRpcException(e);
        }
        finally {
            try {
                ho.close();
            }
            catch (IOException e) {
                throw new XxlRpcException(e);
            }
            try {
                os.close();
            }
            catch (IOException e) {
                throw new XxlRpcException(e);
            }
        }
    }

    @Override
    public <T> Object deserialize(byte[] bytes, Class<T> clazz) {
        ByteArrayInputStream is = new ByteArrayInputStream(bytes);
        HessianInput hi = new HessianInput((InputStream)is);
        try {
            Object result;
            Object object = result = hi.readObject();
            return object;
        }
        catch (IOException e) {
            throw new XxlRpcException(e);
        }
        finally {
            try {
                hi.close();
            }
            catch (Exception e) {
                throw new XxlRpcException(e);
            }
            try {
                is.close();
            }
            catch (IOException e) {
                throw new XxlRpcException(e);
            }
        }
    }
}

