/*
 * Decompiled with CFR 0.152.
 */
package com.talkilla.controller;

import com.talkilla.base.Result;
import com.talkilla.constant.TalkillaConstant;
import com.talkilla.exception.BusinessException;
import com.talkilla.exception.UserException;
import com.talkilla.exception.base.ExceptionUtil;
import com.talkilla.form.UserLoginForm;
import com.talkilla.form.student.AvatarForm;
import com.talkilla.form.student.FindPwdSaveForm;
import com.talkilla.form.student.MobileForm;
import com.talkilla.form.student.ModifyEmailForm;
import com.talkilla.form.student.UserInfoModifySaveForm;
import com.talkilla.form.student.UserLoginByCodeForm;
import com.talkilla.mysql.domain.TLogin;
import com.talkilla.mysql.domain.TStudent;
import com.talkilla.mysql.domain.TWechat;
import com.talkilla.mysql.mapper.TLoginDao;
import com.talkilla.mysql.mapper.TWechatDao;
import com.talkilla.service.CommonService;
import com.talkilla.service.TLoginService;
import com.talkilla.service.TStudentService;
import com.talkilla.service.TWechatService;
import com.talkilla.service.wechat.UserService;
import com.talkilla.utils.DateUtils;
import com.talkilla.utils.PasswordUtil;
import com.talkilla.wechat.service.WechatService;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"/user"})
public class TalkillaUserController {
    private static final Logger logger = LoggerFactory.getLogger(TalkillaUserController.class);
    @Autowired
    private UserService userService;
    @Autowired
    private TLoginService tLoginService;
    @Autowired
    private TStudentService studentService;
    @Autowired
    private TWechatService tWechatService;
    @Autowired
    private TWechatDao tWechatDao;
    @Autowired
    private TLoginDao tLoginDao;
    @Autowired
    private WechatService wechatService;
    @Autowired
    private CommonService commonService;

    @ExceptionHandler(value={Exception.class})
    public ModelAndView handleException(Exception ex) {
        return ExceptionUtil.printErrorInfo((Exception)ex);
    }

    @RequestMapping(value={"/toLoginPage"}, method={RequestMethod.GET})
    public String toLogin() {
        return "newLogin";
    }

    @RequestMapping(value={"/login/index"}, method={RequestMethod.GET})
    public String loginNewIndex() {
        return "newLogin";
    }

    @RequestMapping(value={"/login"}, method={RequestMethod.POST})
    @ResponseBody
    public Map<String, String> login(HttpSession session, @RequestBody UserLoginForm form) throws UserException {
        TStudent student;
        form.setPassword(PasswordUtil.encrypt2((String)form.getPassword()).toLowerCase());
        TLogin loginUser = this.userService.userLogin(form);
        HashMap<String, String> _result = new HashMap<String, String>();
        if (loginUser != null) {
            if (loginUser.getRoleId() != TalkillaConstant.KEY_LOGIN_TYPE_STUDENT) {
                throw new UserException((Object)"1001", " \u7528\u6237\u540d\u6216\u5bc6\u7801\u9519\u8bef\uff0c\u8bf7\u91cd\u65b0\u767b\u5f55\u3002");
            }
            student = this.studentService.findStudentByLoginId(loginUser.getLoginId());
            String openid = (String)session.getAttribute(TalkillaConstant.SESSION_WECHAT_OPENID_PREFIX);
            logger.info("\u7528\u6237openId\uff1a{}" + openid);
            TWechat tWechat = this.tWechatService.getTWechatInfoByLoginId(student.getLoginId());
            if (Objects.isNull(tWechat)) {
                tWechat = new TWechat();
                tWechat.setUserId(student.getStuId());
                tWechat.setRoleId(Integer.valueOf(1));
                tWechat.setLoginId(student.getLoginId());
                tWechat.setOpenid(openid);
                this.tWechatDao.insertSelective(tWechat);
            } else {
                tWechat.setOpenid(openid);
                tWechat.setUpdateTime(new Date());
                this.tWechatDao.updateByIdSelective(tWechat);
            }
            session.setAttribute(TalkillaConstant.SESSION_WECHAT_LOGIN_PREFIX, (Object)student);
            TStudent _tStu = this.tWechatDao.getStudentInfoByLoginId(loginUser.getLoginId());
            if (_tStu != null) {
                this.tWechatDao.updateSendBoxById(student.getStuId());
                _result.put("per", "0");
            }
        } else {
            _result.put("code", "0");
            return _result;
        }
        _result.put("stuId", String.valueOf(student.getStuId()));
        _result.put("code", "1");
        return _result;
    }

    @RequestMapping(value={"/logout"}, method={RequestMethod.GET})
    public String logout(HttpSession session) throws UserException {
        TStudent student = (TStudent)session.getAttribute(TalkillaConstant.SESSION_WECHAT_LOGIN_PREFIX);
        if (Objects.nonNull(student)) {
            TWechat tWechat = this.tWechatService.getTWechatInfoByLoginId(student.getLoginId());
            tWechat.setOpenid(null);
            this.tWechatDao.updateById(tWechat);
        }
        session.removeAttribute(TalkillaConstant.SESSION_WECHAT_LOGIN_PREFIX);
        return "newLogin";
    }

    @RequestMapping(value={"/login/by/code"}, method={RequestMethod.POST})
    @ResponseBody
    public Map<String, String> loginByCode(HttpSession session, @RequestBody UserLoginByCodeForm form) throws UserException {
        TStudent student;
        TLogin loginUser = this.userService.userLoginByCode(form);
        HashMap<String, String> _result = new HashMap<String, String>();
        if (loginUser != null) {
            if (loginUser.getRoleId() != TalkillaConstant.KEY_LOGIN_TYPE_STUDENT) {
                _result.put("code", "3");
                return _result;
            }
            student = this.studentService.findStudentByLoginId(loginUser.getLoginId());
            String openid = (String)session.getAttribute(TalkillaConstant.SESSION_WECHAT_OPENID_PREFIX);
            logger.info("\u7528\u6237openId\uff1a{}" + openid);
            TWechat tWechat = this.tWechatService.getTWechatInfoByLoginId(student.getLoginId());
            if (Objects.isNull(tWechat)) {
                tWechat = new TWechat();
                tWechat.setUserId(student.getStuId());
                tWechat.setRoleId(Integer.valueOf(1));
                tWechat.setLoginId(student.getLoginId());
                tWechat.setOpenid(openid);
                this.tWechatDao.insertSelective(tWechat);
            } else {
                tWechat.setOpenid(openid);
                tWechat.setUpdateTime(new Date());
                this.tWechatDao.updateByIdSelective(tWechat);
            }
            session.setAttribute(TalkillaConstant.SESSION_WECHAT_LOGIN_PREFIX, (Object)student);
            TStudent _tStu = this.tWechatDao.getStudentInfoByLoginId(loginUser.getLoginId());
            if (_tStu != null) {
                this.tWechatDao.updateSendBoxById(student.getStuId());
                _result.put("per", "0");
            }
        } else {
            _result.put("code", "0");
            return _result;
        }
        _result.put("stuId", String.valueOf(student.getStuId()));
        _result.put("code", "1");
        return _result;
    }

    @RequestMapping(value={"/find/password/by/mobile/page"}, method={RequestMethod.GET})
    public String toFindpwdPage(Model model) {
        model.addAttribute("type", (Object)1);
        return "findpwdByMobilePage";
    }

    @RequestMapping(value={"/find/password/by/mobile/page/next"}, method={RequestMethod.GET})
    @ResponseBody
    public String toFindpwdPageNext(HttpSession session, Model model, String mobile, String rand) {
        if (!this.commonService.checkRand(session, rand).booleanValue()) {
            model.addAttribute("message", (Object)"\u9a8c\u8bc1\u7801\u9519\u8bef");
            return Result.failure("\u9a8c\u8bc1\u7801\u9519\u8bef");
        }
        model.addAttribute("type", (Object)1);
        model.addAttribute("mobile", (Object)mobile);
        return Result.success("\u9a8c\u8bc1\u6210\u529f");
    }

    @RequestMapping(value={"/mobile/findpwdByMobilePageNext"}, method={RequestMethod.GET})
    public String findpwdByMobilePageNext(HttpSession session, Model model, String mobile, String rand) {
        model.addAttribute("type", (Object)1);
        model.addAttribute("mobile", (Object)mobile);
        return "findpwdByMobilePageNext";
    }

    @RequestMapping(value={"/rand"})
    public String rand(HttpServletRequest request, HttpSession session, Model model) {
        return "rand";
    }

    @RequestMapping(value={"/find/password/by/mobile/save"}, method={RequestMethod.GET})
    @ResponseBody
    public String findpwdSave(Model model, FindPwdSaveForm form) {
        model.addAttribute("type", (Object)1);
        Map result = this.userService.savePwdByMobile(form);
        if (((String)result.get("flag")).equals("1")) {
            model.addAttribute("type", (Object)1);
            model.addAttribute("mobile", (Object)form.getMobile());
            model.addAttribute("message", result.get("message"));
            return Result.failure(result.get("message"));
        }
        model.addAttribute("message", result.get("message"));
        return Result.success(result.get("message"));
    }

    @RequestMapping(value={"/info/modify/page"}, method={RequestMethod.GET})
    public String modifyPage(Model model, Integer stuId) {
        TStudent student = this.userService.findStudentById(stuId);
        model.addAttribute("birthday", (Object)DateUtils.formatDateToDay((Date)student.getBirthday()));
        model.addAttribute("student", (Object)student);
        model.addAttribute("stuId", (Object)stuId);
        TLogin tLogin = this.tLoginDao.findByStuId(stuId);
        model.addAttribute("eMail", (Object)tLogin.getLoginName());
        model.addAttribute("mobile", (Object)tLogin.getMobile());
        model.addAttribute("province", (Object)(this.commonService.findCityById(student.getProvinceId()) != null ? this.commonService.findCityById(student.getProvinceId()).getRegionName() : ""));
        model.addAttribute("city", (Object)(this.commonService.findCityById(student.getCityId()) != null ? this.commonService.findCityById(student.getCityId()).getRegionName() : ""));
        model.addAttribute("district", (Object)(this.commonService.findCityById(student.getDistrictId()) != null ? this.commonService.findCityById(student.getDistrictId()).getRegionName() : ""));
        return "studentModifyPage";
    }

    @RequestMapping(value={"/info/modify/save"}, method={RequestMethod.POST})
    @ResponseBody
    public String modifySave(Model model, @RequestBody UserInfoModifySaveForm form) {
        try {
            Map result = this.userService.saveStuUserInfo(form);
            model.addAttribute("result", (Object)result);
        }
        catch (Exception e) {
            logger.error("\u4fdd\u5b58\u5931\u8d25", (Throwable)e);
            return Result.failure("\u4fdd\u5b58\u5931\u8d25");
        }
        return Result.success("\u4fdd\u5b58\u6210\u529f");
    }

    @RequestMapping(value={" /info/modify/mobile/page/one"}, method={RequestMethod.GET})
    public String modifyMobilePageOne(Model model, Integer stuId, String mobile) {
        model.addAttribute("stuId", (Object)stuId);
        TLogin tLogin = this.tLoginDao.findByStuId(stuId);
        model.addAttribute("mobile", (Object)tLogin.getMobile());
        return "modifyMobilePageOne";
    }

    @RequestMapping(value={" /info/modify/mobile/page/two"}, method={RequestMethod.POST})
    @ResponseBody
    public String modifyMobilePageTwo(Model model, @RequestBody MobileForm form) {
        model.addAttribute("stuId", (Object)form.getStuId());
        if (this.commonService.checkCode(form.getMobile(), form.getCode()).booleanValue()) {
            return Result.success("\u9a8c\u8bc1\u6210\u529f");
        }
        model.addAttribute("message", (Object)"\u9a8c\u8bc1\u7801\u9519\u8bef");
        return Result.failure("\u9a8c\u8bc1\u7801\u9519\u8bef");
    }

    @RequestMapping(value={" /info/modify/mobile/pageTwo"}, method={RequestMethod.GET})
    public String pageTwo(Model model, String stuId) {
        model.addAttribute("stuId", (Object)stuId);
        return "modifyMobilePageTwo";
    }

    @RequestMapping(value={" /info/modify/avatar/save"}, method={RequestMethod.POST})
    @ResponseBody
    public String modifyAvatarSave(Model model, @RequestBody AvatarForm form) throws BusinessException {
        TStudent student = this.studentService.findOne(form.getStuId());
        if (student != null && StringUtils.isNotBlank((String)form.getAvatar())) {
            student.setAvatar(form.getAvatar());
            student.setUpdateTime(new Date());
            this.studentService.updateByIdSelective(student);
            return Result.success("\u4fdd\u5b58\u6210\u529f");
        }
        return Result.failure("\u4fdd\u5b58\u5931\u8d25");
    }

    @RequestMapping(value={" /info/modify/mobile/save"}, method={RequestMethod.POST})
    @ResponseBody
    public String modifyMobileSave(Model model, @RequestBody MobileForm form) throws BusinessException {
        model.addAttribute("type", (Object)1);
        if (this.commonService.checkCode(form.getMobile(), form.getCode()).booleanValue()) {
            TLogin tLogin = this.tLoginDao.findByMobileExSelf(form.getMobile(), form.getStuId());
            if (tLogin != null) {
                return Result.failure(form.getMobile() + "\u5df2\u7ecf\u88ab\u4f7f\u7528\u4e86\uff01\uff01");
            }
        } else {
            model.addAttribute("stuId", (Object)form.getStuId());
            model.addAttribute("message", (Object)"\u9a8c\u8bc1\u7801\u9519\u8bef");
            return Result.failure("\u9a8c\u8bc1\u7801\u9519\u8bef");
        }
        this.tLoginService.saveMobile(form);
        return Result.success("\u4fdd\u5b58\u6210\u529f");
    }

    @RequestMapping(value={" /info/modify/email/page"}, method={RequestMethod.GET})
    public String modifyEmailPage(Model model, Integer stuId) {
        model.addAttribute("stuId", (Object)stuId);
        return "modifyEmailPage";
    }

    @RequestMapping(value={" /info/modify/email/save"}, method={RequestMethod.POST})
    @ResponseBody
    public String modifyMobileSave(Model model, @RequestBody ModifyEmailForm form) throws BusinessException {
        model.addAttribute("stuId", (Object)form.getStuId());
        if (!StringUtils.isNotBlank((String)form.getEmail()) || !form.getEmail().equals(form.getConfirmEmail())) {
            model.addAttribute("stuId", (Object)form.getStuId());
            model.addAttribute("message", (Object)"\u90ae\u7bb1\u8f93\u5165\u6709\u8bef");
            return Result.failure("\u90ae\u7bb1\u8f93\u5165\u6709\u8bef");
        }
        this.tLoginService.saveEmail(form);
        return Result.success("\u90ae\u7bb1\u4fee\u6539\u6210\u529f");
    }
}

