/*
 * Decompiled with CFR 0.152.
 */
package com.talkilla.controller;

import com.talkilla.constant.ConstantBean;
import com.talkilla.constant.SystemConfig;
import com.talkilla.constant.TalkillaConstant;
import com.talkilla.mysql.domain.TStudent;
import com.talkilla.mysql.domain.TWechat;
import com.talkilla.service.TStudentService;
import com.talkilla.service.TSysdictService;
import com.talkilla.service.TWechatService;
import com.talkilla.utils.QRCodeUtil;
import com.talkilla.wechat.result.WechatUserLoginResult;
import com.talkilla.wechat.service.WechatService;
import java.io.OutputStream;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
@RequestMapping(value={"/recommend"})
public class RecommendController {
    @Autowired
    WechatService wechatService;
    @Autowired
    TWechatService tWechatService;
    @Autowired
    TStudentService tStudentService;
    @Autowired
    ConstantBean constantBean;
    @Autowired
    TSysdictService tSysdictService;

    @RequestMapping(value={"/index"}, method={RequestMethod.GET})
    public String recommendPage(HttpSession session, Integer type, String code, String state) {
        TStudent student = (TStudent)session.getAttribute(TalkillaConstant.SESSION_WECHAT_LOGIN_PREFIX);
        if (student == null) {
            WechatUserLoginResult wechatUserLoginResult = this.wechatService.getOpenIdOrUnionId(code);
            session.setAttribute(TalkillaConstant.SESSION_WECHAT_OPENID_PREFIX, (Object)wechatUserLoginResult.getOpenid());
            TWechat tWechat = this.tWechatService.getTWechatInfoByOpenid(wechatUserLoginResult.getOpenid());
            if (tWechat != null) {
                student = this.tStudentService.findStudentByLoginId(tWechat.getLoginId());
                session.setAttribute(TalkillaConstant.SESSION_WECHAT_LOGIN_PREFIX, (Object)student);
            }
        }
        if (student == null) {
            return "newLogin";
        }
        return "redirect:/recommend/page?sid=" + student.getStuId();
    }

    @RequestMapping(value={"/page"}, method={RequestMethod.GET})
    public String recommendUrl(Integer sid, Model model) {
        model.addAttribute("sid", (Object)sid);
        return "recommend";
    }

    @RequestMapping(value={"/img"}, method={RequestMethod.GET})
    public void bgImage(Integer sid, HttpServletResponse response) throws Exception {
        String registUrl = String.format(SystemConfig.Wechat.WECHAT_RECOMMENDREGIST, sid, 3);
        QRCodeUtil.encode((String)registUrl, (String)this.tSysdictService.fingBgImg().getDictname(), (OutputStream)response.getOutputStream());
    }
}

