/*
 * Decompiled with CFR 0.152.
 */
package com.talkilla.controller;

import com.google.common.collect.Maps;
import com.talkilla.constant.SubjectType;
import com.talkilla.constant.TalkillaConstant;
import com.talkilla.form.student.QueryTeacherByTempCourseForm;
import com.talkilla.mysql.domain.TCourse;
import com.talkilla.mysql.domain.TCoursesession;
import com.talkilla.mysql.domain.TStudent;
import com.talkilla.mysql.domain.TSysdict;
import com.talkilla.mysql.domain.TTeacher;
import com.talkilla.mysql.mapper.TCoursesessionDao;
import com.talkilla.mysql.mapper.TNationDao;
import com.talkilla.mysql.mapper.TSysdictDao;
import com.talkilla.result.admin.base.PageObj;
import com.talkilla.result.teacher.TeacherWorkTimeResult;
import com.talkilla.result.wechat.TeacherDetailResult;
import com.talkilla.service.TCourseService;
import com.talkilla.service.TCoursesessionService;
import com.talkilla.service.TSysdictService;
import com.talkilla.service.TTeacherService;
import com.talkilla.service.teacher.TeaWorkTimeService;
import com.talkilla.utils.DateUtils;
import java.text.ParseException;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.Period;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.servlet.http.HttpSession;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/tempCourse"})
public class TalkillaTempCourceController {
    @Autowired
    TTeacherService tTeacherService;
    @Autowired
    TCourseService tCourseService;
    @Autowired
    TeaWorkTimeService teaWorkTimeService;
    @Autowired
    TCoursesessionService tCoursesessionService;
    @Autowired
    TNationDao tNationDao;
    @Autowired
    TSysdictService tSysdictService;
    @Autowired
    TSysdictDao tSysdictDao;
    @Autowired
    TCoursesessionDao tCoursesessionDao;

    @RequestMapping(value={"/selcetTime"}, method={RequestMethod.GET})
    @ResponseBody
    public Map studentSummaryList(HttpSession session, Model model, int teaId, int cid) throws ParseException {
        Instant now = Instant.now();
        TCourse tCourse = this.tCourseService.findOne(Integer.valueOf(cid));
        TTeacher tTeacher = teaId == 0 ? this.tTeacherService.findOne(tCourse.getTeacherId()) : this.tTeacherService.findOne(Integer.valueOf(teaId));
        TeacherWorkTimeResult workTimeTale = this.teaWorkTimeService.getWorkTimeTale(tTeacher.getTeacherId().intValue(), 8);
        ZoneId zoneId = ZoneId.systemDefault();
        ArrayList dates = new ArrayList();
        workTimeTale.getDateTitles().removeIf(dateTitle -> {
            Instant date = DateUtils.parseDate((String)dateTitle.getDate(), (String)"yyyyMMdd").toInstant();
            Period between = Period.between(now.atZone(zoneId).toLocalDate(), date.atZone(zoneId).toLocalDate());
            int days = between.getDays();
            if (days >= 1 && days <= 7) {
                dates.add(dateTitle.getDate());
                return false;
            }
            return true;
        });
        Map timeList = workTimeTale.getTimeList();
        timeList.entrySet().removeIf(entry -> !dates.contains(((String)entry.getKey()).split("-")[0]));
        LocalDateTime localDateTime = now.atZone(zoneId).toLocalDateTime();
        int hour = localDateTime.getHour();
        int minute = localDateTime.getMinute();
        int rangeId = hour * 2 + 1 + (minute > 30 ? 1 : 0);
        timeList.entrySet().removeIf(entry -> {
            String day = ((String)entry.getKey()).split("-")[0];
            Integer rid = Integer.valueOf(((String)entry.getKey()).split("-")[1]);
            return day.equals(dates.get(0)) && rid < rangeId;
        });
        List listByCid = this.tCoursesessionDao.findNoCompleteListByCid(Integer.valueOf(cid));
        TCoursesession tCoursesession = (TCoursesession)listByCid.get(0);
        tCoursesession.getDuration();
        HashMap map = Maps.newHashMap();
        workTimeTale.setTimeList(timeList);
        map.put("workTimeTale", workTimeTale);
        map.put("teacher", tTeacher);
        map.put("duration", Math.round((double)tCoursesession.getDuration().intValue() / 30.0));
        map.put("nation", "");
        map.put("type", "");
        map.put("courseSessionId", tCoursesession.getSessionid());
        map.put("age", 0);
        if (tTeacher.getBirthday() != null) {
            LocalDate birthdayDate = tTeacher.getBirthday().toInstant().atZone(zoneId).toLocalDate();
            Period between = Period.between(birthdayDate, now.atZone(zoneId).toLocalDate());
            map.put("age", between.getYears());
        }
        if (tTeacher.getCountry() != null && tTeacher.getCountry() > 0) {
            map.put("nation", this.tNationDao.findOne(tTeacher.getCountry()));
        }
        if (tTeacher.getTeacherType() != null && tTeacher.getTeacherType() > 0) {
            map.put("type", this.tSysdictDao.findOne(tTeacher.getTeacherType()));
        }
        TeacherWorkTimeResult.DateTitle firstDay = (TeacherWorkTimeResult.DateTitle)workTimeTale.getDateTitles().get(0);
        TeacherWorkTimeResult.DateTitle endDay = (TeacherWorkTimeResult.DateTitle)workTimeTale.getDateTitles().get(workTimeTale.getDateTitles().size() - 1);
        String dateRange = firstDay.getDate().substring(0, 4) + "\u5e74" + firstDay.getDayName().replace("-", "\u6708") + "\u65e5-" + endDay.getDayName().replace("-", "\u6708") + "\u65e5";
        map.put("dateRange", dateRange);
        return map;
    }

    @RequestMapping(value={"/teacherPage"}, method={RequestMethod.GET})
    public String teaDetailPage(int cid, int teaId, Model model) {
        model.addAttribute("cid", (Object)cid);
        if (teaId == 0) {
            TCourse tCourse = this.tCourseService.findOne(Integer.valueOf(cid));
            model.addAttribute("teaId", (Object)tCourse.getTeacherId());
        } else {
            model.addAttribute("teaId", (Object)teaId);
        }
        return "tempCourseTeacherPage";
    }

    @RequestMapping(value={"/confirmPage"}, method={RequestMethod.GET})
    public String confirmPage(@DateTimeFormat(pattern="yyyyMMdd-HH:mm") Date date, int cid, int teaId, int courseSessionId, Model model) {
        TCourse tCourse = this.tCourseService.findOne(Integer.valueOf(cid));
        TTeacher tTeacher = this.tTeacherService.findOne(Integer.valueOf(teaId));
        model.addAttribute("tCourse", (Object)tCourse);
        model.addAttribute("tTeacher", (Object)tTeacher);
        model.addAttribute("cid", (Object)cid);
        model.addAttribute("teaId", (Object)teaId);
        model.addAttribute("date", (Object)DateUtils.formatDateToSecond((Date)date));
        model.addAttribute("day", (Object)DateUtils.formatDate((Date)date, (String)"yyyy-MM-dd"));
        model.addAttribute("time", (Object)DateUtils.formatDate((Date)date, (String)"HH:mm"));
        model.addAttribute("courseSessionId", (Object)courseSessionId);
        return "confirmPage";
    }

    @RequestMapping(value={"/add"}, method={RequestMethod.POST})
    @ResponseBody
    public String addTempCource(HttpSession session, @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss") Date date, int cid, int teaId, int courseSessionId, String remark) {
        TStudent student = (TStudent)session.getAttribute(TalkillaConstant.SESSION_WECHAT_LOGIN_PREFIX);
        if (session.getAttribute("addTemp" + cid) == null) {
            session.setAttribute("addTemp" + cid, (Object)DateUtils.getNowSeconds());
        } else {
            Integer times = (Integer)session.getAttribute("addTemp" + cid);
            if (DateUtils.getNowSeconds() - times < 60) {
                return "same";
            }
        }
        boolean result = this.teaWorkTimeService.addTempCource(date, cid, teaId, courseSessionId, remark, student);
        if (result) {
            return "OK";
        }
        return "failed";
    }

    @RequestMapping(value={"/teachers"}, method={RequestMethod.GET})
    @ResponseBody
    public PageObj otherTeachers(QueryTeacherByTempCourseForm form) throws ParseException {
        PageObj teacherList = this.tTeacherService.getTeacherList(form);
        List nations = this.tNationDao.findAll();
        List teacherFenlei = this.tSysdictService.findTeacherFenlei();
        List collect = teacherList.getPageElements().stream().map(tTeacher -> new TeacherDetailResult((TTeacher)tTeacher, nations, teacherFenlei)).collect(Collectors.toList());
        teacherList.setPageElements(collect);
        return teacherList;
    }

    @RequestMapping(value={"/teachersPage"}, method={RequestMethod.GET})
    public String otherTeachersPage(int cid, Model model) throws ParseException {
        List nations = this.tNationDao.findAll();
        model.addAttribute("nations", (Object)nations);
        model.addAttribute("subjects", (Object)SubjectType.values());
        List teacherFenlei = this.tSysdictService.findTeacherFenlei();
        teacherFenlei.removeIf(tSysdict -> tSysdict.getDictname().equals("\u62d2\u7edd"));
        model.addAttribute("types", (Object)teacherFenlei);
        model.addAttribute("cid", (Object)cid);
        TCourse one = this.tCourseService.findOne(Integer.valueOf(cid));
        TTeacher one1 = this.tTeacherService.findOne(one.getTeacherId());
        Optional<TSysdict> any = teacherFenlei.stream().filter(t -> t.getDictid().equals(one1.getTeacherType())).findAny();
        model.addAttribute("courseTeacherType", (Object)"");
        if (any.isPresent()) {
            model.addAttribute("courseTeacherType", (Object)any.get().getDictname());
        }
        return "teacherList";
    }
}

