/*
 * Decompiled with CFR 0.152.
 */
package com.talkilla.controller;

import com.talkilla.base.Result;
import com.talkilla.constant.TalkillaConstant;
import com.talkilla.exception.base.ExceptionUtil;
import com.talkilla.mysql.domain.TStudent;
import com.talkilla.result.wechat.SellCourseDetailResult;
import com.talkilla.result.wechat.SellCourseListResult;
import com.talkilla.result.wechat.SellCourseOrderListResult;
import com.talkilla.service.wechat.SellCourseService;
import javax.servlet.http.HttpSession;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"/sell/cource"})
public class TalkillaSellCourceController {
    @Autowired
    private SellCourseService sellCourseService;

    @ExceptionHandler(value={Exception.class})
    public ModelAndView handleException(Exception ex) {
        return ExceptionUtil.printErrorInfo((Exception)ex);
    }

    @RequestMapping(value={"/sellCourseList"}, method={RequestMethod.GET})
    public String sellCourseList(HttpSession session, Model model) {
        SellCourseListResult sellCourseListResult = this.sellCourseService.sellCourseList();
        model.addAttribute((Object)sellCourseListResult);
        return "sellCourseList";
    }

    @RequestMapping(value={"/sellCourseDetail"}, method={RequestMethod.GET})
    public String sellCourseDetail(HttpSession session, Model model, Integer id) {
        SellCourseDetailResult sellCourseDetailResult = this.sellCourseService.sellCourseDetail(id);
        model.addAttribute("sellCourse", (Object)sellCourseDetailResult);
        return "sellCourseDetail";
    }

    @RequestMapping(value={"/createSellCourseOrder"}, method={RequestMethod.POST})
    @ResponseBody
    public String createSellCourseOrder(HttpSession session, Model model, Integer id) {
        TStudent student = (TStudent)session.getAttribute(TalkillaConstant.SESSION_WECHAT_LOGIN_PREFIX);
        Integer orderId = this.sellCourseService.createSellCourseOrder(id, student);
        return Result.success(orderId);
    }

    @RequestMapping(value={"/paySuccess"}, method={RequestMethod.POST})
    @ResponseBody
    public String paySuccess(HttpSession session, Model model, Integer id, Integer payType) {
        TStudent student = (TStudent)session.getAttribute(TalkillaConstant.SESSION_WECHAT_LOGIN_PREFIX);
        String result = this.sellCourseService.paySuccess(id, payType, student);
        return Result.success(result);
    }

    @RequestMapping(value={"/orderList"}, method={RequestMethod.GET})
    public String orderList(HttpSession session, Model model, Integer status) {
        TStudent student = (TStudent)session.getAttribute(TalkillaConstant.SESSION_WECHAT_LOGIN_PREFIX);
        SellCourseOrderListResult sellCourseOrderList = this.sellCourseService.orderList(status, student);
        model.addAttribute("sellCourseOrderList", (Object)sellCourseOrderList);
        return "orderList";
    }

    @RequestMapping(value={"/renewCourse"}, method={RequestMethod.POST})
    @ResponseBody
    public String renewCourse(HttpSession session, Model model, Integer id) {
        TStudent student = (TStudent)session.getAttribute(TalkillaConstant.SESSION_WECHAT_LOGIN_PREFIX);
        String result = this.sellCourseService.renewCourse(id, student);
        return Result.success(result);
    }
}

