/*
 * Decompiled with CFR 0.152.
 */
package com.talkilla.controller;

import com.talkilla.base.Result;
import com.talkilla.constant.TalkillaConstant;
import com.talkilla.exception.base.ExceptionUtil;
import com.talkilla.mysql.domain.TStudent;
import com.talkilla.mysql.domain.TWechat;
import com.talkilla.result.wechat.CourceSessionInfoResult;
import com.talkilla.result.wechat.CourseCenterResult;
import com.talkilla.result.wechat.CourseDetailResult;
import com.talkilla.result.wechat.CoursesessionCalender;
import com.talkilla.service.TStudentService;
import com.talkilla.service.TWechatService;
import com.talkilla.service.wechat.CourseService;
import com.talkilla.wechat.result.WechatUserLoginResult;
import com.talkilla.wechat.service.WechatService;
import com.talkilla.wechat.utils.JsonUtil;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"/course"})
public class TalkillaCourceController {
    private static final Logger logger = LoggerFactory.getLogger(TalkillaCourceController.class);
    @Autowired
    private CourseService courseService;
    @Autowired
    private WechatService wechatService;
    @Autowired
    private TWechatService tWechatService;
    @Autowired
    private TStudentService tStudentService;
    @Autowired
    private TStudentService studentService;

    @ExceptionHandler(value={Exception.class})
    public ModelAndView handleException(Exception ex) {
        return ExceptionUtil.printErrorInfo((Exception)ex);
    }

    @RequestMapping(value={"/courseCenter"}, method={RequestMethod.GET})
    public String courceCenter(HttpSession session, Model model, Integer type, String code, String state) {
        TStudent student;
        if (type == null) {
            type = 1;
        }
        if ((student = (TStudent)session.getAttribute(TalkillaConstant.SESSION_WECHAT_LOGIN_PREFIX)) == null) {
            WechatUserLoginResult wechatUserLoginResult = this.wechatService.getOpenIdOrUnionId(code);
            logger.info("\u83b7\u53d6\u5230\u7684\u7528\u6237openId\u4fe1\u606f\u4e3a: {}", (Object)wechatUserLoginResult);
            TWechat tWechat = null;
            if (wechatUserLoginResult != null) {
                session.setAttribute(TalkillaConstant.SESSION_WECHAT_OPENID_PREFIX, (Object)wechatUserLoginResult.getOpenid());
                tWechat = this.tWechatService.getTWechatInfoByOpenid(wechatUserLoginResult.getOpenid());
            }
            if (tWechat != null) {
                student = this.tStudentService.findStudentByLoginId(tWechat.getLoginId());
                session.setAttribute(TalkillaConstant.SESSION_WECHAT_LOGIN_PREFIX, (Object)student);
            }
        }
        if (student != null) {
            String[] split;
            int length;
            CourseCenterResult courseCenterResult = this.courseService.courceCenter(student.getStuId(), type);
            courseCenterResult.setEnglishname(student.getEnglishName());
            model.addAttribute((Object)courseCenterResult);
            model.addAttribute("type", (Object)type);
            model.addAttribute("stuId", (Object)student.getStuId());
            TStudent _student = this.studentService.findOne(student.getStuId());
            model.addAttribute("avatar", (Object)(_student == null ? "" : _student.getAvatar()));
            logger.info("=====>state:{}" + state);
            if (StringUtils.isNotBlank((CharSequence)state) && (length = (split = state.split("-")).length) > 1) {
                model.addAttribute(split[0], (Object)split[1]);
            }
        }
        if (student == null) {
            return "newLogin";
        }
        return "courseCenter";
    }

    @RequestMapping(value={"/beforeWeek"}, method={RequestMethod.POST})
    public String beforeWeek(HttpSession session, Model model, String showDate) throws ParseException {
        TStudent student = (TStudent)session.getAttribute(TalkillaConstant.SESSION_WECHAT_LOGIN_PREFIX);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy\u5e74MM\u6708dd");
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(sdf.parse(showDate.split("-")[0]));
        calendar.add(5, -7);
        CoursesessionCalender coursesessionCalender = this.courseService.beforeWeek(student.getStuId(), calendar);
        model.addAttribute((Object)coursesessionCalender);
        return "changeWeek";
    }

    @RequestMapping(value={"/afterWeek"}, method={RequestMethod.GET})
    public String afterWeek(HttpSession session, Model model, String showDate) throws ParseException {
        TStudent student = (TStudent)session.getAttribute(TalkillaConstant.SESSION_WECHAT_LOGIN_PREFIX);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy\u5e74MM\u6708dd");
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(sdf.parse(showDate.split("-")[0]));
        calendar.add(5, 7);
        CoursesessionCalender coursesessionCalender = this.courseService.afterWeek(student.getStuId(), calendar);
        model.addAttribute((Object)coursesessionCalender);
        return "changeWeek";
    }

    @RequestMapping(value={"/updateCourseStatus"}, method={RequestMethod.POST})
    @ResponseBody
    public String updateCourseStatus(HttpSession session, Model model, Integer sessionid) throws ParseException {
        TStudent student = (TStudent)session.getAttribute(TalkillaConstant.SESSION_WECHAT_LOGIN_PREFIX);
        String result = this.courseService.updateCourseStatus(sessionid, student);
        return Result.success(result);
    }

    @RequestMapping(value={"/courseDetail"}, method={RequestMethod.GET})
    public String courseDetail(HttpSession session, Model model, Integer cid) throws ParseException {
        TStudent student = (TStudent)session.getAttribute(TalkillaConstant.SESSION_WECHAT_LOGIN_PREFIX);
        CourseDetailResult courseDetailResult = this.courseService.courseDetail(cid, student);
        model.addAttribute((Object)courseDetailResult);
        return "courseDetail";
    }

    @RequestMapping(value={"/studentSummaryList"}, method={RequestMethod.GET})
    @Deprecated
    public String studentSummaryList(HttpSession session, Model model) throws ParseException {
        TStudent student = (TStudent)session.getAttribute(TalkillaConstant.SESSION_WECHAT_LOGIN_PREFIX);
        List studentSummaryList = this.courseService.studentSummaryList(student.getStuId());
        model.addAttribute("studentSummaryList", (Object)studentSummaryList);
        return "studentSummaryList";
    }

    @ResponseBody
    @RequestMapping(value={"/session/info"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public String courceSessionInfo(HttpSession session, Model model, Integer sessionid) {
        TStudent student = (TStudent)session.getAttribute(TalkillaConstant.SESSION_WECHAT_LOGIN_PREFIX);
        CourceSessionInfoResult sessionInfo = this.courseService.courceSessionInfo(sessionid, student);
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        result.put("code", 0);
        result.put("data", (Integer)sessionInfo);
        return JsonUtil.objToStr(result);
    }
}

