/*
 * Decompiled with CFR 0.152.
 */
package com.talkilla.controller;

import com.talkilla.base.Result;
import com.talkilla.exception.base.ExceptionUtil;
import com.talkilla.form.student.MobileRegisterForm;
import com.talkilla.form.student.MobileRegisterSavePWDForm;
import com.talkilla.form.student.RegisterForm;
import com.talkilla.service.CommonService;
import com.talkilla.service.student.StuUserService;
import com.talkilla.utils.mobile.Device;
import com.talkilla.utils.mobile.LiteDeviceResolver;
import java.text.ParseException;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"/register"})
public class RegisterController {
    @Autowired
    StuUserService stuUserService;
    @Autowired
    CommonService commonService;

    @ExceptionHandler(value={Exception.class})
    public ModelAndView handleException(Exception ex) {
        return ExceptionUtil.printErrorInfo((Exception)ex);
    }

    @RequestMapping(value={"/page"})
    public String page(HttpServletRequest request, HttpSession session, Model model, RegisterForm form) {
        LiteDeviceResolver liteDeviceResolver = new LiteDeviceResolver();
        model.addAttribute("list", (Object)this.commonService.getNations());
        model.addAttribute("zones", (Object)this.commonService.getZones());
        model.addAttribute("form", (Object)form);
        Device device = liteDeviceResolver.resolveDevice(request);
        if (device.isMobile()) {
            return "stuRegisterMobile";
        }
        return "stuRegister";
    }

    @RequestMapping(value={"/rand"})
    public String rand(HttpServletRequest request, HttpSession session, Model model) {
        return "rand";
    }

    @RequestMapping(value={"/save"})
    public String doSave(HttpServletRequest request, HttpSession session, Model model, RegisterForm form) throws ParseException {
        LiteDeviceResolver liteDeviceResolver = new LiteDeviceResolver();
        Device device = liteDeviceResolver.resolveDevice(request);
        HashMap resultMap = this.stuUserService.register(session, form);
        String flag = (String)resultMap.get("flag");
        String message = (String)resultMap.get("message");
        if (flag.equals("1")) {
            model.addAttribute("error", (Object)message);
            model.addAttribute("form", (Object)form);
            if (device.isMobile()) {
                return "stuRegisterMobile";
            }
            return "stuRegister";
        }
        model.addAttribute("message", (Object)message);
        model.addAttribute("form", (Object)form);
        if (device.isMobile()) {
            return "mbRegistFinish";
        }
        return "redirect:/user/logOut";
    }

    @RequestMapping(value={"/mobile/page"})
    public String mobilePage(HttpServletRequest request, HttpSession session, Model model, MobileRegisterForm form) {
        model.addAttribute("form", (Object)form);
        return "stuMobileRegister";
    }

    @RequestMapping(value={"/service_protol/page"})
    public String service_protol(HttpServletRequest request, HttpSession session, Model model, MobileRegisterForm form) {
        model.addAttribute("form", (Object)form);
        return "service_protol";
    }

    @RequestMapping(value={"/mobile/save"})
    @ResponseBody
    public String mobileSave(HttpServletRequest request, HttpSession session, Model model, @RequestBody MobileRegisterForm form) throws ParseException {
        HashMap result = this.stuUserService.registerByMobile(form);
        model.addAttribute("form", (Object)form);
        model.addAttribute("result", (Object)result);
        model.addAttribute("stuId", result.get("stuId"));
        if ("1".equals(result.get("flag"))) {
            return Result.failure(result.get("message"));
        }
        return Result.success(result.get("stuId"));
    }

    @RequestMapping(value={"/mobile/registerPwd"})
    public String registerPwd(HttpServletRequest request, HttpSession session, Model model, String stuId) throws ParseException {
        model.addAttribute("stuId", (Object)stuId);
        return "stuMobileSavePassword";
    }

    @RequestMapping(value={"/mobile/save/password"}, method={RequestMethod.POST})
    @ResponseBody
    public String mobileSavePassword(HttpServletRequest request, HttpSession session, Model model, @RequestBody MobileRegisterSavePWDForm form) {
        LiteDeviceResolver liteDeviceResolver = new LiteDeviceResolver();
        Device device = liteDeviceResolver.resolveDevice(request);
        HashMap result = this.stuUserService.savePassword(form);
        if ("1".equals(result.get("flag"))) {
            return Result.failure(result.get("message"));
        }
        return Result.success(result.get("message"));
    }

    @RequestMapping(value={"/mobile/mbRegistFinish"})
    public String mobileSavePassword(HttpServletRequest request, HttpSession session, Model model) {
        return "mbRegistFinish";
    }
}

