/*
 * Decompiled with CFR 0.152.
 */
package com.talkilla.controller;

import com.talkilla.constant.TalkillaConstant;
import com.talkilla.mysql.domain.TAwardCourse;
import com.talkilla.mysql.domain.TCourse;
import com.talkilla.mysql.domain.TStudent;
import com.talkilla.mysql.domain.TWechat;
import com.talkilla.result.admin.base.PageObj;
import com.talkilla.result.wechat.CourseCenterResult;
import com.talkilla.service.TStudentService;
import com.talkilla.service.TWechatService;
import com.talkilla.service.admin.AdminStudentService;
import com.talkilla.service.wechat.CourseService;
import com.talkilla.service.wechat.LessonTimeAwardService;
import com.talkilla.wechat.result.WechatUserLoginResult;
import com.talkilla.wechat.service.WechatService;
import java.math.BigDecimal;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"/timeAward"})
public class LessonTimeAwardController {
    private static final Logger logger = LoggerFactory.getLogger(LessonTimeAwardController.class);
    @Autowired
    private AdminStudentService adminStudentService;
    @Autowired
    private CourseService courseService;
    @Autowired
    private LessonTimeAwardService lessonTimeAwardService;
    @Autowired
    private WechatService wechatService;
    @Autowired
    private TWechatService tWechatService;
    @Autowired
    private TStudentService tStudentService;
    @Autowired
    private TStudentService studentService;

    @RequestMapping(value={"/timeAward/get"})
    public String awardList(HttpServletRequest request, HttpSession session, Model model, Integer pageNo, String code, String state) {
        try {
            TStudent student = (TStudent)session.getAttribute(TalkillaConstant.SESSION_WECHAT_LOGIN_PREFIX);
            if (student == null) {
                WechatUserLoginResult wechatUserLoginResult = this.wechatService.getOpenIdOrUnionId(code);
                logger.info("\u83b7\u53d6\u5230\u7684\u7528\u6237openId\u4fe1\u606f\u4e3a: {}", (Object)wechatUserLoginResult);
                TWechat tWechat = null;
                if (wechatUserLoginResult != null) {
                    session.setAttribute(TalkillaConstant.SESSION_WECHAT_OPENID_PREFIX, (Object)wechatUserLoginResult.getOpenid());
                    tWechat = this.tWechatService.getTWechatInfoByOpenid(wechatUserLoginResult.getOpenid());
                }
                if (tWechat != null) {
                    student = this.tStudentService.findStudentByLoginId(tWechat.getLoginId());
                    session.setAttribute(TalkillaConstant.SESSION_WECHAT_LOGIN_PREFIX, (Object)student);
                }
            }
            Integer _pageNo = pageNo == null || pageNo < 1 ? Integer.valueOf(1) : Integer.valueOf(pageNo);
            if (student != null) {
                PageObj pageObj = this.adminStudentService.findTAwardCourseRecordList(Integer.valueOf(student.getStuId()), Integer.valueOf(_pageNo), Integer.valueOf(10));
                model.addAttribute("pageObj", (Object)pageObj);
                model.addAttribute("stuId", (Object)student.getStuId());
                model.addAttribute("pageNo", (Object)_pageNo);
                model.addAttribute("pageSize", (Object)10);
                model.addAttribute("firstPage", (Object)1);
                if (pageObj.getTotalCount() % 10L == 0L) {
                    model.addAttribute("countPage", (Object)(pageObj.getTotalCount() / 10L));
                } else {
                    model.addAttribute("countPage", (Object)(pageObj.getTotalCount() / 10L + 1L));
                }
                TAwardCourse tAwardCourse = this.lessonTimeAwardService.findOneByStuId(Integer.valueOf(student.getStuId()));
                if (tAwardCourse != null) {
                    model.addAttribute("course", (Object)tAwardCourse.getCourseNum());
                } else {
                    model.addAttribute("course", (Object)0);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "timeAward";
    }

    @RequestMapping(value={"/writeOff"})
    public String timeAwardWriteOff(HttpServletRequest request, HttpSession session, Model model) {
        try {
            TStudent student = (TStudent)session.getAttribute(TalkillaConstant.SESSION_WECHAT_LOGIN_PREFIX);
            logger.info("\u5956\u52b1\u8bfe\u65f6\u6838\u9500: {}", (Object)student);
            TAwardCourse tAwardCourse = this.lessonTimeAwardService.findOneByStuId(Integer.valueOf(student.getStuId()));
            if (student != null) {
                CourseCenterResult courseCenterResult = this.courseService.courceCenter(student.getStuId(), Integer.valueOf(1));
                courseCenterResult.setEnglishname(student.getEnglishName());
                if (tAwardCourse.getCourseNum() == 0.0 || courseCenterResult == null) {
                    return "writeOffPrompt";
                }
                model.addAttribute((Object)courseCenterResult);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "writeOff";
    }

    @RequestMapping(value={"/confirmWriteOff"})
    public String timeAwardConfirmWriteOff(HttpServletRequest request, HttpSession session, Model model, Integer cid) {
        try {
            TStudent student = (TStudent)session.getAttribute(TalkillaConstant.SESSION_WECHAT_LOGIN_PREFIX);
            logger.info("\u5956\u52b1\u8bfe\u65f6\u6838\u9500\u786e\u8ba4\u9875\u9762: {}", (Object)student);
            if (student != null) {
                TAwardCourse tAwardCourse = this.lessonTimeAwardService.findOneByStuId(Integer.valueOf(student.getStuId()));
                logger.info("\u5956\u52b1\u8bfe\u65f6\u6838\u9500\u786e\u8ba4\u9875\u9762: {}", (Object)student.getEnglishName());
                if (tAwardCourse.getCourseNum() == 0.0) {
                    return "writeOffPrompt";
                }
                if (tAwardCourse != null) {
                    model.addAttribute("courseNum", (Object)tAwardCourse.getCourseNum());
                }
                TCourse _tCourse = this.lessonTimeAwardService.findOne(Integer.valueOf(cid));
                if (tAwardCourse != null) {
                    model.addAttribute("duration", (Object)_tCourse.getDuration());
                }
                model.addAttribute("cid", (Object)cid);
                if (tAwardCourse != null && tAwardCourse != null) {
                    model.addAttribute("tAwardTime", (Object)BigDecimal.valueOf(Math.floor(tAwardCourse.getCourseNum() * 60.0 / (double)_tCourse.getDuration().intValue())).stripTrailingZeros().toPlainString());
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "confirmWriteOff";
    }

    @RequestMapping(value={"/completeWriteOff"})
    public ModelAndView timeAwardCompleteWriteOff(HttpServletRequest request, HttpSession session, Model model, Integer cid, Integer courseTime, Double frequency) {
        try {
            TStudent _student = (TStudent)session.getAttribute(TalkillaConstant.SESSION_WECHAT_LOGIN_PREFIX);
            logger.info("\u70b9\u51fb\u786e\u8ba4\u6309\u94ae\u5b8c\u6210\u6838\u9500\u64cd\u4f5c: {},{},{},{}", new Object[]{_student.getEnglishName(), cid, courseTime, frequency});
            TAwardCourse tAwardCourse = this.lessonTimeAwardService.findOneByStuId(Integer.valueOf(_student.getStuId()));
            TCourse tCourse = this.lessonTimeAwardService.findOne(Integer.valueOf(cid));
            Map _result = this.lessonTimeAwardService.timeAwardCompleteWriteOff(_student, cid, tCourse.getDuration(), Double.valueOf(Math.floor(tAwardCourse.getCourseNum() * 60.0 / (double)tCourse.getDuration().intValue())));
            if ("0".equals(_result.get("code"))) {
                return new ModelAndView("writeOffPrompt");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return new ModelAndView("redirect:/course/courseDetail?cid=" + cid);
    }
}

