/*
 * Decompiled with CFR 0.152.
 */
package com.talkilla.controller;

import com.talkilla.constant.TalkillaConstant;
import com.talkilla.exception.ValidationException;
import com.talkilla.exception.base.ExceptionUtil;
import com.talkilla.form.UserLoginForm;
import com.talkilla.form.student.FindpwdForm;
import com.talkilla.form.teacher.PersonalInfoUpdateForm;
import com.talkilla.form.teacher.ToChangePasswordPageForm;
import com.talkilla.mysql.domain.TConsultant;
import com.talkilla.mysql.domain.TLogin;
import com.talkilla.mysql.domain.TMessage;
import com.talkilla.mysql.domain.TTeacher;
import com.talkilla.mysql.mapper.TConsultantDao;
import com.talkilla.mysql.mapper.TLoginDao;
import com.talkilla.mysql.mapper.TTeacherDao;
import com.talkilla.result.ReturnMessageResult;
import com.talkilla.result.teacher.PersonalInfoResult;
import com.talkilla.result.teacher.ZTreeNode;
import com.talkilla.service.teacher.TeaCourseService;
import com.talkilla.service.teacher.TeaMessageService;
import com.talkilla.service.teacher.TeaUserService;
import com.talkilla.utils.JSONUtil;
import com.talkilla.utils.PasswordUtil;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.StringUtils;
import org.nestframework.commons.utils.StringUtil;
import org.omg.CORBA.portable.ApplicationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.ModelAndView;

@RequestMapping(value={"/user"})
@Controller
public class TeacherUserController {
    private static final Logger log = LoggerFactory.getLogger(TeacherUserController.class);
    @Autowired
    private TeaUserService teaUserService;
    @Autowired
    private TeaMessageService teaMessageService;
    @Autowired
    private TTeacherDao tTeacherDao;
    @Autowired
    private TLoginDao tLoginDao;
    @Autowired
    private TConsultantDao tConsultantDao;
    @Autowired
    private TeaCourseService teaCourseService;

    @ExceptionHandler(value={Exception.class})
    public ModelAndView handleException(Exception ex) {
        return ExceptionUtil.printErrorInfo((Exception)ex);
    }

    @RequestMapping(value={"/login/index"}, method={RequestMethod.GET})
    public String loginIndex() {
        return "telogin";
    }

    @RequestMapping(value={"/login"}, method={RequestMethod.POST})
    public String login(HttpSession session, HttpServletResponse response, UserLoginForm form, Model model) {
        ReturnMessageResult messageResult = new ReturnMessageResult();
        String originPassword = form.getPassword();
        form.setPassword(PasswordUtil.encrypt2((String)form.getPassword()).toLowerCase());
        TLogin loginUser = this.teaUserService.userLogin(form);
        if (loginUser != null) {
            if (!Objects.equals(loginUser.getRoleId(), TalkillaConstant.Role.TEACHER_TYPE)) {
                messageResult.setFlag(Integer.valueOf(1));
                messageResult.setMessage("\u8bf7\u4f7f\u7528\u6b63\u786e\u7684\u7528\u6237\u89d2\u8272\u767b\u9646\uff01");
            } else {
                log.info("\u8fdb\u5165\u767b\u5f55\u6210\u529f\u6b65\u9aa4---------");
                form.setPassword(originPassword);
                TTeacher teacher = this.teaUserService.findTeacherByLoginId(loginUser.getLoginId());
                session.setAttribute(TalkillaConstant.SESSION_TEACHER_LOGIN_PREFIX, (Object)teacher);
                messageResult.setFlag(Integer.valueOf(0));
                messageResult.setMessage("\u767b\u5f55\u6210\u529f\uff01");
                log.info("\u767b\u5f55\u6210\u529f---------");
                if (form.isRemember()) {
                    this.writeCookie(response, form);
                }
            }
        } else {
            messageResult.setFlag(Integer.valueOf(1));
            messageResult.setMessage("\u7528\u6237\u540d\u6216\u5bc6\u7801\u9519\u8bef\uff0c\u8bf7\u91cd\u65b0\u767b\u5f55\u3002");
        }
        model.addAttribute("messageResult", (Object)messageResult);
        model.addAttribute("form", (Object)form);
        return "telogin";
    }

    @RequestMapping(value={"/index"}, method={RequestMethod.GET})
    public String index(HttpSession session, Model model) {
        List noticeList;
        TTeacher teacher = (TTeacher)session.getAttribute(TalkillaConstant.SESSION_TEACHER_LOGIN_PREFIX);
        if (teacher == null) {
            log.info("\u8001\u5e08\u4e0d\u5b58\u5728---------");
            return "telogin";
        }
        TLogin tLogin = this.teaUserService.findTLoginByLoginId(teacher.getLoginId());
        model.addAttribute("tLogin", (Object)tLogin);
        TMessage tMessage = this.teaMessageService.getNewestUnReadMessage(teacher);
        if (Objects.nonNull(tMessage)) {
            boolean b;
            Date createTime = tMessage.getCreateTime();
            Date date = new Date();
            long abs = Math.abs(date.getTime() - createTime.getTime());
            boolean bl = b = abs / 2592000000L >= 1L;
            if (!b) {
                model.addAttribute("messageId", (Object)tMessage.getId());
            }
        }
        if ((noticeList = this.teaCourseService.findReportMessageByTeacherId(teacher.getTeacherId())) != null && noticeList.size() > 0) {
            model.addAttribute("noticeId", (Object)"\u6709\u6d88\u606f");
        }
        if (StringUtils.isBlank((String)teacher.getAvatar())) {
            session.setAttribute("message", (Object)"Please complete your personal information");
            session.setAttribute("login", (Object)"1");
            return "forward:/user/personal/info";
        }
        log.info("\u8df3\u8f6cindex\u9875\u9762 ---------");
        return "index";
    }

    @RequestMapping(value={"/menuList"}, method={RequestMethod.GET})
    @ResponseBody
    public String menuList(HttpSession session, HttpServletRequest request) {
        ArrayList<ZTreeNode> newRs = new ArrayList<ZTreeNode>();
        List rs = this.teaUserService.findTeacherMenuList();
        String ctx = request.getContextPath();
        if (ctx.equals("/")) {
            ctx = "";
        }
        if (rs != null && rs.size() > 0) {
            for (ZTreeNode znode : rs) {
                if (StringUtil.isNotEmpty((String)znode.getUrl())) {
                    if ("49".equals(znode.getId())) {
                        String znodeUrl = znode.getUrl();
                        TTeacher teacher = (TTeacher)session.getAttribute(TalkillaConstant.SESSION_TEACHER_LOGIN_PREFIX);
                        if (teacher != null) {
                            TConsultant tConsultant;
                            TTeacher tTeacher;
                            Integer loginId = teacher.getLoginId();
                            TLogin tLogin = this.tLoginDao.findOne(loginId);
                            String displayName = tLogin.getLoginName();
                            Integer roleId = tLogin.getRoleId();
                            if (roleId == 2 && (tTeacher = this.tTeacherDao.findTeacherByLoginId(loginId)) != null) {
                                displayName = tTeacher.getFirstName() + " " + tTeacher.getLastName();
                            }
                            if (roleId == 4 && (tConsultant = this.tConsultantDao.findByLoginId(loginId)) != null) {
                                displayName = tConsultant.geteName();
                            }
                            znodeUrl = znodeUrl + "?username=" + tLogin.getLoginName() + "&roleId=" + loginId + "&displayName=" + displayName;
                        }
                        znode.setUrl(znodeUrl);
                        znode.setTarget("_blank");
                    } else {
                        znode.setUrl(ctx + znode.getUrl());
                    }
                } else {
                    znode.setUrl("javascript:return false;");
                }
                znode.setMore("more");
                if ("24".equals(znode.getId()) || "25".equals(znode.getId())) continue;
                newRs.add(znode);
            }
        }
        return JSONUtil.objToStr(newRs);
    }

    @RequestMapping(value={"/loginOut"}, method={RequestMethod.GET})
    public String loginOut(HttpSession session) {
        session.removeAttribute(TalkillaConstant.SESSION_TEACHER_LOGIN_PREFIX);
        return "telogin";
    }

    @RequestMapping(value={"/toChangePasswordPage"}, method={RequestMethod.GET})
    public String toChangePasswordPage() {
        return "changePasswordPage";
    }

    @RequestMapping(value={"/passwordUpdate"}, method={RequestMethod.POST})
    public String passwordUpdate(ToChangePasswordPageForm form, HttpSession session, Model model) throws ValidationException {
        TTeacher teacher = (TTeacher)session.getAttribute(TalkillaConstant.SESSION_TEACHER_LOGIN_PREFIX);
        String flag = this.teaUserService.passwordUpdate(form, teacher.getLoginId());
        model.addAttribute("flag", (Object)flag);
        model.addAttribute("form", (Object)form);
        return "changePasswordPage";
    }

    @RequestMapping(value={"/personal/info"})
    public String personalInfo(HttpSession session, Model model) {
        TTeacher teacher = (TTeacher)session.getAttribute(TalkillaConstant.SESSION_TEACHER_LOGIN_PREFIX);
        PersonalInfoResult infoResult = this.teaUserService.personalInfo(teacher);
        TTeacher tTeacher = infoResult.gettTeacher();
        List timezones = infoResult.getTimezoneList();
        List countryList = infoResult.getCountryList();
        model.addAttribute("teacher", (Object)tTeacher);
        model.addAttribute("list", (Object)countryList);
        model.addAttribute("zones", (Object)timezones);
        if (session.getAttribute("login") != null && session.getAttribute("login").equals("1")) {
            model.addAttribute("message", session.getAttribute("message"));
        } else {
            model.addAttribute("message", (Object)"");
        }
        return "teacherInfoPage";
    }

    @RequestMapping(value={"/personal/info/update"})
    public String personalInfoUpdate(HttpSession session, Model model, @RequestParam(value="fileItem") MultipartFile fileItem, PersonalInfoUpdateForm form) throws IllegalAccessException, InvocationTargetException, ApplicationException {
        TTeacher teacher = (TTeacher)session.getAttribute(TalkillaConstant.SESSION_TEACHER_LOGIN_PREFIX);
        ReturnMessageResult messageResult = this.teaUserService.personalInfoUpdate(teacher, fileItem, form);
        model.addAttribute("message", (Object)messageResult.getMessage());
        PersonalInfoResult infoResult = this.teaUserService.personalInfo(teacher);
        TTeacher tTeacher = infoResult.gettTeacher();
        List timezones = infoResult.getTimezoneList();
        List countryList = infoResult.getCountryList();
        model.addAttribute("teacher", (Object)tTeacher);
        model.addAttribute("list", (Object)countryList);
        model.addAttribute("zones", (Object)timezones);
        if (messageResult.getFlag() == 0 && session.getAttribute("login") != null && session.getAttribute("login").equals("1")) {
            TLogin tLogin = this.teaUserService.findTLoginByLoginId(teacher.getLoginId());
            model.addAttribute("tLogin", (Object)tLogin);
            model.addAttribute("message", (Object)"");
            session.removeAttribute("login");
            return "index";
        }
        return "teacherInfoPage";
    }

    @RequestMapping(value={"/to/find/password/page"}, method={RequestMethod.GET})
    public String toFindpwdPage(Model model) {
        model.addAttribute("type", (Object)2);
        return "findpwdNext";
    }

    @RequestMapping(value={"/findpwd"}, method={RequestMethod.POST})
    public String findpwd(HttpSession session, Model model, FindpwdForm form) {
        HashMap result = this.teaUserService.findpwd(form);
        model.addAttribute("message", result.get("message"));
        return "login";
    }

    private void writeCookie(HttpServletResponse response, UserLoginForm form) {
        Cookie username = new Cookie("talkillau", form.getUsername());
        response.addCookie(username);
        Cookie password = new Cookie("talkillap", form.getPassword());
        response.addCookie(password);
    }
}

