/*
 * Decompiled with CFR 0.152.
 */
package com.talkilla.controller;

import com.talkilla.constant.TalkillaConstant;
import com.talkilla.exception.base.ExceptionUtil;
import com.talkilla.form.teacher.StudentClassDetailForm;
import com.talkilla.form.teacher.StudentListForm;
import com.talkilla.form.teacher.StudentSummaryAddForm;
import com.talkilla.form.teacher.StudentSummaryListForm;
import com.talkilla.mysql.domain.TCourse;
import com.talkilla.mysql.domain.TTeacher;
import com.talkilla.result.ReturnMessageResult;
import com.talkilla.result.admin.base.PageObj;
import com.talkilla.result.teacher.StudentDetailResult;
import com.talkilla.result.teacher.StudentInfoDetailResult;
import com.talkilla.service.admin.AdminStudentService;
import com.talkilla.service.form.QueryStudentDetailForm;
import com.talkilla.service.teacher.TeaStudentService;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.ModelAndView;

@RequestMapping(value={"/student"})
@Controller
public class TeacherStudentController {
    @Autowired
    private TeaStudentService teaStudentService;
    @Autowired
    private AdminStudentService adminStudentService;

    @ExceptionHandler(value={Exception.class})
    public ModelAndView handleException(Exception ex) {
        return ExceptionUtil.printErrorInfo((Exception)ex);
    }

    @RequestMapping(value={"/detail/infos"})
    public String studentDetail(HttpServletRequest request, Model model, QueryStudentDetailForm queryForm) {
        StudentDetailResult result = this.adminStudentService.getStudentDetailById(queryForm.getId());
        model.addAttribute("result", (Object)result);
        return "studentInfo";
    }

    @RequestMapping(value={"/list"})
    public String studentList(HttpSession session, Model model, StudentListForm form) throws ParseException {
        TTeacher teacher = (TTeacher)session.getAttribute(TalkillaConstant.SESSION_TEACHER_LOGIN_PREFIX);
        PageObj result = this.teaStudentService.studentList(form, teacher);
        model.addAttribute("pageObj", (Object)result);
        model.addAttribute("form", (Object)form);
        model.addAttribute("message", (Object)"");
        return "studentsList";
    }

    @RequestMapping(value={"/detail"})
    public String studentDetail(HttpSession session, Model model, Integer stuId) throws ParseException {
        TTeacher teacher = (TTeacher)session.getAttribute(TalkillaConstant.SESSION_TEACHER_LOGIN_PREFIX);
        List resultList = this.teaStudentService.studentDetailList(teacher, stuId);
        model.addAttribute("list", (Object)resultList);
        model.addAttribute("stuId", (Object)stuId);
        return "studentsDetailList";
    }

    @RequestMapping(value={"/class/detail"})
    public String studentClassDetail(HttpSession session, Model model, StudentClassDetailForm form) {
        TCourse tCourse = this.teaStudentService.studentClassDetail(form);
        ArrayList<TCourse> list = new ArrayList<TCourse>();
        list.add(tCourse);
        PageObj pageObj = new PageObj();
        pageObj.setCurrPageNumber(Integer.valueOf(1));
        pageObj.setFirstPageNumber(Integer.valueOf(1));
        pageObj.setLastPageNumber(Integer.valueOf(1));
        pageObj.setPreviousPageNumber(Integer.valueOf(1));
        pageObj.setNextPageNumber(pageObj.processNextPage());
        pageObj.setPageElements(list);
        pageObj.setPageSize(Integer.valueOf(10));
        pageObj.setTotalCount(Long.valueOf(1L));
        model.addAttribute("pageObj", (Object)pageObj);
        return "studentClassDetail";
    }

    @RequestMapping(value={"/info/detail"}, method={RequestMethod.GET})
    public String studentInfoDetail(HttpSession session, Model model, Integer stuId) {
        StudentInfoDetailResult result = this.teaStudentService.studentInfoDetail(stuId);
        model.addAttribute("result", (Object)result);
        return "studentForTea";
    }

    @RequestMapping(value={"/summaryList"}, method={RequestMethod.GET})
    public String studentSummaryList(HttpSession session, Model model, StudentSummaryListForm form) {
        TTeacher teacher = (TTeacher)session.getAttribute(TalkillaConstant.SESSION_TEACHER_LOGIN_PREFIX);
        PageObj pageObj = this.teaStudentService.studentSummaryList(teacher, form);
        model.addAttribute("pageObj", (Object)pageObj);
        model.addAttribute("form", (Object)form);
        return "teacherSummaryList";
    }

    @RequestMapping(value={"/summaryAdd"})
    public String studentSummaryAdd(HttpSession session, Model model, StudentSummaryAddForm form) {
        TTeacher teacher = (TTeacher)session.getAttribute(TalkillaConstant.SESSION_TEACHER_LOGIN_PREFIX);
        ReturnMessageResult messageResult = this.teaStudentService.studentSummaryAdd(teacher, form);
        model.addAttribute("messageResult", (Object)messageResult);
        return "teacherSummaryList";
    }
}

