/*
 * Decompiled with CFR 0.152.
 */
package com.talkilla.interceptor;

import java.io.UnsupportedEncodingException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

public class JsonpInterceptor
extends HandlerInterceptorAdapter {
    private static Logger logger = LoggerFactory.getLogger(JsonpInterceptor.class);

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        this.configCrossDomain(request, response);
        this.setEncoding(request, response);
        return super.preHandle(request, response, handler);
    }

    private void configCrossDomain(HttpServletRequest request, HttpServletResponse response) {
        String referer = request.getHeader("Referer");
        String host = "";
        if (StringUtils.isNotBlank((CharSequence)referer) && (host = referer.split("/.")[1]).endsWith("/")) {
            host = host.substring(0, host.length() - 1);
        }
        String domainRoot = "";
        if (host.endsWith("bqmart.cn")) {
            domainRoot = host.replace(".bqmart.cn", "");
        } else if (StringUtils.isNotBlank((CharSequence)domainRoot)) {
            response.setHeader("Access-Control-Allow-Origin", "http://" + domainRoot + ".bqmart.cn");
            response.setHeader("Access-Control-Allow-Credentials", "true");
            response.setHeader("Access-Control-Allow-Methods", "*");
            response.setHeader("Access-Control-Expose-Headers", "~o^_^o~;");
        } else {
            response.setHeader("Access-Control-Allow-Origin", "http://" + host);
            response.setHeader("Access-Control-Allow-Credentials", "true");
            response.setHeader("Access-Control-Allow-Methods", "*");
            response.setHeader("Access-Control-Expose-Headers", "~o^_^o~");
        }
        response.setHeader("Access-Control-Allow-Methods", "POST,GET,OPTIONS,DELETE");
        response.setHeader("Access-Control-Max-Age", "3600");
        response.setHeader("Access-Control-Allow-Headers", "Origin, X-Requested-With, Content-Type, Date, Accept,If-Modified-Since");
    }

    private void setEncoding(HttpServletRequest request, HttpServletResponse response) throws UnsupportedEncodingException {
        request.setCharacterEncoding("UTF-8");
        response.setCharacterEncoding("UTF-8");
    }
}

