/*
 * Decompiled with CFR 0.152.
 */
package com.talkilla.controller;

import com.talkilla.constant.TalkillaConstant;
import com.talkilla.mysql.domain.TTeacher;
import com.talkilla.mysql.domain.TTeacherWorkTime;
import com.talkilla.result.teacher.TeacherWorkTimeResult;
import com.talkilla.service.teacher.TeaWorkTimeService;
import com.talkilla.utils.DateUtils;
import java.text.ParseException;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.Date;
import javax.servlet.http.HttpSession;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@RequestMapping(value={"/work/time"})
@Controller
public class TeacherWorkTimeController {
    @Autowired
    TeaWorkTimeService teaWorkTimeService;

    @RequestMapping(value={"/add"}, method={RequestMethod.POST})
    @ResponseBody
    public TeacherWorkTimeResult addTime(HttpSession session, int weekDay, int rangeId, int status) {
        TTeacher teacher = (TTeacher)session.getAttribute(TalkillaConstant.SESSION_TEACHER_LOGIN_PREFIX);
        Date now = new Date();
        int currentWeekDay = LocalDate.from(now.toInstant().atZone(ZoneId.systemDefault())).getDayOfWeek().getValue();
        int addDays = 0;
        addDays = currentWeekDay > weekDay ? 7 - currentWeekDay + weekDay : weekDay - currentWeekDay;
        Date addDate = org.apache.commons.lang.time.DateUtils.addDays((Date)now, (int)addDays);
        TTeacherWorkTime workTime = new TTeacherWorkTime();
        workTime.setTeacherId(teacher.getTeacherId());
        workTime.setDay(Integer.valueOf(DateUtils.formatDate((Date)addDate, (String)"yyyyMMdd")));
        workTime.setWeekDay(Integer.valueOf(weekDay));
        workTime.setTimeRangeId(Integer.valueOf(rangeId));
        workTime.setStatus(Integer.valueOf(status));
        workTime.setIsDelete(Integer.valueOf(0));
        this.teaWorkTimeService.addWorkTime(workTime);
        return this.teaWorkTimeService.getWorkTimeTale(teacher.getTeacherId().intValue(), 30);
    }

    @RequestMapping(value={"/info"}, method={RequestMethod.GET})
    @ResponseBody
    public Object getTimeTable(HttpSession session) {
        TTeacher teacher = (TTeacher)session.getAttribute(TalkillaConstant.SESSION_TEACHER_LOGIN_PREFIX);
        TeacherWorkTimeResult workTimeTale = this.teaWorkTimeService.getWorkTimeTale(teacher.getTeacherId().intValue(), 30);
        return workTimeTale;
    }

    @RequestMapping(value={"/index"})
    public String studentList(HttpSession session) throws ParseException {
        return "teacherWorkTime";
    }
}

