/*
 * Decompiled with CFR 0.152.
 */
package com.talkilla.controller;

import com.talkilla.constant.TalkillaConstant;
import com.talkilla.form.teacher.message.TeaQueryMessageForm;
import com.talkilla.mysql.domain.TMessage;
import com.talkilla.mysql.domain.TTeacher;
import com.talkilla.result.admin.base.PageObj;
import com.talkilla.service.teacher.TeaMessageService;
import javax.servlet.http.HttpSession;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
@RequestMapping(value={"/teacher/message"})
public class TeacherMessageController {
    @Autowired
    private TeaMessageService teaMessageService;

    @RequestMapping(value={"/newest"})
    public String newest(Model model, HttpSession session) {
        TTeacher teacher = (TTeacher)session.getAttribute(TalkillaConstant.SESSION_TEACHER_LOGIN_PREFIX);
        TMessage tMessage = this.teaMessageService.getNewestUnReadMessage(teacher);
        model.addAttribute("message", (Object)tMessage);
        return "message/detail";
    }

    @RequestMapping(value={"/list"})
    public String list(TeaQueryMessageForm form, Model model, HttpSession session) {
        TTeacher teacher = (TTeacher)session.getAttribute(TalkillaConstant.SESSION_TEACHER_LOGIN_PREFIX);
        form.setTeacherId(teacher.getTeacherId());
        PageObj pageObj = this.teaMessageService.findPageMessage(form);
        model.addAttribute("pageObj", (Object)pageObj);
        model.addAttribute("form", (Object)form);
        return "message/list";
    }

    @RequestMapping(value={"/detail"})
    public String info(Model model, HttpSession session, Integer messageId) {
        TTeacher teacher = (TTeacher)session.getAttribute(TalkillaConstant.SESSION_TEACHER_LOGIN_PREFIX);
        TMessage tMessage = this.teaMessageService.fetchAndFreshMessageStatus(teacher, messageId);
        model.addAttribute("message", (Object)tMessage);
        return "message/detail";
    }

    @RequestMapping(value={"/mark/read"})
    public void readedStatusUpdate(Integer messageId, HttpSession session) {
        TTeacher teacher = (TTeacher)session.getAttribute(TalkillaConstant.SESSION_TEACHER_LOGIN_PREFIX);
        this.teaMessageService.readedStatusUpdate(messageId, teacher);
    }
}

