/*
 * Decompiled with CFR 0.152.
 */
package com.talkilla.controller;

import com.talkilla.constant.TalkillaConstant;
import com.talkilla.exception.UserException;
import com.talkilla.exception.base.ExceptionUtil;
import com.talkilla.form.teacher.CourseTeachingListForm;
import com.talkilla.form.teacher.SaveModifyStatusForm;
import com.talkilla.mysql.domain.TStuFeeback;
import com.talkilla.mysql.domain.TStudent;
import com.talkilla.mysql.domain.TTeacher;
import com.talkilla.mysql.domain.TTeacherComments;
import com.talkilla.result.ClassStatusBean;
import com.talkilla.result.ReturnMessageResult;
import com.talkilla.result.admin.base.PageObj;
import com.talkilla.result.teacher.CourseTeachingListResult;
import com.talkilla.result.teacher.StuCommentListResult;
import com.talkilla.result.teacher.StuFeedbackListResult;
import com.talkilla.result.teacher.TeacherIndexResult;
import com.talkilla.result.teacher.TeacherSchedualResult;
import com.talkilla.result.teacher.ToModifystustatusResult;
import com.talkilla.service.TStudentService;
import com.talkilla.service.teacher.TeaCourseService;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.ModelAndView;

@RequestMapping(value={"course"})
@Controller
public class TeacherCourseController {
    @Autowired
    private TeaCourseService teaCourseService;
    @Autowired
    private TStudentService tStudentService;

    @ExceptionHandler(value={Exception.class})
    public ModelAndView handleException(Exception ex) {
        return ExceptionUtil.printErrorInfo((Exception)ex);
    }

    @RequestMapping(value={"/teacherIndex"}, method={RequestMethod.GET})
    public String teacherIndex(HttpSession session, HttpServletRequest request, Model model) throws ParseException {
        TTeacher teacher = (TTeacher)session.getAttribute(TalkillaConstant.SESSION_TEACHER_LOGIN_PREFIX);
        TeacherIndexResult result = this.teaCourseService.teacherIndex(teacher);
        if (Objects.nonNull(request)) {
            model.addAttribute("result", (Object)result);
        }
        return "teacherIndex";
    }

    @RequestMapping(value={"/toModifystustatus"}, method={RequestMethod.GET})
    public String toModifystustatus(HttpSession session, Model model, Integer sessionid) {
        TTeacher teacher = (TTeacher)session.getAttribute(TalkillaConstant.SESSION_TEACHER_LOGIN_PREFIX);
        ToModifystustatusResult result = this.teaCourseService.toModifystustatus(sessionid, teacher);
        ArrayList<ClassStatusBean> classStatusList = new ArrayList<ClassStatusBean>();
        Set keys = TalkillaConstant.statusMap.keySet();
        for (Integer key : keys) {
            if (key.equals(TalkillaConstant.COURSE_STATUS_LEAVE_STUDENT) || key.equals(TalkillaConstant.COURSE_STATUS_UMCONFIRMED)) continue;
            ClassStatusBean classStatusBean = new ClassStatusBean();
            classStatusBean.setStatus(key);
            classStatusBean.setStatusStr((String)TalkillaConstant.statusMap.get(key));
            classStatusList.add(classStatusBean);
        }
        model.addAttribute("result", (Object)result);
        model.addAttribute("classStatusList", classStatusList);
        model.addAttribute("message", (Object)"");
        return "modifyTeacherStatus";
    }

    @RequestMapping(value={"/saveModifyStatus"}, method={RequestMethod.POST})
    public String saveModifyStatus(SaveModifyStatusForm form, HttpSession session, HttpServletRequest request, Model model) throws ParseException, UserException {
        TTeacher teacher = (TTeacher)session.getAttribute(TalkillaConstant.SESSION_TEACHER_LOGIN_PREFIX);
        ReturnMessageResult messageResult = this.teaCourseService.saveModifyStatus(teacher, form);
        model.addAttribute("messageResult", (Object)messageResult);
        model.addAttribute("message", (Object)"");
        return this.toModifystustatus(session, model, form.getSessionid());
    }

    @RequestMapping(value={"/teaching/list"}, method={RequestMethod.GET})
    public String courseTeachingList(CourseTeachingListForm form, HttpSession session, Model model) throws ParseException {
        TTeacher teacher = (TTeacher)session.getAttribute(TalkillaConstant.SESSION_TEACHER_LOGIN_PREFIX);
        CourseTeachingListResult result = this.teaCourseService.courseTeachingList(form, teacher);
        PageObj pageObj = new PageObj();
        pageObj.setCurrPageNumber(result.getPageNo());
        pageObj.setFirstPageNumber(Integer.valueOf(1));
        pageObj.setLastPageNumber(pageObj.processTotalPage(result.getTotalCount().longValue(), result.getPageSize()));
        pageObj.setPreviousPageNumber(pageObj.processPreviousPage(result.getPageNo()));
        pageObj.setNextPageNumber(pageObj.processNextPage());
        pageObj.setPageElements(result.getResultList());
        pageObj.setPageSize(result.getPageSize());
        pageObj.setTotalCount(result.getTotalCount());
        model.addAttribute("pageObj", (Object)pageObj);
        model.addAttribute("totalMoney", (Object)result.getTotalMoney());
        model.addAttribute("form", (Object)form);
        model.addAttribute("message", (Object)"");
        return "teachingRecordList";
    }

    @RequestMapping(value={"/stuComment/list"}, method={RequestMethod.GET})
    public String stuCommentList(HttpSession session, Model model, Integer sessionid) throws ParseException {
        TTeacher teacher = (TTeacher)session.getAttribute(TalkillaConstant.SESSION_TEACHER_LOGIN_PREFIX);
        TTeacherComments comments = this.teaCourseService.stuCommentList(teacher, sessionid);
        ArrayList<StuCommentListResult> commentList = new ArrayList<StuCommentListResult>();
        if (comments != null) {
            StuCommentListResult stuComment = new StuCommentListResult();
            stuComment.setFeeback(comments.getComments());
            TStudent one = this.tStudentService.findOne(comments.getStuId());
            stuComment.setEnglishName(one.getEnglishName());
            commentList.add(stuComment);
        }
        model.addAttribute("comments", commentList);
        return "stuCommentsList";
    }

    @RequestMapping(value={"/stuFeedback/list"}, method={RequestMethod.GET})
    public String stuFeedbackList(HttpSession session, Model model, Integer sessionid) throws ParseException {
        TTeacher teacher = (TTeacher)session.getAttribute(TalkillaConstant.SESSION_TEACHER_LOGIN_PREFIX);
        List feedbacks = this.teaCourseService.stuFeedbackList(teacher, sessionid);
        ArrayList<StuFeedbackListResult> feedbackList = new ArrayList<StuFeedbackListResult>();
        if (!CollectionUtils.isEmpty((Collection)feedbacks)) {
            for (TStuFeeback feedback : feedbacks) {
                StuFeedbackListResult stuFeedback = new StuFeedbackListResult();
                stuFeedback.setStuId(feedback.getStuId());
                stuFeedback.setFeeback(feedback.getFeeback());
                stuFeedback.setStar(feedback.getStar());
                TStudent student = this.tStudentService.findOne(feedback.getStuId());
                stuFeedback.setStuName(student.getEnglishName());
                feedbackList.add(stuFeedback);
            }
        }
        model.addAttribute("feedbacks", feedbackList);
        return "stuFeedbacksList";
    }

    @RequestMapping(value={"/teaching/schedual"}, method={RequestMethod.GET})
    public String schedual(HttpSession session, HttpServletRequest request, Model model, Integer timezone) throws UserException, ParseException {
        TTeacher teacher = (TTeacher)session.getAttribute(TalkillaConstant.SESSION_TEACHER_LOGIN_PREFIX);
        TeacherSchedualResult result = this.teaCourseService.teacherSchedual(teacher);
        model.addAttribute("result", (Object)result);
        request.setAttribute("result", (Object)request);
        return "teacherSchedual";
    }

    @RequestMapping(value={"/teaching/schedual/update"}, method={RequestMethod.POST})
    public String updateSchedual(HttpSession session, HttpServletRequest request, Model model, Integer teacherId, String beginTime, String endTime, Integer timezone) throws UserException, ParseException {
        TTeacher teacher = (TTeacher)session.getAttribute(TalkillaConstant.SESSION_TEACHER_LOGIN_PREFIX);
        TeacherSchedualResult result = this.teaCourseService.teacherSchedual(teacher);
        model.addAttribute("result", (Object)result);
        request.setAttribute("result", (Object)request);
        return "teacherSchedual";
    }
}

