/*
 * Decompiled with CFR 0.152.
 */
package com.talkilla.controller;

import com.talkilla.base.Result;
import com.talkilla.constant.TalkillaConstant;
import com.talkilla.exception.BusinessException;
import com.talkilla.exception.UserException;
import com.talkilla.exception.base.ExceptionUtil;
import com.talkilla.form.UserLoginForm;
import com.talkilla.form.student.AvatarForm;
import com.talkilla.form.student.FindPwdSaveForm;
import com.talkilla.form.student.FindpwdForm;
import com.talkilla.form.student.MobileForm;
import com.talkilla.form.student.ModifyEmailForm;
import com.talkilla.form.student.PasswordUpdateForm;
import com.talkilla.form.student.RegisterForm;
import com.talkilla.form.student.UserInfoModifySaveForm;
import com.talkilla.form.student.UserLoginByCodeForm;
import com.talkilla.mysql.domain.TLogin;
import com.talkilla.mysql.domain.TStudent;
import com.talkilla.mysql.domain.TWechat;
import com.talkilla.mysql.mapper.TLoginDao;
import com.talkilla.mysql.mapper.TWechatDao;
import com.talkilla.otherbean.UserDto;
import com.talkilla.otherbean.ZTreeNode;
import com.talkilla.result.ReturnMessageResult;
import com.talkilla.result.admin.StudentEditInfoResult;
import com.talkilla.result.student.LoginIndexResult;
import com.talkilla.service.CommonService;
import com.talkilla.service.TLoginService;
import com.talkilla.service.TStudentService;
import com.talkilla.service.TWechatService;
import com.talkilla.service.admin.AdminService;
import com.talkilla.service.admin.AdminStudentService;
import com.talkilla.service.form.AdminStudentEditSaveForm;
import com.talkilla.service.form.QueryAreaNameForm;
import com.talkilla.service.impl.InitDictionUtil;
import com.talkilla.service.student.StuCourseService;
import com.talkilla.service.student.StuUserService;
import com.talkilla.service.wechat.UserService;
import com.talkilla.utils.DateUtils;
import com.talkilla.utils.PasswordUtil;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.StringUtils;
import org.nestframework.commons.utils.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"/user"})
public class StudentUserController {
    Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private StuUserService stuUserService;
    @Autowired
    private TStudentService studentService;
    @Autowired
    private StuCourseService stuCourseService;
    @Autowired
    private AdminService adminService;
    @Autowired
    private AdminStudentService adminStudentService;
    @Autowired
    private TLoginService tLoginService;
    @Autowired
    private UserService userService;
    @Autowired
    private CommonService commonService;
    @Autowired
    private TWechatService tWechatService;
    @Autowired
    InitDictionUtil initDictionUtil;
    @Autowired
    TWechatDao tWechatDao;
    @Autowired
    TLoginDao tLoginDao;

    @ExceptionHandler(value={Exception.class})
    public ModelAndView handleException(Exception ex) {
        return ExceptionUtil.printErrorInfo((Exception)ex);
    }

    @RequestMapping(value={"/login/index"}, method={RequestMethod.GET})
    public String loginIndex() {
        return "login";
    }

    @RequestMapping(value={"/loginOut"})
    public String loginOut(HttpSession session) {
        session.setAttribute(TalkillaConstant.SESSION_STUDENT_LOGIN_PREFIX, null);
        return "login";
    }

    @RequestMapping(value={"/login"}, method={RequestMethod.POST})
    @ResponseBody
    public String login(HttpSession session, Model model, @RequestBody UserLoginForm form) throws UserException {
        form.setPassword(PasswordUtil.encrypt2((String)form.getPassword()).toLowerCase());
        TLogin loginUser = this.stuUserService.userLogin(form);
        if (loginUser != null) {
            if (loginUser.getRoleId() != TalkillaConstant.KEY_LOGIN_TYPE_STUDENT) {
                throw new UserException((Object)"1002", "\u8bf7\u4f7f\u7528\u6b63\u786e\u7684\u7528\u6237\u89d2\u8272\u767b\u5f55");
            }
        } else {
            return Result.failure(" \u7528\u6237\u540d\u6216\u5bc6\u7801\u9519\u8bef\uff0c\u8bf7\u91cd\u65b0\u767b\u5f55\u3002");
        }
        TStudent student = this.studentService.findStudentByLoginId(loginUser.getLoginId());
        UserDto d = new UserDto();
        d.setLoginId(loginUser.getLoginId());
        d.setLoginName(loginUser.getLoginName());
        d.setUsertype(10003);
        d.setLoginPwd(loginUser.getLoginPwd());
        d.setLoginCount(loginUser.getLoginCount());
        d.setStuId(student.getStuId());
        session.setAttribute(TalkillaConstant.SESSION_STUDENT_LOGIN_PREFIX, (Object)d);
        return Result.success("\u767b\u5f55\u6210\u529f");
    }

    @RequestMapping(value={"/index"}, method={RequestMethod.GET})
    public String adminIndex(HttpSession session, Model model) {
        UserDto student = (UserDto)session.getAttribute(TalkillaConstant.SESSION_STUDENT_LOGIN_PREFIX);
        model.addAttribute("sessionUser", (Object)student);
        return "index";
    }

    @RequestMapping(value={"/index/detail"}, method={RequestMethod.GET})
    public String loginIndex(HttpSession session, Model model) {
        UserDto student = (UserDto)session.getAttribute(TalkillaConstant.SESSION_STUDENT_LOGIN_PREFIX);
        if (student == null) {
            return "login";
        }
        LoginIndexResult result = this.stuCourseService.loginIndex(student.getStuId());
        model.addAttribute("indexResult", (Object)result);
        model.addAttribute("student", (Object)student);
        model.addAttribute("date", (Object)new SimpleDateFormat("yyyy-MM-dd").format(new Date()));
        String[] paras = this.stuUserService.processStudentInfosByLoginId(student.getLoginId());
        model.addAttribute("paras", (Object)paras);
        List cals = this.stuUserService.findAllCalendarsByLoginId(student.getLoginId());
        model.addAttribute("cals", (Object)cals);
        return "studentIndex";
    }

    @RequestMapping(value={"/toRegisterPage"}, method={RequestMethod.GET})
    public String toRegisterPage() throws UserException {
        return "stuRegister";
    }

    @RequestMapping(value={"/register"}, method={RequestMethod.POST})
    public String register(HttpSession session, Model model, RegisterForm form) throws UserException, ParseException {
        HashMap resultMap = this.stuUserService.register(session, form);
        String flag = (String)resultMap.get("flag");
        String message = (String)resultMap.get("message");
        if (flag.equals("1")) {
            model.addAttribute("error", (Object)message);
            model.addAttribute("form", (Object)form);
        } else {
            model.addAttribute("message", (Object)message);
            model.addAttribute("form", (Object)form);
        }
        return "stuRegister";
    }

    @RequestMapping(value={"/findpwd/from"}, method={RequestMethod.POST})
    public String findPwd(HttpSession session, Model model, Integer type) {
        if (type != null && type.equals(1)) {
            return "redirect:/user/find/password/by/mobile/page";
        }
        if (type != null && type.equals(0)) {
            return "redirect:/user/to/find/password/page";
        }
        return "login";
    }

    @RequestMapping(value={"/findpwd/select"}, method={RequestMethod.POST})
    public String findpwdFrom(HttpSession session, Model model, Integer type) {
        if (type != null && type.equals(1)) {
            return "findpwdByMobilePage";
        }
        if (type != null && type.equals(2)) {
            return "findpwdNext";
        }
        return "login";
    }

    @RequestMapping(value={"/to/find/password/page"}, method={RequestMethod.GET})
    public String totoFindpwdPage(Model model) {
        model.addAttribute("type", (Object)1);
        return "findpwd";
    }

    @RequestMapping(value={"/findpwd"}, method={RequestMethod.POST})
    public String findpwd(HttpSession session, Model model, FindpwdForm form) {
        HashMap result = this.stuUserService.findpwd(form);
        model.addAttribute("message", result.get("message"));
        return "login";
    }

    @RequestMapping(value={"/to/change/password/page"}, method={RequestMethod.GET})
    public String toChangePasswordPage(HttpSession session) {
        return "changePasswordPage";
    }

    @RequestMapping(value={"/password/update"}, method={RequestMethod.POST})
    public String passwordUpdate(HttpSession session, Model model, PasswordUpdateForm form) {
        UserDto student = (UserDto)session.getAttribute(TalkillaConstant.SESSION_STUDENT_LOGIN_PREFIX);
        ReturnMessageResult messageResult = this.stuUserService.passwordUpdate(student, form);
        model.addAttribute("message", (Object)messageResult.getMessage());
        model.addAttribute("form", (Object)form);
        return "changePasswordPage";
    }

    @RequestMapping(value={"/edit"})
    public String doEdit(HttpSession session, Model model) {
        UserDto student = (UserDto)session.getAttribute(TalkillaConstant.SESSION_STUDENT_LOGIN_PREFIX);
        StudentEditInfoResult result = this.adminStudentService.getStudentEditInfo(student.getStuId());
        model.addAttribute("list", (Object)result.getNations());
        model.addAttribute("zones", (Object)result.getZones());
        model.addAttribute("student", (Object)result.getStudent());
        model.addAttribute("birthday", (Object)result.getBirthday());
        model.addAttribute("create_time", (Object)result.getCreate_time());
        model.addAttribute("consultantList", (Object)result.getConsultantList());
        result.setRawName(this.initDictionUtil.getCityNameById(result.getStudent().getCity() == null ? "" : result.getStudent().getCity().toString()));
        model.addAttribute("rawName", (Object)result.getRawName());
        model.addAttribute("consultant_email", (Object)result.getConsultantEmail());
        model.addAttribute("consultant_name", (Object)result.getConsultantName());
        return "studentEdit";
    }

    @RequestMapping(value={"/edit/save"})
    public String doSave(HttpServletRequest request, HttpSession session, Model model, AdminStudentEditSaveForm form, @RequestParam(value="fileItem") MultipartFile fileItem) {
        this.adminStudentService.saveStudent(form, fileItem);
        model.addAttribute("message", (Object)"\u4fdd\u5b58\u6210\u529f");
        return this.doEdit(session, model);
    }

    @RequestMapping(value={"/query/area/name"})
    @ResponseBody
    public Object queryAreaName(HttpServletRequest request, Model model, QueryAreaNameForm queryForm) {
        List x = this.adminService.findAllBZone(queryForm.getQueryName());
        ArrayList l = new ArrayList(x);
        int idx = -1;
        for (int i = 0; i < l.size(); ++i) {
            Map m = (Map)l.get(i);
            if (!"\u65e0".equals(m.get("text"))) continue;
            idx = i;
            break;
        }
        if (idx != -1) {
            l.remove(idx);
        }
        return l;
    }

    public static void main(String[] args) {
    }

    @RequestMapping(value={"/menu"}, method={RequestMethod.POST})
    @ResponseBody
    public Object menu(HttpServletRequest request) {
        List rs = new ArrayList();
        ArrayList<ZTreeNode> newRs = new ArrayList<ZTreeNode>();
        UserDto userDto = (UserDto)request.getSession().getAttribute(TalkillaConstant.SESSION_STUDENT_LOGIN_PREFIX);
        if (userDto == null) {
            return rs;
        }
        rs = this.stuUserService.findStudentMenuList(userDto.getLoginId());
        String ctx = request.getContextPath();
        if (ctx.equals("/")) {
            ctx = "";
        }
        if (rs != null && rs.size() > 0) {
            for (ZTreeNode znode : rs) {
                if (StringUtil.isNotEmpty((String)znode.getUrl())) {
                    znode.setUrl(ctx + znode.getUrl());
                } else {
                    znode.setUrl("javascript:return false;");
                }
                znode.setMore("\u66f4\u591a");
                if ("42".equals(znode.getId()) || "18".equals(znode.getId())) continue;
                if ("7".equals(znode.getId())) {
                    znode.setUrl("https://weidian.com/s/414344083?wfr=c&ifr=shopdetail");
                }
                newRs.add(znode);
            }
        }
        return newRs;
    }

    @RequestMapping(value={"/login/by/code"}, method={RequestMethod.POST})
    @ResponseBody
    public String loginByCode(HttpSession session, @RequestBody UserLoginByCodeForm form) throws UserException {
        TStudent student;
        TLogin loginUser = this.userService.userLoginByCode(form);
        if (loginUser != null) {
            if (loginUser.getRoleId() != TalkillaConstant.KEY_LOGIN_TYPE_STUDENT) {
                return Result.failure("\u8bf7\u4f7f\u7528\u6b63\u786e\u7684\u7528\u6237\u89d2\u8272\u767b\u5f55");
            }
            student = this.studentService.findStudentByLoginId(loginUser.getLoginId());
            String openid = (String)session.getAttribute(TalkillaConstant.SESSION_WECHAT_OPENID_PREFIX);
            this.logger.info("\u7528\u6237openId\uff1a{}" + openid);
            TWechat tWechat = this.tWechatService.getTWechatInfoByLoginId(student.getLoginId());
            if (Objects.isNull(tWechat)) {
                tWechat = new TWechat();
                tWechat.setUserId(student.getStuId());
                tWechat.setRoleId(Integer.valueOf(1));
                tWechat.setLoginId(student.getLoginId());
                tWechat.setOpenid(openid);
                this.tWechatDao.insertSelective(tWechat);
            } else {
                tWechat.setOpenid(openid);
                tWechat.setUpdateTime(new Date());
                this.tWechatDao.updateByIdSelective(tWechat);
            }
        } else {
            return Result.failure(" \u624b\u673a\u53f7\u6216\u8005\u9a8c\u8bc1\u7801\u9519\u8bef\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u3002");
        }
        UserDto d = new UserDto();
        d.setLoginId(loginUser.getLoginId());
        d.setLoginName(loginUser.getLoginName());
        d.setUsertype(10003);
        d.setLoginPwd(loginUser.getLoginPwd());
        d.setLoginCount(loginUser.getLoginCount());
        d.setStuId(student.getStuId());
        session.setAttribute(TalkillaConstant.SESSION_STUDENT_LOGIN_PREFIX, (Object)d);
        return Result.success("\u767b\u5f55\u6210\u529f");
    }

    @RequestMapping(value={"/find/password/by/mobile/page/next"}, method={RequestMethod.GET})
    @ResponseBody
    public String toFindpwdPageNext(HttpSession session, Model model, String mobile, String rand) {
        if (!this.commonService.checkRand(session, rand).booleanValue()) {
            model.addAttribute("message", (Object)"\u9a8c\u8bc1\u7801\u9519\u8bef");
            return Result.failure("\u9a8c\u8bc1\u7801\u9519\u8bef");
        }
        model.addAttribute("type", (Object)1);
        model.addAttribute("mobile", (Object)mobile);
        return Result.success("\u9a8c\u8bc1\u6210\u529f");
    }

    @RequestMapping(value={"/mobile/findpwdByMobilePageNext"}, method={RequestMethod.GET})
    public String findpwdByMobilePageNext(HttpSession session, Model model, String mobile, String rand) {
        model.addAttribute("type", (Object)1);
        model.addAttribute("mobile", (Object)mobile);
        return "findpwdByMobilePageNext";
    }

    @RequestMapping(value={"/rand"})
    public String rand(HttpServletRequest request, HttpSession session, Model model) {
        return "rand";
    }

    @RequestMapping(value={"/find/password/by/mobile/save"}, method={RequestMethod.GET})
    @ResponseBody
    public String findpwdSave(Model model, FindPwdSaveForm form) {
        model.addAttribute("type", (Object)1);
        Map result = this.userService.savePwdByMobile(form);
        if (((String)result.get("flag")).equals("1")) {
            model.addAttribute("type", (Object)1);
            model.addAttribute("mobile", (Object)form.getMobile());
            model.addAttribute("message", result.get("message"));
            return Result.failure(result.get("message"));
        }
        model.addAttribute("message", result.get("message"));
        return Result.success(result.get("message"));
    }

    @RequestMapping(value={"/info/modify/page"}, method={RequestMethod.GET})
    public String modifyPage(HttpServletRequest request, Model model) {
        UserDto userDto = (UserDto)request.getSession().getAttribute(TalkillaConstant.SESSION_STUDENT_LOGIN_PREFIX);
        TStudent student = this.userService.findStudentById(userDto.getStuId());
        model.addAttribute("birthday", (Object)DateUtils.formatDateToDay((Date)student.getBirthday()));
        model.addAttribute("student", (Object)student);
        model.addAttribute("stuId", (Object)userDto.getStuId());
        TLogin tLogin = this.tLoginDao.findByStuId(userDto.getStuId());
        model.addAttribute("eMail", (Object)tLogin.getLoginName());
        model.addAttribute("mobile", (Object)tLogin.getMobile());
        model.addAttribute("province", (Object)(this.commonService.findCityById(student.getProvinceId()) != null ? this.commonService.findCityById(student.getProvinceId()).getRegionName() : ""));
        model.addAttribute("city", (Object)(this.commonService.findCityById(student.getCityId()) != null ? this.commonService.findCityById(student.getCityId()).getRegionName() : ""));
        model.addAttribute("district", (Object)(this.commonService.findCityById(student.getDistrictId()) != null ? this.commonService.findCityById(student.getDistrictId()).getRegionName() : ""));
        return "studentModifyPage";
    }

    @RequestMapping(value={"/info/modify/save"}, method={RequestMethod.POST})
    @ResponseBody
    public String modifySave(Model model, @RequestBody UserInfoModifySaveForm form) {
        try {
            Map result = this.userService.saveStuUserInfo(form);
            model.addAttribute("result", (Object)result);
        }
        catch (Exception e) {
            e.printStackTrace();
            return Result.failure("\u4fdd\u5b58\u5931\u8d25");
        }
        return Result.success("\u4fdd\u5b58\u6210\u529f");
    }

    @RequestMapping(value={" /info/modify/avatar/save"}, method={RequestMethod.POST})
    @ResponseBody
    public String modifyAvatarSave(Model model, @RequestBody AvatarForm form) throws BusinessException {
        TStudent student = this.studentService.findOne(form.getStuId());
        if (student != null && StringUtils.isNotBlank((String)form.getAvatar())) {
            student.setAvatar(form.getAvatar());
            student.setUpdateTime(new Date());
            this.studentService.updateByIdSelective(student);
            return Result.success("\u4fdd\u5b58\u6210\u529f");
        }
        return Result.failure("\u4fdd\u5b58\u5931\u8d25");
    }

    @RequestMapping(value={" /info/modify/mobile/page/one"}, method={RequestMethod.GET})
    public String modifyMobilePageOne(Model model, Integer stuId, String mobile) {
        model.addAttribute("stuId", (Object)stuId);
        TLogin tLogin = this.tLoginDao.findByStuId(stuId);
        model.addAttribute("mobile", (Object)tLogin.getMobile());
        return "modifyMobilePageOne";
    }

    @RequestMapping(value={" /info/modify/mobile/page/two"}, method={RequestMethod.POST})
    @ResponseBody
    public String modifyMobilePageTwo(Model model, @RequestBody MobileForm form) {
        model.addAttribute("stuId", (Object)form.getStuId());
        if (this.commonService.checkCode(form.getMobile(), form.getCode()).booleanValue()) {
            return Result.success("\u9a8c\u8bc1\u6210\u529f");
        }
        model.addAttribute("message", (Object)"\u9a8c\u8bc1\u7801\u9519\u8bef");
        return Result.failure("\u9a8c\u8bc1\u7801\u9519\u8bef");
    }

    @RequestMapping(value={" /info/modify/mobile/pageTwo"}, method={RequestMethod.GET})
    public String pageTwo(Model model, String stuId) {
        model.addAttribute("stuId", (Object)stuId);
        return "modifyMobilePageTwo";
    }

    @RequestMapping(value={" /info/modify/mobile/save"}, method={RequestMethod.POST})
    @ResponseBody
    public String modifyMobileSave(Model model, @RequestBody MobileForm form) throws BusinessException {
        model.addAttribute("type", (Object)1);
        if (this.commonService.checkCode(form.getMobile(), form.getCode()).booleanValue()) {
            TLogin tLogin = this.tLoginDao.findByMobileExSelf(form.getMobile(), form.getStuId());
            if (tLogin != null) {
                return Result.failure(form.getMobile() + "\u5df2\u7ecf\u88ab\u4f7f\u7528\u4e86\uff01\uff01");
            }
        } else {
            model.addAttribute("stuId", (Object)form.getStuId());
            model.addAttribute("message", (Object)"\u9a8c\u8bc1\u7801\u9519\u8bef");
            return Result.failure("\u9a8c\u8bc1\u7801\u9519\u8bef");
        }
        this.tLoginService.saveMobile(form);
        return Result.success("\u4fdd\u5b58\u6210\u529f");
    }

    @RequestMapping(value={" /info/modify/email/page"}, method={RequestMethod.GET})
    public String modifyEmailPage(Model model, Integer stuId) {
        model.addAttribute("stuId", (Object)stuId);
        return "modifyEmailPage";
    }

    @RequestMapping(value={" /info/modify/email/save"}, method={RequestMethod.POST})
    @ResponseBody
    public String modifyMobileSave(Model model, @RequestBody ModifyEmailForm form) throws BusinessException {
        model.addAttribute("stuId", (Object)form.getStuId());
        if (!StringUtils.isNotBlank((String)form.getEmail()) || !form.getEmail().equals(form.getConfirmEmail())) {
            model.addAttribute("stuId", (Object)form.getStuId());
            model.addAttribute("message", (Object)"\u90ae\u7bb1\u8f93\u5165\u6709\u8bef");
            return Result.failure("\u90ae\u7bb1\u8f93\u5165\u6709\u8bef");
        }
        this.tLoginService.saveEmail(form);
        return Result.success("\u90ae\u7bb1\u4fee\u6539\u6210\u529f");
    }
}

