/*
 * Decompiled with CFR 0.152.
 */
package com.talkilla.controller;

import com.talkilla.base.Result;
import com.talkilla.constant.TalkillaConstant;
import com.talkilla.exception.base.ExceptionUtil;
import com.talkilla.otherbean.UserDto;
import com.talkilla.result.student.SellCourseDetailResult;
import com.talkilla.result.student.SellCourseListResult;
import com.talkilla.result.student.SellCourseOrderListResult;
import com.talkilla.service.student.StuSellCourseService;
import javax.servlet.http.HttpSession;
import org.apache.ibatis.annotations.Param;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"/sell/course"})
public class StudentSellCourseController {
    @Autowired
    private StuSellCourseService stuSellCourseService;

    @ExceptionHandler(value={Exception.class})
    public ModelAndView handleException(Exception ex) {
        return ExceptionUtil.printErrorInfo((Exception)ex);
    }

    @RequestMapping(value={"/list"}, method={RequestMethod.GET})
    public String sellCourseList(HttpSession session, Model model) {
        SellCourseListResult sellCourseListResult = this.stuSellCourseService.sellCourseList();
        model.addAttribute("bannerList", (Object)sellCourseListResult.getBannerList());
        model.addAttribute("courseList", (Object)sellCourseListResult.getSellCourseList());
        return "sellCourseList";
    }

    @RequestMapping(value={"/detail"}, method={RequestMethod.GET})
    public String sellCourseDetail(HttpSession session, Model model, Integer id) {
        SellCourseDetailResult sellCourseDetailResult = this.stuSellCourseService.sellCourseDetail(id);
        model.addAttribute("sellCourse", (Object)sellCourseDetailResult);
        return "sellCourseDetail";
    }

    @RequestMapping(value={"/order"})
    @ResponseBody
    public String createSellCourseOrder(HttpSession session, Model model, @Param(value="id") Integer id) {
        UserDto student = (UserDto)session.getAttribute(TalkillaConstant.SESSION_STUDENT_LOGIN_PREFIX);
        Integer orderId = this.stuSellCourseService.createSellCourseOrder(id, student);
        return Result.success(orderId);
    }

    @RequestMapping(value={"/pay/success"}, method={RequestMethod.POST})
    @ResponseBody
    public Object paySuccess(HttpSession session, Model model, Integer id, Integer payType) {
        UserDto student = (UserDto)session.getAttribute(TalkillaConstant.SESSION_STUDENT_LOGIN_PREFIX);
        String result = this.stuSellCourseService.paySuccess(id, payType, student);
        return Result.success(result);
    }

    @RequestMapping(value={"/order/list"}, method={RequestMethod.GET})
    public String orderList(HttpSession session, Model model, Integer status) {
        UserDto student = (UserDto)session.getAttribute(TalkillaConstant.SESSION_STUDENT_LOGIN_PREFIX);
        SellCourseOrderListResult sellCourseOrderList = this.stuSellCourseService.orderList(status, student);
        model.addAttribute("orderList", (Object)sellCourseOrderList.getOrderList());
        model.addAttribute("status", (Object)sellCourseOrderList.getStatus());
        return "orderList";
    }

    @RequestMapping(value={"/renew"}, method={RequestMethod.POST})
    @ResponseBody
    public String renewCourse(HttpSession session, Model model, Integer id) {
        UserDto student = (UserDto)session.getAttribute(TalkillaConstant.SESSION_STUDENT_LOGIN_PREFIX);
        String result = this.stuSellCourseService.renewCourse(id, student);
        return Result.success(result);
    }
}

