/*
 * Decompiled with CFR 0.152.
 */
package com.talkilla.controller;

import com.qiniu.util.Auth;
import com.talkilla.exception.base.ExceptionUtil;
import com.talkilla.mysql.domain.TRegion;
import com.talkilla.mysql.domain.TStudent;
import com.talkilla.service.CommonService;
import com.talkilla.service.TStudentService;
import com.talkilla.utils.qiniu.QiniuUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.commons.CommonsMultipartFile;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"/common"})
public class CommonController {
    @Autowired
    private CommonService commonService;
    @Autowired
    private TStudentService studentService;

    @ExceptionHandler(value={Exception.class})
    public ModelAndView handleException(Exception ex) {
        return ExceptionUtil.printErrorInfo((Exception)ex);
    }

    @RequestMapping(value={"/region/get"}, method={RequestMethod.POST})
    @ResponseBody
    public Map<String, Object> getRegion(HttpServletRequest request, HttpServletResponse response) {
        HashMap<String, Object> _result = new HashMap<String, Object>();
        ArrayList _pList = new ArrayList();
        ArrayList _aList = new ArrayList();
        List _provinceList = this.commonService.getRegionList();
        if (_provinceList != null) {
            for (TRegion _tRegion : _provinceList) {
                HashMap<String, Object> _province = new HashMap<String, Object>();
                _province.put("id", _tRegion.getId());
                _province.put("name", _tRegion.getRegionName());
                List _cityList = this.commonService.getCitys(_tRegion.getId());
                ArrayList _ctList = new ArrayList();
                if (_cityList != null) {
                    for (TRegion _ct : _cityList) {
                        HashMap<String, Object> _city = new HashMap<String, Object>();
                        _city.put("id", _ct.getId());
                        _city.put("name", _ct.getRegionName());
                        _ctList.add(_city);
                        List _areaList = this.commonService.getCitys(_ct.getId());
                        if (_areaList == null) continue;
                        for (TRegion _region : _areaList) {
                            HashMap<String, Object> _area = new HashMap<String, Object>();
                            _area.put("id", _region.getId());
                            _area.put("name", _region.getRegionName());
                            _area.put("pid", _region.getFid());
                            _aList.add(_area);
                        }
                    }
                    _province.put("city", _ctList);
                }
                _pList.add(_province);
            }
        }
        _result.put("province", _pList);
        _result.put("city", _aList);
        return _result;
    }

    @RequestMapping(value={"/qiniu/uptoken/get"}, method={RequestMethod.GET})
    @ResponseBody
    public Object getQiniuUptoken() {
        Auth auth = Auth.create((String)"0AcfrDOduKQ4E5tlx6Ujxo0i6uVq57yTxb7Fw6ar", (String)"3WjKtGTbgmuERVxF7_vwsF1_o3qq3-zbf0FYE6Zh");
        String token = auth.uploadToken("talkilla");
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("uptoken", token);
        return map;
    }

    @RequestMapping(value={"/qiniu/uploadImg"}, method={RequestMethod.POST})
    @ResponseBody
    public Map<String, Object> uploadImg(@RequestParam(value="image") CommonsMultipartFile image, @RequestParam(value="stuId") Integer stuId, HttpServletRequest request, HttpServletResponse response) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        try {
            String fileName;
            String picName = fileName = UUID.randomUUID().toString() + ".png";
            String msg = new QiniuUtil().upload(image.getBytes(), fileName).bodyString();
            String _downloadFileUrl = new QiniuUtil().getDownloadFileUrl(fileName, "http://image.talkilla.org");
            result.put("result", "ok");
            result.put("file", _downloadFileUrl);
            TStudent _student = new TStudent();
            _student.setAvatar(_downloadFileUrl);
            _student.setStuId(stuId);
            _student.setUpdateTime(new Date());
            this.studentService.updateByIdSelective(_student);
        }
        catch (Exception e) {
            result.put("result", "fail");
            e.printStackTrace();
        }
        return result;
    }
}

