/*
 * Decompiled with CFR 0.152.
 */
package com.talkilla.controller;

import com.talkilla.constant.TalkillaConstant;
import com.talkilla.exception.base.ExceptionUtil;
import com.talkilla.form.student.CourseListForm;
import com.talkilla.form.student.CoursesessionListForm;
import com.talkilla.form.student.ModifyStatusForm;
import com.talkilla.form.student.SaveCoursesessionListForm;
import com.talkilla.form.student.StudentCourseDetailForm;
import com.talkilla.form.student.StudentCourseDetailSaveForm;
import com.talkilla.mysql.domain.TStudent;
import com.talkilla.otherbean.UserDto;
import com.talkilla.result.ReturnMessageResult;
import com.talkilla.result.admin.base.PageObj;
import com.talkilla.result.student.ToModifystustatusResult;
import com.talkilla.service.student.StuCourseService;
import com.talkilla.service.student.StuUserService;
import java.text.ParseException;
import java.util.List;
import javax.servlet.http.HttpSession;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"/course"})
public class StudentCourseController {
    @Autowired
    private StuCourseService stuCourseService;
    @Autowired
    private StuUserService stuUserService;

    @ExceptionHandler(value={Exception.class})
    public ModelAndView handleException(Exception ex) {
        return ExceptionUtil.printErrorInfo((Exception)ex);
    }

    @RequestMapping(value={"/session/modify//status"}, method={RequestMethod.GET})
    public String toModifystustatus(HttpSession session, Model model, Integer sesessionid) {
        UserDto student = (UserDto)session.getAttribute(TalkillaConstant.SESSION_STUDENT_LOGIN_PREFIX);
        ToModifystustatusResult result = this.stuCourseService.toModifystustatus(sesessionid, student);
        model.addAttribute("result", (Object)result);
        return "modifystustatus";
    }

    @RequestMapping(value={"/session/modify/status/save"}, method={RequestMethod.POST})
    public String modifyStatus(HttpSession session, Model model, ModifyStatusForm form) throws ParseException {
        UserDto student = (UserDto)session.getAttribute(TalkillaConstant.SESSION_STUDENT_LOGIN_PREFIX);
        form.setStatus(student.getStuId());
        form.setLoginId(student.getLoginId());
        ReturnMessageResult messageResult = this.stuCourseService.modifyStatus(form);
        ToModifystustatusResult result = this.stuCourseService.toModifystustatus(form.getSessionid(), student);
        model.addAttribute("messageResult", (Object)messageResult);
        model.addAttribute("result", (Object)result);
        model.addAttribute("message", (Object)messageResult.getMessage());
        return "modifystustatus";
    }

    @RequestMapping(value={"/list"})
    public String courseList(HttpSession session, Model model, CourseListForm form) {
        UserDto student = (UserDto)session.getAttribute(TalkillaConstant.SESSION_STUDENT_LOGIN_PREFIX);
        PageObj pageObj = this.stuCourseService.courseList(student, form);
        model.addAttribute("pageObj", (Object)pageObj);
        model.addAttribute("form", (Object)form);
        return "myCourseList";
    }

    @RequestMapping(value={"/detail"})
    public String courseDetail(HttpSession session, Model model, StudentCourseDetailForm form) {
        UserDto student = (UserDto)session.getAttribute(TalkillaConstant.SESSION_STUDENT_LOGIN_PREFIX);
        List items = this.stuCourseService.getCourseDetail(student, form);
        model.addAttribute("items", (Object)items);
        model.addAttribute("form", (Object)form);
        model.addAttribute("cid", (Object)form.getCid());
        return "myCourseDetail";
    }

    @RequestMapping(value={"/detail/save"})
    public String courseDetailSave(HttpSession session, Model model, StudentCourseDetailSaveForm form) {
        UserDto student = (UserDto)session.getAttribute(TalkillaConstant.SESSION_STUDENT_LOGIN_PREFIX);
        if (form.getSid() == null || form.getFeeback() == null || form.getSid().length == 0 || form.getFeeback().length == 0 || null == form.getCid() || form.getCid() == 0) {
            model.addAttribute("message", (Object)"\u6ca1\u6709\u53ef\u4ee5\u4fdd\u5b58\u7684\u8bb0\u5f55");
        } else {
            this.stuCourseService.saveFeeBack(form, student);
            model.addAttribute("message", (Object)"\u4fdd\u5b58\u6210\u529f");
        }
        return "redirect:/course/list";
    }

    @RequestMapping(value={"/coursesessionlist"}, method={RequestMethod.GET})
    public String coursesessionList(HttpSession session, Model model, Integer cid) {
        TStudent student = (TStudent)session.getAttribute(TalkillaConstant.SESSION_STUDENT_LOGIN_PREFIX);
        CoursesessionListForm form = new CoursesessionListForm();
        form.setStuId(student.getStuId());
        form.setCid(cid);
        List results = this.stuCourseService.coursesessionList(form);
        model.addAttribute("results", (Object)results);
        return "coursesessionList";
    }

    @RequestMapping(value={"/coursesessionListSave"}, method={RequestMethod.GET})
    public String saveCoursesessionList(HttpSession session, Model model, SaveCoursesessionListForm form) {
        TStudent student = (TStudent)session.getAttribute(TalkillaConstant.SESSION_STUDENT_LOGIN_PREFIX);
        this.stuCourseService.saveCoursesessionList(form, student);
        return this.coursesessionList(session, model, form.getCid());
    }
}

