/*
 * Decompiled with CFR 0.152.
 */
package com.talkilla.wechat.utils;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import java.util.Vector;

public final class TimeZoneUtil {
    static SimpleDateFormat fmt = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    public static Date calculateByDate(Date d, int amount) {
        return TimeZoneUtil.calculate(d, 5, amount);
    }

    public static Date calculateByMinute(Date d, int amount) {
        return TimeZoneUtil.calculate(d, 12, amount);
    }

    public static Date calculateByYear(Date d, int amount) {
        return TimeZoneUtil.calculate(d, 1, amount);
    }

    private static Date calculate(Date d, int field, int amount) {
        if (d == null) {
            return null;
        }
        GregorianCalendar g = new GregorianCalendar();
        g.setGregorianChange(d);
        g.add(field, amount);
        return g.getTime();
    }

    public static String date2String(String formater, Date aDate) {
        if (formater == null || "".equals(formater)) {
            return null;
        }
        if (aDate == null) {
            return null;
        }
        return new SimpleDateFormat(formater).format(aDate);
    }

    public static String date2String(String formater) {
        return TimeZoneUtil.date2String(formater, new Date());
    }

    public static int dayOfWeek() {
        GregorianCalendar g = new GregorianCalendar();
        int ret = g.get(7);
        g = null;
        return ret;
    }

    public static String[] fecthAllTimeZoneIds() {
        Vector<String> v = new Vector<String>();
        Object[] ids = TimeZone.getAvailableIDs();
        for (int i = 0; i < ids.length; ++i) {
            v.add(ids[i]);
        }
        Collections.sort(v, String.CASE_INSENSITIVE_ORDER);
        v.copyInto(ids);
        v = null;
        return ids;
    }

    public static void main(String[] argc) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        SimpleDateFormat sdfold = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date d = new Date();
        String timezone = "Etc/GMT-5";
        System.out.println(sdf.format(d));
        System.out.println(sdf.format(TimeZoneUtil.Date2TimezoneDefault(d, timezone)));
        Calendar now = Calendar.getInstance();
        long srcTime = now.getTimeInMillis();
        long targetTime = srcTime - (long)TimeZone.getTimeZone(timezone).getRawOffset();
        Date newDate = new Date(targetTime);
        System.out.println(sdf.format(newDate));
        sdf.setTimeZone(TimeZone.getTimeZone(timezone));
        System.out.println(sdf.format(d));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String string2Timezone(String srcFormater, String srcDateTime, String dstFormater, String dstTimeZoneId) {
        if (srcFormater == null || "".equals(srcFormater)) {
            return null;
        }
        if (srcDateTime == null || "".equals(srcDateTime)) {
            return null;
        }
        if (dstFormater == null || "".equals(dstFormater)) {
            return null;
        }
        if (dstTimeZoneId == null || "".equals(dstTimeZoneId)) {
            return null;
        }
        SimpleDateFormat sdf = new SimpleDateFormat(srcFormater);
        try {
            int diffTime = TimeZoneUtil.getDiffTimeZoneRawOffset(dstTimeZoneId);
            Date d = sdf.parse(srcDateTime);
            long nowTime = d.getTime();
            long newNowTime = nowTime - (long)diffTime;
            d = new Date(newNowTime);
            String string = TimeZoneUtil.date2String(dstFormater, d);
            return string;
        }
        catch (ParseException e) {
            e.printStackTrace();
            String string = null;
            return string;
        }
        finally {
            sdf = null;
        }
    }

    private static int getDefaultTimeZoneRawOffset() {
        return TimeZone.getDefault().getRawOffset();
    }

    private static int getTimeZoneRawOffset(String timeZoneId) {
        return TimeZone.getTimeZone(timeZoneId).getRawOffset();
    }

    private static int getDiffTimeZoneRawOffset(String timeZoneId) {
        return TimeZone.getDefault().getRawOffset() - TimeZone.getTimeZone(timeZoneId).getRawOffset();
    }

    public static String string2TimezoneDefault(String srcDateTime, String dstTimeZoneId) {
        return TimeZoneUtil.string2Timezone("yyyy-MM-dd HH:mm:ss", srcDateTime, "yyyy-MM-dd HH:mm:ss", dstTimeZoneId);
    }

    public static Date Date2TimezoneDefault(Date d, String dstTimeZoneId) {
        if (dstTimeZoneId == null || "".equals(dstTimeZoneId) || d == null) {
            return null;
        }
        if (dstTimeZoneId.contains("Etc/GMT+")) {
            dstTimeZoneId = dstTimeZoneId.replaceAll("GMT\\+", "GMT-");
        } else if (dstTimeZoneId.contains("Etc/GMT-")) {
            dstTimeZoneId = dstTimeZoneId.replaceAll("GMT\\-", "GMT+");
        }
        TimeZone tz = TimeZone.getTimeZone(dstTimeZoneId);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        sdf.setTimeZone(tz);
        try {
            return fmt.parse(sdf.format(d));
        }
        catch (ParseException e) {
            return d;
        }
    }

    public static String date2StringTimezoneDefault(Date d, String dstTimeZoneId) {
        if (dstTimeZoneId == null || "".equals(dstTimeZoneId) || d == null) {
            return null;
        }
        if (dstTimeZoneId.contains("Etc/GMT+")) {
            dstTimeZoneId = dstTimeZoneId.replaceAll("GMT\\+", "GMT-");
        } else if (dstTimeZoneId.contains("Etc/GMT-")) {
            dstTimeZoneId = dstTimeZoneId.replaceAll("GMT\\-", "GMT+");
        }
        TimeZone tz = TimeZone.getTimeZone(dstTimeZoneId);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm");
        sdf.setTimeZone(tz);
        try {
            return sdf.format(d);
        }
        catch (Exception e) {
            return "";
        }
    }

    public static int getAge(Date dateOfBirth) {
        int age = 0;
        Calendar born = Calendar.getInstance();
        Calendar now = Calendar.getInstance();
        if (dateOfBirth != null) {
            now.setTime(new Date());
            born.setTime(dateOfBirth);
            if (born.after(now)) {
                throw new IllegalArgumentException("Can't be born in the future");
            }
            age = now.get(1) - born.get(1);
            if (now.get(6) < born.get(6)) {
                --age;
            }
        }
        return age;
    }

    public static Date getDateForDay(String day) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        try {
            return sdf.parse(day);
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String getWeekOfDate(Date date) {
        int w;
        String[] weekOfDays = new String[]{"\u661f\u671f\u65e5", "\u661f\u671f\u4e00", "\u661f\u671f\u4e8c", "\u661f\u671f\u4e09", "\u661f\u671f\u56db", "\u661f\u671f\u4e94", "\u661f\u671f\u516d"};
        Calendar calendar = Calendar.getInstance();
        if (date != null) {
            calendar.setTime(date);
        }
        if ((w = calendar.get(7) - 1) < 0) {
            w = 0;
        }
        return weekOfDays[w];
    }
}

