/*
 * Decompiled with CFR 0.152.
 */
package com.talkilla.wechat.utils;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import org.apache.commons.lang.StringUtils;

public class EncryptUtil {
    private static final DecimalFormat numberFormat = new DecimalFormat("0.######");
    private static final ObjectMapper mapper = new ObjectMapper();
    private static String DEFAULT_CHARSET;
    private static int[] CODE_DICTIONARY;
    private static char[] CHAR_DIGITS_DICTIONARY;
    private static int DEFAULT_CODE_MAX_LENGTH;

    public static String radixTransfor(BigInteger number, int radix) {
        if (radix < 0 || radix > CHAR_DIGITS_DICTIONARY.length) {
            return null;
        }
        BigInteger radixBigInteger = new BigInteger(String.valueOf(radix));
        BigInteger[] divideAndRemainder = number.divideAndRemainder(radixBigInteger);
        StringBuffer result = new StringBuffer();
        while (divideAndRemainder[0].compareTo(BigInteger.ZERO) > 0) {
            result.insert(0, CHAR_DIGITS_DICTIONARY[divideAndRemainder[1].intValue()]);
            divideAndRemainder = divideAndRemainder[0].divideAndRemainder(radixBigInteger);
        }
        if (divideAndRemainder[1].compareTo(BigInteger.ZERO) > 0) {
            result.insert(0, CHAR_DIGITS_DICTIONARY[divideAndRemainder[1].intValue()]);
        }
        return result.toString();
    }

    public static String encryptSHA1(String str, String charset) {
        StringBuffer result = new StringBuffer();
        try {
            byte[] bytes;
            MessageDigest md = MessageDigest.getInstance("SHA-1");
            md.update(str.getBytes(StringUtils.isBlank((String)charset) ? DEFAULT_CHARSET : charset));
            for (byte b : bytes = md.digest()) {
                result.append(Integer.toHexString((b & 0xF0) >> 4));
                result.append(Integer.toHexString(b & 0xF));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result.toString();
    }

    public static String encryptMD5(String str) {
        return EncryptUtil.encryptMD5(str, DEFAULT_CHARSET);
    }

    public static String encryptMD5(String str, String charset) {
        StringBuilder sb = new StringBuilder();
        for (byte b : EncryptUtil.md5(str, charset)) {
            sb.append(String.format("%02X", b));
        }
        return sb.toString().toLowerCase();
    }

    public static byte[] md5(String str, String charset) {
        if (charset == null) {
            charset = DEFAULT_CHARSET;
        }
        MessageDigest md5 = null;
        try {
            md5 = MessageDigest.getInstance("MD5");
            return md5.digest(str.getBytes(charset));
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String md5(Object obj) {
        return EncryptUtil.md5UseJson(obj, DEFAULT_CHARSET);
    }

    public static String md5UseJson(Object obj, String charset) {
        if (obj != null) {
            JsonNode node = mapper.valueToTree(obj);
            if (node.isArray()) {
                ArrayList<String> listMD5 = new ArrayList<String>();
                Iterator elements = node.elements();
                while (elements.hasNext()) {
                    listMD5.add(EncryptUtil.md5UseJson(elements.next(), charset));
                }
                Collections.sort(listMD5);
                StringBuffer signString = new StringBuffer();
                for (String md5 : listMD5) {
                    if (md5 == null) continue;
                    signString.append(",").append(md5);
                }
                return signString.length() > 0 ? EncryptUtil.encryptMD5(signString.substring(1), charset) : null;
            }
            if (node.isObject()) {
                StringBuffer signString = new StringBuffer();
                Iterator fieldNames = node.fieldNames();
                ArrayList keyList = new ArrayList();
                while (fieldNames.hasNext()) {
                    keyList.add(fieldNames.next());
                }
                Collections.sort(keyList);
                for (String key : keyList) {
                    String value = EncryptUtil.md5UseJson(node.get(key), charset);
                    if (value == null) continue;
                    signString.append("&").append(key).append("=").append(value);
                }
                return signString.length() > 0 ? EncryptUtil.encryptMD5(signString.substring(1), charset) : null;
            }
            if (node.isDouble()) {
                return numberFormat.format(node.asDouble());
            }
            if (!node.isNull()) {
                return node.asText();
            }
        }
        return null;
    }

    public static String encryptNumber(int number) {
        return EncryptUtil.encryptNumber(number, null);
    }

    public static String encryptNumber(int number, Integer length) {
        int first = number % 10;
        int resultLength = length == null ? DEFAULT_CODE_MAX_LENGTH : length;
        StringBuffer str = new StringBuffer().append(number);
        if (str.length() > resultLength) {
            throw new RuntimeException("");
        }
        int fillLength = resultLength > str.length() ? resultLength - str.length() - 1 : 0;
        int i = 0;
        int j = first;
        while (i < fillLength) {
            str.insert(0, CODE_DICTIONARY[j % CODE_DICTIONARY.length] % 10);
            ++i;
            ++j;
        }
        String[] strs = str.toString().split("|");
        StringBuffer result = new StringBuffer();
        int i2 = 1;
        int j2 = first;
        while (i2 < strs.length) {
            result.append(Integer.valueOf(strs[i2]) * CODE_DICTIONARY[j2 % CODE_DICTIONARY.length]);
            if (result.length() % 2 != 0) {
                result.insert(result.length() - 1, 0);
            }
            ++i2;
            ++j2;
        }
        return result.append(fillLength).append(first).toString();
    }

    public static int decryptNumber(String s) {
        int first = Integer.valueOf(s.substring(s.length() - 1, s.length()));
        int fillLength = Integer.valueOf(s.substring(s.length() - 2, s.length() - 1));
        String number = s.substring(0, s.length() - 2);
        StringBuffer result = new StringBuffer();
        int i = 0;
        int j = first;
        while (i < number.length()) {
            result.append(Integer.parseInt(number.substring(i, i + 2)) / CODE_DICTIONARY[j % CODE_DICTIONARY.length]);
            i += 2;
            ++j;
        }
        return Integer.valueOf(result.substring(fillLength));
    }

    static {
        mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        DEFAULT_CHARSET = "UTF-8";
        CODE_DICTIONARY = new int[]{11, 7, 5, 3, 2};
        CHAR_DIGITS_DICTIONARY = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '-', '_'};
        DEFAULT_CODE_MAX_LENGTH = 8;
    }
}

