/*
 * Decompiled with CFR 0.152.
 */
package com.talkilla.wechat.utils;

import com.talkilla.wechat.base.BeanUtilsDontRead;
import com.talkilla.wechat.base.FieldDescription;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class BeanUtils {
    public static Map<String, Object> getDifferences(Object reference, Object byReference, Class<?> baseClass) {
        return BeanUtils.getDifferences(reference, byReference, baseClass, reference, true);
    }

    public static Map<String, Object> getDifferences(Object reference, Object byReference, Class<?> baseClass, Object returnReference) {
        return BeanUtils.getDifferences(reference, byReference, baseClass, returnReference, true);
    }

    public static Map<String, Object> getDifferences(Object reference, Object byReference, Class<?> baseClass, Object returnReference, boolean onlyPrimitive) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        try {
            Map<String, Object> e = BeanUtils.getPropertiesMap(reference, true, false);
            Map<String, Object> byReferenceProperties = BeanUtils.getPropertiesMap(byReference, true, false);
            Map<String, Object> returnReferenceProperties = BeanUtils.getPropertiesMap(returnReference, true, false);
            List<FieldDescription> compareFields = BeanUtils.getAllPrimitiveField(baseClass, onlyPrimitive);
            for (FieldDescription field : compareFields) {
                String fieldName = field.getName();
                if (!e.containsKey(fieldName) || !byReferenceProperties.containsKey(fieldName) || BeanUtils.isEquals(e.get(fieldName), byReferenceProperties.get(fieldName))) continue;
                result.put(fieldName, returnReferenceProperties.get(fieldName));
            }
        }
        catch (Exception var13) {
            var13.printStackTrace();
        }
        return result;
    }

    public static boolean isEquals(Object obj1, Object obj2) {
        return !(obj1 == null ? obj2 != null : !obj1.equals(obj2));
    }

    public static Map<String, Object> getPropertiesMap(Object obj) {
        return BeanUtils.getPropertiesMap(obj, true, true);
    }

    public static Map<String, Object> getPropertiesMap(Object obj, boolean onlyPrimitive, boolean onlyNotNull) {
        HashMap<String, Object> objMap = new HashMap<String, Object>();
        if (obj == null) {
            return objMap;
        }
        if (obj instanceof Map) {
            Map e1 = (Map)obj;
            for (String objField1 : e1.keySet()) {
                Object propertyDescriptor1 = e1.get(objField1);
                if (onlyNotNull && propertyDescriptor1 == null) {
                    if (onlyNotNull) continue;
                    objMap.put(objField1, propertyDescriptor1);
                    continue;
                }
                Class<?> readMethod1 = propertyDescriptor1.getClass();
                if (onlyPrimitive && !BeanUtils.isPrimitive(readMethod1) && !readMethod1.equals(String.class) && !Date.class.isAssignableFrom(readMethod1)) continue;
                objMap.put(objField1, propertyDescriptor1);
            }
            return objMap;
        }
        try {
            List<FieldDescription> e = BeanUtils.getAllPrimitiveField(obj.getClass(), onlyPrimitive);
            Iterator<FieldDescription> var6 = e.iterator();
            while (true) {
                if (!var6.hasNext()) {
                    return objMap;
                }
                FieldDescription objField = var6.next();
                PropertyDescriptor propertyDescriptor = objField.getPropertyDescriptor();
                Method readMethod = propertyDescriptor.getReadMethod();
                if (readMethod == null || readMethod.getAnnotation(BeanUtilsDontRead.class) != null) continue;
                Object value = readMethod.invoke(obj, new Object[0]);
                if (!onlyNotNull && value == null) {
                    objMap.put(propertyDescriptor.getName(), value);
                    continue;
                }
                if (value == null) continue;
                if (Date.class.isAssignableFrom(propertyDescriptor.getPropertyType())) {
                    objMap.put(propertyDescriptor.getName(), ((Date)value).clone());
                    continue;
                }
                objMap.put(propertyDescriptor.getName(), value);
            }
        }
        catch (Exception var10) {
            var10.printStackTrace();
            return objMap;
        }
    }

    public static List<FieldDescription> getAllPrimitiveField(Class<?> claz, boolean onlyPrimitive) {
        ArrayList<FieldDescription> primitiveFieldList = new ArrayList<FieldDescription>();
        try {
            PropertyDescriptor[] var14;
            Class<?> e = claz;
            ArrayList<Field> fieldList = new ArrayList<Field>(Arrays.asList(claz.getDeclaredFields()));
            while ((e = e.getSuperclass()) != null) {
                fieldList.addAll(Arrays.asList(e.getDeclaredFields()));
            }
            HashMap<String, Field> fieldMap = new HashMap<String, Field>();
            for (Field objFields : fieldList) {
                fieldMap.put(objFields.getName(), objFields);
            }
            PropertyDescriptor[] var10 = var14 = Introspector.getBeanInfo(claz).getPropertyDescriptors();
            int var9 = var14.length;
            for (int var8 = 0; var8 < var9; ++var8) {
                Class<?> fieldClass;
                PropertyDescriptor var15 = var10[var8];
                String propertyName = var15.getName();
                if (!fieldMap.keySet().contains(propertyName) || Class.class.equals(fieldClass = var15.getPropertyType()) || onlyPrimitive && !BeanUtils.isPrimitive(fieldClass) && !fieldClass.equals(String.class) && !Date.class.isAssignableFrom(fieldClass)) continue;
                primitiveFieldList.add(new FieldDescription((Field)fieldMap.get(propertyName), var15, propertyName, fieldClass, null));
            }
        }
        catch (Exception var13) {
            var13.printStackTrace();
        }
        return primitiveFieldList;
    }

    public static FieldDescription getFieldDescription(Object obj, Class<? extends Annotation> annotationClass) {
        FieldDescription field;
        Annotation annotation;
        List<FieldDescription> fields = BeanUtils.getFields(obj, true);
        Iterator<FieldDescription> var4 = fields.iterator();
        do {
            if (!var4.hasNext()) {
                return null;
            }
            field = var4.next();
            annotation = field.getField().getAnnotation(annotationClass);
            Method readMethod = field.getPropertyDescriptor().getReadMethod();
            Method writeMethod = field.getPropertyDescriptor().getWriteMethod();
            if (annotation == null && readMethod != null) {
                annotation = readMethod.getAnnotation(annotationClass);
            }
            if (annotation != null || writeMethod == null) continue;
            annotation = writeMethod.getAnnotation(annotationClass);
        } while (annotation == null);
        return field;
    }

    public static List<FieldDescription> getFieldDescriptionList(Object obj, Class<? extends Annotation> annotationClass) {
        ArrayList<FieldDescription> result = new ArrayList<FieldDescription>();
        List<FieldDescription> fields = BeanUtils.getFields(obj, true);
        Iterator<FieldDescription> var5 = fields.iterator();
        while (var5.hasNext()) {
            FieldDescription field = var5.next();
            if (field.getField().getAnnotation(annotationClass) == null && field.getPropertyDescriptor().getReadMethod().getAnnotation(annotationClass) == null && field.getPropertyDescriptor().getWriteMethod().getAnnotation(annotationClass) == null) continue;
            result.add(field);
        }
        return result;
    }

    public static <T> List<T> subList(List<T> list, int size, int index) {
        int start = size * index;
        int end = Math.min(size * (index + 1), list.size());
        return list.subList(start, end);
    }

    public static <T> T convertMap(Map<String, Object> map, Class<T> resultClass) {
        try {
            T e = resultClass.newInstance();
            List<FieldDescription> sourceFields = BeanUtils.getFields(map, false);
            List<FieldDescription> targetFields = BeanUtils.getFields(e, false);
            block2: for (FieldDescription sourceField : sourceFields) {
                for (FieldDescription targetField : targetFields) {
                    if (!sourceField.getName().equals(targetField.getName()) || targetField.getPropertyDescriptor().getWriteMethod() == null) continue;
                    Object sourceValue = sourceField.getValue();
                    if (sourceValue != null && sourceValue instanceof Map) {
                        targetField.setValue(BeanUtils.convertMap((Map)sourceValue, targetField.getType()));
                    } else {
                        targetField.setValue(BeanUtils.cloneObj(sourceValue));
                    }
                    if (sourceValue != null && sourceValue instanceof List && List.class.isAssignableFrom(targetField.getType())) {
                        Class targetItemClass = null;
                        Type genericType = targetField.getField().getGenericType();
                        if (genericType != null && genericType instanceof ParameterizedType) {
                            targetItemClass = (Class)((ParameterizedType)genericType).getActualTypeArguments()[0];
                        }
                        ArrayList<Object> targetList = new ArrayList<Object>();
                        for (Object item : (List)targetField.getValue()) {
                            if (item instanceof Map) {
                                targetList.add(BeanUtils.convertMap((Map)item, targetItemClass));
                                continue;
                            }
                            if (item instanceof List) continue;
                            targetList.add(BeanUtils.cloneObj(item));
                        }
                        targetField.setValue(targetList);
                    }
                    targetField.getPropertyDescriptor().getWriteMethod().invoke(e, targetField.getValue());
                    continue block2;
                }
            }
            return e;
        }
        catch (Exception var15) {
            var15.printStackTrace();
            return null;
        }
    }

    public static void copy(Object source, Object target) {
        BeanUtils.copy(source, target, false);
    }

    public static void copy(Object source, Object target, boolean deepOrNot) {
        try {
            List<FieldDescription> e = BeanUtils.getFields(source, false);
            List<FieldDescription> targetFields = BeanUtils.getFields(target, false);
            Iterator<FieldDescription> var6 = e.iterator();
            while (true) {
                FieldDescription targetField;
                if (!var6.hasNext()) {
                    return;
                }
                FieldDescription sourceField = var6.next();
                if (!targetFields.contains(sourceField) || (targetField = targetFields.get(targetFields.indexOf(sourceField))).getPropertyDescriptor().getWriteMethod() == null) continue;
                if (deepOrNot) {
                    Object sourceValue = sourceField.getValue();
                    if (sourceValue != null && sourceValue instanceof Map) {
                        Object targetObject = targetField.getType().newInstance();
                        BeanUtils.copy(sourceValue, targetObject, deepOrNot);
                        targetField.setValue(targetObject);
                    } else {
                        targetField.setValue(BeanUtils.cloneObj(sourceValue));
                    }
                } else {
                    targetField.setValue(sourceField.getValue());
                }
                targetField.getPropertyDescriptor().getWriteMethod().invoke(target, targetField.getValue());
            }
        }
        catch (Exception var10) {
            var10.printStackTrace();
            return;
        }
    }

    private static Object cloneObj(Object obj) throws Exception {
        if (obj == null) {
            return obj;
        }
        Class<?> claz = obj.getClass();
        if (!claz.equals(String.class) && !BeanUtils.isPrimitive(claz)) {
            if (obj instanceof Date) {
                return ((Date)obj).clone();
            }
            if (List.class.isAssignableFrom(claz)) {
                List var8 = (List)obj;
                ArrayList<Object> var9 = new ArrayList<Object>();
                for (Object var11 : var8) {
                    var9.add(BeanUtils.cloneObj(var11));
                }
                return var9;
            }
            if (claz.isArray()) {
                int var7 = Array.getLength(obj);
                Object key = Array.newInstance(claz.getComponentType(), var7);
                for (int var10 = 0; var10 < var7; ++var10) {
                    Array.set(key, var10, BeanUtils.cloneObj(Array.get(obj, var10)));
                }
                return key;
            }
            if (!(obj instanceof Map)) {
                Object var6 = claz.newInstance();
                BeanUtils.copy(obj, var6, true);
                return var6;
            }
            HashMap newObj = new HashMap();
            for (Object key : ((Map)obj).keySet()) {
                newObj.put(key, ((Map)obj).get(key));
            }
            return newObj;
        }
        return obj;
    }

    private static List<FieldDescription> getFields(Object obj, boolean onlyPrimitive) {
        List<Object> fields = new ArrayList();
        if (obj instanceof Map) {
            Map field = (Map)obj;
            for (Object readMethod : field.keySet()) {
                Object value = field.get(readMethod);
                ((List)fields).add(new FieldDescription(readMethod.toString(), value != null ? value.getClass() : null, value));
            }
        } else {
            fields = BeanUtils.getAllPrimitiveField(obj.getClass(), onlyPrimitive);
            for (FieldDescription field1 : (List)fields) {
                Method readMethod1 = field1.getPropertyDescriptor().getReadMethod();
                Object value = null;
                if (readMethod1 != null && readMethod1.getAnnotation(BeanUtilsDontRead.class) == null) {
                    try {
                        value = readMethod1.invoke(obj, new Object[0]);
                    }
                    catch (Exception var8) {
                        var8.printStackTrace();
                    }
                }
                if (value != null && Date.class.isAssignableFrom(field1.getType())) {
                    value = ((Date)value).clone();
                }
                field1.setValue(value);
            }
        }
        return fields;
    }

    public static boolean isPrimitive(Class<?> claz) {
        try {
            return claz.isPrimitive() ? true : ((Class)claz.getField("TYPE").get(null)).isPrimitive();
        }
        catch (Exception var2) {
            return false;
        }
    }

    public static boolean isPrimitiveEqual(Class<?> clazA, Class<?> clazB) {
        try {
            return clazA.isPrimitive() ? (clazB.isPrimitive() ? clazA == clazB : clazA == clazB.getField("TYPE").get(null)) : (clazB.isPrimitive() ? clazA.getField("TYPE").get(null) == clazB : clazA.equals(clazB) || clazA.isAssignableFrom(clazB) || clazB.isAssignableFrom(clazA));
        }
        catch (Exception var3) {
            return false;
        }
    }
}

