/*
 * Decompiled with CFR 0.152.
 */
package com.talkilla.wechat.service;

import com.talkilla.constant.SystemConfig;
import com.talkilla.mysql.domain.TStudent;
import com.talkilla.mysql.domain.TStudentConsultant;
import com.talkilla.mysql.domain.TTeacher;
import com.talkilla.mysql.domain.TWechat;
import com.talkilla.mysql.mapper.TCourseDao;
import com.talkilla.service.TStudentService;
import com.talkilla.wechat.base.WechatTemplateMessageRequest;
import com.talkilla.wechat.form.WeChatTimeRewardNoticeForm;
import com.talkilla.wechat.form.WechatCourseStatusChangeForm;
import com.talkilla.wechat.form.WechatTemplateMessageForm;
import com.talkilla.wechat.result.WechatHttpsResult;
import com.talkilla.wechat.result.WechatTemplateMessageResult;
import com.talkilla.wechat.service.WechatService;
import com.talkilla.wechat.utils.JsonUtil;
import java.net.URLEncoder;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="wechatMessageService")
public class WechatMessageService {
    Logger logger = LoggerFactory.getLogger(WechatMessageService.class);
    @Autowired
    private WechatService wechatService;
    @Autowired
    private TCourseDao tCourseDao;
    @Autowired
    private TStudentService tStudentService;

    public void sendTaskTemplateMessageForCourseStatusChange(WechatCourseStatusChangeForm form) {
        String title = form.getStudentRealName() + "\uff1a\u4f60\u597d\uff01\n\u4f60\u4e0e\u8001\u5e08" + form.getTeacherFirstName() + "\u5728" + form.getStartTime() + form.getWeek() + "\u7684[" + form.getClassName() + "]\u7684\u8bfe\u7a0b\u72b6\u6001\u5df2\u53d8\u66f4";
        String contents = "";
        contents = StringUtils.isNotEmpty((String)form.getConsultantName()) ? contents + "\n\u4f60\u5982\u679c\u5bf9\u6b64\u6709\u4efb\u4f55\u7591\u95ee\uff0c\u8bf7\u4e0e\u4f60\u7684\u4eac\u8bed\u6cc9\u8bfe\u7a0b\u987e\u95ee " + form.getConsultantName() + "\uff08\u624b\u673a\u53f7\u7801\uff1a" + form.getOnsultantPhone() + "\uff09\u8054\u7cfb" : contents + "\n\u4f60\u5982\u679c\u5bf9\u6b64\u6709\u4efb\u4f55\u7591\u95ee\uff0c\u8bf7\u4e0e\u4f60\u7684\u4eac\u8bed\u6cc9\u8bfe\u7a0b\u987e\u95ee\u8054\u7cfb";
        WechatTemplateMessageForm messageFrom = new WechatTemplateMessageForm();
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("first", title);
        param.put("keyword1", form.getClassName());
        param.put("keyword2", "\u8be5\u8282\u8bfe\u7684\u8bfe\u7a0b\u72b6\u6001\u5df2\u8bbe\u7f6e\u4e3a\uff1a" + form.getCourseStatusDesc() + ";" + form.getAddComment() + " \u5907\u6ce8\uff1a" + form.getComments() + ".");
        messageFrom.setTemplateId(SystemConfig.Wechat.WECHAT_MESSAGE_TEMPLATE_ID4);
        messageFrom.setAppId(SystemConfig.Wechat.WECHAT_APP_ID);
        messageFrom.setRedirectUrl(SystemConfig.Wechat.WECHAT_URL);
        messageFrom.setParam(param);
        messageFrom.setRemark(contents);
        messageFrom.setState("statusChangedSessionid-" + form.getSessionid());
        if (StringUtils.isNotBlank((String)form.getOpenId())) {
            messageFrom.setReceiver(form.getOpenId());
            this.sendTemplateMessage(messageFrom);
        } else {
            this.logger.error("\u6ca1\u6709\u53d1\u9001\u5fae\u4fe1\u8bfe\u7a0b\u72b6\u6001\u6d88\u606f" + contents);
        }
    }

    public WechatTemplateMessageResult sendTaskTemplateMessage(WechatTemplateMessageForm messageFrom) {
        WechatTemplateMessageRequest request = new WechatTemplateMessageRequest();
        request.setTemplate_id(messageFrom.getTemplateId());
        request.setTouser(messageFrom.getReceiver());
        String url = messageFrom.getRedirectUrl();
        try {
            url = "https://open.weixin.qq.com/connect/oauth2/authorize?appid=" + messageFrom.getAppId() + "&redirect_uri=" + URLEncoder.encode(messageFrom.getRedirectUrl(), "UTF-8") + "&response_type=code&scope=snsapi_base&state=10#wechat_redirect";
        }
        catch (Exception e) {
            this.logger.error("\u53d1\u9001\u5fae\u4fe1\u6d88\u606f\u5f02\u5e38", (Throwable)e);
        }
        request.setUrl(url);
        HashMap<String, WechatTemplateMessageRequest.Data> data = new HashMap<String, WechatTemplateMessageRequest.Data>();
        Map<String, String> param = messageFrom.getParam();
        if (messageFrom.getTitle() != null) {
            data.put("first", new WechatTemplateMessageRequest.Data(messageFrom.getTitle()));
        }
        if (messageFrom.getRemark() != null) {
            if (messageFrom.getTemplateId().equals("EO6foSgS9kj8eYqJ_AepGGiMX0ksCvuFJHNLMwti30o")) {
                data.put("Remark", new WechatTemplateMessageRequest.Data(messageFrom.getRemark()));
            } else {
                data.put("remark", new WechatTemplateMessageRequest.Data(messageFrom.getRemark()));
            }
            data.put("Remark", new WechatTemplateMessageRequest.Data(messageFrom.getRemark()));
        }
        Set<String> keySet = param.keySet();
        for (String key : keySet) {
            data.put(key, new WechatTemplateMessageRequest.Data(param.get(key)));
        }
        request.setData(data);
        this.logger.info("\u53d1\u9001\u7ed9\u5fae\u4fe1id " + messageFrom.getReceiver() + " \u7684\u5185\u5bb9\u662f " + messageFrom.getRemark());
        this.logger.info("\u8bf7\u6c42\u5fae\u4fe1\u53d1\u9001\u6a21\u677f\u6d88\u606f\u63a5\u53e3");
        WechatHttpsResult wechatResponse = this.wechatService.wechatHttpsPostJsonWithAccessToken("https://api.weixin.qq.com/cgi-bin/message/template/send", JsonUtil.objToStr(request), WechatHttpsResult.class, messageFrom.getAppId());
        if (wechatResponse == null) {
            wechatResponse = this.wechatService.wechatHttpsPostJsonWithAccessToken("https://api.weixin.qq.com/cgi-bin/message/template/send", JsonUtil.objToStr(request), WechatHttpsResult.class, messageFrom.getAppId());
        }
        this.logger.info("\u5fae\u4fe1\u53d1\u9001\u4fe1\u606f\uff0c\u8fd4\u56de\u7ed3\u679c\u4e3a: {}", (Object)wechatResponse);
        if (wechatResponse == null) {
            this.logger.info("\u5fae\u4fe1\u53d1\u9001\u4fe1\u606f\uff0c\u8fd4\u56de\u7ed3\u679c\u4e3a: null \u5fae\u4fe1\u63a5\u53e3\u8c03\u7528\u5f02\u5e38");
            wechatResponse = this.wechatService.wechatHttpsPostJsonWithAccessToken("https://api.weixin.qq.com/cgi-bin/message/template/send", JsonUtil.objToStr(request), WechatHttpsResult.class, messageFrom.getAppId());
            if (wechatResponse == null) {
                this.logger.info("\u5fae\u4fe1\u53d1\u9001\u4fe1\u606f\uff0c\u8fd4\u56de\u7ed3\u679c\u4e3a: null \u5fae\u4fe1\u63a5\u53e3\u8c03\u7528\u5f02\u5e38 \u7b2c\u4e8c\u6b21\u540c\u6837\u4e0d\u884c");
            }
        }
        WechatTemplateMessageResult result = new WechatTemplateMessageResult();
        return result;
    }

    public void sendStudentByTeacherLeaveClass(TStudent student, TWechat tWechat, TTeacher teacher, TStudentConsultant studentConsultant, String startTime, String week, Integer sessionid, String note) {
        String contents = student.getRealName() + "\uff1a\u4f60\u597d\uff01\n\u8001\u5e08" + teacher.getFirstName() + "\u5728" + startTime + week + "\u6709\u4e8b\u8bf7\u5047\uff0c\u5f53\u5929" + startTime + "\u8bfe\u7a0b\u53d6\u6d88\u3002\u4f60\u53ef\u4ee5\u5229\u7528\u8fd9\u4e2a\u65f6\u95f4\u56de\u770b\u4e0a\u4e00\u8282\u8bfe\u7684\u5f55\u50cf\u6216\u5e72\u8106\u653e\u677e\u4e00\u4e0b\u81ea\u5df1\u3002";
        contents = contents + "\n\u5907\u6ce8\uff1a" + note;
        contents = contents + "\n\u82e5\u5bf9\u6b64\u6709\u7591\u95ee\uff0c\u8bf7\u4e0e\u60a8\u7684\u8bfe\u7a0b\u987e\u95ee\u8054\u7cfb\uff0c\u6216\u8fdb\u5165\u8bfe\u7a0b\u4e2d\u5fc3\u67e5\u770b\u8bfe\u7a0b\u8868\u8be6\u60c5\u3002";
        WechatTemplateMessageForm messageFrom = new WechatTemplateMessageForm();
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("first", "");
        param.put("keyword1", teacher.getFirstName() + " " + teacher.getLastName().substring(0, 1).toUpperCase() + ".");
        param.put("keyword2", startTime);
        param.put("keyword3", " ");
        messageFrom.setTemplateId(SystemConfig.Wechat.WECHAT_MESSAGE_TEMPLATE_ID2);
        messageFrom.setAppId(SystemConfig.Wechat.WECHAT_APP_ID);
        messageFrom.setRedirectUrl(SystemConfig.Wechat.WECHAT_URL);
        messageFrom.setParam(param);
        messageFrom.setRemark(contents);
        messageFrom.setState("statusChangedSessionid-" + sessionid);
        if (tWechat != null && StringUtils.isNotBlank((String)tWechat.getOpenid())) {
            messageFrom.setReceiver(tWechat.getOpenid());
            this.sendTemplateMessage(messageFrom);
        } else {
            this.logger.error("\u6ca1\u6709\u53d1\u9001\u5fae\u4fe1\u8bf7\u5047\u6d88\u606f" + student.getRealName() + contents);
        }
    }

    public void sendStudentByGoOnClass(TStudent student, TWechat tWechat, TTeacher tTeacher, String classname, Integer pendingCount) {
        WechatTemplateMessageForm messageFrom = new WechatTemplateMessageForm();
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("first", "\u60a8\u597d,\u60a8\u7684\u8bfe\u65f6\u5df2\u5feb\u4e0d\u8db3");
        param.put("keyword1", classname);
        param.put("keyword2", "\u5269\u4f59" + pendingCount + "\u6b21\u8bfe\u4e86");
        param.put("keyword3", "\u4eac\u8bed\u6cc9");
        messageFrom.setTemplateId(SystemConfig.Wechat.WECHAT_MESSAGE_TEMPLATE_ID3);
        messageFrom.setAppId(SystemConfig.Wechat.WECHAT_APP_ID);
        messageFrom.setRedirectUrl(SystemConfig.Wechat.WECHAT_URL);
        messageFrom.setParam(param);
        messageFrom.setRemark("\u5b66\u5458" + student.getRealName() + "\u4e0e\u5916\u6559" + tTeacher.getFirstName() + "\u7684\u8bfe\u7a0b " + classname + " \u8fd8\u5269\u4e0b" + pendingCount + "\u6b21\u8bfe\uff0c\u4e3a\u907f\u514d\u5f71\u54cd\u6b63\u5e38\u4e0a\u8bfe\uff0c\u8bf7\u60a8\u53ca\u65f6\u4e0e\u4eac\u8bed\u6cc9\u8bfe\u7a0b\u987e\u95ee\u8054\u7cfb\u7eed\u8d39\u53ca\u8bfe\u7a0b\u521b\u5efa\u4e8b\u5b9c\u3002\u5982\u679c\u60a8\u8fd1\u671f\u5df2\u7ecf\u7eed\u8d39\uff0c\u8bf7\u5ffd\u7565\u6b64\u4fe1\u606f\u3002");
        if (tWechat != null && StringUtils.isNotBlank((String)tWechat.getOpenid())) {
            messageFrom.setReceiver(tWechat.getOpenid());
            this.sendTemplateMessage(messageFrom);
        } else {
            this.logger.error("\u6ca1\u6709\u53d1\u9001\u5fae\u4fe1\u8bf7\u5047\u6d88\u606f" + student.getRealName());
        }
    }

    public void sendTaskTemplateTimeRewardWeChatNotice(WeChatTimeRewardNoticeForm form) {
        Calendar _calendar = Calendar.getInstance();
        String title = "\u8bfe\u65f6\u53d8\u66f4\u63d0\u9192:";
        String contents_2 = "\u53d8\u66f4\u8bf4\u660e:\u5956\u52b1\u6c60:" + form.getHourAwardedPool() + "\u5c0f\u65f6,\u5956\u52b1\u539f\u56e0:" + form.getComment() + "\u3002\u5956\u52b1\u8bfe\u65f6\u5df2\u7ecf\u6dfb\u52a0\u81f3\u8bfe\u7a0b\u5305:" + form.getCoursePackageName() + form.getCoursePackageId() + "\uff0c\u70b9\u51fb\u8be6\u60c5\u53ef\u4e86\u89e3\u8bfe\u65f6\u5956\u52b1\u660e\u7ec6\u3002";
        String contents_1 = "\u53d8\u66f4\u8bf4\u660e:\u5956\u52b1\u6c60:" + form.getHourAwardedPool() + "\u5c0f\u65f6,\u5956\u52b1\u539f\u56e0:\u6210\u529f\u4ecb\u7ecd\u65b0\u5b66\u5458" + form.getStudentRealName() + "\u3002\u70b9\u51fb\u8be6\u60c5\u53ef\u4e86\u89e3\u8bfe\u65f6\u5956\u52b1\u660e\u7ec6\u3002\u70b9\u51fb\u8be6\u60c5\u53ef\u4e86\u89e3\u8bfe\u65f6\u5956\u52b1\u660e\u7ec6\uff0c\u6216\u6838\u9500\u5956\u52b1\u8bfe\u65f6\u6dfb\u52a0\u8bfe\u7a0b\u81f3\u5f53\u524d\u8bfe\u7a0b\u5305\u3002";
        String contents_3 = "\u53d8\u66f4\u8bf4\u660e:\u5956\u52b1\u6c60:" + form.getHourAwardedPool() + "\u5c0f\u65f6,\u5956\u52b1\u539f\u56e0:" + form.getComment() + "\u70b9\u51fb\u8be6\u60c5\u53ef\u4e86\u89e3\u8bfe\u65f6\u5956\u52b1\u660e\u7ec6\uff0c\u6216\u6838\u9500\u5956\u52b1\u8bfe\u65f6\u6dfb\u52a0\u8bfe\u7a0b\u81f3\u5f53\u524d\u8bfe\u7a0b\u5305\u3002";
        String contents_4 = "\u65b0\u5956\u52b1\u8bfe\u65f6\u6570" + form.getHourAwarded() + "\u5c0f\u65f6\uff0c\u5956\u52b1\u539f\u56e0\uff1a" + form.getComment() + "\u3002\u5956\u52b1\u6c60\u539f\u6709\u8bfe\u65f6\u6570\u4e3a" + form.getHourAwardedPool() + "\u5c0f\u65f6\uff1b\u5171\u5956\u52b1" + form.getBonusNum() + "\u6b21\u8bfe\uff0c\u5df2\u7ecf\u6dfb\u52a0\u81f3\u8bfe\u7a0b\u5305#" + form.getCoursePackageId() + "\u3002\u5956\u52b1\u6c60\u5269\u4f59\u8bfe\u65f6\u6570\u4e3a" + form.getHourAwardedPoolRemaining() + "\u5c0f\u65f6\u3002\u5982\u60a8\u5bf9\u6b64\u6709\u4efb\u4f55\u7591\u95ee\uff0c\u8bf7\u4e0e\u60a8\u7684\u8bfe\u7a0b\u987e\u95ee\u8054\u7cfb\u3002";
        WechatTemplateMessageForm messageFrom = new WechatTemplateMessageForm();
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("first", title);
        if (form.getType() == 1) {
            param.put("keyword1", form.getStudentRefereeName());
        }
        if (form.getType() == 2) {
            param.put("keyword1", form.getStudentRealName());
        }
        param.put("keyword2", "\u5956\u52b1" + form.getHourAwarded() + "\u5c0f\u65f6");
        param.put("keyword3", _calendar.get(1) + "\u5e74" + (_calendar.get(2) + 1) + "\u6708" + _calendar.get(5) + "\u65e5" + _calendar.get(11) + "\u65f6" + _calendar.get(12) + "\u5206" + _calendar.get(13) + "\u79d2");
        messageFrom.setTemplateId(SystemConfig.Wechat.WECHAT_MESSAGE_TEMPLATE_ID6);
        messageFrom.setAppId(SystemConfig.Wechat.WECHAT_APP_ID);
        messageFrom.setRedirectUrl(SystemConfig.Wechat.WECHAT_URL_TIME_AWARD);
        messageFrom.setParam(param);
        if (form.getType() == 1) {
            messageFrom.setRemark(contents_1);
        }
        if (form.getType() == 2) {
            messageFrom.setRemark(contents_2);
        }
        if (form.getType() == 3) {
            messageFrom.setRemark(contents_3);
        }
        if (form.getType() == 4) {
            messageFrom.setRemark(contents_4);
        }
        if (StringUtils.isNotBlank((String)form.getOpenId())) {
            messageFrom.setReceiver(form.getOpenId());
            this.sendTemplateMessage(messageFrom);
        } else {
            this.logger.error("\u6ca1\u6709\u53d1\u9001\u8bfe\u7a0b\u5956\u52b1\u5fae\u4fe1\u8bf7\u5047\u6d88\u606f");
        }
    }

    private WechatTemplateMessageResult sendTemplateMessage(WechatTemplateMessageForm messageFrom) {
        WechatTemplateMessageRequest request = new WechatTemplateMessageRequest();
        request.setTemplate_id(messageFrom.getTemplateId());
        request.setTouser(messageFrom.getReceiver());
        String url = messageFrom.getRedirectUrl();
        try {
            url = "https://open.weixin.qq.com/connect/oauth2/authorize?appid=" + messageFrom.getAppId() + "&redirect_uri=" + URLEncoder.encode(messageFrom.getRedirectUrl(), "UTF-8") + "&response_type=code&scope=snsapi_base&state=" + messageFrom.getState() + "#wechat_redirect";
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        request.setUrl(url);
        HashMap<String, WechatTemplateMessageRequest.Data> data = new HashMap<String, WechatTemplateMessageRequest.Data>();
        Map<String, String> param = messageFrom.getParam();
        if (messageFrom.getTitle() != null) {
            data.put("first", new WechatTemplateMessageRequest.Data(messageFrom.getTitle()));
        }
        if (messageFrom.getRemark() != null) {
            if (messageFrom.getTemplateId().equals("EO6foSgS9kj8eYqJ_AepGGiMX0ksCvuFJHNLMwti30o")) {
                data.put("Remark", new WechatTemplateMessageRequest.Data(messageFrom.getRemark()));
            } else {
                data.put("remark", new WechatTemplateMessageRequest.Data(messageFrom.getRemark()));
            }
            data.put("Remark", new WechatTemplateMessageRequest.Data(messageFrom.getRemark()));
        }
        Set<String> keySet = param.keySet();
        for (String key : keySet) {
            data.put(key, new WechatTemplateMessageRequest.Data(param.get(key)));
        }
        request.setData(data);
        WechatHttpsResult wechatResponse = this.wechatService.wechatHttpsPostJsonWithAccessToken("https://api.weixin.qq.com/cgi-bin/message/template/send", JsonUtil.objToStr(request), WechatHttpsResult.class, messageFrom.getAppId());
        if (wechatResponse == null) {
            wechatResponse = this.wechatService.wechatHttpsPostJsonWithAccessToken("https://api.weixin.qq.com/cgi-bin/message/template/send", JsonUtil.objToStr(request), WechatHttpsResult.class, messageFrom.getAppId());
        }
        this.logger.info("\u5fae\u4fe1\u53d1\u9001\u4fe1\u606f\uff0c\u8fd4\u56de\u7ed3\u679c\u4e3a: {}", (Object)wechatResponse);
        if (wechatResponse == null) {
            this.logger.error("\u5fae\u4fe1\u53d1\u9001\u4fe1\u606f\uff0c\u8fd4\u56de\u7ed3\u679c\u4e3anull,\u5fae\u4fe1\u63a5\u53e3\u8c03\u7528\u5f02\u5e38");
        }
        WechatTemplateMessageResult result = new WechatTemplateMessageResult();
        return result;
    }
}

