/*
 * Decompiled with CFR 0.152.
 */
package com.talkilla.serviceUtils;

import com.talkilla.mysql.domain.TConsultant;
import com.talkilla.mysql.domain.TLogin;
import com.talkilla.mysql.domain.TSellCourse;
import com.talkilla.mysql.domain.TSellCourseOrder;
import com.talkilla.mysql.domain.TStuFeeback;
import com.talkilla.mysql.domain.TStudent;
import com.talkilla.mysql.domain.TStudentConsultant;
import com.talkilla.mysql.domain.TTeacher;
import com.talkilla.otherbean.TeacherUnconfirmEamilDto;
import com.talkilla.utils.Bean.MailSenderInfo;
import com.talkilla.utils.DateUtils;
import com.talkilla.utils.EmailUtils;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.mail.internet.MimeUtility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TalkillaEmailMessageUtils {
    private static final Logger logger = LoggerFactory.getLogger(TalkillaEmailMessageUtils.class);
    private static MailSenderInfo mailInfo = new MailSenderInfo();

    public static void sendTeacherByStudentFeedback(String aimEmail, TTeacher teacher, TStudent student, String startDate, String duringtime, TStuFeeback tStuFeeback, String adminEmail) {
        String contents = "Dear Teacher " + teacher.getFirstName() + ",\n\nYou have just received a feedback given by your student as below :  \n\nStudent name: " + student.getEnglishName() + "\nTime of lesson:" + startDate + "-" + duringtime + "\nFeedback: " + tStuFeeback.getFeeback() + "\nStars: " + tStuFeeback.getStar() + " out of 5\n\nIf you have questions with this feedback, please consult your Talkilla contact.\n\nTalkilla";
        ArrayList<String> addressList = new ArrayList<String>();
        if (tStuFeeback.getStar() <= 3) {
            addressList.add(adminEmail);
        }
        TalkillaEmailMessageUtils.sendMessageToManyPeople(aimEmail, contents, "Student Feedback", addressList);
    }

    public static void sendTeacherByCreateCourseEmail(String aimEmail, List<String> addressList, TStudent student, TTeacher teacher, double totalHours, TStudentConsultant tStudentConsultant) {
        String contents = "Dear " + teacher.getFirstName() + "\uff01\nCongratulations! You have just received a new teaching assignment as below:\nStudent name: " + student.getEnglishName() + "\nTotal hours:" + totalHours + "hours\nPlease login at http://esl.talkilla.org to see more details of the time table and prepare yourself to teach online.\nIf you have any questions with this teaching assignment, please inquire with your Talkilla contact :" + tStudentConsultant.getConsultantName() + "(" + tStudentConsultant.getConsultantEmail() + ")\nThanks and best regards\n Talkilla Education\n please inquire with your Talkilla contact: talkilla@talkilla.org.";
        TalkillaEmailMessageUtils.sendMessageToManyPeople(aimEmail, contents, " Talkilla Education", addressList);
    }

    public static void sendStudentByGoOnClass(String aimEmail, List<String> addressList, TStudent student, Integer pendingCount) {
        String content = student.getRealName() + " \u60a8\u597d \u60a8\u8d2d\u4e70\u7684\u4eac\u8bed\u6cc9\u82f1\u8bed\u8bfe\u7a0b\u76ee\u524d\u5269\u4f59" + pendingCount + "\u6b21\u8bfe\u4e86\uff0c\u4e3a\u907f\u514d\u60a8\u7684\u82f1\u8bed\u8bfe\u7a0b\u51fa\u73b0\u4e0d\u5fc5\u8981\u7684\u4e2d\u65ad\u800c\u5f71\u54cd\u5b66\u4e60\uff0c\u7279\u63d0\u9192\u60a8\u5c3d\u5feb\u7eed\u8d39\u3002\n\u60a8\u53ef\u4ee5\u8bbf\u95ee\u4eac\u8bed\u6cc9\u82f1\u8bed\u7f51\u7ad9www.talkilla.org\u70b9\u51fb\u201c\u6211\u7684\u4eac\u8bed\u6cc9\u201d\u767b\u5f55\u60a8\u7684\u4e2a\u4eba\u4e3b\u9875\uff0c\u70b9\u51fb\u201c\u8bfe\u7a0b\u7ba1\u7406\u201d\u627e\u5230\u4e0a\u6b21\u8d2d\u4e70\u7684\u8ba2\u5355\u5373\u53ef\u7eed\u8d39\u8d2d\u4e70\u3002\n\u60a8\u6bcf\u6210\u529f\u5730\u4ecb\u7ecd\u4e00\u4e2a\u5ba2\u6237\u6210\u4e3a\u4eac\u8bed\u6cc9\u82f1\u8bed\u5b66\u5458\uff0c\u60a8\u5c31\u53ef\u4ee5\u5f97\u5230\u514d\u8d39\u7684\u8bfe\u65f6\u5956\u52b1\u54e6\u3002\u8be6\u60c5\u8bf7\u54a8\u8be2\u60a8\u7684\u8bfe\u7a0b\u987e\u95ee\u3002\n";
        content = content + "\u8c22\u8c22\u60a8\u4e00\u76f4\u4ee5\u6765\u5bf9\u4eac\u8bed\u6cc9\u82f1\u8bed\u7684\u5927\u529b\u652f\u6301\uff01\n\u4eac\u8bed\u6cc9\u82f1\u8bed www.talkilla.org ";
        TalkillaEmailMessageUtils.sendMessageToManyPeople(aimEmail, content, "\u4eac\u8bed\u6cc9\u82f1\u8bed\u8bfe\u7a0b\u7eed\u8d39\u63d0\u9192\u901a\u77e5", addressList);
    }

    public static void sendTeacherByLeaveClassEmail(String aimEmail, TTeacher teacher, String studentEnglishName, String startDate, String duringTime, String weekday) {
        String contents = "Dear " + teacher.getFirstName() + "\uff01\nYou have made a leave request on " + startDate + "(" + weekday + ") , the session with " + studentEnglishName + " at " + duringTime + " is canceled.\n If you have any questions with this notice, please contact your Talkilla Rep accordingly.\nRegards. \nTalkilla Edu";
        TalkillaEmailMessageUtils.sendMessageToManyPeople(aimEmail, contents, "Teacher\u2019s Leave Request", null);
    }

    public static void sendTeacherBySpecialClassEmail(String aimEmail, TTeacher teacher, TStudent student, String startDate, String duringTime, String weekday) {
        String contents = "Dear " + teacher.getFirstName() + "\uff01\nYou have set the status of class with " + student.getEnglishName() + " at " + duringTime + "," + startDate + "(" + weekday + ") to Special Case  this session will be postponed accordingly.\n If you have any questions with this notice, please contact your Talkilla Rep accordingly.\nRegards. \nTalkilla Edu";
        TalkillaEmailMessageUtils.sendMessageToManyPeople(aimEmail, contents, "Teacher\u2019s Leave Request", null);
    }

    public static void sendStudentByTeacherLeaveClass(String aimEmail, List<String> addressList, TStudent student, TTeacher teacher, TStudentConsultant studentConsultant, String startDate, String timeZone, String week) {
        String contents = student.getRealName() + "\uff1a\u4f60\u597d\uff01\n\u8001\u5e08" + teacher.getFirstName() + " " + teacher.getLastName().substring(0, 1).toUpperCase() + "\u56e0\u6709\u4e8b\u8bf7\u5047\uff0c\u539f\u8ba1\u5212\u5b89\u6392\u5728" + timeZone + "," + startDate + "(" + week + ")\u7684\u8bfe\u7a0b\u5c06\u987a\u5ef6\uff0c\u7531\u6b64\u7ed9\u60a8\u7684\u5b66\u4e60\u5e26\u6765\u4e0d\u4fbf\uff0c\u656c\u8bf7\u8c05\u89e3\u3002\n \u5982\u679c\u4f60\u4e0d\u5e0c\u671b\u4e2d\u65ad\u5b66\u4e60\uff0c\u53ef\u4ee5\u5728\u5fae\u4fe1\u8bfe\u7a0b\u4e2d\u5fc3\u70b9\u51fb\u4e34\u65f6\u52a0\u8bfe\u8bd5\u8bd5\u8fd0\u6c14\uff0c\u7ed9\u81ea\u5df1\u627e\u4e00\u4f4d\u4ee3\u8bfe\u8001\u5e08\u3002";
        if (studentConsultant != null) {
            contents = contents + "\n\u4f60\u5982\u679c\u5bf9\u6b64\u6709\u4efb\u4f55\u7591\u95ee\uff0c\u8bf7\u4e0e\u4f60\u7684\u4eac\u8bed\u6cc9\u8bfe\u7a0b\u987e\u95ee " + studentConsultant.getConsultantName() + "\uff08\u624b\u673a\u53f7\u7801\uff1a" + studentConsultant.getMobile() + "\uff09\u8054\u7cfb\u3002";
        }
        TalkillaEmailMessageUtils.sendMessageToManyPeople(aimEmail, contents, "\u5916\u6559\u8bf7\u5047\u901a\u77e5", addressList);
    }

    public static void sendTeacherByStudentLeaveClassEmail(String aimEmail, TTeacher teacher, TStudent student, String startDate, String duringtime, String week) {
        String contents = "Dear Teacher " + teacher.getFirstName() + ": \r\n\tYour  Student  " + student.getEnglishName() + "  has requested for a leave for" + startDate + " , the session at " + duringtime + " is canceled.  If you have any questions with this notice, please contact your Talkilla Rep accordingly.\n\nYou can go to your Dashboard and click \"Set Schedule\" to mark that time slot open to other students who may request instant classes.";
        TalkillaEmailMessageUtils.sendMessageToManyPeople(aimEmail, contents, "Student's Leave Request", null);
    }

    public static void sendStudentByStudentLeaveClass(String aimEmail, List<String> addressList, TStudent student, TTeacher teacher, TStudentConsultant studentConsultant, String startDate, String timeZone, String week) {
        String contents = student.getRealName() + "\uff1a\u4f60\u597d\uff01\n\u4f60\u5df2\u7ecf\u8bf7\u5047\u6210\u529f\uff0c\u539f\u8ba1\u5212\u5b89\u6392\u5728" + timeZone + "," + startDate + "(" + week + ")\u7684\u8bfe\u7a0b\u5c06\u987a\u5ef6";
        if (studentConsultant != null) {
            contents = contents + "\n\u4f60\u5982\u679c\u5bf9\u6b64\u6709\u4efb\u4f55\u7591\u95ee\uff0c\u8bf7\u4e0e\u4f60\u7684\u4eac\u8bed\u6cc9\u8bfe\u7a0b\u987e\u95ee " + studentConsultant.getConsultantName() + "\uff08\u624b\u673a\u53f7\u7801\uff1a" + studentConsultant.getMobile() + "\uff09\u8054\u7cfb\u3002";
        }
        TalkillaEmailMessageUtils.sendMessageToManyPeople(aimEmail, contents, "\u5b66\u751f\u8bf7\u5047\u901a\u77e5", addressList);
    }

    public static void sendStudentByGoOnClassPaysuccess(String aimEmail, TStudent student, TStudentConsultant studentConsultant, String createTime, TSellCourseOrder newOrder, TSellCourse sellCourse, double totalhour) {
        String contents = student.getRealName() + "\uff1a\u4f60\u597d\uff01\n\u611f\u8c22\u60a8\u5bf9\u4eac\u8bed\u6cc9\u82f1\u8bed\u7684\u4fe1\u4efb\u4e0e\u652f\u6301\u3002\u60a8\u5df2\u7ecf\u6210\u529f\u8d2d\u4e70\u4eac\u8bed\u6cc9\u82f1\u8bed\u8bfe\u7a0b\u3002\n\u8ba2\u5355\u7f16\u53f7: " + newOrder.getOrderNo() + "       \u8d2d\u4e70\u65f6\u95f4\uff1a" + createTime + "\n\u8d2d\u4e70\u8bfe\u7a0b: " + newOrder.getSellCourseName() + "     \u4ef7\u683c:" + newOrder.getPrice() / 100 + "\u5143\u8d2d\u4e70\u8bfe\u65f6:" + sellCourse.getHour() + "\u8bfe\u65f6           \u8d60\u9001\u8bfe\u65f6: " + sellCourse.getPresentHour() + "\u8bfe\u65f6    \u603b\u8bfe\u65f6:  " + totalhour + "\u8bfe\u65f6\n\u8bfe\u7a0b\u987e\u95ee:" + studentConsultant.getConsultantName() + "\u8054\u7cfb\u65b9\u5f0f:  " + studentConsultant.getConsultantEmail() + "\n\u6211\u4eec\u7684\u8bfe\u7a0b\u987e\u95ee\u5c06\u4e0e\u60a8\u8054\u7cfb\u534f\u8c03\u5b89\u6392\u5916\u6559\u4e0a\u8bfe\u65f6\u95f4\u3002\u5bf9\u6b64\u5982\u6709\u7591\u95ee\uff0c\u8bf7\u53ca\u65f6\u4e0e\u60a8\u7684\u8bfe\u7a0b\u987e\u95ee\u8054\u7cfb\u3002\n\u8c22\u8c22\n";
        contents = contents + "\n\u4eac\u8bed\u6cc9\u82f1\u8bed www.talkilla.org ";
        TalkillaEmailMessageUtils.sendMessageToManyPeople(aimEmail, contents, "\u4eac\u8bed\u6cc9\u82f1\u8bed\u8bfe\u7a0b\u8ba2\u5355", null);
    }

    public static void sendNewStudentRegisterSuccess(String aimEmail, TStudent student) {
        String content = "\u5b66\u751f\u4fe1\u606f:\u59d3\u540d->" + student.getEnglishName() + ",\u8054\u7cfb\u7535\u8bdd->" + student.getPhone() + ",\u5bb6\u957f\u540d\u5b57->" + student.getParentName() + "";
        TalkillaEmailMessageUtils.sendMessageToManyPeople(aimEmail, content, "\u65b0\u5b66\u751f(" + student.getRealName() + ")\u6ce8\u518c\u4e86\uff01", null);
    }

    public static void sendNewTeacherRegisterSuccess(String aimEmail, TLogin login, TTeacher teacher, String nation) {
        String content = "\u6559\u5e08\u4fe1\u606f:\u59d3\u540d->" + teacher.getFirstName() + "    " + teacher.getLastName() + ",skypeid->" + teacher.getSkypeid() + ",email->" + login.getLoginName() + ",native nationality->" + nation;
        TalkillaEmailMessageUtils.sendMessageToManyPeople(aimEmail, content, "\u65b0\u6559\u5e08(" + teacher.getFirstName() + teacher.getLastName() + ")\u6ce8\u518c\u4e86\uff01", null);
    }

    public static void sendMessageToPeople(String aimEmail, String message, String title) {
        mailInfo.setSubject(title);
        mailInfo.setToAddress(aimEmail);
        mailInfo.setContent(message);
        TalkillaEmailMessageUtils.sendMessageToManyPeople(aimEmail, message, title, null);
    }

    public static void sendMessageToManyPeople(String aimEmail, String message, String title, List<String> addressList) {
        if (addressList != null) {
            addressList.remove("admin");
        }
        if (aimEmail.equals("admin")) {
            return;
        }
        String subject = null;
        try {
            subject = MimeUtility.encodeText((String)title, (String)MimeUtility.mimeCharset((String)"UTF-8"), null);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        mailInfo.setSubject(subject);
        mailInfo.setToAddress(aimEmail);
        mailInfo.setContent(message);
        mailInfo.setAddressList(addressList);
        logger.info("\u53d1\u9001\u7ed9\u90ae\u7bb1" + aimEmail + "\u90ae\u4ef6\u6807\u9898\u662f " + subject + "    \u7684\u90ae\u4ef6\u5185\u5bb9\u662f\uff1a" + message);
        EmailUtils.sendTextMail((MailSenderInfo)mailInfo);
    }

    public static void sendStudentByPaysuccess(String aimEmail, List<String> addressList, TStudent student, TSellCourseOrder newOrder, TSellCourse sellCourse) {
        String content = student.getRealName() + "\uff0c\u60a8\u597d\uff01\n\u8c22\u60a8\u5bf9\u4eac\u8bed\u6cc9\u82f1\u8bed\u7684\u4fe1\u4efb\u4e0e\u652f\u6301\u3002\u60a8\u5df2\u7ecf\u6210\u529f\u8d2d\u4e70\u4eac\u8bed\u6cc9\u82f1\u8bed\u8bfe\u7a0b\u3002\n\u8d2d\u4e70\u8bfe\u7a0b\uff1a" + sellCourse.getName() + "\t\t\u4ef7\u683c\uff1a" + sellCourse.getPrice() + "\u5143\n\u8d2d\u4e70\u8bfe\u65f6\uff1a" + sellCourse.getHour();
        if (sellCourse.getPresentHour() != 0) {
            content = content + " \u8d60\u9001\u8bfe\u65f6\uff1a" + sellCourse.getPresentHour() + " \u603b\u8bfe\u65f6\uff1a" + (sellCourse.getHour() + sellCourse.getPresentHour());
        }
        content = content + "\n\u6211\u4eec\u7684\u8bfe\u7a0b\u987e\u95ee\u5c06\u4e0e\u60a8\u8054\u7cfb\u534f\u8c03\u5b89\u6392\u5916\u6559\u4e0a\u8bfe\u65f6\u95f4\u3002\u5bf9\u6b64\u5982\u6709\u7591\u95ee\uff0c\u8bf7\u53ca\u65f6\u4e0e\u60a8\u7684\u8bfe\u7a0b\u987e\u95ee\u8054\u7cfb\u3002\n\u8c22\u8c22\n\u4eac\u8bed\u6cc9\u82f1\u8bedwww.talkilla.org";
        TalkillaEmailMessageUtils.sendMessageToManyPeople(aimEmail, content, "\u4eac\u8bed\u6cc9\u82f1\u8bed\u8bfe\u7a0b\u8ba2\u5355", addressList);
    }

    public static void sendConsultByRegisterSuccess(String aimEmail, TConsultant courseConsultant, String loginName, String pwd) {
        String content = courseConsultant.getName() + "\uff0c\u60a8\u597d\uff01\u795d\u8d3a\u60a8\u6210\u4e3a\u4eac\u8bed\u6cc9\u8bfe\u7a0b\u987e\u95ee\u3002\u8bf7\u8bbf\u95eewww.talkilla.org\u767b\u5f55\u4eac\u8bed\u6cc9\u5728\u7ebf\u6559\u5b66\u7ba1\u7406\u7cfb\u7edf\u3002\u60a8\u7684\u8d26\u53f7\u4fe1\u606f\u5982\u4e0b\uff1a\u767b\u5f55\u540d\uff1a" + loginName + "\u767b\u5f55\u5bc6\u7801\uff1a" + pwd + "\u8bf7\u5728\u9996\u6b21\u767b\u5f55\u7cfb\u7edf\u540e\u9a6c\u4e0a\u4fee\u6539\u60a8\u7684\u767b\u5f55\u5bc6\u7801\u3002\u5982\u6709\u95ee\u9898\uff0c\u8bf7\u4e0e\u4eac\u8bed\u6cc9\u7cfb\u7edf\u7ba1\u7406\u5458talkilla@talkilla.org\u8054\u7cfb\u3002";
        TalkillaEmailMessageUtils.sendMessageToManyPeople(aimEmail, content, "\u4eac\u8bed\u6cc9\u8bfe\u7a0b\u987e\u95ee\u8d26\u53f7\u4fe1\u606f", null);
    }

    public static void sendTeacherByUnconfirmedCourse(String aimEmail, List<TeacherUnconfirmEamilDto> dtos, TTeacher teacher) {
        if (dtos == null || dtos.size() == 0) {
            return;
        }
        String contents = "Dear Teacher " + teacher.getFirstName() + ": \r\n\tPlease kindly be reminded that the following classes are older than 48 hours and have not been updated. Please login at your Talkilla Dashboard (esl.talkilla.org) and update the status of each session accordingly:\n       Date and Time            Student        Class Name \n";
        for (TeacherUnconfirmEamilDto dto : dtos) {
            contents = contents + DateUtils.formatDateToSecond((Date)dto.getStarttime()) + "             " + dto.getEnglishName() + "          " + dto.getClassname() + "\n";
        }
        contents = contents + "\n Thanks. \nTalkilla Edu";
        TalkillaEmailMessageUtils.sendMessageToManyPeople(aimEmail, contents, "Talkilla Reminder to Update Class Status", null);
    }

    public static void sendToTeacherInstantClassRequestConfirm(String teaEmail, TTeacher teacher, TStudent tStudent, String teacherLocalTime, String className, String comments, String remark) {
        String contents = "Dear Teacher " + teacher.getFirstName() + ": \r\n " + tStudent.getEnglishName() + " has confirmed an instant class at " + teacherLocalTime + " as you have indicated that you are available to teach for this time slot. \r\n  Class Name : " + className + "\r\n Notes from the student:  " + remark + "\r\n Teacher's Comments from last session:  " + comments + "\r\nPlease prepare yourself for that session accordingly. If you are not able to teach this class, please make a leave request 12 hours in advance. \r\nIf you have any questions about this class about text book or contents of this class, please contact your Teaching Assistant (karenyang@talkilla.org) or other Talkilla Rep directly. \r\n\nThanks\r\nTalkilla Edu";
        TalkillaEmailMessageUtils.sendMessageToManyPeople(teaEmail, contents, "Instant Class Request", null);
    }

    public static void sendTeacherClassReportOneType(String aimEmail, TTeacher teacher, TStudent student) {
        String contents = "Hi Teacher " + teacher.getFirstName() + ": \r\n\tYour new student \uff08" + student.getEnglishName() + "\uff09 has already finished 3 lessons with you. Your early feedback to the student is very  important. You may include your comments how your student has been doing in the class and recommendation how he or she can do better in order to make good progress.\n  Will you please finish your early feedback within the next 7 days and send it to Karen at karenyang@talkilla.org?\n Your effort in helping the student and Talkilla is highly appreciated.\n";
        contents = contents + "\n Talkilla Team\n";
        ArrayList<String> addresses = new ArrayList<String>();
        addresses.add("karenyang@talkilla.org");
        TalkillaEmailMessageUtils.sendMessageToManyPeople(aimEmail, contents, "Early Feedback to " + student.getEnglishName(), addresses);
    }

    public static void sendTeacherClassReportTwoType(String email, TTeacher teacher, TStudent student) {
        String contents = "Hi Teacher " + teacher.getFirstName() + ": \r\n\tYour student  ( " + student.getEnglishName() + "\uff09is going to finish the current learning package in 1 week. It is time for you as the teacher to complete a periodic progress report. In this report you may give your honest feedback to the student or the parents how the student has been doing, and your professional suggestions how the student can do better in future. Please always try to be specific with each student\u2019s progress and shortcomings. \n  This report is also very helpful in securing the student to renew the learning program. We expect this student can continue to learn from you and make big progress under your help.\n Will you please finish this periodic report within the next 7 days and send it to Karen at karenyang@talkilla.org?\nYour effort in helping the student and Talkilla is highly appreciated.\n";
        contents = contents + "\n Talkilla Team\n";
        ArrayList<String> addresses = new ArrayList<String>();
        addresses.add("karenyang@talkilla.org");
        TalkillaEmailMessageUtils.sendMessageToManyPeople(email, contents, "Progress Report for " + student.getEnglishName(), addresses);
    }

    public static void sendTeacherBonusEmail(String email, TTeacher teacher, BigDecimal bonus, String reson) {
        String contents = "Dear Teacher  " + teacher.getFirstName() + ": \r\n\tCongratulations! You have just received a bonus of US$" + bonus + "\nReason: " + reson + "\n You can find this bonus listed in your monthly payment, which will be paid together with tutoring fee of this month\n  Great thanks to your continuous contribution to Talkilla!\n";
        contents = contents + "\n Talkilla Team\n";
        TalkillaEmailMessageUtils.sendMessageToManyPeople(email, contents, "Bonus", null);
    }
}

