/*
 * Decompiled with CFR 0.152.
 */
package com.talkilla.service.impl.wechat;

import com.talkilla.constant.SystemConfig;
import com.talkilla.constant.TalkillaConstant;
import com.talkilla.constant.enums.TeacherTypeEnum;
import com.talkilla.form.wechat.StudentSummarySaveForm;
import com.talkilla.mysql.domain.TCountry;
import com.talkilla.mysql.domain.TCoursesession;
import com.talkilla.mysql.domain.TCustTimezone;
import com.talkilla.mysql.domain.TLogin;
import com.talkilla.mysql.domain.TSendEmailRecord;
import com.talkilla.mysql.domain.TStuFeeback;
import com.talkilla.mysql.domain.TStudent;
import com.talkilla.mysql.domain.TTeacher;
import com.talkilla.mysql.mapper.TCountryDao;
import com.talkilla.mysql.mapper.TCoursesessionDao;
import com.talkilla.mysql.mapper.TCustTimezoneDao;
import com.talkilla.mysql.mapper.TLoginDao;
import com.talkilla.mysql.mapper.TSendEmailRecordDao;
import com.talkilla.mysql.mapper.TStuFeebackDao;
import com.talkilla.mysql.mapper.TStudentDao;
import com.talkilla.mysql.mapper.TTeacherDao;
import com.talkilla.result.wechat.StudentSumaryInfo;
import com.talkilla.result.wechat.StudentSummarysResult;
import com.talkilla.service.wechat.StudentSummaryService;
import com.talkilla.serviceUtils.TalkillaEmailMessageUtils;
import com.talkilla.serviceUtils.TimeZoneUtil;
import com.talkilla.utils.CheckFormatUtils;
import com.talkilla.utils.DateUtils;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class StudentSummaryServiceImpl
implements StudentSummaryService {
    @Autowired
    private TStuFeebackDao tStuFeebackDao;
    @Autowired
    private TTeacherDao tTeacherDao;
    @Autowired
    private TCoursesessionDao tCoursesessionDao;
    @Autowired
    private TCountryDao tCountryDao;
    @Autowired
    private TLoginDao tLoginDao;
    @Autowired
    private TCustTimezoneDao tCustTimezoneDao;
    @Autowired
    private TStudentDao tStudentDao;
    @Autowired
    private TSendEmailRecordDao tSendEmailRecordDao;

    @Override
    public StudentSummarysResult list(Integer teacherId) {
        TTeacher tTeacher = this.tTeacherDao.findOne(teacherId);
        List studentSumaryInfoList = this.tStuFeebackDao.findListByTeacherId(teacherId);
        Integer averageStar = null;
        if (!CollectionUtils.isEmpty((Collection)studentSumaryInfoList)) {
            averageStar = 0;
            for (StudentSumaryInfo studentSumaryInfo : studentSumaryInfoList) {
                averageStar = averageStar + studentSumaryInfo.getStar();
                Date starttime = studentSumaryInfo.getStarttime();
                String beginHour = DateUtils.formatDate((Date)starttime, (String)"HH:mm");
                String dayAndYearStr = DateUtils.formatDate((Date)starttime, (String)"yyyy-MM-dd");
                String endHour = DateUtils.formatDate((Date)org.apache.commons.lang.time.DateUtils.addMinutes((Date)starttime, (int)studentSumaryInfo.getDuration()), (String)"HH:mm");
                String dateStr = dayAndYearStr + " " + beginHour + "-" + endHour;
                studentSumaryInfo.setStarttimeDesc(dateStr);
            }
            averageStar = averageStar / studentSumaryInfoList.size();
        }
        TCountry country = this.tCountryDao.findOne(tTeacher.getCountry());
        StudentSummarysResult result = new StudentSummarysResult();
        result.setTeacherId(teacherId);
        result.setFirstName(tTeacher.getFirstName());
        result.setLastName(tTeacher.getLastName());
        result.setAvatar(tTeacher.getAvatar());
        result.setCountry(tTeacher.getCountry());
        if (Objects.nonNull(country)) {
            result.setCountryName(country.getName());
        }
        result.setTeacherType(tTeacher.getTeacherType());
        result.setTeacherTypeDesc(TeacherTypeEnum.transferTypeToDesc((Integer)tTeacher.getTeacherType()));
        result.setAverageStar(averageStar);
        result.setStudentSumaryInfoList(studentSumaryInfoList);
        return result;
    }

    @Override
    public void save(StudentSummarySaveForm form, final TStudent student) {
        TStuFeeback tStuFeeback = this.tStuFeebackDao.findBySessionidAndStuId(form.getSessionid(), student.getStuId());
        if (Objects.nonNull(tStuFeeback)) {
            return;
        }
        final TCoursesession tCoursesession = this.tCoursesessionDao.findOne(form.getSessionid());
        tStuFeeback = new TStuFeeback();
        tStuFeeback.setSessionid(form.getSessionid());
        tStuFeeback.setStuId(student.getStuId());
        tStuFeeback.setTeacherId(tCoursesession.getTeacherId());
        tStuFeeback.setFeeback(form.getFeedback());
        tStuFeeback.setStar(form.getStar());
        tStuFeeback.setCreateTime(new Date());
        this.tStuFeebackDao.insertSelective(tStuFeeback);
        final TStuFeeback finalTStuFeeback = tStuFeeback;
        new Thread(new Runnable(){

            @Override
            public void run() {
                String loginName;
                TTeacher teacher = StudentSummaryServiceImpl.this.tTeacherDao.findOne(tCoursesession.getTeacherId());
                TLogin teacherTLogin = StudentSummaryServiceImpl.this.tLoginDao.findOne(teacher.getLoginId());
                Date startDate = null;
                String timezone = teacher.getTimezone();
                if (timezone != null) {
                    TCustTimezone tCustTimezone = StudentSummaryServiceImpl.this.tCustTimezoneDao.findByTimezone(timezone);
                    startDate = tCustTimezone != null ? TimeZoneUtil.findTimeByCustomerDate(tCoursesession.getStarttime(), tCustTimezone) : TimeZoneUtil.Date2TimezoneDefault(tCoursesession.getStarttime(), timezone);
                }
                if ((loginName = teacherTLogin.getLoginName()) != null && CheckFormatUtils.checkEmail((String)loginName)) {
                    TalkillaEmailMessageUtils.sendTeacherByStudentFeedback(loginName, teacher, student, DateUtils.formatDateToDay((Date)startDate), DateUtils.getHHmmString((Date)startDate, (Integer)tCoursesession.getDuration()), finalTStuFeeback, SystemConfig.Admin.ADMIN_EMAIL);
                    TSendEmailRecord tSendEmailRecord = new TSendEmailRecord();
                    tSendEmailRecord.setUserType(TalkillaConstant.SendEmailUserType.TEACHER);
                    tSendEmailRecord.setEmail(loginName);
                    tSendEmailRecord.setEmailType(TalkillaConstant.SendEmailType.SEND_TEACHER_BY_STUDENT_FEEDBACK);
                    tSendEmailRecord.setRecordType(TalkillaConstant.SendEmailType.SEND_TEACHER_BY_STUDENT_FEEDBACK);
                    tSendEmailRecord.setCid(tCoursesession.getCid());
                    tSendEmailRecord.setStuId(student.getStuId());
                    tSendEmailRecord.setTeacherId(tCoursesession.getTeacherId());
                    StudentSummaryServiceImpl.this.tSendEmailRecordDao.insertSelective(tSendEmailRecord);
                }
            }
        }).start();
    }
}

