/*
 * Decompiled with CFR 0.152.
 */
package com.talkilla.service.impl.wechat;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.talkilla.constant.TalkillaConstant;
import com.talkilla.mysql.domain.TConsultant;
import com.talkilla.mysql.domain.TCourse;
import com.talkilla.mysql.domain.TCourseSessionStudent;
import com.talkilla.mysql.domain.TCoursesession;
import com.talkilla.mysql.domain.TCustTimezone;
import com.talkilla.mysql.domain.TLogin;
import com.talkilla.mysql.domain.TSendEmailRecord;
import com.talkilla.mysql.domain.TStuFeeback;
import com.talkilla.mysql.domain.TStudent;
import com.talkilla.mysql.domain.TStudentConsultant;
import com.talkilla.mysql.domain.TStudentSummary;
import com.talkilla.mysql.domain.TTeacher;
import com.talkilla.mysql.domain.TTeacherComments;
import com.talkilla.mysql.mapper.TCourseDao;
import com.talkilla.mysql.mapper.TCourseSessionStudentDao;
import com.talkilla.mysql.mapper.TCourseStudentDao;
import com.talkilla.mysql.mapper.TCoursesessionDao;
import com.talkilla.mysql.mapper.TSendEmailRecordDao;
import com.talkilla.mysql.mapper.TStuFeebackDao;
import com.talkilla.mysql.mapper.TStudentConsultantDao;
import com.talkilla.mysql.mapper.TTeacherCommentsDao;
import com.talkilla.mysql.mapper.TTeacherDao;
import com.talkilla.result.LeaveCourseResult;
import com.talkilla.result.wechat.CourceSessionInfoResult;
import com.talkilla.result.wechat.CourseCenterResult;
import com.talkilla.result.wechat.CourseDetailResult;
import com.talkilla.result.wechat.CoursesessionCalender;
import com.talkilla.result.wechat.StudentSummaryListResult;
import com.talkilla.service.TCourseService;
import com.talkilla.service.TCoursesessionService;
import com.talkilla.service.TCustTimezoneService;
import com.talkilla.service.TLoginService;
import com.talkilla.service.TStudentConsultantService;
import com.talkilla.service.TStudentSummaryService;
import com.talkilla.service.TTeacherCommentsService;
import com.talkilla.service.TTeacherService;
import com.talkilla.service.wechat.CourseService;
import com.talkilla.serviceUtils.TalkillaEmailMessageUtils;
import com.talkilla.serviceUtils.TimeZoneUtil;
import com.talkilla.utils.Arith;
import com.talkilla.utils.CheckFormatUtils;
import com.talkilla.utils.DateUtils;
import com.talkilla.utils.MathUtils;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service(value="courseService")
public class CourseServiceImpl
implements CourseService {
    @Autowired
    private TCourseService tCourseService;
    @Autowired
    private TCoursesessionService tCoursesessionService;
    @Autowired
    private TTeacherService tTeacherService;
    @Autowired
    private TLoginService tLoginService;
    @Autowired
    private TCustTimezoneService tCustTimezoneService;
    @Autowired
    private TStudentConsultantService tStudentConsultantService;
    @Autowired
    private TTeacherCommentsService tTeacherCommentsService;
    @Autowired
    private TStudentSummaryService tStudentSummaryService;
    @Autowired
    private TCoursesessionDao tCoursesessionDao;
    @Autowired
    private TCourseDao tCourseDao;
    @Autowired
    private TTeacherDao tTeacherDao;
    @Autowired
    private TStudentConsultantDao tStudentConsultantDao;
    @Autowired
    private TCourseStudentDao tCourseStudentDao;
    @Autowired
    private TCourseSessionStudentDao tCourseSessionStudentDao;
    @Autowired
    private TTeacherCommentsDao tTeacherCommentsDao;
    @Autowired
    private TStuFeebackDao tStuFeebackDao;
    @Autowired
    private TSendEmailRecordDao tSendEmailRecordDao;

    @Override
    public CourseCenterResult courceCenter(Integer studentId, Integer type) {
        CourseCenterResult result = new CourseCenterResult();
        List<TCourse> tCourseList = this.tCourseService.findCourceListByStudentId(studentId, type);
        if (tCourseList != null && tCourseList.size() > 0) {
            ArrayList<CourseCenterResult.Course> courseList = new ArrayList<CourseCenterResult.Course>();
            for (TCourse tCourse : tCourseList) {
                CourseCenterResult.Course course = new CourseCenterResult.Course(result);
                BeanUtils.copyProperties((Object)tCourse, (Object)course);
                course.setHourawarded(MathUtils.getCoursesTimes((Double)tCourse.getHourawarded(), (Integer)tCourse.getDuration()));
                course.setHourpending(MathUtils.getCoursesTimes((Double)tCourse.getHourpending(), (Integer)tCourse.getDuration()));
                course.setHourpurchase(MathUtils.getCoursesTimes((Double)tCourse.getHourpurchase(), (Integer)tCourse.getDuration()));
                courseList.add(course);
            }
            result.setCourseList(courseList);
        }
        Calendar calendar = Calendar.getInstance();
        CoursesessionCalender coursesessionCalender = this.getCoursesessionCalender(studentId, calendar);
        result.setCalender(coursesessionCalender);
        return result;
    }

    @Override
    public CoursesessionCalender beforeWeek(Integer stuId, Calendar calendar) {
        return this.getCoursesessionCalender(stuId, calendar);
    }

    @Override
    public CoursesessionCalender afterWeek(Integer stuId, Calendar calendar) {
        return this.getCoursesessionCalender(stuId, calendar);
    }

    @Override
    @Transactional(rollbackFor={Throwable.class}, propagation=Propagation.REQUIRED)
    public synchronized String updateCourseStatus(Integer sessionid, final TStudent tStudent) throws ParseException {
        final TCoursesession tCoursesession = this.tCoursesessionService.findOne(sessionid);
        TTeacher tTeacher = this.tTeacherDao.findOne(tCoursesession.getTeacherId());
        if (tCoursesession.getStatus() != null && !tCoursesession.getStatus().equals(TalkillaConstant.COURSE_STATUS_UMCONFIRMED)) {
            return "\u8bfe\u7a0b\u72b6\u6001\u5df2\u7ecf\u4fee\u6539\u8fc7\u4e86 \u4e0d\u80fd\u518d\u6b21\u4fee\u6539";
        }
        if (tCoursesession.getStarttime().getTime() - System.currentTimeMillis() - 43200000L < 1L) {
            return "\u5b66\u751f\u8bf7\u5047\u8bf7\u63d0\u524d12\u5c0f\u65f6";
        }
        final TCourse tCourse = this.tCourseDao.findOne(tCoursesession.getCid());
        Integer type = tCourse.getType();
        if (type.equals(100002)) {
            TConsultant tConsultant = this.tStudentConsultantDao.findConsultantByStudentId(tStudent.getStuId());
            String mobile = "";
            String name = "";
            if (Objects.nonNull(tConsultant)) {
                mobile = tConsultant.getMobile();
                name = tConsultant.getName();
            }
            return DateUtils.formatDate((Date)tCoursesession.getStarttime(), (String)"yyyy-MM-dd HH:mm") + "-" + DateUtils.formatDateToHHmm((Date)new Date(tCoursesession.getStarttime().getTime() + (long)(tCoursesession.getDuration() * 60) * 1000L)) + "\u8fd9\u662f\u4e00\u8282\u591a\u4eba\u5c0f\u7ec4\u8bfe\uff0c\u4e2a\u4eba\u4e0d\u80fd\u5355\u72ec\u8bf7\u5047\uff1b\u82e5\u4ecd\u9700\u8bf7\u5047\uff0c\u8bf7\u5411\u4f60\u7684\u6559\u5b66\u987e\u95ee\uff08" + name + " " + mobile + " \uff09\u8054\u7cfb\u3002";
        }
        List<LeaveCourseResult> leaveCourseResults = this.tCoursesessionService.leaveCoursePlan(tCoursesession.getCid(), 1);
        TCoursesession newCoursesession = new TCoursesession();
        if (leaveCourseResults != null && leaveCourseResults.size() > 0) {
            LeaveCourseResult leaveCourseResult = leaveCourseResults.get(0);
            BeanUtils.copyProperties((Object)tCoursesession, (Object)newCoursesession, (String[])new String[]{"updateTime"});
            newCoursesession.setTeacherId(tCoursesession.getTeacherId());
            newCoursesession.setCreateTime(null);
            newCoursesession.setDuration(Integer.valueOf(leaveCourseResult.getTimeLength()));
            newCoursesession.setSessionid(null);
            newCoursesession.setStatus(null);
            newCoursesession.setStarttime(DateUtils.parseDateToSecond((String)leaveCourseResult.getStartTime()));
            newCoursesession.setIsSystem(Integer.valueOf(1));
            if (tCourse.getType() == 100001) {
                newCoursesession.setRate(new BigDecimal(tTeacher.getOneOnOne()));
            } else {
                newCoursesession.setRate(new BigDecimal(tTeacher.getOneOnMultiple()));
            }
            this.tCoursesessionDao.insertSelective(newCoursesession);
            List addBeforeStudentIdList = this.tCourseStudentDao.findStudentIdListByCid(tCourse.getCid());
            ArrayList<TCourseSessionStudent> tCourseSessionStudentList = new ArrayList<TCourseSessionStudent>();
            for (Integer stuId : addBeforeStudentIdList) {
                TCourseSessionStudent tCourseSessionStudent = new TCourseSessionStudent();
                tCourseSessionStudent.setCourseSessionId(newCoursesession.getSessionid());
                tCourseSessionStudent.setStudentId(stuId);
                tCourseSessionStudent.setCreater(String.valueOf(tStudent.getLoginId()));
                tCourseSessionStudentList.add(tCourseSessionStudent);
            }
            this.tCourseSessionStudentDao.batchInsert(tCourseSessionStudentList);
        }
        tCoursesession.setStatus(TalkillaConstant.COURSE_STATUS_LEAVE_STUDENT);
        int flag = this.tCoursesessionService.updateByIdSelective(tCoursesession);
        if (flag < 1) {
            return "\u8bf7\u5047\u5931\u8d25\uff01\uff01\uff01";
        }
        new Thread(new Runnable(){

            @Override
            public void run() {
                String loginName;
                TTeacher teacher = CourseServiceImpl.this.tTeacherService.findOne(tCoursesession.getTeacherId());
                TLogin teacherTLogin = CourseServiceImpl.this.tLoginService.findOne(teacher.getLoginId());
                Date startDate = null;
                String timezone = teacher.getTimezone();
                if (timezone != null) {
                    TCustTimezone tCustTimezone = CourseServiceImpl.this.tCustTimezoneService.findByTimezone(timezone);
                    startDate = tCustTimezone != null ? TimeZoneUtil.findTimeByCustomerDate(tCoursesession.getStarttime(), tCustTimezone) : TimeZoneUtil.Date2TimezoneDefault(tCoursesession.getStarttime(), timezone);
                }
                if ((loginName = teacherTLogin.getLoginName()) != null && CheckFormatUtils.checkEmail((String)loginName)) {
                    TalkillaEmailMessageUtils.sendTeacherByStudentLeaveClassEmail(loginName, teacher, tStudent, DateUtils.formatDateToDay((Date)startDate), DateUtils.getHHmmString((Date)startDate, (Integer)tCoursesession.getDuration()), DateUtils.getEnglishWeekNumberOfDate((Date)startDate));
                    TSendEmailRecord tSendEmailRecord = new TSendEmailRecord();
                    tSendEmailRecord.setUserType(TalkillaConstant.SendEmailUserType.TEACHER);
                    tSendEmailRecord.setEmail(loginName);
                    tSendEmailRecord.setEmailType(TalkillaConstant.SendEmailType.SEND_TEACHER_BY_STUDENT_LEAVE_CLASS_EMAIL);
                    tSendEmailRecord.setRecordType(TalkillaConstant.SendEmailType.SEND_TEACHER_BY_STUDENT_LEAVE_CLASS_EMAIL);
                    tSendEmailRecord.setCid(tCourse.getCid());
                    tSendEmailRecord.setStuId(tCourse.getStuId());
                    tSendEmailRecord.setTeacherId(tCourse.getTeacherId());
                    CourseServiceImpl.this.tSendEmailRecordDao.insertSelective(tSendEmailRecord);
                }
                TLogin studentTLogin = CourseServiceImpl.this.tLoginService.findOne(tStudent.getLoginId());
                TStudentConsultant tStudentConsultant = CourseServiceImpl.this.tStudentConsultantService.findByStudentId(tStudent.getStuId());
                TalkillaEmailMessageUtils.sendStudentByStudentLeaveClass(studentTLogin.getLoginName(), null, tStudent, teacher, tStudentConsultant, DateUtils.formatDateToDay((Date)tCoursesession.getStarttime()), DateUtils.getHHmmString((Date)tCoursesession.getStarttime(), (Integer)tCoursesession.getDuration()), DateUtils.getChineseWeekNumberOfDate((Date)tCoursesession.getStarttime()));
                TSendEmailRecord tSendEmailRecord = new TSendEmailRecord();
                tSendEmailRecord.setUserType(TalkillaConstant.SendEmailUserType.STUDENT);
                tSendEmailRecord.setEmail(studentTLogin.getLoginName());
                tSendEmailRecord.setEmailType(TalkillaConstant.SendEmailType.SEND_STUDENT_BY_STUDENT_LEAVE_CLASS);
                tSendEmailRecord.setRecordType(TalkillaConstant.SendEmailType.SEND_STUDENT_BY_STUDENT_LEAVE_CLASS);
                tSendEmailRecord.setCid(tCourse.getCid());
                tSendEmailRecord.setStuId(tStudent.getStuId());
                tSendEmailRecord.setTeacherId(tCourse.getTeacherId());
                CourseServiceImpl.this.tSendEmailRecordDao.insertSelective(tSendEmailRecord);
            }
        }).start();
        return "\u60a8\u5df2\u7ecf\u8bf7\u5047\u6210\u529f\u3002";
    }

    @Override
    public CourseDetailResult courseDetail(Integer cid, TStudent student) {
        CourseDetailResult result = new CourseDetailResult();
        Double hourStudentLeave = 0.0;
        Double hourTeacherLeave = 0.0;
        Double hourStudentAbsent = 0.0;
        Double hourTeacherAbsent = 0.0;
        TCourse course = this.tCourseService.findOne(cid);
        BeanUtils.copyProperties((Object)course, (Object)result);
        result.setHourawarded(MathUtils.getIntegerFromDouble((Double)MathUtils.getCoursesTimes((Double)course.getHourawarded(), (Integer)course.getDuration())));
        result.setHourcomplete(MathUtils.getIntegerFromDouble((Double)MathUtils.getCoursesTimes((Double)course.getHourcomplete(), (Integer)course.getDuration())));
        result.setHourpending(MathUtils.getIntegerFromDouble((Double)MathUtils.getCoursesTimes((Double)course.getHourpending(), (Integer)course.getDuration())));
        result.setHourpurchase(MathUtils.getIntegerFromDouble((Double)MathUtils.getCoursesTimes((Double)course.getHourpurchase(), (Integer)course.getDuration())));
        List<TCoursesession> coursesessionList = this.tCoursesessionService.findListByCidAsc(cid);
        Integer duration = 0;
        if (coursesessionList != null && coursesessionList.size() > 0) {
            TTeacher teacher = null;
            ArrayList<CourseDetailResult.TeacherComment> commentList = new ArrayList<CourseDetailResult.TeacherComment>();
            for (TCoursesession coursesession : coursesessionList) {
                teacher = this.tTeacherService.findOne(coursesession.getTeacherId());
                duration = coursesession.getDuration();
                TTeacherComments tTeacherComments = this.tTeacherCommentsService.findBySessionid(coursesession.getSessionid());
                CourseDetailResult.TeacherComment teacherComment = new CourseDetailResult.TeacherComment(result);
                Date starttime = coursesession.getStarttime();
                if (coursesession.getStatus() != null && coursesession.getStatus().equals(TalkillaConstant.COURSE_STATUS_ABSENT_TEACHER)) {
                    hourTeacherAbsent = Arith.add((double)hourTeacherAbsent, (double)coursesession.getDuration().intValue());
                    teacherComment.setClassStatus("\u8001\u5e08\u65f7\u8bfe");
                } else if (coursesession.getStatus() != null && coursesession.getStatus().equals(TalkillaConstant.COURSE_STATUS_ABSENT_STUDENT)) {
                    hourStudentAbsent = Arith.add((double)hourStudentAbsent, (double)coursesession.getDuration().intValue());
                    teacherComment.setClassStatus("\u5b66\u751f\u65f7\u8bfe");
                } else if (coursesession.getStatus() != null && coursesession.getStatus() == 101002) {
                    hourTeacherLeave = Arith.add((double)hourTeacherLeave, (double)coursesession.getDuration().intValue());
                    teacherComment.setClassStatus("\u8001\u5e08\u8bf7\u5047");
                } else if (coursesession.getStatus() != null && coursesession.getStatus() == 101003) {
                    hourStudentLeave = Arith.add((double)hourStudentLeave, (double)coursesession.getDuration().intValue());
                    teacherComment.setClassStatus("\u5b66\u751f\u8bf7\u5047");
                } else if (coursesession.getStatus() != null && coursesession.getStatus() == 101006) {
                    teacherComment.setClassStatus("\u7279\u6b8a\u60c5\u51b5");
                } else if (coursesession.getStatus() != null && coursesession.getStatus() == 101007) {
                    teacherComment.setClassStatus("\u5c1a\u672a\u786e\u8ba4");
                } else if (coursesession.getStatus() != null && coursesession.getStatus() == 101001) {
                    teacherComment.setClassStatus("\u6b63\u5e38\u5b8c\u6210");
                } else {
                    teacherComment.setClassStatus("\u8fd8\u672a\u4e0a\u8bfe");
                }
                teacherComment.setIspay(coursesession.getIspay());
                teacherComment.setCourseType(coursesession.getCourseType().toString());
                teacherComment.setTeachername(teacher.getFirstName() + " " + teacher.getLastName().substring(0, 1).toUpperCase() + ".");
                teacherComment.setStarttime(DateUtils.formatDateToMinute((Date)starttime));
                if (tTeacherComments != null) {
                    teacherComment.setComments(tTeacherComments.getComments());
                }
                commentList.add(teacherComment);
            }
            result.setHourStudentAbsent(MathUtils.getIntegerFromDouble((Double)Arith.div((double)hourStudentAbsent, (double)duration.intValue())));
            result.setHourTeacherAbsent(MathUtils.getIntegerFromDouble((Double)Arith.div((double)hourTeacherAbsent, (double)duration.intValue())));
            result.setHourStudentLeave(MathUtils.getIntegerFromDouble((Double)Arith.div((double)hourStudentLeave, (double)duration.intValue())));
            result.setHourTeacherLeave(MathUtils.getIntegerFromDouble((Double)Arith.div((double)hourTeacherLeave, (double)duration.intValue())));
            result.setTeacherCommentList(commentList);
        }
        return result;
    }

    @Override
    public List<StudentSummaryListResult> studentSummaryList(Integer stuId) {
        ArrayList<StudentSummaryListResult> resultList = new ArrayList<StudentSummaryListResult>();
        List<TStudentSummary> studentSummaryList = this.tStudentSummaryService.findStudentSummaryListByStuId(stuId);
        if (studentSummaryList != null && studentSummaryList.size() > 0) {
            for (TStudentSummary tStudentSummary : studentSummaryList) {
                StudentSummaryListResult result = new StudentSummaryListResult();
                TTeacher tTeacher = this.tTeacherService.findOne(tStudentSummary.getTeacherId());
                result.setTeacherFirstName(tTeacher.getFirstName());
                result.setTeacherLastName(tTeacher.getLastName());
                result.setSummary(tStudentSummary.getSummary());
                result.setCreateTime(DateUtils.formatByJsDate((Date)tStudentSummary.getCreateTime()));
                resultList.add(result);
            }
        }
        return resultList;
    }

    @Override
    public CourceSessionInfoResult courceSessionInfo(Integer sessionId, TStudent student) {
        if (Objects.isNull(sessionId)) {
            return null;
        }
        TCoursesession tCoursesession = this.tCoursesessionDao.findOne(sessionId);
        if (Objects.isNull(tCoursesession)) {
            return null;
        }
        TTeacher tTeacher = this.tTeacherService.findOne(tCoursesession.getTeacherId());
        if (Objects.isNull(tTeacher)) {
            return null;
        }
        CourceSessionInfoResult result = new CourceSessionInfoResult();
        result.setTeacherId(tCoursesession.getTeacherId());
        result.setTeacherName(tTeacher.getFirstName() + " " + tTeacher.getLastName());
        result.setSessionid(tCoursesession.getSessionid());
        result.setCid(tCoursesession.getCid());
        result.setStatus(tCoursesession.getStatus());
        result.setStatusDesc(TalkillaConstant.transferCourseStatus((Integer)tCoursesession.getStatus()));
        Date starttime = tCoursesession.getStarttime();
        result.setStarttime(starttime);
        String beginHour = DateUtils.formatDate((Date)starttime, (String)"HH:mm");
        String dayAndYearStr = DateUtils.formatDate((Date)starttime, (String)"yyyy-MM-dd");
        String endHour = DateUtils.formatDate((Date)org.apache.commons.lang.time.DateUtils.addMinutes((Date)starttime, (int)tCoursesession.getDuration()), (String)"HH:mm");
        String dateStr = dayAndYearStr + " " + beginHour + "-" + endHour;
        result.setStarttimeDesc(dateStr);
        TTeacherComments tTeacherComments = this.tTeacherCommentsDao.findBySessionid(sessionId);
        if (Objects.nonNull(tTeacherComments)) {
            result.setTeacherComments(tTeacherComments.getComments());
        }
        TStuFeeback tStuFeeback = this.tStuFeebackDao.findBySessionidAndStuId(sessionId, student.getStuId());
        result.setIsEvaluateTeacher(Boolean.valueOf(Objects.nonNull(tStuFeeback)));
        return result;
    }

    private CoursesessionCalender getCoursesessionCalender(Integer studentId, Calendar calendar) {
        CoursesessionCalender coursesessionCalender = new CoursesessionCalender();
        ArrayList<CoursesessionCalender.CourseInfo> courseInfos = new ArrayList<CoursesessionCalender.CourseInfo>();
        ArrayList<CoursesessionCalender.CourseTime> courseTimes = new ArrayList<CoursesessionCalender.CourseTime>();
        String[] weekOfDays = new String[]{"\u65e5", "\u4e00", "\u4e8c", "\u4e09", "\u56db", "\u4e94", "\u516d"};
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        SimpleDateFormat sdf2 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        if (calendar.get(7) != 1) {
            calendar.set(7, 1);
        }
        int curMonth = calendar.get(2);
        String showDate = calendar.get(1) + "\u5e74" + (curMonth + 1) + "\u6708" + calendar.get(5);
        calendar.add(5, 6);
        showDate = calendar.get(2) == curMonth ? showDate + "-" + calendar.get(5) : showDate + "-" + (calendar.get(2) + 1) + "\u6708" + calendar.get(5);
        calendar.add(5, -6);
        coursesessionCalender.setShowDate(showDate);
        for (int i = 0; i < 7; ++i) {
            CoursesessionCalender.CourseInfo courseInfo = new CoursesessionCalender.CourseInfo(coursesessionCalender);
            courseInfo.setWeek(weekOfDays[i]);
            courseInfo.setIntDate(Integer.valueOf(calendar.get(5)));
            List<TCoursesession> coursesessionList = this.tCoursesessionService.findCoursesessionListByStudentIdAndSearchDate(studentId, sdf.format(calendar.getTime()));
            courseTimes = new ArrayList();
            if (coursesessionList != null && coursesessionList.size() > 0) {
                ArrayList teacherIds = Lists.newArrayList();
                for (TCoursesession tCoursesession : coursesessionList) {
                    teacherIds.add(tCoursesession.getTeacherId());
                }
                List<TTeacher> tTeachers = this.tTeacherService.findByTeacherIds(teacherIds);
                HashMap tTeacherMap = Maps.newHashMap();
                for (TTeacher tTeacher : tTeachers) {
                    tTeacherMap.putIfAbsent(tTeacher.getTeacherId(), tTeacher);
                }
                for (TCoursesession tCoursesession : coursesessionList) {
                    CoursesessionCalender.CourseTime courseTime = new CoursesessionCalender.CourseTime(coursesessionCalender);
                    courseTime.setCid(tCoursesession.getCid());
                    courseTime.setType(tCoursesession.getCourseType());
                    courseTime.setSessionid(tCoursesession.getSessionid());
                    courseTime.setStarTimeStr(sdf2.format(tCoursesession.getStarttime()));
                    courseTime.setStatus(tCoursesession.getStatus());
                    TTeacher tTeacher = (TTeacher)tTeacherMap.get(tCoursesession.getTeacherId());
                    if (Objects.nonNull(tTeacher)) {
                        courseTime.setTeacherName(tTeacher.getFirstName());
                    }
                    Calendar instance = Calendar.getInstance();
                    instance.setTime(tCoursesession.getStarttime());
                    instance.add(12, tCoursesession.getDuration());
                    courseTime.setEndTimeStr(sdf2.format(instance.getTime()));
                    Integer status = tCoursesession.getStatus();
                    if (TalkillaConstant.COURSE_STATUS_COMPLETED.equals(status)) {
                        courseTime.setColor("gray");
                        courseTime.setStatusDesc(TalkillaConstant.transferCourseStatus((Integer)status));
                    } else if (TalkillaConstant.COURSE_STATUS_LEAVE_TEACHER.equals(status) || TalkillaConstant.COURSE_STATUS_LEAVE_STUDENT.equals(status) || TalkillaConstant.COURSE_STATUS_SPECIAL_CASES.equals(status)) {
                        courseTime.setColor("blue");
                        courseTime.setStatusDesc(TalkillaConstant.transferCourseStatus((Integer)status));
                    } else if (TalkillaConstant.COURSE_STATUS_ABSENT_TEACHER.equals(status) || TalkillaConstant.COURSE_STATUS_ABSENT_STUDENT.equals(status)) {
                        courseTime.setColor("red");
                        courseTime.setStatusDesc(TalkillaConstant.transferCourseStatus((Integer)status));
                    } else if (TalkillaConstant.COURSE_STATUS_UMCONFIRMED.equals(status)) {
                        courseTime.setColor("purple");
                        courseTime.setStatusDesc(TalkillaConstant.transferCourseStatus((Integer)status));
                    } else {
                        courseTime.setColor("green");
                        courseTime.setStatusDesc(TalkillaConstant.transferCourseStatus((Integer)status));
                    }
                    courseTimes.add(courseTime);
                }
            }
            courseInfo.setCourseTimeList(courseTimes);
            calendar.add(5, 1);
            courseInfos.add(courseInfo);
        }
        coursesessionCalender.setDateList(courseInfos);
        return coursesessionCalender;
    }
}

