/*
 * Decompiled with CFR 0.152.
 */
package com.talkilla.service.impl.teacher;

import com.talkilla.constant.SystemConfig;
import com.talkilla.constant.TalkillaConstant;
import com.talkilla.form.teacher.CourseTeachingListForm;
import com.talkilla.form.teacher.MultipleLeavesComfirmForm;
import com.talkilla.form.teacher.MultipleLeavesPageSearchForm;
import com.talkilla.mysql.domain.TCourse;
import com.talkilla.mysql.domain.TCourseSessionStudent;
import com.talkilla.mysql.domain.TCoursesession;
import com.talkilla.mysql.domain.TCustTimezone;
import com.talkilla.mysql.domain.TLogin;
import com.talkilla.mysql.domain.TSendEmailRecord;
import com.talkilla.mysql.domain.TStudent;
import com.talkilla.mysql.domain.TStudentConsultant;
import com.talkilla.mysql.domain.TTeacher;
import com.talkilla.mysql.domain.TTeacherMultipleLeavesRecordWithBLOBs;
import com.talkilla.mysql.domain.TWechat;
import com.talkilla.mysql.mapper.TConsultantDao;
import com.talkilla.mysql.mapper.TCourseDao;
import com.talkilla.mysql.mapper.TCourseSessionStudentDao;
import com.talkilla.mysql.mapper.TCourseStudentDao;
import com.talkilla.mysql.mapper.TCoursesessionDao;
import com.talkilla.mysql.mapper.TCustTimezoneDao;
import com.talkilla.mysql.mapper.TLoginDao;
import com.talkilla.mysql.mapper.TNationDao;
import com.talkilla.mysql.mapper.TSendEmailRecordDao;
import com.talkilla.mysql.mapper.TStuFeebackDao;
import com.talkilla.mysql.mapper.TStudentConsultantDao;
import com.talkilla.mysql.mapper.TStudentDao;
import com.talkilla.mysql.mapper.TTeacherCommentsDao;
import com.talkilla.mysql.mapper.TTeacherDao;
import com.talkilla.mysql.mapper.TTeacherMultipleLeavesRecordDao;
import com.talkilla.mysql.mapper.TWechatDao;
import com.talkilla.result.LeaveCourseResult;
import com.talkilla.result.ReturnMessageResult;
import com.talkilla.result.teacher.CourseTeachingResult;
import com.talkilla.result.teacher.MultipleLeavesPageSearchResult;
import com.talkilla.service.TCourseService;
import com.talkilla.service.TCoursesessionService;
import com.talkilla.service.UploadPhotoService;
import com.talkilla.service.teacher.TeacherMultipleLeaveService;
import com.talkilla.serviceUtils.TalkillaEmailMessageUtils;
import com.talkilla.serviceUtils.TimeZoneUtil;
import com.talkilla.utils.DateUtils;
import com.talkilla.utils.ThreadPoolUtils;
import com.talkilla.wechat.service.WechatMessageService;
import java.math.BigDecimal;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.TimeZone;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class TeacherMultipleLeaveServiceImpl
implements TeacherMultipleLeaveService {
    private static final Logger log = LoggerFactory.getLogger(TeacherMultipleLeaveServiceImpl.class);
    @Autowired
    private TTeacherDao tTeacherDao;
    @Autowired
    private TCustTimezoneDao tCustTimezoneDao;
    @Autowired
    private TCoursesessionDao tCoursesessionDao;
    @Autowired
    private TTeacherMultipleLeavesRecordDao tTeacherMultipleLeavesRecordDao;
    @Autowired
    private TCoursesessionService tCoursesessionService;
    @Autowired
    private TCourseDao tCourseDao;
    @Autowired
    UploadPhotoService uploadPhotoService;
    @Autowired
    TNationDao tNationDao;
    @Autowired
    TLoginDao tLoginDao;
    @Autowired
    TStudentDao tStudentDao;
    @Autowired
    TCourseService tCourseService;
    @Autowired
    TWechatDao tWechatDao;
    @Autowired
    TStudentConsultantDao tStudentConsultantDao;
    @Autowired
    TConsultantDao tConsultantDao;
    @Autowired
    TStuFeebackDao tStuFeebackDao;
    @Autowired
    TTeacherCommentsDao tTeacherCommentsDao;
    @Autowired
    WechatMessageService wechatMessageService;
    @Autowired
    private TCourseStudentDao tCourseStudentDao;
    @Autowired
    private TCourseSessionStudentDao tCourseSessionStudentDao;
    @Autowired
    private TSendEmailRecordDao tSendEmailRecordDao;

    @Override
    public MultipleLeavesPageSearchResult multipleLeavesPageSearch(MultipleLeavesPageSearchForm form) {
        TTeacher teacher = this.tTeacherDao.findOne(form.getTeacherId());
        String timezone = teacher.getTimezone();
        TCustTimezone custTimezone = this.tCustTimezoneDao.findByTimezone(timezone);
        this.initAndCheckStartDataStr(form, timezone, custTimezone);
        CourseTeachingListForm queryForm = new CourseTeachingListForm();
        queryForm.setTeacherId(form.getTeacherId());
        queryForm.setStartDate(form.getSearchStartDataStr());
        queryForm.setEndDate(form.getSearchEndDataStr());
        List teachingResultList = this.tCoursesessionDao.courseTeachingListForUnConfirmed(queryForm);
        List<MultipleLeavesPageSearchResult.SessionListBean> sessionListBeanList = this.teachingResultListToSessionListBean(teachingResultList, timezone, custTimezone);
        MultipleLeavesPageSearchResult result = new MultipleLeavesPageSearchResult();
        result.setStartDataStr(form.getStartDataStr());
        result.setEndDataStr(form.getEndDataStr());
        result.setSessionList(sessionListBeanList);
        return result;
    }

    @Override
    @Transactional(rollbackFor={Throwable.class})
    public ReturnMessageResult multipleLeavesComfirm(MultipleLeavesComfirmForm form) {
        String[] split;
        String sessionIdStr = form.getSessionIdStr();
        TTeacher teacher = form.getTeacher();
        Integer teacherId = teacher.getTeacherId();
        if (StringUtils.isEmpty((CharSequence)sessionIdStr) || Objects.isNull(teacherId)) {
            return null;
        }
        TTeacherMultipleLeavesRecordWithBLOBs tTeacherMultipleLeavesRecord = new TTeacherMultipleLeavesRecordWithBLOBs();
        tTeacherMultipleLeavesRecord.setTeacherId(teacherId);
        tTeacherMultipleLeavesRecord.setSessionIdStr(sessionIdStr);
        tTeacherMultipleLeavesRecord.setNotes(form.getLeaveNote());
        tTeacherMultipleLeavesRecord.setCreater(teacherId.toString());
        this.tTeacherMultipleLeavesRecordDao.insertSelective(tTeacherMultipleLeavesRecord);
        ReturnMessageResult messageResult = new ReturnMessageResult();
        for (String str : split = sessionIdStr.split(",")) {
            Integer sessionid = Integer.valueOf(str);
            Boolean checkValue = this.tCoursesessionService.checkCoursesessionStatus(sessionid, null);
            if (!checkValue.booleanValue()) {
                log.warn("\u8bfe\u7a0b\u72b6\u6001\u4fee\u6539\u8fc7\u4e86");
                continue;
            }
            TCoursesession tCoursesession = this.tCoursesessionDao.findOne(sessionid);
            TCourse tCourse = this.tCourseDao.findOne(tCoursesession.getCid());
            TStudent tStudent = this.tStudentDao.findOne(tCourse.getStuId());
            TLogin studentLogin = this.tLoginDao.findOne(tStudent.getLoginId());
            TTeacher tTeacher = this.tTeacherDao.findOne(tCoursesession.getTeacherId());
            TLogin teacherLogin = this.tLoginDao.findOne(tTeacher.getLoginId());
            TStudentConsultant studentConsultant = this.tStudentConsultantDao.findByStudentId(tCourse.getStuId());
            TWechat tWechat = this.tWechatDao.getTWechatInfoByLoginId(tStudent.getLoginId());
            tCoursesession.setStatus(TalkillaConstant.COURSE_STATUS_LEAVE_TEACHER);
            tCoursesession.setUpdateTime(new Date());
            this.tCoursesessionDao.updateByIdSelective(tCoursesession);
            TCoursesession newCoursesession = new TCoursesession();
            List<LeaveCourseResult> leaveCourseResults = this.tCoursesessionService.leaveCoursePlan(tCoursesession.getCid(), 1);
            List addBeforeStudentIdList = this.tCourseStudentDao.findStudentIdListByCid(tCourse.getCid());
            if (CollectionUtils.isEmpty((Collection)addBeforeStudentIdList)) {
                log.warn("\u8bfe\u7a0b\u6ca1\u6709\u5173\u8054\u7684\u5b66\u751f");
                continue;
            }
            if (leaveCourseResults != null && leaveCourseResults.size() > 0) {
                LeaveCourseResult leaveCourseResult = leaveCourseResults.get(0);
                BeanUtils.copyProperties((Object)tCoursesession, (Object)newCoursesession, (String[])new String[]{"updateTime"});
                newCoursesession.setTeacherId(tCoursesession.getTeacherId());
                newCoursesession.setCreateTime(null);
                newCoursesession.setDuration(Integer.valueOf(leaveCourseResult.getTimeLength()));
                newCoursesession.setSessionid(null);
                newCoursesession.setStatus(null);
                try {
                    newCoursesession.setStarttime(DateUtils.parseDateToSecond((String)leaveCourseResult.getStartTime()));
                }
                catch (ParseException e) {
                    e.printStackTrace();
                }
                newCoursesession.setIsSystem(Integer.valueOf(1));
                newCoursesession.setStuId(tCoursesession.getStuId());
                if (tCourse.getType() == 100001) {
                    newCoursesession.setRate(new BigDecimal(tTeacher.getOneOnOne()));
                } else {
                    newCoursesession.setRate(new BigDecimal(tTeacher.getOneOnMultiple()));
                }
                this.tCoursesessionDao.insertSelective(newCoursesession);
                ArrayList<TCourseSessionStudent> tCourseSessionStudentList = new ArrayList<TCourseSessionStudent>();
                for (Integer stuId : addBeforeStudentIdList) {
                    TCourseSessionStudent tCourseSessionStudent = new TCourseSessionStudent();
                    tCourseSessionStudent.setCourseSessionId(newCoursesession.getSessionid());
                    tCourseSessionStudent.setStudentId(stuId);
                    tCourseSessionStudent.setCreater(String.valueOf(teacher.getLoginId()));
                    tCourseSessionStudentList.add(tCourseSessionStudent);
                }
                this.tCourseSessionStudentDao.batchInsert(tCourseSessionStudentList);
            }
            this.sendEmailAndWechatMessage(form, tCoursesession, tCourse, tTeacher, teacherLogin, addBeforeStudentIdList);
        }
        messageResult.setFlag(Integer.valueOf(0));
        messageResult.setMessage("\u8001\u5e08\u8bf7\u5047\uff0c\u4fdd\u5b58\u6210\u529f,\u8bfe\u7a0b\u987a\u5ef6");
        return messageResult;
    }

    private void sendEmailAndWechatMessage(final MultipleLeavesComfirmForm form, final TCoursesession tCoursesession, final TCourse tCourse, final TTeacher tTeacher, final TLogin teacherLogin, final List<Integer> addBeforeStudentIdList) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                TSendEmailRecord tSendEmailRecord;
                for (Integer stuId : addBeforeStudentIdList) {
                    TStudent tStudent = TeacherMultipleLeaveServiceImpl.this.tStudentDao.findOne(stuId);
                    TLogin studentLogin = TeacherMultipleLeaveServiceImpl.this.tLoginDao.findOne(tStudent.getLoginId());
                    TStudentConsultant studentConsultant = TeacherMultipleLeaveServiceImpl.this.tStudentConsultantDao.findByStudentId(stuId);
                    TWechat tWechat = TeacherMultipleLeaveServiceImpl.this.tWechatDao.getTWechatInfoByLoginId(tStudent.getLoginId());
                    ArrayList<String> addressList = new ArrayList<String>();
                    addressList.add(SystemConfig.Admin.ADMIN_EMAIL);
                    if (studentConsultant != null && !"admin".equals(studentConsultant.getConsultantEmail())) {
                        addressList.add(studentConsultant.getConsultantEmail());
                    }
                    TalkillaEmailMessageUtils.sendStudentByTeacherLeaveClass(studentLogin.getLoginName(), addressList, tStudent, tTeacher, studentConsultant, DateUtils.formatDateToDay((Date)tCoursesession.getStarttime()), DateUtils.getHHmmString((Date)tCoursesession.getStarttime(), (Integer)tCoursesession.getDuration()), DateUtils.getChineseWeekNumberOfDate((Date)tCoursesession.getStarttime()));
                    tSendEmailRecord = new TSendEmailRecord();
                    tSendEmailRecord.setUserType(TalkillaConstant.SendEmailUserType.STUDENT);
                    tSendEmailRecord.setEmail(studentLogin.getLoginName());
                    tSendEmailRecord.setEmailType(TalkillaConstant.SendEmailType.SEND_STUDENT_BY_TEACHER_LEAVE_CLASS);
                    tSendEmailRecord.setRecordType(TalkillaConstant.SendEmailType.SEND_STUDENT_BY_TEACHER_LEAVE_CLASS);
                    tSendEmailRecord.setCid(tCourse.getCid());
                    tSendEmailRecord.setStuId(tStudent.getStuId());
                    tSendEmailRecord.setTeacherId(tCourse.getTeacherId());
                    TeacherMultipleLeaveServiceImpl.this.tSendEmailRecordDao.insertSelective(tSendEmailRecord);
                    TeacherMultipleLeaveServiceImpl.this.wechatMessageService.sendStudentByTeacherLeaveClass(tStudent, tWechat, tTeacher, studentConsultant, DateUtils.formatDate((Date)tCoursesession.getStarttime(), (String)"yyyy\u5e74MM\u6708dd\u65e5"), DateUtils.getChineseWeekNumberOfDate((Date)tCoursesession.getStarttime()), tCoursesession.getSessionid(), form.getLeaveNote());
                }
                String timezone = tTeacher.getTimezone();
                TCustTimezone tCustTimezone = TeacherMultipleLeaveServiceImpl.this.tCustTimezoneDao.findByTimezone(timezone);
                Date starttime = tCustTimezone != null ? TimeZoneUtil.findTimeByCustomerDate(tCoursesession.getStarttime(), tCustTimezone) : TimeZoneUtil.Date2TimezoneDefault(tCoursesession.getStarttime(), timezone);
                TalkillaEmailMessageUtils.sendTeacherByLeaveClassEmail(teacherLogin.getLoginName(), tTeacher, tCourse.getStuEnName(), DateUtils.formatDateToDay((Date)starttime), DateUtils.getHHmmString((Date)starttime, (Integer)tCoursesession.getDuration()), DateUtils.getEnglishWeekNumberOfDate((Date)starttime));
                tSendEmailRecord = new TSendEmailRecord();
                tSendEmailRecord.setUserType(TalkillaConstant.SendEmailUserType.TEACHER);
                tSendEmailRecord.setEmail(teacherLogin.getLoginName());
                tSendEmailRecord.setEmailType(TalkillaConstant.SendEmailType.SEND_TEACHER_BY_LEAVE_CLASS_EMAIL);
                tSendEmailRecord.setRecordType(TalkillaConstant.SendEmailType.SEND_TEACHER_BY_LEAVE_CLASS_EMAIL);
                tSendEmailRecord.setCid(tCourse.getCid());
                tSendEmailRecord.setStuId(tCourse.getStuId());
                tSendEmailRecord.setTeacherId(tCourse.getTeacherId());
                TeacherMultipleLeaveServiceImpl.this.tSendEmailRecordDao.insertSelective(tSendEmailRecord);
            }
        };
        ThreadPoolUtils.execute((Runnable)runnable);
    }

    private List<MultipleLeavesPageSearchResult.SessionListBean> teachingResultListToSessionListBean(List<CourseTeachingResult> teachingResultList, String timezone, TCustTimezone custTimezone) {
        if (CollectionUtils.isEmpty(teachingResultList)) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<MultipleLeavesPageSearchResult.SessionListBean> sessionListBeanList = new ArrayList<MultipleLeavesPageSearchResult.SessionListBean>(teachingResultList.size());
        teachingResultList.forEach(courseTeachingResult -> {
            Integer status = courseTeachingResult.getStatus();
            if (status == null || status.equals(TalkillaConstant.COURSE_STATUS_UMCONFIRMED)) {
                Date starttime = courseTeachingResult.getStarttime();
                Date teacTime = TimeZoneUtil.Date2TimezoneDefault(starttime, timezone);
                if (custTimezone != null) {
                    teacTime = TimeZoneUtil.findTimeByCustomerDate(starttime, custTimezone);
                }
                Integer duration = courseTeachingResult.getDuration();
                String classDataStr = DateUtils.formatDate((Date)teacTime, (String)"yyyy-MM-dd");
                String classTimeStr = DateUtils.formatDate((Date)teacTime, (String)"HH:mm");
                classTimeStr = classTimeStr + "-" + DateUtils.formatDateToHHmm((Date)new Date(teacTime.getTime() + (long)(duration * 60) * 1000L));
                MultipleLeavesPageSearchResult.SessionListBean sessionListBean = new MultipleLeavesPageSearchResult.SessionListBean();
                sessionListBean.setSessionid(courseTeachingResult.getSessionid());
                sessionListBean.setClassDataStr(classDataStr);
                sessionListBean.setClassTimeStr(classTimeStr);
                sessionListBean.setStudentNameStr(courseTeachingResult.getStunames());
                sessionListBeanList.add(sessionListBean);
            }
        });
        return sessionListBeanList;
    }

    private void initAndCheckStartDataStr(MultipleLeavesPageSearchForm form, String timezone, TCustTimezone custTimezone) {
        Date now;
        String startDataStr = form.getStartDataStr();
        if (StringUtils.isEmpty((CharSequence)startDataStr)) {
            now = DateUtils.addTimeByType((Date)new Date(), (int)10, (int)12);
            Date teacTime = TimeZoneUtil.Date2TimezoneDefault(now, timezone);
            if (custTimezone != null) {
                teacTime = TimeZoneUtil.findTimeByCustomerDate(now, custTimezone);
            }
            form.setStartDataStr(DateUtils.formatDate((Date)teacTime, (String)"yyyy-MM-dd"));
            form.setSearchStartDataStr(DateUtils.formatDate((Date)now, (String)"yyyy-MM-dd"));
        } else {
            Date dateAfterAdd;
            now = new Date();
            Date date = DateUtils.parseDate((String)startDataStr, (String)"yyyy-MM-dd");
            Date teacTime = DateUtils.convertTimezone((Date)date, (TimeZone)TimeZoneUtil.getTimeZone(timezone), (TimeZone)TimeZone.getTimeZone("GMT+:08:00"));
            if (custTimezone != null) {
                teacTime = TimeZoneUtil.reversalTimeByCustomerDate(date, custTimezone);
            }
            if ((dateAfterAdd = DateUtils.addTimeByType((Date)now, (int)10, (int)12)).after(teacTime)) {
                teacTime = DateUtils.addTimeByType((Date)now, (int)10, (int)12);
            }
            form.setSearchStartDataStr(DateUtils.formatDate((Date)teacTime, (String)"yyyy-MM-dd"));
        }
        String endDataStr = form.getEndDataStr();
        if (StringUtils.isNotBlank((CharSequence)endDataStr)) {
            Date dateAfterAdd;
            Date now2 = new Date();
            Date date = DateUtils.parseDate((String)endDataStr, (String)"yyyy-MM-dd");
            Date teacTime = DateUtils.convertTimezone((Date)date, (TimeZone)TimeZoneUtil.getTimeZone(timezone), (TimeZone)TimeZone.getTimeZone("GMT+:08:00"));
            if (custTimezone != null) {
                teacTime = TimeZoneUtil.reversalTimeByCustomerDate(date, custTimezone);
            }
            if ((dateAfterAdd = DateUtils.addTimeByType((Date)now2, (int)10, (int)12)).after(teacTime)) {
                teacTime = DateUtils.addTimeByType((Date)now2, (int)5, (int)1);
            }
            Calendar instance = Calendar.getInstance();
            instance.setTime(teacTime);
            instance.set(11, 23);
            instance.set(12, 59);
            instance.set(13, 59);
            form.setSearchEndDataStr(DateUtils.formatDate((Date)instance.getTime(), (String)"yyyy-MM-dd HH:mm:ss"));
        }
    }

    public static void main(String[] args) {
        Date date = DateUtils.addTimeByType((Date)new Date(), (int)10, (int)8);
        System.out.println(date);
    }
}

