/*
 * Decompiled with CFR 0.152.
 */
package com.talkilla.service.impl.teacher;

import com.talkilla.constant.TalkillaConstant;
import com.talkilla.mysql.domain.TCourse;
import com.talkilla.mysql.domain.TCourseSessionStudent;
import com.talkilla.mysql.domain.TCoursesession;
import com.talkilla.mysql.domain.TCustTimezone;
import com.talkilla.mysql.domain.TSendEmailRecord;
import com.talkilla.mysql.domain.TStudent;
import com.talkilla.mysql.domain.TTeacher;
import com.talkilla.mysql.domain.TTeacherComments;
import com.talkilla.mysql.domain.TTeacherWorkTime;
import com.talkilla.mysql.mapper.TCourseDao;
import com.talkilla.mysql.mapper.TCourseSessionStudentDao;
import com.talkilla.mysql.mapper.TCourseStudentDao;
import com.talkilla.mysql.mapper.TCoursesessionDao;
import com.talkilla.mysql.mapper.TCustTimezoneDao;
import com.talkilla.mysql.mapper.TLoginDao;
import com.talkilla.mysql.mapper.TSendEmailRecordDao;
import com.talkilla.mysql.mapper.TStudentDao;
import com.talkilla.mysql.mapper.TTeacherCommentsDao;
import com.talkilla.mysql.mapper.TTeacherDao;
import com.talkilla.mysql.mapper.TTeacherWorkTimeDao;
import com.talkilla.otherbean.TTeacherWorkTimeBean;
import com.talkilla.result.teacher.TeacherWorkTimeResult;
import com.talkilla.service.teacher.TeaWorkTimeService;
import com.talkilla.serviceUtils.TalkillaEmailMessageUtils;
import com.talkilla.serviceUtils.TimeZoneUtil;
import com.talkilla.utils.DateUtils;
import java.math.BigDecimal;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service(value="teaWorkTimeService")
public class TeaWorkTimeServiceImpl
implements TeaWorkTimeService {
    @Autowired
    TTeacherWorkTimeDao tTeacherWorkTimeDao;
    @Autowired
    TCoursesessionDao tCoursesessionDao;
    @Autowired
    TTeacherDao tTeacherDao;
    @Autowired
    TCustTimezoneDao tCustTimezoneDao;
    @Autowired
    TLoginDao tLoginDao;
    @Autowired
    TStudentDao tStudentDao;
    @Autowired
    TCourseDao tCourseDao;
    @Autowired
    TTeacherCommentsDao tTeacherCommentsDao;
    @Autowired
    private TCourseStudentDao tCourseStudentDao;
    @Autowired
    private TCourseSessionStudentDao tCourseSessionStudentDao;
    @Autowired
    private TSendEmailRecordDao tSendEmailRecordDao;

    @Override
    public TeacherWorkTimeResult getWorkTimeTale(int teaId, int days) {
        Date now = new Date();
        ZoneId zoneId = ZoneId.systemDefault();
        int day = Integer.valueOf(DateUtils.formatDate((Date)now, (String)"yyyyMMdd"));
        List workTimeByTeacherId = this.tTeacherWorkTimeDao.findWorkTimeByTeacherId(Integer.valueOf(teaId)).stream().map(TTeacherWorkTimeBean::new).collect(Collectors.toList());
        Map<Integer, List<TTeacherWorkTimeBean>> timeTable = workTimeByTeacherId.stream().collect(Collectors.groupingBy(TTeacherWorkTime::getWeekDay));
        IntStream.range(1, 8).forEach(weekDay -> {
            List tTeacherWorkTimes = (List)timeTable.get(weekDay);
            if (tTeacherWorkTimes != null) {
                tTeacherWorkTimes.removeIf(t -> t.getDay() < day && t.getStatus().equals(20));
                tTeacherWorkTimes.stream().filter(t -> t.getDay() < day).forEach(t -> t.setDay(Integer.valueOf(this.addSevenDay(t.getDay()))));
            }
        });
        HashMap timeTableTemp = new HashMap();
        IntStream.range(0, days).forEach(dayAdd -> {
            Date date = org.apache.commons.lang.time.DateUtils.addDays((Date)now, (int)dayAdd);
            Integer weekDayNum = date.toInstant().atZone(zoneId).toLocalDate().getDayOfWeek().getValue();
            List tTeacherWorkTimeBeans = (List)timeTable.get(weekDayNum);
            if (tTeacherWorkTimeBeans != null && !tTeacherWorkTimeBeans.isEmpty()) {
                List collect = tTeacherWorkTimeBeans.stream().filter(tt -> tt.getStatus().equals(10)).map(tt -> tt.clone(date)).collect(Collectors.toList());
                timeTableTemp.putIfAbsent(weekDayNum, new ArrayList());
                ((List)timeTableTemp.get(weekDayNum)).addAll(collect);
            }
        });
        IntStream.range(1, 8).forEach(weekDay -> {
            List tTeacherWorkTimes = (List)timeTable.get(weekDay);
            List tTeacherWorkTimeBeans = (List)timeTableTemp.get(weekDay);
            if (tTeacherWorkTimes != null && tTeacherWorkTimeBeans != null && !tTeacherWorkTimeBeans.isEmpty()) {
                tTeacherWorkTimes.addAll(tTeacherWorkTimeBeans);
                tTeacherWorkTimes.sort(TeaWorkTimeServiceImpl::compareByTimeRange);
            }
        });
        Date endTime = org.apache.commons.lang.time.DateUtils.addDays((Date)now, (int)days);
        List coursesessionInfoResults = this.tCoursesessionDao.findNoCompleteListByTeacheridAndEndTime(Integer.valueOf(teaId), endTime);
        for (TCoursesession csr : coursesessionInfoResults) {
            Instant instant = csr.getStarttime().toInstant();
            int dayCourse = Integer.valueOf(DateUtils.formatDate((Date)csr.getStarttime(), (String)"yyyyMMdd"));
            if (dayCourse < day) continue;
            int weekDayNum = instant.atZone(zoneId).getDayOfWeek().getValue();
            LocalDateTime localDateTime = instant.atZone(zoneId).toLocalDateTime();
            int hour = localDateTime.getHour();
            int minute = localDateTime.getMinute();
            LocalDateTime startTemp = localDateTime;
            if (minute > 0 && minute < 30) {
                startTemp = localDateTime.minusMinutes(minute);
                minute = 0;
            }
            if (minute >= 30) {
                minute = 1;
            }
            int startRange = hour * 2 + 1 + minute;
            LocalDateTime endCsrTime = localDateTime.plusMinutes(csr.getDuration().intValue());
            int endTimeMinute = endCsrTime.getMinute();
            if (endTimeMinute > 0 && endTimeMinute < 30) {
                endCsrTime = endCsrTime.plusMinutes(30 - endTimeMinute);
            }
            if (minute >= 30) {
                endCsrTime = endCsrTime.plusMinutes(60 - endTimeMinute);
            }
            Duration between = Duration.between(startTemp, endCsrTime);
            int endRange = startRange + Double.valueOf(Math.ceil((double)between.toMinutes() / 30.0)).intValue();
            IntStream range = IntStream.range(startRange, endRange);
            List<TTeacherWorkTimeBean> tTeacherWorkTimes = timeTable.get(weekDayNum);
            if (tTeacherWorkTimes == null) {
                List collect = range.boxed().map(r -> TTeacherWorkTimeBean.getZhanKeBean((int)weekDayNum, (int)dayCourse, (int)r)).collect(Collectors.toList());
                timeTable.put(weekDayNum, collect);
                continue;
            }
            range.forEach(r -> {
                Optional<TTeacherWorkTimeBean> first = tTeacherWorkTimes.stream().filter(twt -> twt.getTimeRangeId().equals(r) && twt.getDay().equals(dayCourse)).findFirst();
                if (first.isPresent()) {
                    first.get().addStudentCourseTime();
                } else {
                    tTeacherWorkTimes.add(TTeacherWorkTimeBean.getZhanKeBean((int)weekDayNum, (int)dayCourse, (int)r));
                }
            });
        }
        return this.genTeacherWorkTimeResult(teaId, now, timeTable, days);
    }

    private TeacherWorkTimeResult genTeacherWorkTimeResult(int teaId, Date now, Map<Integer, List<TTeacherWorkTimeBean>> timeTable, int days) {
        TeacherWorkTimeResult result = new TeacherWorkTimeResult();
        TTeacher teacher = this.tTeacherDao.findOne(Integer.valueOf(teaId));
        String timezone = teacher.getTimezone();
        TCustTimezone custTimezone = this.tCustTimezoneDao.findByTimezone(timezone);
        Date teacTime = TimeZoneUtil.Date2TimezoneDefault(now, timezone);
        if (custTimezone != null) {
            teacTime = TimeZoneUtil.findTimeByCustomerDate(now, custTimezone);
        }
        long between = ChronoUnit.MINUTES.between(now.toInstant(), teacTime.toInstant());
        result.setTimeRangeIds(IntStream.range(17, 49).boxed().map(r -> {
            TeacherWorkTimeResult teacherWorkTimeResult = result;
            teacherWorkTimeResult.getClass();
            return new TeacherWorkTimeResult.TimeRangeId(teacherWorkTimeResult, r.intValue(), Long.valueOf(between));
        }).collect(Collectors.toList()));
        result.setDateTitles(IntStream.range(0, days).boxed().map(index -> TeaWorkTimeServiceImpl.getByIndex(now, index)).map(TeacherWorkTimeResult.DateTitle::new).collect(Collectors.toList()));
        result.setTimeList(timeTable.values().stream().flatMap(v -> v.stream()).map(TeacherWorkTimeResult.TimeItem::new).collect(Collectors.groupingBy(TeacherWorkTimeResult.TimeItem::getId)));
        return result;
    }

    @Override
    @Transactional(rollbackFor={Throwable.class}, propagation=Propagation.REQUIRED)
    public boolean addWorkTime(TTeacherWorkTime tTeacherWorkTime) {
        this.tTeacherWorkTimeDao.deleteByTimeChange(tTeacherWorkTime.getTeacherId(), tTeacherWorkTime.getWeekDay().intValue(), tTeacherWorkTime.getTimeRangeId().intValue());
        tTeacherWorkTime.setId(null);
        if (tTeacherWorkTime.getStatus() > 0) {
            this.tTeacherWorkTimeDao.insertSelective(tTeacherWorkTime);
        }
        return true;
    }

    @Override
    @Transactional(rollbackFor={Throwable.class}, propagation=Propagation.REQUIRED)
    public boolean addTempCource(Date date, int cid, int teaId, int courseSessionId, String remark, TStudent tStudent) {
        TTeacherComments commentss;
        TCoursesession tCoursesession = this.tCoursesessionDao.findOne(Integer.valueOf(courseSessionId));
        TCourse course = this.tCourseDao.findOne(tCoursesession.getCid());
        if (course.getType().equals(100002)) {
            return false;
        }
        if (tCoursesession.getIsDelete() != 0) {
            return false;
        }
        if (!this.checkTeacherTime(teaId, date, tCoursesession.getDuration())) {
            return false;
        }
        TTeacher teacher = this.tTeacherDao.findOne(Integer.valueOf(teaId));
        tCoursesession.setIsDelete(DateUtils.getNowSeconds());
        tCoursesession.setUpdateTime(new Date());
        this.tCoursesessionDao.updateByIdSelective(tCoursesession);
        tCoursesession.setSessionid(null);
        tCoursesession.setIsDelete(Integer.valueOf(0));
        tCoursesession.setStarttime(date);
        tCoursesession.setTeacherId(Integer.valueOf(teaId));
        tCoursesession.setCreateTime(new Date());
        tCoursesession.setUpdateTime(null);
        if (course.getType() == 100001) {
            tCoursesession.setRate(new BigDecimal(teacher.getOneOnOne()));
        } else {
            tCoursesession.setRate(new BigDecimal(teacher.getOneOnMultiple()));
        }
        this.tCoursesessionDao.insertSelective(tCoursesession);
        List addBeforeStudentIdList = this.tCourseStudentDao.findStudentIdListByCid(course.getCid());
        ArrayList<TCourseSessionStudent> tCourseSessionStudentList = new ArrayList<TCourseSessionStudent>();
        for (Integer stuId : addBeforeStudentIdList) {
            TCourseSessionStudent tCourseSessionStudent = new TCourseSessionStudent();
            tCourseSessionStudent.setCourseSessionId(tCoursesession.getSessionid());
            tCourseSessionStudent.setStudentId(stuId);
            tCourseSessionStudent.setCreater(String.valueOf(tStudent.getLoginId()));
            tCourseSessionStudentList.add(tCourseSessionStudent);
        }
        this.tCourseSessionStudentDao.batchInsert(tCourseSessionStudentList);
        String email = this.tLoginDao.findByTeacherId(Integer.valueOf(teaId));
        TStudent student = this.tStudentDao.findOne(tCoursesession.getStuId());
        String timezone = teacher.getTimezone();
        TCustTimezone custTimezone = this.tCustTimezoneDao.findByTimezone(timezone);
        Date teacTime = TimeZoneUtil.Date2TimezoneDefault(date, timezone);
        if (custTimezone != null) {
            teacTime = TimeZoneUtil.findTimeByCustomerDate(date, custTimezone);
        }
        String beginHour = DateUtils.formatDate((Date)teacTime, (String)"HH:mm");
        String dayAndYearStr = DateUtils.formatDate((Date)teacTime, (String)"yyyy-MM-dd");
        String endHour = DateUtils.formatDate((Date)org.apache.commons.lang.time.DateUtils.addMinutes((Date)teacTime, (int)tCoursesession.getDuration()), (String)"HH:mm");
        String dateStr = beginHour + "-" + endHour + ", " + dayAndYearStr;
        String comments = "";
        String className = course.getClassname();
        TCoursesession coursesession = this.tCoursesessionDao.findLastCompleteSessionByCid(course.getCid());
        if (coursesession != null && (commentss = this.tTeacherCommentsDao.findBySessionid(coursesession.getSessionid())) != null) {
            comments = commentss.getComments();
        }
        if (StringUtils.isBlank((String)remark)) {
            remark = "";
        }
        TalkillaEmailMessageUtils.sendToTeacherInstantClassRequestConfirm(email, teacher, student, dateStr, className, comments, remark);
        TSendEmailRecord tSendEmailRecord = new TSendEmailRecord();
        tSendEmailRecord.setUserType(TalkillaConstant.SendEmailUserType.TEACHER);
        tSendEmailRecord.setEmail(email);
        tSendEmailRecord.setEmailType(TalkillaConstant.SendEmailType.SEND_TO_TEACHER_INSTANT_CLASS_REQUEST_CONFIRM);
        tSendEmailRecord.setRecordType(TalkillaConstant.SendEmailType.SEND_TO_TEACHER_INSTANT_CLASS_REQUEST_CONFIRM);
        tSendEmailRecord.setCid(course.getCid());
        tSendEmailRecord.setStuId(student.getStuId());
        tSendEmailRecord.setTeacherId(teacher.getTeacherId());
        this.tSendEmailRecordDao.insertSelective(tSendEmailRecord);
        return true;
    }

    @Override
    public boolean checkTeacherTime(Integer tid, Date starttime, Integer duration) {
        Date end;
        Date start = new Date(starttime.getTime() - 0x6DDD00L);
        List list = this.tCoursesessionDao.findTeacherCoursesessionByStartAndEndTime(tid, start, end = new Date(starttime.getTime() + 0x6DDD00L));
        if (list != null && list.size() > 0) {
            Long coursessionStart = starttime.getTime();
            Long coursessionEnd = starttime.getTime() + (long)(duration * 60) * 1000L;
            Long tempStart = null;
            Long tempEnd = null;
            for (TCoursesession coursesession : list) {
                long minEnd;
                tempStart = coursesession.getStarttime().getTime();
                tempEnd = coursesession.getStarttime().getTime() + (long)(duration * 60) * 1000L;
                Long sameTimes = 0L;
                long maxStart = Math.max(tempStart, coursessionStart);
                if (maxStart <= (minEnd = Math.min(tempEnd, coursessionEnd))) {
                    sameTimes = minEnd - maxStart;
                }
                if (sameTimes <= 0L) continue;
                return false;
            }
        }
        return true;
    }

    private static Date getByIndex(Date now, int index) {
        return org.apache.commons.lang.time.DateUtils.addDays((Date)now, (int)index);
    }

    private static int compareByTimeRange(TTeacherWorkTime lh, TTeacherWorkTime rh) {
        if (!lh.getDay().equals(rh.getDay())) {
            return lh.getDay() - rh.getDay();
        }
        return lh.getTimeRangeId() - rh.getTimeRangeId();
    }

    private int addSevenDay(int day) {
        Date date = DateUtils.parseDate((String)("" + day), (String)"yyyyMMdd");
        Date dateToAddDays = DateUtils.getDateToAddDays((Date)date, (Integer)7);
        return Integer.valueOf(DateUtils.formatDate((Date)dateToAddDays, (String)"yyyyMMdd"));
    }
}

