/*
 * Decompiled with CFR 0.152.
 */
package com.talkilla.service.impl.teacher;

import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.talkilla.constant.SystemConfig;
import com.talkilla.form.teacher.message.TeaQueryMessageForm;
import com.talkilla.mysql.domain.TMessage;
import com.talkilla.mysql.domain.TTeacher;
import com.talkilla.mysql.domain.TTeacherMessage;
import com.talkilla.mysql.mapper.TMessageDao;
import com.talkilla.mysql.mapper.TTeacherMessageDao;
import com.talkilla.otherbean.MessageDto;
import com.talkilla.result.admin.base.PageObj;
import com.talkilla.service.teacher.TeaMessageService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang.StringUtils;
import org.nestframework.commons.utils.StringUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class TeaMessageServiceImpl
implements TeaMessageService {
    @Autowired
    private TTeacherMessageDao teacherMessageDao;
    @Autowired
    private TMessageDao tMessageDao;

    @Override
    public TMessage getNewestUnReadMessage(TTeacher teacher) {
        TMessage tMessage = this.tMessageDao.getNewestUnReadMessage(teacher.getTeacherId());
        if (Objects.isNull(tMessage)) {
            return null;
        }
        this.saveTeacherMessage(tMessage.getId(), teacher);
        return tMessage;
    }

    @Override
    public PageObj findPageMessage(TeaQueryMessageForm form) {
        Page page;
        HashMap<String, String> querymap = new HashMap<String, String>();
        if (StringUtil.isNotEmpty((String)form.getDate1()) && StringUtil.isNotEmpty((String)form.getDate2())) {
            querymap.put("startDate", form.getDate1() + "-01");
            querymap.put("endDate", form.getDate2() + "-01");
        }
        if (StringUtils.isNotBlank((String)form.getTitle())) {
            querymap.put("title", form.getTitle());
        }
        if (form.getPageNo() != null && form.getPageNo() != 0) {
            querymap.put("pageNo", form.getPageNo() + "");
        } else {
            querymap.put("pageNo", "1");
        }
        if (form.getPageSize() != null && form.getPageSize() != 0) {
            querymap.put("pageSize", form.getPageSize() + "");
        } else {
            querymap.put("pageSize", "20");
        }
        Integer pageNo = Integer.valueOf((String)querymap.get("pageNo"));
        Integer pageSize = Integer.valueOf((String)querymap.get("pageSize"));
        if (pageNo != null && pageNo != 0 && pageSize != null && pageSize != 0) {
            page = PageHelper.startPage((int)pageNo, (int)pageSize);
        } else {
            pageNo = 1;
            pageSize = 20;
            page = PageHelper.startPage((int)pageNo, (int)pageSize);
        }
        List messages = this.tMessageDao.findSendedMessages((String)querymap.get("title"), (String)querymap.get("startDate"), (String)querymap.get("endDate"));
        if (!CollectionUtils.isEmpty((Collection)messages)) {
            ArrayList<Integer> messageIdList = new ArrayList<Integer>();
            for (MessageDto message : messages) {
                messageIdList.add(message.getId());
            }
            ArrayList readedMessageIdList = this.teacherMessageDao.findMessageIdList(form.getTeacherId(), messageIdList);
            if (Objects.isNull(readedMessageIdList)) {
                readedMessageIdList = new ArrayList();
            }
            for (MessageDto message : messages) {
                if (readedMessageIdList.contains(message.getId())) {
                    message.setStatus(Integer.valueOf(1));
                    continue;
                }
                message.setStatus(Integer.valueOf(0));
            }
        }
        PageObj pageObj = new PageObj();
        pageObj.setCurrPageNumber(pageNo);
        pageObj.setFirstPageNumber(Integer.valueOf(1));
        pageObj.setLastPageNumber(pageObj.processTotalPage(page.getTotal(), Integer.valueOf(page.getPageSize())));
        pageObj.setPreviousPageNumber(pageObj.processPreviousPage(pageNo));
        pageObj.setNextPageNumber(pageObj.processNextPage());
        pageObj.setPageElements(page.getResult());
        pageObj.setPageSize(pageSize);
        pageObj.setTotalCount(Long.valueOf(page.getTotal()));
        return pageObj;
    }

    @Override
    public void readedStatusUpdate(Integer messageId, TTeacher teacher) {
        TTeacherMessage teacherMessage = this.teacherMessageDao.getOneByMessageIdAndTeacherId(messageId, teacher.getTeacherId());
        if (Objects.nonNull(teacherMessage)) {
            return;
        }
        this.saveTeacherMessage(messageId, teacher);
    }

    @Override
    public TMessage fetchAndFreshMessageStatus(TTeacher teacher, Integer messageId) {
        TTeacherMessage tTeacherMessage;
        TMessage tMessage = this.tMessageDao.findOne(messageId);
        if (Objects.isNull(tMessage)) {
            return null;
        }
        if (StringUtils.isNotBlank((String)tMessage.getTopicViewUrl())) {
            tMessage.setTopicViewUrl(SystemConfig.TALKILLACOMMUNITY_URL + tMessage.getTopicViewUrl());
        }
        if (Objects.nonNull(tTeacherMessage = this.teacherMessageDao.getOneByMessageIdAndTeacherId(messageId, teacher.getTeacherId()))) {
            return tMessage;
        }
        this.saveTeacherMessage(messageId, teacher);
        return tMessage;
    }

    private void saveTeacherMessage(Integer messageId, TTeacher teacher) {
        TTeacherMessage teacherMessage = new TTeacherMessage();
        teacherMessage.setTeacherId(teacher.getTeacherId());
        teacherMessage.setMessageId(messageId);
        teacherMessage.setStatus(Integer.valueOf(1));
        teacherMessage.setCreater("" + teacher.getLoginId());
        this.teacherMessageDao.insertSelective(teacherMessage);
    }
}

