/*
 * Decompiled with CFR 0.152.
 */
package com.talkilla.service.impl.teacher;

import com.talkilla.constant.SystemConfig;
import com.talkilla.form.teacher.GetAvatarForm;
import com.talkilla.mysql.domain.TStudent;
import com.talkilla.mysql.domain.TTeacher;
import com.talkilla.mysql.mapper.TStudentDao;
import com.talkilla.mysql.mapper.TTeacherDao;
import com.talkilla.service.teacher.TeaCommonService;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="teaCommonService")
public class TeaCommonServiceImpl
implements TeaCommonService {
    @Autowired
    private TStudentDao tStudentDao;
    @Autowired
    private TTeacherDao tTeacherDao;

    @Override
    public void getAvatar(HttpServletRequest request, HttpServletResponse response, GetAvatarForm form) {
        Integer type = form.getType();
        Integer uid = form.getUid();
        String avatar = "";
        if (type == 1) {
            TStudent tStudent = this.tStudentDao.findOne(uid);
            avatar = tStudent.getAvatar();
        } else if (type == 2) {
            TTeacher tTeacher = this.tTeacherDao.findOne(uid);
            avatar = tTeacher.getAvatar();
        }
        response.setContentType("text/html; charset=gb2312");
        response.setHeader("Pragma", "no-cache");
        response.setHeader("Cache-Control", "no-cache");
        response.setDateHeader("Expires", 0L);
        try {
            File file = new File(SystemConfig.PICTURE_PATH + File.separator + avatar);
            if (!file.exists()) {
                String webRealPath = request.getRealPath("/");
                file = new File(webRealPath + "images" + File.separator + "default.jpg");
            }
            long fileLen = file.length();
            int readBytes = 0;
            int totalRead = 0;
            byte[] b = new byte[6500];
            FileInputStream fileIn = new FileInputStream(file);
            response.addHeader("content-length", Long.toString(fileLen));
            while ((long)totalRead < fileLen) {
                readBytes = fileIn.read(b, 0, 6500);
                totalRead += readBytes;
                response.getOutputStream().write(b, 0, readBytes);
            }
            fileIn.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

