/*
 * Decompiled with CFR 0.152.
 */
package com.talkilla.service.impl.student;

import com.talkilla.constant.TalkillaConstant;
import com.talkilla.mysql.domain.TBanner;
import com.talkilla.mysql.domain.TLogin;
import com.talkilla.mysql.domain.TSellCourse;
import com.talkilla.mysql.domain.TSellCourseImg;
import com.talkilla.mysql.domain.TSellCourseOrder;
import com.talkilla.mysql.domain.TSendEmailRecord;
import com.talkilla.mysql.domain.TStudent;
import com.talkilla.mysql.domain.TStudentConsultant;
import com.talkilla.mysql.mapper.TSendEmailRecordDao;
import com.talkilla.mysql.mapper.TStudentDao;
import com.talkilla.otherbean.UserDto;
import com.talkilla.result.student.SellCourseDetailResult;
import com.talkilla.result.student.SellCourseListResult;
import com.talkilla.result.student.SellCourseOrderListResult;
import com.talkilla.service.TBannerService;
import com.talkilla.service.TLoginService;
import com.talkilla.service.TSellCourseImgService;
import com.talkilla.service.TSellCourseOrderService;
import com.talkilla.service.TSellCourseService;
import com.talkilla.service.TStudentConsultantService;
import com.talkilla.service.student.StuSellCourseService;
import com.talkilla.serviceUtils.TalkillaEmailMessageUtils;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service(value="stuSellCourseService")
public class StuSellCourseServiceImpl
implements StuSellCourseService {
    @Autowired
    private TBannerService tBannerService;
    @Autowired
    private TSellCourseService tSellCourseService;
    @Autowired
    private TSellCourseImgService tSellCourseImgService;
    @Autowired
    private TSellCourseOrderService tSellCourseOrderService;
    @Autowired
    private TLoginService tLoginService;
    @Autowired
    private TStudentConsultantService tStudentConsultantService;
    @Autowired
    private TStudentDao tStudentDao;
    @Autowired
    private TSendEmailRecordDao tSendEmailRecordDao;

    @Override
    public SellCourseListResult sellCourseList() {
        List<TSellCourse> tSellCourseList;
        SellCourseListResult sellCourseListResult = new SellCourseListResult();
        ArrayList<SellCourseListResult.Banner> bannerList = new ArrayList<SellCourseListResult.Banner>();
        ArrayList<SellCourseListResult.SellCourse> sellCourseList = new ArrayList<SellCourseListResult.SellCourse>();
        List<TBanner> tBannerList = this.tBannerService.findAllList();
        if (tBannerList != null && tBannerList.size() > 0) {
            for (TBanner tBanner : tBannerList) {
                SellCourseListResult.Banner banner = new SellCourseListResult.Banner(sellCourseListResult);
                banner.setImg(tBanner.getImg());
                banner.setUrl(tBanner.getUrl());
                banner.setName(tBanner.getName());
                bannerList.add(banner);
            }
        }
        if ((tSellCourseList = this.tSellCourseService.findAllList()) != null && tSellCourseList.size() > 0) {
            for (TSellCourse tSellCourse : tSellCourseList) {
                SellCourseListResult.SellCourse sellCourse = new SellCourseListResult.SellCourse(sellCourseListResult);
                BeanUtils.copyProperties((Object)tSellCourse, (Object)sellCourse);
                sellCourseList.add(sellCourse);
            }
        }
        sellCourseListResult.setBannerList(bannerList);
        sellCourseListResult.setSellCourseList(sellCourseList);
        return sellCourseListResult;
    }

    @Override
    public SellCourseDetailResult sellCourseDetail(Integer id) {
        SellCourseDetailResult sellCourseDetailResult = new SellCourseDetailResult();
        ArrayList<String> imgList = new ArrayList<String>();
        TSellCourse tSellCourse = this.tSellCourseService.findOne(id);
        BeanUtils.copyProperties((Object)tSellCourse, (Object)sellCourseDetailResult);
        List<TSellCourseImg> tSellCourseImgList = this.tSellCourseImgService.findListBySellCourseId(id);
        if (tSellCourseImgList != null && tSellCourseImgList.size() > 0) {
            for (TSellCourseImg tSellCourseImg : tSellCourseImgList) {
                imgList.add(tSellCourseImg.getImg());
            }
        }
        sellCourseDetailResult.setImgList(imgList);
        return sellCourseDetailResult;
    }

    @Override
    @Transactional(rollbackFor={Throwable.class}, propagation=Propagation.REQUIRED)
    public Integer createSellCourseOrder(Integer id, UserDto userDto) {
        TSellCourseOrder tSellCourseOrder = new TSellCourseOrder();
        SimpleDateFormat sdf = new SimpleDateFormat("yyMMddHHmm");
        TStudent student = this.tStudentDao.findStudentByLoginId(userDto.getLoginId());
        TSellCourse tSellCourse = this.tSellCourseService.findOne(id);
        tSellCourseOrder.setSellCourseId(tSellCourse.getId());
        tSellCourseOrder.setPrice(tSellCourse.getPrice());
        tSellCourseOrder.setStatus(Integer.valueOf(0));
        tSellCourseOrder.setPayType(Integer.valueOf(0));
        tSellCourseOrder.setName(student.getRealName());
        tSellCourseOrder.setSellCourseName(tSellCourse.getName());
        tSellCourseOrder.setImg(tSellCourse.getImg());
        tSellCourseOrder.setMobile(student.getPhone());
        tSellCourseOrder.setOrderNo(sdf.format(new Date()));
        tSellCourseOrder.setCreater(student.getRealName());
        tSellCourseOrder.setStudentId(student.getStuId());
        tSellCourseOrder.setAlipay(tSellCourse.getAlipay());
        tSellCourseOrder.setUnionpay(tSellCourse.getUnionpay());
        tSellCourseOrder.setWechatpay(tSellCourse.getWechatpay());
        this.tSellCourseOrderService.insertSelective(tSellCourseOrder);
        return tSellCourseOrder.getId();
    }

    @Override
    @Transactional(rollbackFor={Throwable.class}, propagation=Propagation.REQUIRED)
    public String paySuccess(Integer id, Integer payType, UserDto userDto) {
        TSellCourseOrder tSellCourseOrder = this.tSellCourseOrderService.findOne(id);
        tSellCourseOrder.setStatus(Integer.valueOf(1));
        tSellCourseOrder.setPayType(payType);
        this.tSellCourseOrderService.updateByIdSelective(tSellCourseOrder);
        TStudent student = this.tStudentDao.findStudentByLoginId(userDto.getLoginId());
        this.sendStudentByGoOnClassPaysuccess(student, tSellCourseOrder);
        return "\u652f\u4ed8\u6210\u529f";
    }

    @Override
    public SellCourseOrderListResult orderList(Integer status, UserDto student) {
        SellCourseOrderListResult result = new SellCourseOrderListResult();
        List<TSellCourseOrder> courseOrderList = this.tSellCourseOrderService.orderList(status, student.getStuId());
        result.setStatus(status);
        result.setOrderList(courseOrderList);
        return result;
    }

    @Override
    @Transactional(rollbackFor={Throwable.class}, propagation=Propagation.REQUIRED)
    public String renewCourse(Integer id, UserDto user) {
        TStudent student = this.tStudentDao.findOne(user.getStuId());
        TSellCourseOrder newOrder = new TSellCourseOrder();
        TSellCourseOrder oldOrder = this.tSellCourseOrderService.findOne(id);
        BeanUtils.copyProperties((Object)oldOrder, (Object)newOrder);
        SimpleDateFormat sdf = new SimpleDateFormat("yyMMddHHmm");
        newOrder.setId(null);
        newOrder.setStatus(Integer.valueOf(0));
        newOrder.setOrderNo(sdf.format(new Date()));
        newOrder.setCreateTime(new Date());
        newOrder.setCreater(student.getRealName());
        this.tSellCourseOrderService.insertSelective(newOrder);
        this.sendStudentByGoOnClassPaysuccess(student, newOrder);
        return "\u7eed\u8d39\u6210\u529f,\u8bf7\u7f34\u8d39\u7136\u540e\u70b9\u51fb\u652f\u4ed8\u6210\u529f\u540e\u8054\u7cfb\u8bfe\u7a0b\u987e\u95ee\u751f\u6210\u8bfe\u7a0b\uff01";
    }

    private void sendStudentByGoOnClassPaysuccess(final TStudent student, final TSellCourseOrder newOrder) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                SimpleDateFormat sdf = new SimpleDateFormat("yy-MM-dd HH:mm:ss");
                TLogin tLogin = StuSellCourseServiceImpl.this.tLoginService.findOne(student.getLoginId());
                TStudentConsultant tStudentConsultant = StuSellCourseServiceImpl.this.tStudentConsultantService.findByStudentId(student.getStuId());
                TSellCourse tSellCourse = StuSellCourseServiceImpl.this.tSellCourseService.findOne(newOrder.getSellCourseId());
                if (tStudentConsultant != null) {
                    TalkillaEmailMessageUtils.sendStudentByGoOnClassPaysuccess(tLogin.getLoginName(), student, tStudentConsultant, sdf.format(new Date()), newOrder, tSellCourse, tSellCourse.getHour() + tSellCourse.getPresentHour());
                    TSendEmailRecord tSendEmailRecord = new TSendEmailRecord();
                    tSendEmailRecord.setUserType(TalkillaConstant.SendEmailUserType.STUDENT);
                    tSendEmailRecord.setEmail(tLogin.getLoginName());
                    tSendEmailRecord.setEmailType(TalkillaConstant.SendEmailType.SEND_STUDENT_BY_GO_ON_CLASS_PAY_SUCCESS);
                    tSendEmailRecord.setRecordType(TalkillaConstant.SendEmailType.SEND_STUDENT_BY_GO_ON_CLASS_PAY_SUCCESS);
                    tSendEmailRecord.setCid(newOrder.getId());
                    tSendEmailRecord.setStuId(student.getStuId());
                    tSendEmailRecord.setTeacherId(Integer.valueOf(0));
                    StuSellCourseServiceImpl.this.tSendEmailRecordDao.insertSelective(tSendEmailRecord);
                }
            }
        }).start();
    }
}

