/*
 * Decompiled with CFR 0.152.
 */
package com.talkilla.service.impl.student;

import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.talkilla.constant.TalkillaConstant;
import com.talkilla.form.student.CourseListForm;
import com.talkilla.form.student.CoursesessionListForm;
import com.talkilla.form.student.ModifyStatusForm;
import com.talkilla.form.student.SaveCoursesessionListForm;
import com.talkilla.form.student.StudentCourseDetailForm;
import com.talkilla.form.student.StudentCourseDetailSaveForm;
import com.talkilla.mysql.domain.TConsultant;
import com.talkilla.mysql.domain.TCourse;
import com.talkilla.mysql.domain.TCourseSessionStudent;
import com.talkilla.mysql.domain.TCoursesession;
import com.talkilla.mysql.domain.TCustTimezone;
import com.talkilla.mysql.domain.TLogin;
import com.talkilla.mysql.domain.TSendEmailRecord;
import com.talkilla.mysql.domain.TStuFeeback;
import com.talkilla.mysql.domain.TStudent;
import com.talkilla.mysql.domain.TStudentConsultant;
import com.talkilla.mysql.domain.TTeacher;
import com.talkilla.mysql.mapper.TCourseDao;
import com.talkilla.mysql.mapper.TCourseSessionStudentDao;
import com.talkilla.mysql.mapper.TCourseStudentDao;
import com.talkilla.mysql.mapper.TCoursesessionDao;
import com.talkilla.mysql.mapper.TCustTimezoneDao;
import com.talkilla.mysql.mapper.TLoginDao;
import com.talkilla.mysql.mapper.TSendEmailRecordDao;
import com.talkilla.mysql.mapper.TStuFeebackDao;
import com.talkilla.mysql.mapper.TStudentConsultantDao;
import com.talkilla.mysql.mapper.TStudentDao;
import com.talkilla.mysql.mapper.TTeacherDao;
import com.talkilla.otherbean.UserDto;
import com.talkilla.result.CoursesessionInfoResult;
import com.talkilla.result.LeaveCourseResult;
import com.talkilla.result.ReturnMessageResult;
import com.talkilla.result.admin.base.PageObj;
import com.talkilla.result.student.CourseDetailResult;
import com.talkilla.result.student.CourseListResult;
import com.talkilla.result.student.CourseNameAndCidAtPresentResult;
import com.talkilla.result.student.CoursesessionListResult;
import com.talkilla.result.student.LoginIndexResult;
import com.talkilla.result.student.ToModifystustatusResult;
import com.talkilla.service.TCourseService;
import com.talkilla.service.TCoursesessionService;
import com.talkilla.service.student.StuCourseService;
import com.talkilla.serviceUtils.TalkillaEmailMessageUtils;
import com.talkilla.serviceUtils.TimeZoneUtil;
import com.talkilla.utils.DateUtils;
import com.talkilla.utils.MathUtils;
import java.math.BigDecimal;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang.StringUtils;
import org.nestframework.commons.utils.StringUtil;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service(value="stuCourseService")
public class StuCourseServiceImpl
implements StuCourseService {
    @Autowired
    private TCourseService tCourseService;
    @Autowired
    private TCoursesessionService tCoursesessionService;
    @Autowired
    private TTeacherDao tTeacherDao;
    @Autowired
    private TCoursesessionDao tCoursesessionDao;
    @Autowired
    private TLoginDao tLoginDao;
    @Autowired
    private TStudentDao tStudentDao;
    @Autowired
    private TCustTimezoneDao tCustTimezoneDao;
    @Autowired
    private TStudentConsultantDao tStudentConsultantDao;
    @Autowired
    private TCourseDao tCourseDao;
    @Autowired
    private TStuFeebackDao tStuFeebackDao;
    @Autowired
    private TCourseStudentDao tCourseStudentDao;
    @Autowired
    private TCourseSessionStudentDao tCourseSessionStudentDao;
    @Autowired
    private TSendEmailRecordDao tSendEmailRecordDao;

    @Override
    public LoginIndexResult loginIndex(Integer stuid) {
        LoginIndexResult result = new LoginIndexResult();
        ArrayList<LoginIndexResult.Course> courseList = new ArrayList<LoginIndexResult.Course>();
        CourseNameAndCidAtPresentResult courceNameAtPresent = this.tCourseService.findCourceNameAtPresent(stuid);
        if (courceNameAtPresent != null) {
            String cidStr = courceNameAtPresent.getCidStr();
            Integer completedCount = this.tCourseService.findCourcesessionCompleted(cidStr);
            Integer pendingCount = this.tCourseService.findCourcesessionUnCompleted(cidStr);
            Integer noFeedbackCount = this.tCourseService.findCourcessionCompletedNoFeedback(cidStr);
            List<CoursesessionInfoResult> coursesessionList = this.tCoursesessionService.findListBycidStr(cidStr);
            if (coursesessionList != null && coursesessionList.size() > 0) {
                for (CoursesessionInfoResult coursesessionInfo : coursesessionList) {
                    LoginIndexResult.Course course = new LoginIndexResult.Course(result);
                    String title = coursesessionInfo.getClassname();
                    Integer status = coursesessionInfo.getStatus();
                    String statusStr = (String)TalkillaConstant.statusMap.get(status);
                    if (statusStr != null) {
                        title = title + "(" + statusStr + ")";
                    }
                    String color = TalkillaConstant.COURSE_STATUS_COMPLETED.equals(status) ? "gray" : (TalkillaConstant.COURSE_STATUS_LEAVE_TEACHER.equals(status) || TalkillaConstant.COURSE_STATUS_LEAVE_STUDENT.equals(status) || TalkillaConstant.COURSE_STATUS_SPECIAL_CASES.equals(status) ? "blue" : (TalkillaConstant.COURSE_STATUS_ABSENT_TEACHER.equals(status) || TalkillaConstant.COURSE_STATUS_ABSENT_STUDENT.equals(status) ? "red" : (TalkillaConstant.COURSE_STATUS_UMCONFIRMED.equals(status) ? "purple" : "green")));
                    course.setStarTimeStr(DateUtils.formatDateToMinute((Date)coursesessionInfo.getStarttime()));
                    course.setEndTimeStr(DateUtils.formatDateToMinute((Date)DateUtils.addTimeByType((Date)coursesessionInfo.getStarttime(), (int)12, (int)coursesessionInfo.getDuration())));
                    course.setSessionid(coursesessionInfo.getSessionid());
                    course.setTitle(title);
                    course.setColor(color);
                    courseList.add(course);
                }
            }
            result.setClassname(courceNameAtPresent.getCourceNameStr());
            result.setCompleteCount(completedCount);
            result.setPendingCount(pendingCount);
            result.setNoFeedbackCount(noFeedbackCount);
            result.setCalenderList(courseList);
        }
        return result;
    }

    @Override
    public ToModifystustatusResult toModifystustatus(Integer sesessionid, UserDto student) {
        ToModifystustatusResult result = new ToModifystustatusResult();
        TCoursesession coursesession = this.tCoursesessionService.findOne(sesessionid);
        TCourse course = this.tCourseService.findOne(coursesession.getCid());
        TTeacher teacher = this.tTeacherDao.findOne(coursesession.getTeacherId());
        TConsultant consultant = this.tStudentConsultantDao.findConsultantByStudentId(student.getStuId());
        result.setCid(course.getCid());
        result.setClassid(course.getClassid());
        result.setStatus(coursesession.getStatus());
        result.setStatusValue((String)TalkillaConstant.statusMap.get(result.getStatus()));
        result.setStarttime(DateUtils.formatDateToHHmm((Date)coursesession.getStarttime()));
        result.setTeacherId(coursesession.getTeacherId());
        result.setTeacherName(teacher.getFirstName() + teacher.getLastName());
        result.setFirstName(teacher.getFirstName());
        result.setLastName(teacher.getLastName());
        result.setClassType((String)TalkillaConstant.classTypeMap.get(course.getType()));
        result.setSessionid(coursesession.getSessionid());
        result.setConsultant(consultant);
        return result;
    }

    @Override
    @Transactional(rollbackFor={Throwable.class}, propagation=Propagation.REQUIRED)
    public ReturnMessageResult modifyStatus(ModifyStatusForm form) throws ParseException {
        ReturnMessageResult result = new ReturnMessageResult();
        Integer cid = form.getCid();
        TCoursesession coursesession = this.tCoursesessionService.findOne(form.getSessionid());
        TTeacher tTeacher = this.tTeacherDao.findOne(coursesession.getTeacherId());
        TCourse tCourse = this.tCourseDao.findOne(cid);
        if (coursesession.getStatus() != null) {
            result.setFlag(Integer.valueOf(1));
            result.setMessage("\u8bfe\u7a0b\u72b6\u6001\u5df2\u7ecf\u66f4\u6539\u8fc7\u4e86");
            return result;
        }
        if (tCourse.getType().equals(100002)) {
            TConsultant tConsultant = this.tStudentConsultantDao.findConsultantByStudentId(form.getStuId());
            String mobile = "";
            String name = "";
            if (Objects.nonNull(tConsultant)) {
                mobile = tConsultant.getMobile();
                name = tConsultant.getName();
            }
            result.setFlag(Integer.valueOf(1));
            result.setMessage(DateUtils.formatDate((Date)coursesession.getStarttime(), (String)"yyyy-MM-dd HH:mm") + "-" + DateUtils.formatDateToHHmm((Date)new Date(coursesession.getStarttime().getTime() + (long)(coursesession.getDuration() * 60) * 1000L)) + "\u8fd9\u662f\u4e00\u8282\u591a\u4eba\u5c0f\u7ec4\u8bfe\uff0c\u4e2a\u4eba\u4e0d\u80fd\u5355\u72ec\u8bf7\u5047\uff1b\u82e5\u4ecd\u9700\u8bf7\u5047\uff0c\u8bf7\u5411\u4f60\u7684\u6559\u5b66\u987e\u95ee\uff08" + name + " " + mobile + " \uff09\u8054\u7cfb\u3002");
            return result;
        }
        if (!DateUtils.isAfter12Hours((Date)coursesession.getStarttime())) {
            result.setFlag(Integer.valueOf(1));
            result.setMessage("\u8bf7\u5047\u9700\u63d0\u524d12\u5c0f\u65f6");
            return result;
        }
        TCoursesession tCoursesession = new TCoursesession();
        List<LeaveCourseResult> leaveCourseResults = this.tCoursesessionService.leaveCoursePlan(cid, 1);
        if (leaveCourseResults != null && leaveCourseResults.size() > 0) {
            LeaveCourseResult leaveCourseResult = leaveCourseResults.get(0);
            BeanUtils.copyProperties((Object)coursesession, (Object)tCoursesession);
            tCoursesession.setTeacherId(coursesession.getTeacherId());
            tCoursesession.setCreateTime(null);
            tCoursesession.setDuration(Integer.valueOf(leaveCourseResult.getTimeLength()));
            tCoursesession.setSessionid(null);
            tCoursesession.setStatus(null);
            tCoursesession.setStarttime(DateUtils.parseDateToSecond((String)leaveCourseResult.getStartTime()));
            tCoursesession.setIsSystem(Integer.valueOf(1));
            if (tCourse.getType() == 100001) {
                tCoursesession.setRate(new BigDecimal(tTeacher.getOneOnOne()));
            } else {
                tCoursesession.setRate(new BigDecimal(tTeacher.getOneOnMultiple()));
            }
            this.tCoursesessionDao.insertSelective(tCoursesession);
            List addBeforeStudentIdList = this.tCourseStudentDao.findStudentIdListByCid(tCourse.getCid());
            ArrayList<TCourseSessionStudent> tCourseSessionStudentList = new ArrayList<TCourseSessionStudent>();
            for (Integer stuId : addBeforeStudentIdList) {
                TCourseSessionStudent tCourseSessionStudent = new TCourseSessionStudent();
                tCourseSessionStudent.setCourseSessionId(tCoursesession.getSessionid());
                tCourseSessionStudent.setStudentId(stuId);
                tCourseSessionStudent.setCreater(String.valueOf(form.getLoginId()));
                tCourseSessionStudentList.add(tCourseSessionStudent);
            }
            this.tCourseSessionStudentDao.batchInsert(tCourseSessionStudentList);
        }
        coursesession.setStatus(TalkillaConstant.COURSE_STATUS_LEAVE_STUDENT);
        coursesession.setUpdateTime(new Date());
        this.tCoursesessionDao.updateByIdSelective(coursesession);
        String teacherEmail = this.tLoginDao.findByTeacherId(coursesession.getTeacherId());
        TTeacher teacher = this.tTeacherDao.findOne(coursesession.getTeacherId());
        TStudent student = this.tStudentDao.findOne(tCourse.getStuId());
        if (StringUtils.isNotEmpty((String)teacherEmail)) {
            String timezone = teacher.getTimezone();
            TCustTimezone tCustTimezone = this.tCustTimezoneDao.findByTimezone(timezone);
            Date starttime = tCustTimezone != null ? TimeZoneUtil.findTimeByCustomerDate(tCoursesession.getStarttime(), tCustTimezone) : TimeZoneUtil.Date2TimezoneDefault(coursesession.getStarttime(), timezone);
            TalkillaEmailMessageUtils.sendTeacherByStudentLeaveClassEmail(teacherEmail, teacher, student, DateUtils.formatDateToDay((Date)starttime), DateUtils.getHHmmString((Date)starttime, (Integer)tCoursesession.getDuration()), DateUtils.getEnglishWeekNumberOfDate((Date)starttime));
            TSendEmailRecord tSendEmailRecord = new TSendEmailRecord();
            tSendEmailRecord.setUserType(TalkillaConstant.SendEmailUserType.TEACHER);
            tSendEmailRecord.setEmail(teacherEmail);
            tSendEmailRecord.setEmailType(TalkillaConstant.SendEmailType.SEND_TEACHER_BY_STUDENT_LEAVE_CLASS_EMAIL);
            tSendEmailRecord.setRecordType(TalkillaConstant.SendEmailType.SEND_TEACHER_BY_STUDENT_LEAVE_CLASS_EMAIL);
            tSendEmailRecord.setCid(tCourse.getCid());
            tSendEmailRecord.setStuId(tCourse.getStuId());
            tSendEmailRecord.setTeacherId(tCourse.getTeacherId());
            this.tSendEmailRecordDao.insertSelective(tSendEmailRecord);
        }
        TLogin studentTLogin = this.tLoginDao.findOne(student.getLoginId());
        TStudentConsultant tStudentConsultant = this.tStudentConsultantDao.findByStudentId(student.getStuId());
        TalkillaEmailMessageUtils.sendStudentByStudentLeaveClass(studentTLogin.getLoginName(), null, student, teacher, tStudentConsultant, DateUtils.formatDateToDay((Date)coursesession.getStarttime()), DateUtils.getHHmmString((Date)coursesession.getStarttime(), (Integer)coursesession.getDuration()), DateUtils.getChineseWeekNumberOfDate((Date)coursesession.getStarttime()));
        TSendEmailRecord tSendEmailRecord = new TSendEmailRecord();
        tSendEmailRecord.setUserType(TalkillaConstant.SendEmailUserType.STUDENT);
        tSendEmailRecord.setEmail(studentTLogin.getLoginName());
        tSendEmailRecord.setEmailType(TalkillaConstant.SendEmailType.SEND_STUDENT_BY_STUDENT_LEAVE_CLASS);
        tSendEmailRecord.setRecordType(TalkillaConstant.SendEmailType.SEND_STUDENT_BY_STUDENT_LEAVE_CLASS);
        tSendEmailRecord.setCid(tCourse.getCid());
        tSendEmailRecord.setStuId(student.getStuId());
        tSendEmailRecord.setTeacherId(tCourse.getTeacherId());
        this.tSendEmailRecordDao.insertSelective(tSendEmailRecord);
        result.setFlag(Integer.valueOf(0));
        result.setMessage("\u60a8\u5df2\u7ecf\u8bf7\u5047\u6210\u529f\u3002\u8bfe\u7a0b\u5c06\u987a\u5ef6\u3002\u5982\u9700\u8c03\u6574\uff0c\u8bf7\u4e0e\u8bed\u6cc9\u5728\u7ebf\u82f1\u8bed\u7684\u7ba1\u7406\u5458\u8054\u7cfb\u3002");
        return result;
    }

    @Override
    public PageObj courseList(UserDto student, CourseListForm form) {
        form.setStuId(student.getStuId());
        Integer pageNo = form.getPageNo();
        Integer pageSize = form.getPageSize();
        if (pageNo == null || pageNo <= 0) {
            pageNo = 1;
        }
        if (pageSize == null || pageSize <= 0) {
            pageSize = 10;
        }
        Page page = PageHelper.startPage((int)pageNo, (int)pageSize);
        this.tCourseDao.courseList(form);
        List results = page.getResult();
        ArrayList<CourseListResult> list = new ArrayList<CourseListResult>();
        for (CourseListResult res : results) {
            res.setHourawarded(MathUtils.getCoursesTimes((Double)res.getHourawarded(), (Integer)res.getDuration()));
            res.setHourcomplete(MathUtils.getCoursesTimes((Double)res.getHourcomplete(), (Integer)res.getDuration()));
            res.setHourpending(MathUtils.getCoursesTimes((Double)res.getHourpending(), (Integer)res.getDuration()));
            res.setHourpurchase(MathUtils.getCoursesTimes((Double)res.getHourpurchase(), (Integer)res.getDuration()));
            list.add(res);
        }
        PageObj pageObj = new PageObj();
        pageObj.setCurrPageNumber(pageNo);
        pageObj.setFirstPageNumber(Integer.valueOf(1));
        pageObj.setLastPageNumber(pageObj.processTotalPage(page.getTotal(), Integer.valueOf(page.getPageSize())));
        pageObj.setPreviousPageNumber(pageObj.processPreviousPage(pageNo));
        pageObj.setNextPageNumber(pageObj.processNextPage());
        pageObj.setPageElements(list);
        pageObj.setPageSize(pageSize);
        pageObj.setTotalCount(Long.valueOf(page.getTotal()));
        return pageObj;
    }

    @Override
    public List<CoursesessionListResult> coursesessionList(CoursesessionListForm form) {
        List results = this.tCoursesessionDao.coursesessionList(form);
        if (results != null && results.size() > 0) {
            for (CoursesessionListResult result : results) {
                result.setStarttimeStr(DateUtils.formatDateToMinute((Date)result.getStarttime()));
                result.setTeachername(result.getFirstName() + " " + result.getLastName());
                result.setStatusStr((String)TalkillaConstant.statusMap.get(result.getStatus()));
            }
        }
        return results;
    }

    @Override
    @Transactional(rollbackFor={Throwable.class}, propagation=Propagation.REQUIRED)
    public void saveCoursesessionList(SaveCoursesessionListForm form, TStudent student) {
        String[] feebacks = form.getFeebacks();
        Integer[] sessionids = form.getSessionids();
        if (feebacks == null || sessionids == null || feebacks.length < 1 || sessionids.length < 1) {
            return;
        }
        for (int i = 0; i < feebacks.length; ++i) {
            Integer sessionid = sessionids[i];
            String feeback = feebacks[i];
            TStuFeeback tStuFeeback = this.tStuFeebackDao.findBySessionidAndStuId(sessionid, student.getStuId());
            if (tStuFeeback != null) {
                tStuFeeback.setFeeback(feeback);
                this.tStuFeebackDao.updateByIdSelective(tStuFeeback);
                continue;
            }
            TCoursesession coursesession = this.tCoursesessionDao.findOne(sessionid);
            TStuFeeback stuFeeback = new TStuFeeback();
            stuFeeback.setFeeback(feeback);
            stuFeeback.setStuId(student.getStuId());
            stuFeeback.setTeacherId(coursesession.getTeacherId());
            stuFeeback.setSessionid(sessionid);
            this.tStuFeebackDao.insert(stuFeeback);
        }
    }

    @Override
    public List<CourseDetailResult> getCourseDetail(UserDto student, StudentCourseDetailForm form) {
        return this.tCourseDao.getStudentCourseDetailById(student.getStuId(), form.getCid());
    }

    @Override
    @Transactional(rollbackFor={Throwable.class}, propagation=Propagation.REQUIRED)
    public void saveFeeBack(StudentCourseDetailSaveForm form, UserDto student) {
        ArrayList<Object[]> par = new ArrayList<Object[]>();
        String[] feeback = form.getFeeback();
        Integer[] sid = form.getSid();
        for (int i = 0; i < feeback.length; ++i) {
            String f = feeback[i];
            if (!StringUtil.isNotEmpty((String)f)) continue;
            Object[] o = new Object[]{f, sid[i]};
            par.add(o);
        }
        List feedbacks = this.tStuFeebackDao.findByStuIdAndCid(student.getStuId(), form.getCid());
        for (TStuFeeback feb : feedbacks) {
            this.tStuFeebackDao.deleteById(feb.getFeebackid());
        }
        for (int i = 0; i < par.size(); ++i) {
            TStuFeeback stuFeeback = new TStuFeeback();
            stuFeeback.setCreater("system");
            stuFeeback.setStuId(student.getStuId());
            stuFeeback.setFeeback(((Object[])par.get(i))[0].toString());
            stuFeeback.setSessionid(Integer.valueOf(((Object[])par.get(i))[1].toString()));
            TCoursesession one = this.tCoursesessionDao.findOne(Integer.valueOf(((Object[])par.get(i))[1].toString()));
            stuFeeback.setTeacherId(one.getTeacherId());
            stuFeeback.setIsDelete(Integer.valueOf(0));
            this.tStuFeebackDao.insert(stuFeeback);
        }
    }
}

