/*
 * Decompiled with CFR 0.152.
 */
package com.talkilla.service.impl.job;

import com.talkilla.constant.SystemConfig;
import com.talkilla.constant.TalkillaConstant;
import com.talkilla.mysql.domain.TCourse;
import com.talkilla.mysql.domain.TCourseSessionStudent;
import com.talkilla.mysql.domain.TCoursesession;
import com.talkilla.mysql.domain.TCustTimezone;
import com.talkilla.mysql.domain.TSendEmailRecord;
import com.talkilla.mysql.domain.TStudent;
import com.talkilla.mysql.domain.TTeacher;
import com.talkilla.mysql.domain.TWechat;
import com.talkilla.mysql.mapper.TCourseDao;
import com.talkilla.mysql.mapper.TCourseSessionStudentDao;
import com.talkilla.mysql.mapper.TCourseStudentDao;
import com.talkilla.mysql.mapper.TCoursesessionDao;
import com.talkilla.mysql.mapper.TCustTimezoneDao;
import com.talkilla.mysql.mapper.TLoginDao;
import com.talkilla.mysql.mapper.TSendEmailRecordDao;
import com.talkilla.mysql.mapper.TSendWechatRecordDAO;
import com.talkilla.mysql.mapper.TStudentConsultantDao;
import com.talkilla.mysql.mapper.TStudentDao;
import com.talkilla.mysql.mapper.TTeacherDao;
import com.talkilla.mysql.mapper.TWechatDao;
import com.talkilla.otherbean.TeacherUnconfirmEamilDto;
import com.talkilla.service.job.JobService;
import com.talkilla.service.teacher.TeaCourseService;
import com.talkilla.serviceUtils.TalkillaEmailMessageUtils;
import com.talkilla.serviceUtils.TimeZoneUtil;
import com.talkilla.utils.DateUtils;
import com.talkilla.wechat.form.WechatTemplateMessageForm;
import com.talkilla.wechat.service.WechatMessageService;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="jobService")
public class JobServiceImpl
implements JobService {
    Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    WechatMessageService wechatMessageService;
    @Autowired
    TeaCourseService teaCourseService;
    @Autowired
    TCoursesessionDao tCoursesessionDao;
    @Autowired
    TCourseSessionStudentDao tCourseSessionStudentDao;
    @Autowired
    TCourseDao tCourseDao;
    @Autowired
    TTeacherDao tTeacherDao;
    @Autowired
    TStudentDao tStudentDao;
    @Autowired
    TWechatDao tWechatDao;
    @Autowired
    TLoginDao tLoginDao;
    @Autowired
    TCustTimezoneDao tCustTimezoneDao;
    @Autowired
    TStudentConsultantDao tStudentConsultantDao;
    @Autowired
    TCourseStudentDao tCourseStudentDao;
    @Autowired
    TSendEmailRecordDao tSendEmailRecordDao;
    @Autowired
    TSendWechatRecordDAO tSendWechatRecordDAO;

    @Override
    public void sendStudentClassNoticeMessage() {
        this.logger.info("\u53d1\u9001\u5b66\u751f\u8bfe\u7a0b\u63d0\u9192\u5f00\u59cb");
        List sessionList = this.tCoursesessionDao.geTodaySession();
        this.logger.info("\u67e5\u8be2\u51fa\u6765\u7684\u8bfe\u7a0blist" + sessionList.size());
        Integer temp = 0;
        try {
            for (TCoursesession session : sessionList) {
                String classRoomNotify;
                if (session.getStatus() != null && !temp.equals(session.getStatus())) {
                    this.logger.info("\u4e00\u4e2a\u8bfe\u7a0b\u63d0\u9192\u88ab\u5ffd\u7565" + session.getSessionid());
                    continue;
                }
                long time = session.getStarttime().getTime() - System.currentTimeMillis();
                if (time <= 0L) continue;
                Calendar ca = Calendar.getInstance();
                ca.setTime(session.getStarttime());
                SimpleDateFormat sdf1 = new SimpleDateFormat("yyyy\u5e74MM\u6708dd\u65e5HH:mm");
                SimpleDateFormat sdf2 = new SimpleDateFormat("HH:mm");
                ca.add(12, session.getDuration());
                TCourse course = this.tCourseDao.findOne(session.getCid());
                TTeacher teacher = this.tTeacherDao.findOne(session.getTeacherId());
                List students = this.tCourseSessionStudentDao.findListBySessionId(session.getSessionid());
                if (course.getType() == 100002) {
                    classRoomNotify = "\u5efa\u8bae\u4f60\u597d\u597d\u5229\u7528\u8bfe\u524d\u8fd9\u6bb5\u65f6\u95f4\u505a\u597d\u9884\u4e60\uff0c\u5728\u6307\u5b9a\u65f6\u95f4\u51c6\u65f6\u8fdb\u5165\u6559\u5ba4\"" + course.getClassRoom() + "\"\u3002\u5bf9\u6b64\u82e5\u6709\u7591\u95ee\uff0c\u8bf7\u4e0e\u4f60\u7684\u4eac\u8bed\u6cc9\u8bfe\u7a0b\u987e\u95ee\u8054\u7cfb\u3002";
                } else {
                    String classRoom = teacher.getZoomId();
                    if (StringUtils.isBlank((String)classRoom)) {
                        classRoom = course.getClassRoom();
                    }
                    classRoomNotify = "\u5efa\u8bae\u4f60\u597d\u597d\u5229\u7528\u8bfe\u524d\u8fd9\u6bb5\u65f6\u95f4\u505a\u597d\u9884\u4e60\uff0c\u5728\u6307\u5b9a\u65f6\u95f4\u51c6\u65f6\u8fdb\u5165\u6559\u5ba4\"" + classRoom + "\"\u3002\u5bf9\u6b64\u82e5\u6709\u7591\u95ee\uff0c\u8bf7\u4e0e\u4f60\u7684\u4eac\u8bed\u6cc9\u8bfe\u7a0b\u987e\u95ee\u8054\u7cfb\u3002";
                }
                if (students != null && students.size() > 0) {
                    for (TCourseSessionStudent courseStudent : students) {
                        TStudent student = this.tStudentDao.findOne(courseStudent.getStudentId());
                        WechatTemplateMessageForm messageFrom = new WechatTemplateMessageForm();
                        messageFrom.setTemplateId(SystemConfig.Wechat.WECHAT_MESSAGE_TEMPLATE_ID);
                        messageFrom.setAppId(SystemConfig.Wechat.WECHAT_APP_ID);
                        messageFrom.setRedirectUrl(SystemConfig.Wechat.WECHAT_URL);
                        String remark = student.getRealName() + "\u540c\u5b66:\u4f60\u4e0e" + teacher.getFirstName() + " " + teacher.getLastName().substring(0, 1).toUpperCase() + ". \u5728" + sdf1.format(session.getStarttime()) + "~" + sdf2.format(ca.getTime()) + "\u6709\u4e00\u8282\u3010" + course.getClassname() + "\u3011\u8bfe\u7a0b\u3002" + classRoomNotify;
                        TWechat tWechat = this.tWechatDao.getTWechatInfoByLoginId(student.getLoginId());
                        if (tWechat == null || StringUtils.isBlank((String)tWechat.getOpenid())) {
                            this.logger.info("\u4e00\u4e2a\u8bfe\u7a0b\u63d0\u9192\u88ab\u5ffd\u7565openid\u4e3a\u7a7a \u5fae\u4fe1\u4fe1\u606f\u4e3a\u7a7a" + session.getSessionid());
                            continue;
                        }
                        this.logger.info("stuId\u4e3a: {},\u5b66\u751f\u7684openId\u4e3a: {}", (Object)student.getStuId(), (Object)tWechat.getOpenid());
                        try {
                            HashMap<String, String> param = new HashMap<String, String>();
                            param.put("keyword1", course.getClassname());
                            param.put("keyword2", sdf1.format(session.getStarttime()));
                            messageFrom.setParam(param);
                        }
                        catch (Exception e) {
                            this.logger.error("\u53d1\u9001\u5fae\u4fe1\u6d88\u606f\u8f6c\u6362\u9519\u8bef", (Throwable)e);
                        }
                        if (time / 1000L <= 3600L && time / 1000L > 2700L) {
                            messageFrom.setRemark(remark);
                            messageFrom.setReceiver(tWechat.getOpenid());
                            if (StringUtils.isNotBlank((String)tWechat.getOpenid())) {
                                this.wechatMessageService.sendTaskTemplateMessage(messageFrom);
                            } else {
                                this.logger.info("\u4e00\u4e2a\u8bfe\u7a0b\u63d0\u9192\u88ab\u5ffd\u7565openid\u4e3a\u7a7a" + session.getSessionid());
                            }
                        } else {
                            this.logger.info("\u4e00\u4e2a\u8bfe\u7a0b\u63d0\u524d1\u5c0f\u65f6\u63d0\u9192\u88ab\u5ffd\u7565" + session.getSessionid());
                        }
                        if (time / 1000L <= 900L) {
                            remark = student.getRealName() + "\u540c\u5b66:\u4f60\u4e0e" + teacher.getFirstName() + " " + teacher.getLastName().substring(0, 1).toUpperCase() + ". \u5728" + sdf1.format(session.getStarttime()) + "~" + sdf2.format(ca.getTime()) + "\u6709\u4e00\u8282\u3010" + course.getClassname() + "\u3011\u8bfe\u7a0b\u3002\u73b0\u5728\u79bb\u4e0a\u8bfe\u65f6\u95f4\u4e0d\u523015\u5206\u949f\uff0c\u8bf7\u4f60\u597d\u597d\u5229\u7528\u8fd9\u6bb5\u65f6\u95f4\u505a\u597d\u8bfe\u524d\u9884\u4e60\u5427\uff0c" + classRoomNotify;
                            messageFrom.setRemark(remark);
                            messageFrom.setReceiver(tWechat.getOpenid());
                            if (StringUtils.isNotBlank((String)tWechat.getOpenid())) {
                                this.wechatMessageService.sendTaskTemplateMessage(messageFrom);
                                continue;
                            }
                            this.logger.info("\u4e00\u4e2a\u8bfe\u7a0b\u63d0\u9192\u88ab\u5ffd\u7565openid\u4e3a\u7a7a" + session.getSessionid());
                            continue;
                        }
                        this.logger.info("\u4e00\u4e2a\u8bfe\u7a0b\u63d0\u524d15\u5206\u949f\u63d0\u9192\u88ab\u5ffd\u7565" + session.getSessionid());
                    }
                    continue;
                }
                this.logger.info("\u4e00\u4e2a\u8bfe\u7a0b\u63d0\u9192\u88ab\u5ffd\u7565" + session.getSessionid());
            }
        }
        catch (Exception e) {
            this.logger.error("\u5904\u7406\u53d1\u9001\u8bfe\u7a0b\u63d0\u9192\u9519\u8bef", (Throwable)e);
        }
        this.logger.info(sessionList.size() + "\u53d1\u9001\u5b66\u751f\u8bfe\u7a0b\u63d0\u9192\u7ed3\u675f!!!!!" + new Date());
    }

    @Override
    public void sendStudentLeaveClassNoticeMessage() {
        this.logger.info("\u53d1\u9001\u5b66\u751f\u8bf7\u5047\u8bfe\u7a0b\u63d0\u9192\u5f00\u59cb");
        List sessionList = this.tCoursesessionDao.geTodayStudentLeaveSession();
        Integer temp = 0;
        for (TCoursesession session : sessionList) {
            long time = session.getStarttime().getTime() - System.currentTimeMillis();
            if (time <= 0L) continue;
            Calendar ca = Calendar.getInstance();
            ca.setTime(session.getStarttime());
            SimpleDateFormat sdf1 = new SimpleDateFormat("yyyy\u5e74MM\u6708dd\u65e5HH:mm");
            SimpleDateFormat sdf2 = new SimpleDateFormat("HH:mm");
            ca.add(12, session.getDuration());
            TCourse course = this.tCourseDao.findOne(session.getCid());
            TTeacher teacher = this.tTeacherDao.findOne(session.getTeacherId());
            TStudent student = null;
            List courseSessionStudents = this.tCourseSessionStudentDao.findListBySessionId(session.getSessionid());
            if (courseSessionStudents == null || courseSessionStudents.size() <= 0) continue;
            for (TCourseSessionStudent courseSessionStudent : courseSessionStudents) {
                student = this.tStudentDao.findOne(courseSessionStudent.getStudentId());
                WechatTemplateMessageForm messageFrom = new WechatTemplateMessageForm();
                HashMap<String, String> param = new HashMap<String, String>();
                messageFrom.setTemplateId(SystemConfig.Wechat.WECHAT_MESSAGE_TEMPLATE_ID5);
                messageFrom.setAppId(SystemConfig.Wechat.WECHAT_APP_ID);
                messageFrom.setRedirectUrl(SystemConfig.Wechat.WECHAT_URL);
                String remark = student.getRealName() + "\u540c\u5b66:\u4f60\u4e0e" + teacher.getFirstName() + " " + teacher.getLastName().substring(0, 1).toUpperCase() + ". \u539f\u5b9a\u4e8e" + sdf1.format(session.getStarttime()) + "~" + sdf2.format(ca.getTime()) + "\u7684" + course.getClassname() + "\u8bfe\u7a0b\u56e0\u201c\u5b66\u5458\u8bf7\u5047\u201d\u5df2\u88ab\u53d6\u6d88\u3002\u4f60\u53ef\u4ee5\u5229\u7528\u8fd9\u4e2a\u65f6\u95f4\u56de\u770b\u4e0a\u4e00\u8282\u8bfe\u7684\u5f55\u50cf\u6216\u5e72\u8106\u653e\u677e\u4e00\u4e0b\u81ea\u5df1\u3002\n\u82e5\u5bf9\u6b64\u6709\u7591\u95ee\u8bf7\u8054\u7cfb\u60a8\u7684\u8bfe\u7a0b\u987e\u95ee\uff0c\u6216\u8fdb\u5165\u8bfe\u7a0b\u4e2d\u5fc3\u67e5\u770b\u8bfe\u7a0b\u8868\u8be6\u60c5\u3002";
                TWechat tWechat = this.tWechatDao.getTWechatInfoByLoginId(student.getLoginId());
                this.logger.info("stuId\u4e3a: {},\u5b66\u751f\u7684openId\u4e3a: {}", (Object)student.getStuId(), (Object)tWechat.getOpenid());
                if (tWechat == null || StringUtils.isEmpty((String)tWechat.getOpenid())) continue;
                if (time / 1000L <= 3600L && time / 1000L > 2700L) {
                    try {
                        param = new HashMap();
                        param.put("keyword1", course.getClassname());
                        param.put("keyword2", sdf1.format(session.getStarttime()));
                        param.put("keyword3", teacher.getFirstName() + " " + teacher.getLastName());
                        param.put("keyword4", student.getRealName());
                        messageFrom.setParam(param);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    messageFrom.setRemark(remark);
                    messageFrom.setReceiver(tWechat.getOpenid());
                    if (StringUtils.isNotBlank((String)tWechat.getOpenid())) {
                        this.wechatMessageService.sendTaskTemplateMessage(messageFrom);
                    }
                }
                if (time / 1000L > 900L) continue;
                try {
                    param = new HashMap();
                    param.put("keyword1", course.getClassname());
                    param.put("keyword2", sdf1.format(session.getStarttime()));
                    param.put("keyword3", teacher.getFirstName() + " " + teacher.getLastName());
                    param.put("keyword4", student.getRealName());
                    messageFrom.setParam(param);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                messageFrom.setRemark(remark);
                messageFrom.setReceiver(tWechat.getOpenid());
                if (!StringUtils.isNotBlank((String)tWechat.getOpenid())) continue;
                this.wechatMessageService.sendTaskTemplateMessage(messageFrom);
            }
        }
        this.logger.info(sessionList.size() + "\u53d1\u9001\u5b66\u751f\u8bf7\u5047\u8bfe\u7a0b\u63d0\u9192\u7ed3\u675f!!!!!" + new Date());
    }

    @Override
    public void sendTeacherLeaveClassNoticeMessage() {
        this.logger.info("\u53d1\u9001\u7ed9\u5b66\u751f\u8001\u5e08\u8bf7\u5047\u8bfe\u7a0b\u63d0\u9192\u5f00\u59cb");
        List sessionList = this.tCoursesessionDao.geTodayTeacherLeaveSession();
        for (TCoursesession session : sessionList) {
            long time = session.getStarttime().getTime() - System.currentTimeMillis();
            if (time <= 0L) continue;
            Calendar ca = Calendar.getInstance();
            ca.setTime(session.getStarttime());
            SimpleDateFormat sdf1 = new SimpleDateFormat("yyyy\u5e74MM\u6708dd\u65e5HH:mm");
            SimpleDateFormat sdf2 = new SimpleDateFormat("HH:mm");
            ca.add(12, session.getDuration());
            TCourse course = this.tCourseDao.findOne(session.getCid());
            TTeacher teacher = this.tTeacherDao.findOne(session.getTeacherId());
            TStudent student = null;
            List courseSessionStudents = this.tCourseSessionStudentDao.findListBySessionId(session.getSessionid());
            if (courseSessionStudents == null || courseSessionStudents.size() <= 0) continue;
            for (TCourseSessionStudent courseSessionStudent : courseSessionStudents) {
                student = this.tStudentDao.findOne(courseSessionStudent.getStudentId());
                WechatTemplateMessageForm messageFrom = new WechatTemplateMessageForm();
                HashMap<String, String> param = new HashMap<String, String>();
                messageFrom.setTemplateId(SystemConfig.Wechat.WECHAT_MESSAGE_TEMPLATE_ID5);
                messageFrom.setAppId(SystemConfig.Wechat.WECHAT_APP_ID);
                messageFrom.setRedirectUrl(SystemConfig.Wechat.WECHAT_URL);
                String remark = student.getRealName() + "\u540c\u5b66:\u4f60\u4e0e" + teacher.getFirstName() + " " + teacher.getLastName().substring(0, 1).toUpperCase() + ". \u539f\u5b9a\u4e8e" + sdf1.format(session.getStarttime()) + "~" + sdf2.format(ca.getTime()) + "\u7684" + course.getClassname() + "\u8bfe\u7a0b\u56e0\u201c\u5916\u6559\u8bf7\u5047\u201d\u5df2\u88ab\u53d6\u6d88\u3002\u4f60\u53ef\u4ee5\u5229\u7528\u8fd9\u4e2a\u65f6\u95f4\u56de\u770b\u4e0a\u4e00\u8282\u8bfe\u7684\u5f55\u50cf\u6216\u5e72\u8106\u653e\u677e\u4e00\u4e0b\u81ea\u5df1\u3002\n\u82e5\u5bf9\u6b64\u6709\u7591\u95ee\u8bf7\u8054\u7cfb\u60a8\u7684\u8bfe\u7a0b\u987e\u95ee\uff0c\u6216\u8fdb\u5165\u8bfe\u7a0b\u4e2d\u5fc3\u67e5\u770b\u8bfe\u7a0b\u8868\u8be6\u60c5\u3002";
                TWechat tWechat = this.tWechatDao.getTWechatInfoByLoginId(student.getLoginId());
                this.logger.info("stuId\u4e3a: {},\u5b66\u751f\u7684openId\u4e3a: {}", (Object)student.getStuId(), (Object)tWechat.getOpenid());
                if (tWechat == null || StringUtils.isEmpty((String)tWechat.getOpenid())) continue;
                if (time / 1000L <= 3600L && time / 1000L > 2700L) {
                    try {
                        param = new HashMap();
                        param.put("keyword1", course.getClassname());
                        param.put("keyword2", sdf1.format(session.getStarttime()));
                        param.put("keyword3", teacher.getFirstName() + " " + teacher.getLastName());
                        param.put("keyword4", student.getRealName());
                        messageFrom.setParam(param);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    messageFrom.setRemark(remark);
                    messageFrom.setReceiver(tWechat.getOpenid());
                    if (StringUtils.isNotBlank((String)tWechat.getOpenid())) {
                        this.wechatMessageService.sendTaskTemplateMessage(messageFrom);
                    }
                }
                if (time / 1000L > 900L) continue;
                try {
                    param = new HashMap();
                    param.put("keyword1", course.getClassname());
                    param.put("keyword2", sdf1.format(session.getStarttime()));
                    param.put("keyword3", teacher.getFirstName() + " " + teacher.getLastName());
                    param.put("keyword4", student.getRealName());
                    messageFrom.setParam(param);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                messageFrom.setRemark(remark);
                messageFrom.setReceiver(tWechat.getOpenid());
                if (!StringUtils.isNotBlank((String)tWechat.getOpenid())) continue;
                this.wechatMessageService.sendTaskTemplateMessage(messageFrom);
            }
        }
        this.logger.info(sessionList.size() + "\u53d1\u9001\u7ed9\u5b66\u751f\u8001\u5e08\u8bf7\u5047\u8bfe\u7a0b\u63d0\u9192\u7ed3\u675f!!!!!" + new Date());
    }

    @Override
    public void sendTeacherReportOneTypeEmail() {
        List cids = this.tCoursesessionDao.selectNowClassId();
        for (Integer cid : cids) {
            if (!this.teaCourseService.canSendTeacherReportOneTypeEmail(cid)) continue;
            TCourse course = this.tCourseDao.findOne(cid);
            TStudent student = this.tStudentDao.findOne(course.getStuId());
            TTeacher teacher = this.tTeacherDao.findOne(course.getTeacherId());
            String email = this.tLoginDao.findByTeacherId(teacher.getTeacherId());
            TalkillaEmailMessageUtils.sendTeacherClassReportOneType(email, teacher, student);
            TSendEmailRecord tSendEmailRecord = new TSendEmailRecord();
            tSendEmailRecord.setUserType(TalkillaConstant.SendEmailUserType.TEACHER);
            tSendEmailRecord.setEmail(email);
            tSendEmailRecord.setEmailType(TalkillaConstant.SendEmailType.SEND_TO_TEACHER_REPORT_ONE_TYPE);
            tSendEmailRecord.setRecordType(TalkillaConstant.SendEmailType.SEND_TO_TEACHER_REPORT_ONE_TYPE);
            tSendEmailRecord.setCid(cid);
            tSendEmailRecord.setStuId(student.getStuId());
            tSendEmailRecord.setTeacherId(teacher.getTeacherId());
            this.tSendEmailRecordDao.insertSelective(tSendEmailRecord);
        }
    }

    @Override
    public void sendTeacherReportTwoTypeEmail() {
        List cids = this.tCoursesessionDao.selectNowClassId();
        for (Integer cid : cids) {
            if (!this.teaCourseService.canSendTeacherReportTwoTypeEmail(cid)) continue;
            TCourse course = this.tCourseDao.findOne(cid);
            TStudent student = this.tStudentDao.findOne(course.getStuId());
            TTeacher teacher = this.tTeacherDao.findOne(course.getTeacherId());
            String email = this.tLoginDao.findByTeacherId(teacher.getTeacherId());
            TalkillaEmailMessageUtils.sendTeacherClassReportTwoType(email, teacher, student);
            TSendEmailRecord tSendEmailRecord = new TSendEmailRecord();
            tSendEmailRecord.setUserType(TalkillaConstant.SendEmailUserType.TEACHER);
            tSendEmailRecord.setEmail(email);
            tSendEmailRecord.setEmailType(TalkillaConstant.SendEmailType.SEND_TO_TEACHER_REPORT_TWO_TYPE);
            tSendEmailRecord.setRecordType(TalkillaConstant.SendEmailType.SEND_TO_TEACHER_REPORT_TWO_TYPE);
            tSendEmailRecord.setCid(cid);
            tSendEmailRecord.setStuId(student.getStuId());
            tSendEmailRecord.setTeacherId(teacher.getTeacherId());
            this.tSendEmailRecordDao.insertSelective(tSendEmailRecord);
        }
    }

    @Override
    public void sendStudentRecordWechatMessage() {
        List cids = this.tCoursesessionDao.selectNowClassId();
        for (Integer cid : cids) {
            Long countRecord;
            Long finishMinutes = this.tCoursesessionDao.countFinishByCid(cid);
            if (finishMinutes < 300L || (countRecord = this.tSendWechatRecordDAO.countRecord(cid, TalkillaConstant.SendWechatType.SEND_STUDENT_RECORED_TYPE)) > 0L) continue;
            List students = this.tCourseStudentDao.findStudentIdListByCid(cid);
            for (Integer stuId : students) {
                TStudent student = this.tStudentDao.findOne(stuId);
                WechatTemplateMessageForm messageFrom = new WechatTemplateMessageForm();
                HashMap<String, String> param = new HashMap<String, String>();
                messageFrom.setTemplateId(SystemConfig.Wechat.WECHAT_MESSAGE_TEMPLATE_ID7);
                messageFrom.setAppId(SystemConfig.Wechat.WECHAT_APP_ID);
                messageFrom.setRedirectUrl(SystemConfig.Wechat.WECHAT_URL);
                String remark = "\u56de\u770b\u4e0a\u8bfe\u5f55\u50cf\u662f\u4fdd\u8bc1\u5916\u6559\u4e0a\u8bfe\u8d28\u91cf\u7684\u91cd\u8981\u65b9\u5f0f\u4e4b\u4e00\uff0c\u8bf7\u4f60\u5728\u4e0b\u6b21\u4e0a\u8bfe\u65f6\u8bb0\u5f97\u5f55\u50cf\uff0c\u5e76\u5728\u8bfe\u540e\u5c06\u4e0a\u8bfe\u5f55\u50cf\u89c6\u9891\u6587\u4ef6\u901a\u8fc7QQ\u90ae\u7bb1\u53d1\u9001\u81f3talkilla@qq.com, \u6216\u8005\u4e0a\u4f20\u81f3\u767e\u5ea6\u76d8\uff0c\u5e76\u901a\u8fc7\u5fae\u4fe1\u5206\u4eab\u89c6\u9891\u8fde\u63a5\u7ed9\u6768\u8001\u5e08\uff0c\u5e76\u53d1\u5fae\u4fe1\u63d0\u9192\u3002\u5982\u679c\u60a8\u4e0d\u6e05\u695a\u5982\u4f55\u64cd\u4f5c\uff0c\u4e5f\u8bf7\u4e0e\u8bfe\u7a0b\u987e\u95ee\u6768\u8001\u5e08\u8054\u7cfb\u3002";
                TWechat tWechat = this.tWechatDao.getTWechatInfoByLoginId(student.getLoginId());
                TCourse course = this.tCourseDao.findOne(cid);
                TTeacher teacher = this.tTeacherDao.findOne(course.getTeacherId());
                this.logger.info("stuId\u4e3a: {},\u5b66\u751f\u7684openId\u4e3a: {}", (Object)student.getStuId(), (Object)tWechat.getOpenid());
                if (tWechat == null || StringUtils.isEmpty((String)tWechat.getOpenid())) continue;
                try {
                    param = new HashMap();
                    param.put("keyword1", "Talkilla\u5728\u7ebf\u82f1\u8bed\u5b66\u4e60");
                    param.put("keyword2", "\u7559\u610f\u5177\u4f53\u7684\u4e0a\u8bfe\u65f6\u95f4");
                    param.put("keyword3", teacher.getFirstName() + " " + teacher.getLastName());
                    messageFrom.setParam(param);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                messageFrom.setRemark(remark);
                messageFrom.setReceiver(tWechat.getOpenid());
                if (!StringUtils.isNotBlank((String)tWechat.getOpenid())) continue;
                this.wechatMessageService.sendTaskTemplateMessage(messageFrom);
            }
        }
    }

    @Override
    public void updateCoursesessionToUncomfired() {
        long seconds = (long)DateUtils.getNowSeconds().intValue() - 1800L;
        List coursession = this.tCoursesessionDao.findAfterHalfHourNotCompleteCoursesession(new Date(seconds * 1000L));
        for (TCoursesession coursesession : coursession) {
            coursesession.setStatus(TalkillaConstant.COURSE_STATUS_UMCONFIRMED);
            coursesession.setUpdateTime(new Date());
            this.tCoursesessionDao.updateByIdSelective(coursesession);
        }
    }

    @Override
    public void sendTeacherUncomfiredEmail() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("startTime", DateUtils.formatDateToSecond((Date)DateUtils.getOneMonthBeforeTime()));
        map.put("endTime", DateUtils.formatDateToSecond((Date)DateUtils.get48HourBeforeTime()));
        List tids = this.tCoursesessionDao.findNeedSendUnconfirmedEmailTeacherId(map);
        for (Integer tid : tids) {
            TTeacher teacher = this.tTeacherDao.findOne(tid);
            String email = this.tLoginDao.findByTeacherId(tid);
            List dtos = this.tCoursesessionDao.findNeedSendUnconfirmedEmailDetail(DateUtils.getOneMonthBeforeTime(), DateUtils.get48HourBeforeTime(), tid);
            ArrayList<TeacherUnconfirmEamilDto> newDtos = new ArrayList<TeacherUnconfirmEamilDto>();
            for (TeacherUnconfirmEamilDto dto : dtos) {
                String timezone = teacher.getTimezone();
                TCustTimezone tCustTimezone = this.tCustTimezoneDao.findByTimezone(timezone);
                Date starttime = tCustTimezone != null ? TimeZoneUtil.findTimeByCustomerDate(dto.getStarttime(), tCustTimezone) : TimeZoneUtil.Date2TimezoneDefault(dto.getStarttime(), timezone);
                dto.setStarttime(starttime);
                newDtos.add(dto);
            }
            TalkillaEmailMessageUtils.sendTeacherByUnconfirmedCourse(email, newDtos, teacher);
            TSendEmailRecord tSendEmailRecord = new TSendEmailRecord();
            tSendEmailRecord.setUserType(TalkillaConstant.SendEmailUserType.TEACHER);
            tSendEmailRecord.setEmail(email);
            tSendEmailRecord.setEmailType(TalkillaConstant.SendEmailType.SEND_TEACHER_BY_UNCONFIRMED_COURSE);
            tSendEmailRecord.setRecordType(TalkillaConstant.SendEmailType.SEND_TEACHER_BY_UNCONFIRMED_COURSE);
            tSendEmailRecord.setCid(Integer.valueOf(0));
            tSendEmailRecord.setStuId(Integer.valueOf(0));
            tSendEmailRecord.setTeacherId(teacher.getTeacherId());
            this.tSendEmailRecordDao.insertSelective(tSendEmailRecord);
        }
    }

    @Override
    public void sendRenewMessage() {
        TTeacher teacher;
        TCourse course;
        List needPayTwoCoursessionsCourses = this.tCoursesessionDao.findNeedPayTwoCoursessionsCourse();
        for (Integer twoCid : needPayTwoCoursessionsCourses) {
            List sends;
            course = this.tCourseDao.findOne(twoCid);
            Integer type = course.getType();
            if (type != 100001) continue;
            teacher = this.tTeacherDao.findOne(course.getTeacherId());
            if (course.getIsRenew() != 0 || !CollectionUtils.isEmpty((Collection)(sends = this.tSendEmailRecordDao.findListByStuIdAndRecordType(course.getStuId(), TalkillaConstant.SendEmailType.RENEW_COURSE_BYTWO_EMAIL, course.getCid())))) continue;
            this.sendRenewMessage(course, 2, teacher);
            TSendEmailRecord tSendEmailRecord = new TSendEmailRecord();
            tSendEmailRecord.setUserType(TalkillaConstant.SendEmailUserType.STUDENT);
            tSendEmailRecord.setEmail("\u5b9a\u65f6\u63a8\u9001");
            tSendEmailRecord.setEmailType(TalkillaConstant.SendEmailType.RENEW_COURSE_BYTWO_EMAIL);
            tSendEmailRecord.setRecordType(TalkillaConstant.SendEmailType.RENEW_COURSE_BYTWO_EMAIL);
            tSendEmailRecord.setCid(course.getCid());
            tSendEmailRecord.setStuId(course.getStuId());
            tSendEmailRecord.setTeacherId(course.getTeacherId());
            this.tSendEmailRecordDao.insertSelective(tSendEmailRecord);
        }
        List needPayOneCoursessionsCourses = this.tCoursesessionDao.findNeedPayOneCoursessionsCourse();
        for (Integer oneCid : needPayOneCoursessionsCourses) {
            List sends;
            course = this.tCourseDao.findOne(oneCid);
            Integer type = course.getType();
            if (type != 100001) continue;
            teacher = this.tTeacherDao.findOne(course.getTeacherId());
            if (course.getIsRenew() != 0 || !CollectionUtils.isEmpty((Collection)(sends = this.tSendEmailRecordDao.findListByStuIdAndRecordType(course.getStuId(), TalkillaConstant.SendEmailType.RENEW_COURSE_BYONE_EMAIL, course.getCid())))) continue;
            this.sendRenewMessage(course, 1, teacher);
            TSendEmailRecord tSendEmailRecord = new TSendEmailRecord();
            tSendEmailRecord.setUserType(TalkillaConstant.SendEmailUserType.STUDENT);
            tSendEmailRecord.setEmail("\u5b9a\u65f6\u63a8\u9001");
            tSendEmailRecord.setEmailType(TalkillaConstant.SendEmailType.RENEW_COURSE_BYONE_EMAIL);
            tSendEmailRecord.setRecordType(TalkillaConstant.SendEmailType.RENEW_COURSE_BYONE_EMAIL);
            tSendEmailRecord.setCid(course.getCid());
            tSendEmailRecord.setStuId(course.getStuId());
            tSendEmailRecord.setTeacherId(course.getTeacherId());
            this.tSendEmailRecordDao.insertSelective(tSendEmailRecord);
        }
    }

    private void sendRenewMessage(TCourse tCourse, Integer pendingCount, TTeacher wTTeacher) {
        TStudent tStudent = this.tStudentDao.findOne(tCourse.getStuId());
        TWechat tWechat = this.tWechatDao.getTWechatInfoByLoginId(tStudent.getLoginId());
        this.wechatMessageService.sendStudentByGoOnClass(tStudent, tWechat, wTTeacher, tCourse.getClassname(), pendingCount);
    }
}

