/*
 * Decompiled with CFR 0.152.
 */
package com.talkilla.service.impl.admin;

import com.talkilla.exception.BusinessException;
import com.talkilla.otherbean.AssignedCell;
import com.talkilla.otherbean.AssignedSheet;
import com.talkilla.otherbean.ExportExcelParameter;
import com.talkilla.service.admin.ExportSupportService;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.imageio.ImageIO;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFClientAnchor;
import org.apache.poi.hssf.usermodel.HSSFPatriarch;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.ClientAnchor;
import org.apache.poi.ss.util.CellRangeAddress;
import org.nestframework.commons.utils.StringUtil;
import org.springframework.core.io.Resource;
import org.springframework.stereotype.Service;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

@Service(value="exportSupportService")
public class ExportSupportServiceImpl
implements ExportSupportService {
    @Override
    public void export(ExportExcelParameter para, OutputStream os, HttpSession session) throws BusinessException {
        String templateFilePath = null;
        FileInputStream fis = null;
        try {
            templateFilePath = this.getAbsolutePath(session.getServletContext(), para.getTemplateName());
            fis = new FileInputStream(new File(templateFilePath));
            HSSFWorkbook wb = new HSSFWorkbook((InputStream)fis);
            ArrayList<String> sheetNames = new ArrayList<String>();
            HashMap mergedSheets = new HashMap();
            for (AssignedSheet aSheet : para.getSheets()) {
                List<String> list;
                HSSFSheet sheet = wb.cloneSheet(wb.getSheetIndex(aSheet.getTemplateSheetName()));
                if (!aSheet.getTemplateSheetName().equals(aSheet.getSheetName())) {
                    wb.setSheetName(wb.getNumberOfSheets() - 1, aSheet.getSheetName());
                }
                sheetNames.add(wb.getSheetName(wb.getNumberOfSheets() - 1));
                int rowNumber = aSheet.getDataRow().getRow();
                HSSFRow datarow = sheet.getRow(rowNumber);
                HSSFRow hlDataRow = null;
                int hldatacol = 0;
                if (aSheet.getHighLightRow() != null) {
                    hlDataRow = sheet.getRow(aSheet.getHighLightRow().getRow());
                    hldatacol = aSheet.getHighLightRow().getCol();
                } else {
                    hlDataRow = datarow;
                }
                if (hlDataRow == null) {
                    hlDataRow = sheet.getRow(rowNumber);
                }
                List data = aSheet.getData();
                this.outputData(wb, sheet, datarow, hlDataRow, aSheet.getDataRow(), data, aSheet.getAssignedCells(), aSheet.isNeedCopyTemplateRow(), aSheet.isAutoHeight(), aSheet.getDataRowSpan(), aSheet.getTotalCol(), hldatacol);
                if (StringUtil.isEmpty((String)aSheet.getAppendToSheet()) || !mergedSheets.containsKey(aSheet.getAppendToSheet())) {
                    list = new ArrayList<String>();
                    list.add(wb.getSheetName(wb.getNumberOfSheets() - 1));
                    mergedSheets.put(aSheet.getSheetName(), list);
                    continue;
                }
                if (!mergedSheets.containsKey(aSheet.getAppendToSheet())) continue;
                list = (List)mergedSheets.get(aSheet.getAppendToSheet());
                list.add(wb.getSheetName(wb.getNumberOfSheets() - 1));
            }
            for (String sn : mergedSheets.keySet()) {
                List slist = (List)mergedSheets.get(sn);
                HSSFSheet targetSheet = wb.getSheet((String)slist.get(0));
                for (int i = 1; i < slist.size(); ++i) {
                    HSSFSheet sourceSheet = wb.getSheet((String)slist.get(i));
                    this.copySheet(sourceSheet, targetSheet);
                    wb.removeSheetAt(wb.getSheetIndex((String)slist.get(i)));
                }
            }
            int i = 0;
            while (i < wb.getNumberOfSheets()) {
                String sheetName = wb.getSheetName(i);
                if (sheetNames.contains(sheetName)) {
                    ++i;
                    continue;
                }
                wb.removeSheetAt(i);
            }
            wb.write(os);
        }
        catch (Exception e) {
            throw new BusinessException((Object)"CODE_99999", "\u6570\u636e\u5bfc\u51fa\u5931\u8d25");
        }
    }

    @Override
    public void export(ExportExcelParameter para, OutputStream os, HttpSession session, List<AssignedCell[]> data) throws BusinessException {
        String templateFilePath = null;
        FileInputStream fis = null;
        try {
            templateFilePath = this.getAbsolutePath(session.getServletContext(), para.getTemplateName());
            fis = new FileInputStream(new File(templateFilePath));
            HSSFWorkbook wb = new HSSFWorkbook((InputStream)fis);
            HSSFSheet sheet = wb.getSheetAt(0);
            HSSFRow datarow = sheet.getRow(para.getDataRow().getRow());
            HSSFRow hldatarow = null;
            int hldatacol = 0;
            if (para.getHighLightRow() != null) {
                hldatarow = sheet.getRow(para.getHighLightRow().getRow());
                hldatacol = para.getHighLightRow().getCol();
            } else {
                hldatarow = datarow;
            }
            this.outputData(wb, sheet, datarow, hldatarow, para.getDataRow(), data, para.getAssignedCells(), para.isNeedCopyTemplateRow(), para.isAutoHeight(), para.getDataRowSpan(), para.getTotalCol(), hldatacol);
            wb.write(os);
        }
        catch (Exception e) {
            throw new BusinessException((Object)"CODE_99999", "\u6570\u636e\u5bfc\u51fa\u5931\u8d25");
        }
    }

    private void outputData(HSSFWorkbook wb, HSSFSheet sheet, HSSFRow datarow, HSSFRow hldatarow, AssignedCell dataRow, List<AssignedCell[]> data, List<AssignedCell> assignedCells, boolean isNeedCopyTemplateRow, boolean autoHeight, int dataRowSpan, int totalCol, int hldatacol) {
        HSSFPatriarch patriarch = sheet.createDrawingPatriarch();
        int rowNumber = 0;
        int rowNum = 0;
        rowNumber = datarow != null ? datarow.getRowNum() : dataRow.getRow();
        rowNum = rowNumber;
        HSSFRow currRow = null;
        for (AssignedCell[] rowData : data) {
            if (isNeedCopyTemplateRow) {
                this.copyRows(sheet, rowNum, rowNum + dataRowSpan - 1, rowNumber, totalCol);
            } else {
                for (int i = 0; i < dataRowSpan; ++i) {
                    currRow = sheet.createRow(rowNumber + i);
                    if (datarow != null && !autoHeight) {
                        currRow.setHeight(datarow.getHeight());
                    }
                    for (int j = 0; j < totalCol; ++j) {
                        HSSFCell cell = currRow.createCell(j);
                        if (datarow == null) continue;
                        cell.setCellStyle(datarow.getCell(j).getCellStyle());
                    }
                }
            }
            for (int k = 0; k < rowData.length; ++k) {
                HSSFCell cell;
                HSSFRow row;
                AssignedCell acell = rowData[k];
                if (acell == null) continue;
                if (acell.getUseStyle() == 9) {
                    HSSFClientAnchor anchor = new HSSFClientAnchor(0, 0, 0, 0, (short)acell.getCol(), rowNumber + acell.getRow(), (short)(acell.getColEnd() + 1), rowNumber + acell.getRowEnd() + 1);
                    anchor.setAnchorType(ClientAnchor.AnchorType.MOVE_AND_RESIZE);
                    if (!StringUtil.isNotEmpty((String)((String)acell.getValue()))) continue;
                    if (((String)acell.getValue()).startsWith("http")) {
                        try {
                            patriarch.createPicture(anchor, ExportSupportServiceImpl.loadPicture(new URL((String)acell.getValue()), wb));
                        }
                        catch (MalformedURLException malformedURLException) {}
                        continue;
                    }
                    patriarch.createPicture(anchor, ExportSupportServiceImpl.loadPicture((String)acell.getValue(), wb));
                    continue;
                }
                if (acell.getRow() != acell.getRowEnd() || acell.getCol() != acell.getColEnd()) {
                    sheet.addMergedRegion(new CellRangeAddress(rowNumber + acell.getRow(), rowNumber + acell.getRowEnd(), acell.getCol(), acell.getColEnd()));
                }
                if ((row = sheet.getRow(rowNumber + acell.getRow())) == null) {
                    row = sheet.createRow(rowNumber + acell.getRow());
                }
                if ((cell = row.getCell(acell.getCol())) == null) {
                    cell = row.createCell(acell.getCol());
                }
                int cType = 1;
                Object value = acell.getValue();
                if (value == null) {
                    cell.setCellValue("");
                } else if (value instanceof Integer || value instanceof Double) {
                    cType = 0;
                    try {
                        cell.setCellValue(new BigDecimal(value.toString()).doubleValue());
                    }
                    catch (Exception e) {
                        cell.setCellType(1);
                        cell.setCellValue(value.toString());
                    }
                } else {
                    cType = 1;
                    cell.setCellType(cType);
                    cell.setCellValue(value.toString());
                }
                if (acell.getUseStyle() == 0) {
                    if (datarow != null) {
                        cell.setCellStyle(datarow.getCell(acell.getCol()).getCellStyle());
                    }
                } else if (acell.getUseStyle() == 1) {
                    cell.setCellStyle(hldatarow.getCell(hldatacol).getCellStyle());
                } else if (acell.getUseStyle() == 2) {
                    cell.setCellStyle(hldatarow.getCell(acell.getCol()).getCellStyle());
                }
                if (!autoHeight) continue;
                HSSFCellStyle style = cell.getCellStyle();
                style.setWrapText(true);
                cell.setCellStyle((CellStyle)style);
            }
            rowNumber += dataRowSpan;
        }
        if (assignedCells != null && assignedCells.size() > 0) {
            for (AssignedCell cell : assignedCells) {
                HSSFCell assignCell;
                if (cell.getValue() == null) continue;
                if (cell.getRow() > sheet.getLastRowNum()) {
                    currRow = sheet.createRow(cell.getRow());
                    for (int j = 0; j < totalCol; ++j) {
                        currRow.createCell(j);
                    }
                }
                if (sheet.getRow(cell.getRow()) == null) {
                    sheet.createRow(cell.getRow());
                }
                if ((assignCell = sheet.getRow(cell.getRow()).getCell(cell.getCol())) == null) {
                    assignCell = sheet.getRow(cell.getRow()).createCell(cell.getCol());
                }
                assignCell.setCellValue(cell.getValue().toString());
            }
        }
    }

    private static int loadPicture(URL filePath, HSSFWorkbook wb) {
        int result = 0;
        try {
            ByteArrayOutputStream byteArrayOut = new ByteArrayOutputStream();
            BufferedImage bufferImg = ImageIO.read(filePath);
            ImageIO.write((RenderedImage)bufferImg, "jpg", byteArrayOut);
            result = wb.addPicture(byteArrayOut.toByteArray(), 5);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    private static int loadPicture(String filePath, HSSFWorkbook wb) {
        int result = 0;
        try {
            ByteArrayOutputStream byteArrayOut = new ByteArrayOutputStream();
            File url = new File(filePath);
            BufferedImage bufferImg = ImageIO.read(url);
            ImageIO.write((RenderedImage)bufferImg, "jpg", byteArrayOut);
            result = wb.addPicture(byteArrayOut.toByteArray(), 5);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    protected void copyRows(HSSFSheet sheet, int pStartRow, int pEndRow, int pPosition, int colTotal) {
        int i;
        HSSFRow sourceRow = null;
        HSSFRow targetRow = null;
        HSSFCell sourceCell = null;
        HSSFCell targetCell = null;
        CellRangeAddress region = null;
        if (pStartRow == -1 || pEndRow == -1) {
            return;
        }
        if (pStartRow == pPosition) {
            return;
        }
        int numregions = sheet.getNumMergedRegions();
        for (i = 0; i < numregions; ++i) {
            region = sheet.getMergedRegion(i);
            CellRangeAddress region2 = null;
            if (region.getFirstRow() < pStartRow || region.getLastRow() > pEndRow) continue;
            int targetRowFrom = region.getFirstRow() - pStartRow + pPosition;
            int targetRowTo = region.getLastRow() - pStartRow + pPosition;
            region2 = new CellRangeAddress(targetRowFrom, targetRowTo, region.getFirstColumn(), region.getLastColumn());
            sheet.addMergedRegion(region2);
        }
        for (i = pStartRow; i <= pEndRow; ++i) {
            sourceRow = sheet.getRow(i);
            if (sourceRow == null) continue;
            targetRow = sheet.createRow(i - pStartRow + pPosition);
            targetRow.setHeight(sourceRow.getHeight());
            block9: for (int j = sourceRow.getFirstCellNum(); j < colTotal; ++j) {
                sourceCell = sourceRow.getCell(j);
                if (sourceCell == null) continue;
                targetCell = targetRow.createCell(j);
                targetCell.setCellStyle(sourceCell.getCellStyle());
                int cType = sourceCell.getCellType();
                switch (cType) {
                    case 4: {
                        targetCell.setCellValue(sourceCell.getBooleanCellValue());
                        continue block9;
                    }
                    case 5: {
                        targetCell.setCellErrorValue(sourceCell.getErrorCellValue());
                        continue block9;
                    }
                    case 2: {
                        targetCell.setCellFormula(sourceCell.getCellFormula());
                        continue block9;
                    }
                    case 0: {
                        targetCell.setCellValue(sourceCell.getNumericCellValue());
                        continue block9;
                    }
                    case 1: {
                        targetCell.setCellValue(sourceCell.getStringCellValue());
                    }
                }
            }
        }
    }

    protected void copySheet(HSSFSheet sourceSheet, HSSFSheet targetSheet) {
        int i;
        HSSFRow sourceRow = null;
        HSSFRow targetRow = null;
        HSSFCell sourceCell = null;
        HSSFCell targetCell = null;
        CellRangeAddress region = null;
        int pStartRow = 0;
        int pEndRow = sourceSheet.getLastRowNum();
        int pPosition = targetSheet.getLastRowNum() + 3;
        for (i = 0; i < sourceSheet.getNumMergedRegions(); ++i) {
            region = sourceSheet.getMergedRegion(i);
            CellRangeAddress region2 = null;
            if (region.getFirstRow() < pStartRow || region.getLastRow() > pEndRow) continue;
            int targetRowFrom = region.getFirstRow() - pStartRow + pPosition;
            int targetRowTo = region.getLastRow() - pStartRow + pPosition;
            region2 = new CellRangeAddress(targetRowFrom, targetRowTo, region.getFirstColumn(), region.getLastColumn());
            targetSheet.addMergedRegion(region2);
        }
        for (i = 0; i <= pEndRow; ++i) {
            sourceRow = sourceSheet.getRow(i);
            if (sourceRow == null) continue;
            targetRow = targetSheet.createRow(i - pStartRow + pPosition);
            targetRow.setHeight(sourceRow.getHeight());
            block9: for (int j = sourceRow.getFirstCellNum(); j < sourceRow.getPhysicalNumberOfCells(); ++j) {
                sourceCell = sourceRow.getCell(j);
                if (sourceCell == null) continue;
                targetCell = targetRow.createCell(j);
                targetCell.setCellStyle(sourceCell.getCellStyle());
                int cType = sourceCell.getCellType();
                targetCell.setCellType(cType);
                switch (cType) {
                    case 4: {
                        targetCell.setCellValue(sourceCell.getBooleanCellValue());
                        continue block9;
                    }
                    case 5: {
                        targetCell.setCellErrorValue(sourceCell.getErrorCellValue());
                        continue block9;
                    }
                    case 2: {
                        targetCell.setCellFormula(sourceCell.getCellFormula());
                        continue block9;
                    }
                    case 0: {
                        targetCell.setCellValue(sourceCell.getNumericCellValue());
                        continue block9;
                    }
                    case 1: {
                        targetCell.setCellValue(sourceCell.getStringCellValue());
                    }
                }
            }
        }
    }

    private String getAbsolutePath(ServletContext sc, String fileRelativePath) throws IOException {
        String ret = "";
        WebApplicationContext ctx = WebApplicationContextUtils.getWebApplicationContext((ServletContext)sc);
        Resource resource = ctx.getResource(fileRelativePath);
        ret = resource.getFile().getAbsolutePath();
        return ret;
    }
}

