/*
 * Decompiled with CFR 0.152.
 */
package com.talkilla.service.impl.admin;

import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.talkilla.constant.TalkillaConstant;
import com.talkilla.constant.enums.CalculatePriceTypeEnums;
import com.talkilla.event.common.CommonEvent;
import com.talkilla.form.admin.AdminStudentCoursesessionAddSaveForm;
import com.talkilla.form.admin.AdminStudentCoursesessionInfoEditForm;
import com.talkilla.form.admin.AdminStudentSummaryEditForm;
import com.talkilla.form.admin.AdminStudentSummaryListForm;
import com.talkilla.form.admin.StudentAwardForm;
import com.talkilla.form.wechat.TAwardCourseRecordForm;
import com.talkilla.local.CourseCommonService;
import com.talkilla.mysql.domain.TAwardCourse;
import com.talkilla.mysql.domain.TAwardCourseRecord;
import com.talkilla.mysql.domain.TConsultant;
import com.talkilla.mysql.domain.TCourse;
import com.talkilla.mysql.domain.TCourseSessionStudent;
import com.talkilla.mysql.domain.TCoursesession;
import com.talkilla.mysql.domain.TDistributionUser;
import com.talkilla.mysql.domain.TLogin;
import com.talkilla.mysql.domain.TStudent;
import com.talkilla.mysql.domain.TStudentConsultant;
import com.talkilla.mysql.domain.TStudentSummary;
import com.talkilla.mysql.domain.TTeacher;
import com.talkilla.mysql.domain.TWechat;
import com.talkilla.mysql.mapper.TAwardCourseDao;
import com.talkilla.mysql.mapper.TAwardCourseRecordDao;
import com.talkilla.mysql.mapper.TConsultantDao;
import com.talkilla.mysql.mapper.TCourseDao;
import com.talkilla.mysql.mapper.TCourseSessionStudentDao;
import com.talkilla.mysql.mapper.TCourseStudentDao;
import com.talkilla.mysql.mapper.TCoursesessionDao;
import com.talkilla.mysql.mapper.TDTimezoneDao;
import com.talkilla.mysql.mapper.TDistributionUserDao;
import com.talkilla.mysql.mapper.TLoginDao;
import com.talkilla.mysql.mapper.TNationDao;
import com.talkilla.mysql.mapper.TStudentConsultantDao;
import com.talkilla.mysql.mapper.TStudentDao;
import com.talkilla.mysql.mapper.TStudentSummaryDao;
import com.talkilla.mysql.mapper.TTeacherDao;
import com.talkilla.mysql.mapper.TWechatDao;
import com.talkilla.otherbean.StudentCourseDto;
import com.talkilla.otherbean.StudentDto;
import com.talkilla.otherbean.UserDto;
import com.talkilla.result.ReturnMessageResult;
import com.talkilla.result.StudentLastCourseResult;
import com.talkilla.result.admin.AdminFindCourseResult;
import com.talkilla.result.admin.AdminStudentCoursesessionInfoResult;
import com.talkilla.result.admin.StudentEditInfoResult;
import com.talkilla.result.admin.StudentRecommendDetailResult;
import com.talkilla.result.admin.base.PageObj;
import com.talkilla.result.teacher.StudentDetailResult;
import com.talkilla.service.TAwardCourseService;
import com.talkilla.service.TCourseService;
import com.talkilla.service.TStudentService;
import com.talkilla.service.TWechatService;
import com.talkilla.service.UploadPhotoService;
import com.talkilla.service.admin.AdminStudentService;
import com.talkilla.service.form.AdminStudentEditSaveForm;
import com.talkilla.service.form.QueryStudentListForm;
import com.talkilla.service.form.StudentCourseListQueryForm;
import com.talkilla.serviceUtils.TimeZoneUtil;
import com.talkilla.utils.DateUtils;
import com.talkilla.utils.MathUtils;
import com.talkilla.utils.NoServiceUtil;
import com.talkilla.wechat.form.WeChatTimeRewardNoticeForm;
import com.talkilla.wechat.service.WechatMessageService;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.nestframework.commons.utils.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;

@Service(value="adminStudentService")
public class AdminStudentServiceImpl
implements AdminStudentService {
    Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    TStudentDao tStudentDao;
    @Autowired
    TTeacherDao tTeacherDao;
    @Autowired
    TWechatDao tWechatDao;
    @Autowired
    TDistributionUserDao tDistributionUserDao;
    @Autowired
    TLoginDao tLoginDao;
    @Autowired
    TCourseDao tCourseDao;
    @Autowired
    TNationDao tNationDao;
    @Autowired
    TDTimezoneDao tDTimezoneDao;
    @Autowired
    TConsultantDao tConsultantDao;
    @Autowired
    TStudentConsultantDao tStudentConsultantDao;
    @Autowired
    UploadPhotoService uploadPhotoService;
    @Autowired
    TCoursesessionDao tCoursesessionDao;
    @Autowired
    TStudentSummaryDao tStudentSummaryDao;
    @Autowired
    TAwardCourseRecordDao tAwardCourseRecordDao;
    @Autowired
    TAwardCourseService tAwardCourseService;
    @Autowired
    TCourseService tCourseService;
    @Autowired
    TAwardCourseDao tAwardCourseDao;
    @Autowired
    private TStudentService tStudentService;
    @Autowired
    private TWechatService tWechatService;
    @Autowired
    private WechatMessageService wechatMessageService;
    @Autowired
    private CommonEvent commonEvent;
    @Autowired
    private TCourseStudentDao tCourseStudentDao;
    @Autowired
    private TCourseSessionStudentDao tCourseSessionStudentDao;
    @Autowired
    private CourseCommonService courseCommonService;

    @Override
    public PageObj findnewQuerys(Map<String, String> querymap, Integer pageSize, Integer pageNo) {
        Page page;
        if (pageNo != null && pageNo != 0 && pageSize != null && pageSize != 1) {
            page = PageHelper.startPage((int)pageNo, (int)pageSize);
        } else {
            pageNo = 1;
            pageSize = 20;
            page = PageHelper.startPage((int)pageNo, (int)pageSize);
        }
        this.tStudentDao.findNewQuerysStudent(querymap.get("startDate"), querymap.get("endDate"));
        PageObj pageObj = new PageObj();
        pageObj.setCurrPageNumber(pageNo);
        pageObj.setFirstPageNumber(Integer.valueOf(1));
        pageObj.setLastPageNumber(pageObj.processTotalPage(page.getTotal(), Integer.valueOf(page.getPageSize())));
        pageObj.setPreviousPageNumber(pageObj.processPreviousPage(pageNo));
        pageObj.setNextPageNumber(pageObj.processNextPage());
        pageObj.setPageElements(page.getResult());
        pageObj.setPageSize(pageSize);
        pageObj.setTotalCount(Long.valueOf(page.getTotal()));
        return pageObj;
    }

    @Override
    public StudentDetailResult getStudentDetailById(Integer id) {
        StudentDetailResult result = new StudentDetailResult();
        TStudent student = this.tStudentDao.findOne(id);
        TLogin Login = this.tLoginDao.findOne(student.getLoginId());
        result.setStuId(student.getStuId());
        result.setAge(Integer.valueOf(TimeZoneUtil.getAge(student.getBirthday())));
        result.setLoginName(Login.getLoginName());
        result.setEnglishName(student.getEnglishName());
        result.setRealname(student.getRealName());
        result.setWxh(student.getWeixinhao());
        result.setSelf(student.getIntroduce());
        result.setStucity(student.getCity());
        result.setParentname(student.getParentName());
        result.setStuskypeid(student.getSkypeid());
        result.setStugender(student.getGender());
        result.setPhone(student.getPhone());
        result.setBirthday(student.getBirthday());
        StudentLastCourseResult resultById = this.tCourseDao.getStudentLastCourseResultById(id);
        if (resultById != null) {
            result.setClassname(resultById.getClassname());
            result.setJiaocai(resultById.getTrainingmaterials());
            result.setTeacherName(resultById.getFirstName() + " " + resultById.getLastName());
        }
        return result;
    }

    @Override
    public StudentEditInfoResult getStudentEditInfo(Integer stuid) {
        TStudentConsultant consultant;
        StudentEditInfoResult result = new StudentEditInfoResult();
        List nations = this.tNationDao.findAllNationDto();
        result.setNations(nations);
        List names = this.tDTimezoneDao.findNames();
        result.setZones(names);
        TStudent student = this.tStudentDao.findOne(stuid);
        result.setStudent(student);
        result.setBirthday(student.getBirthday());
        result.setCreate_time(student.getCreateTime());
        List all = this.tConsultantDao.findAll();
        result.setConsultantList(all);
        TLogin tLogin = this.tLoginDao.findOne(student.getLoginId());
        if (null != tLogin) {
            result.setLoginName(tLogin.getLoginName());
        }
        if ((consultant = this.tStudentConsultantDao.findByStudentId(stuid)) != null) {
            result.setConsultantName(consultant.getConsultantName());
            result.setConsultantId(consultant.getConsultantId());
            result.setConsultantEmail(consultant.getConsultantEmail());
        } else {
            result.setConsultantName("admin");
            result.setConsultantId(Integer.valueOf(1));
            result.setConsultantEmail("talkilla@talkilla.org");
        }
        return result;
    }

    @Override
    public PageObj findQueryStudentList(QueryStudentListForm form) {
        Page page;
        HashMap<String, String> querymap = new HashMap<String, String>();
        if (StringUtil.isNotEmpty((String)form.getDate1()) && StringUtil.isNotEmpty((String)form.getDate2())) {
            querymap.put("startDate", form.getDate1() + "-01");
            querymap.put("endDate", form.getDate2() + "-01");
        }
        if (StringUtils.isNotBlank((String)form.geteName())) {
            querymap.put("eName", form.geteName());
        }
        if (StringUtils.isNotBlank((String)form.getName())) {
            querymap.put("name", form.getName());
        }
        if (StringUtils.isNotBlank((String)form.getPhone())) {
            querymap.put("phone", form.getPhone());
        }
        if (form.getTag() != null && form.getTag() >= 0) {
            querymap.put("tag", form.getTag() + "");
        }
        if (form.getPageNo() != null && form.getPageNo() != 0) {
            querymap.put("pageNo", form.getPageNo() + "");
        } else {
            querymap.put("pageNo", "1");
        }
        if (form.getPageSize() != null && form.getPageSize() != 0) {
            querymap.put("pageSize", form.getPageSize() + "");
        } else {
            querymap.put("pageSize", "20");
        }
        Integer pageNo = Integer.valueOf((String)querymap.get("pageNo"));
        Integer pageSize = Integer.valueOf((String)querymap.get("pageSize"));
        if (pageNo != null && pageNo != 0 && pageSize != null && pageSize != 0) {
            page = PageHelper.startPage((int)pageNo, (int)pageSize);
        } else {
            pageNo = 1;
            pageSize = 20;
            page = PageHelper.startPage((int)pageNo, (int)pageSize);
        }
        this.tStudentDao.findQueryStudentList((String)querymap.get("name"), (String)querymap.get("phone"), (String)querymap.get("stugender"), (String)querymap.get("tag"), (String)querymap.get("email"), (String)querymap.get("startDate"), (String)querymap.get("endDate"), (String)querymap.get("eName"), form.getWeixinhao());
        PageObj pageObj = new PageObj();
        pageObj.setCurrPageNumber(pageNo);
        pageObj.setFirstPageNumber(Integer.valueOf(1));
        pageObj.setLastPageNumber(pageObj.processTotalPage(page.getTotal(), Integer.valueOf(page.getPageSize())));
        pageObj.setPreviousPageNumber(pageObj.processPreviousPage(pageNo));
        pageObj.setNextPageNumber(pageObj.processNextPage());
        pageObj.setPageElements(page.getResult());
        pageObj.setPageSize(pageSize);
        pageObj.setTotalCount(Long.valueOf(page.getTotal()));
        ArrayList<StudentDto> dtoList = null;
        if (pageObj.getPageElements() != null && pageObj.getPageElements().size() > 0) {
            dtoList = new ArrayList<StudentDto>();
            StudentDto dtos = null;
            for (Object dto : pageObj.getPageElements()) {
                dtos = (StudentDto)dto;
                if (dtos.getBirthday() != null) {
                    dtos.setAge(String.valueOf(TimeZoneUtil.getAge(dtos.getBirthday())));
                }
                dtos.setCreateTimeStr(DateUtils.formatDateToDay((Date)dtos.getCreateTime()));
                dtoList.add(dtos);
            }
            pageObj.setPageElements(dtoList);
        }
        return pageObj;
    }

    @Override
    @Transactional(rollbackFor={Throwable.class}, propagation=Propagation.REQUIRED)
    public void saveStudent(AdminStudentEditSaveForm form, MultipartFile fileItem) {
        TStudent student = this.tStudentDao.findOne(form.getStuId());
        BeanUtils.copyProperties((Object)form, (Object)student);
        if (fileItem != null && StringUtil.isNotEmpty((String)fileItem.getOriginalFilename())) {
            String path = this.uploadPhotoService.savePhoto(fileItem, form.getAvatar(), "", "teacher");
            student.setAvatar(path);
        }
        if (StringUtils.isNotBlank((String)form.getLoginName())) {
            TLogin tLogin = new TLogin();
            tLogin.setLoginId(student.getLoginId());
            tLogin.setLoginName(form.getLoginName());
            tLogin.setUpdateTime(new Date());
            this.tLoginDao.updateByIdSelective(tLogin);
        }
        if (StringUtils.isNotBlank((String)form.getConsultantEmail()) && StringUtils.isNotBlank((String)form.getConsultantName())) {
            TConsultant consultant = this.tConsultantDao.findCounsultantByEmail(form.getConsultantEmail());
            TStudentConsultant studentConsultant = this.tStudentConsultantDao.findByStudentId(form.getStuId());
            if (studentConsultant != null && consultant != null) {
                studentConsultant.setConsultantEmail(form.getConsultantEmail());
                studentConsultant.setConsultantName(form.getConsultantName());
                studentConsultant.setConsultantId(consultant.getConsultantId());
                studentConsultant.setMobile(consultant.getMobile());
                studentConsultant.setUpdateTime(new Date());
                this.tStudentConsultantDao.updateByIdSelective(studentConsultant);
            } else if (studentConsultant == null && consultant != null) {
                studentConsultant = new TStudentConsultant();
                studentConsultant.setStuId(form.getStuId());
                studentConsultant.setConsultantEmail(form.getConsultantEmail());
                studentConsultant.setConsultantName(form.getConsultantName());
                studentConsultant.setConsultantId(consultant.getConsultantId());
                studentConsultant.setMobile(consultant.getMobile());
                this.tStudentConsultantDao.insertSelective(studentConsultant);
            } else if (studentConsultant == null && consultant == null) {
                studentConsultant = new TStudentConsultant();
                studentConsultant.setConsultantId(Integer.valueOf(1));
                studentConsultant.setMobile("18910070280");
                studentConsultant.setConsultantEmail("yanfengxue@talkilla.org");
                this.tStudentConsultantDao.insertSelective(studentConsultant);
            }
        }
        this.tStudentDao.updateByIdSelective(student);
    }

    @Override
    public PageObj getStudentCourseList(StudentCourseListQueryForm form, HttpServletRequest request) throws ParseException {
        HashMap<String, String> querymap = new HashMap<String, String>();
        Date dateEnd = null;
        if (form.getDateEnd() != null) {
            dateEnd = NoServiceUtil.correctDate((Date)form.getDateEnd());
        }
        if (StringUtils.isNotBlank((String)form.getClassid())) {
            querymap.put("classid", form.getClassid());
        }
        if (StringUtils.isNotBlank((String)form.getClassname())) {
            querymap.put("classname", form.getClassname());
        }
        if (StringUtils.isNotBlank((String)form.getStuname())) {
            querymap.put("stuname", form.getStuname());
        }
        if (StringUtils.isNotBlank((String)form.geteName())) {
            querymap.put("eName", form.geteName());
        }
        if (StringUtils.isNotBlank((String)form.getStuid())) {
            querymap.put("stuid", form.getStuid());
        }
        if (null != form.getIsgenerate()) {
            querymap.put("isgenerate", form.getIsgenerate() + "");
        }
        if (StringUtils.isNotBlank((String)form.getFirstname())) {
            querymap.put("firstname", form.getFirstname());
        }
        if (StringUtils.isNotBlank((String)form.getLastname())) {
            querymap.put("lastname", form.getLastname());
        }
        querymap.put("ctx", request.getContextPath());
        if (null != form.getDateStart()) {
            querymap.put("start", DateUtils.formatDateToDay((Date)form.getDateStart()));
        }
        if (dateEnd != null) {
            querymap.put("end", DateUtils.formatDateToSecond((Date)DateUtils.getDateEnd((Date)dateEnd)));
        }
        Integer pageNo = form.getPageNo();
        Integer pageSize = form.getPageSize();
        if (pageNo == null || pageNo == 0) {
            pageNo = 1;
        }
        if (pageSize == null || pageSize == 0) {
            pageSize = 10;
        }
        Page page = PageHelper.startPage((int)pageNo, (int)pageSize);
        this.tStudentDao.findStudentCourseList(querymap);
        PageObj pageObj = new PageObj();
        pageObj.setCurrPageNumber(pageNo);
        pageObj.setFirstPageNumber(Integer.valueOf(1));
        pageObj.setLastPageNumber(pageObj.processTotalPage(page.getTotal(), Integer.valueOf(page.getPageSize())));
        pageObj.setPreviousPageNumber(pageObj.processPreviousPage(pageNo));
        pageObj.setNextPageNumber(pageObj.processNextPage());
        pageObj.setPageElements(page.getResult());
        pageObj.setPageSize(pageSize);
        pageObj.setTotalCount(Long.valueOf(page.getTotal()));
        if (pageObj.getPageElements() != null && pageObj.getPageElements().size() > 0) {
            ArrayList<StudentCourseDto> dtoList = new ArrayList<StudentCourseDto>();
            List elements = pageObj.getPageElements();
            StudentCourseDto dtos = null;
            for (Object dto : elements) {
                dtos = (StudentCourseDto)dto;
                dtos.setClasstype("" + dtos.getType());
                dtos.setSessiontime(dtos.getStarttime());
                dtos.setStunames(dtos.getRealName());
                dtos.setTeacherid("" + dtos.getTeacherId());
                dtos.setTeachername(dtos.getFirstName() + " " + dtos.getLastName());
                dtoList.add(dtos);
            }
            pageObj.setPageElements(dtoList);
        }
        return pageObj;
    }

    @Override
    public AdminStudentCoursesessionInfoResult studentCoursesessionInfo(String cid_sessionid) {
        Integer cid = Integer.valueOf(cid_sessionid.split("-")[0]);
        Integer sessionid = Integer.valueOf(cid_sessionid.split("-")[1]);
        AdminStudentCoursesessionInfoResult info = this.tCoursesessionDao.studentCoursesessionInfo(sessionid);
        Date date = info.getStarttime();
        Calendar c = Calendar.getInstance();
        c.setTime(info.getStarttime());
        info.setHour(Integer.valueOf(c.get(11)));
        info.setMinute(Integer.valueOf(c.get(12)));
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm");
        System.out.println(sdf.format(c.getTime()));
        return info;
    }

    @Override
    public String studentCoursesessionInfoEdit(AdminStudentCoursesessionInfoEditForm form) {
        Calendar c = Calendar.getInstance();
        c.setTime(form.getDate());
        c.set(11, form.getHour());
        c.set(12, form.getMinute());
        TCoursesession tCoursesession = this.tCoursesessionDao.findOne(form.getSessionid());
        if (!Objects.equals(tCoursesession.getTeacherId(), form.getTeacherId())) {
            tCoursesession.setTeacherId(form.getTeacherId());
            TTeacher teacher = this.tTeacherDao.findOne(form.getTeacherId());
            tCoursesession.setClassRoom(teacher.getZoomId());
            if (null != teacher.getOneOnOne()) {
                tCoursesession.setRate(new BigDecimal(teacher.getOneOnOne()));
            }
        } else if (form.getRate() != null && new BigDecimal(form.getRate()).compareTo(tCoursesession.getRate()) != 0) {
            tCoursesession.setRate(new BigDecimal(form.getRate()));
        }
        tCoursesession.setStarttime(c.getTime());
        tCoursesession.setUpdateTime(new Date());
        this.tCoursesessionDao.updateByIdSelective(tCoursesession);
        return "\u4fdd\u5b58\u6210\u529f";
    }

    @Override
    @Transactional(rollbackFor={Throwable.class}, propagation=Propagation.REQUIRED)
    public AdminStudentCoursesessionInfoResult studentCoursesessionAdd(Integer sessionid) {
        AdminStudentCoursesessionInfoResult info = this.tCoursesessionDao.studentCoursesessionInfo(sessionid);
        if (info != null) {
            Calendar c = Calendar.getInstance();
            c.setTime(info.getStarttime());
            info.setHour(Integer.valueOf(c.get(11)));
            info.setMinute(Integer.valueOf(c.get(12)));
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm");
            System.out.println(sdf.format(c.getTime()));
            info.setStarttimestr(sdf.format(c.getTime()));
        } else {
            info = new AdminStudentCoursesessionInfoResult();
        }
        return info;
    }

    @Override
    @Transactional(rollbackFor={Throwable.class}, propagation=Propagation.REQUIRED)
    public synchronized ReturnMessageResult studentCoursesessionAddSave(AdminStudentCoursesessionAddSaveForm form) {
        ReturnMessageResult result = new ReturnMessageResult();
        result.setFlag(Integer.valueOf(0));
        TCourse tCourse = this.tCourseDao.findOne(form.getCid());
        if (form.getIsUseAward() == 1) {
            TAwardCourse awardCourse = this.tAwardCourseDao.findOneByStuId(tCourse.getStuId());
            if (awardCourse != null && awardCourse.getCourseNum() > 0.0) {
                if (!MathUtils.isBiggerOrEquals((BigDecimal)new BigDecimal(awardCourse.getCourseNum()), (BigDecimal)new BigDecimal((double)form.getDuration().intValue() / 60.0)).booleanValue()) {
                    result.setFlag(Integer.valueOf(1));
                    result.setMessage("\u5956\u52b1\u6c60\u8bfe\u65f6\u4f59\u989d\u4e0d\u8db3\uff0c\u65e0\u6cd5\u4f7f\u7528\u5956\u52b1\u6c60\u5185\u7684\u8bfe\u65f6");
                    return result;
                }
            } else {
                result.setFlag(Integer.valueOf(1));
                result.setMessage("\u5956\u52b1\u6c60\u8bfe\u65f6\u4f59\u989d\u4e0d\u8db3\uff0c\u65e0\u6cd5\u4f7f\u7528\u5956\u52b1\u6c60\u5185\u7684\u8bfe\u65f6");
                return result;
            }
        }
        TCoursesession tCoursesession = new TCoursesession();
        TTeacher teacher = this.tTeacherDao.findOne(form.getTeacherId());
        tCoursesession.setCourseType(tCourse.getType());
        tCoursesession.setCid(tCourse.getCid());
        Calendar c = Calendar.getInstance();
        c.setTime(form.getDate());
        c.set(11, form.getHour());
        c.set(12, form.getMinute());
        tCoursesession.setStarttime(c.getTime());
        tCoursesession.setTeacherId(form.getTeacherId());
        if (tCourse.getType() == 100001) {
            tCoursesession.setRate(new BigDecimal(teacher.getOneOnOne()));
        } else {
            tCoursesession.setRate(new BigDecimal(teacher.getOneOnMultiple()));
        }
        tCoursesession.setIspay(form.getIspay());
        tCoursesession.setDuration(form.getDuration());
        tCoursesession.setIsSystem(Integer.valueOf(1));
        tCoursesession.setNote(form.getNote());
        tCoursesession.setStuId(tCourse.getStuId());
        TStudent student = this.tStudentDao.findOne(tCourse.getStuId());
        tCoursesession.setStuName(student.getRealName());
        tCoursesession.setStuEnName(student.getEnglishName());
        BigDecimal price = this.courseCommonService.calculateCoursesessionPrice(CalculatePriceTypeEnums.ADDTIME_SAMEPRICE, tCourse.getCid(), 1, null);
        tCoursesession.setPrice(price);
        TCoursesession coursesession = this.tCoursesessionDao.findOneByCidAndTime(tCourse.getCid(), tCoursesession.getStarttime());
        if (coursesession != null) {
            result.setFlag(Integer.valueOf(1));
            result.setMessage("\u8bfe\u7a0b\u5df2\u5b58\u5728\uff0c\u8bf7\u4e0d\u8981\u91cd\u590d\u6dfb\u52a0");
            return result;
        }
        this.tCoursesessionDao.updatePriceByCidForNoCompleteAndIsPay(tCourse.getCid(), price);
        this.tCoursesessionDao.insertSelective(tCoursesession);
        List addBeforeStudentIdList = this.tCourseStudentDao.findStudentIdListByCid(tCourse.getCid());
        ArrayList<TCourseSessionStudent> tCourseSessionStudentList = new ArrayList<TCourseSessionStudent>();
        for (Integer stuId : addBeforeStudentIdList) {
            TCourseSessionStudent tCourseSessionStudent = new TCourseSessionStudent();
            tCourseSessionStudent.setCourseSessionId(tCoursesession.getSessionid());
            tCourseSessionStudent.setStudentId(stuId);
            tCourseSessionStudent.setCreater(String.valueOf(form.getLoginId()));
            tCourseSessionStudentList.add(tCourseSessionStudent);
        }
        this.tCourseSessionStudentDao.batchInsert(tCourseSessionStudentList);
        if (form.getIspay() == TalkillaConstant.COURSESESSION_FREE_TYPE) {
            this.tCourseService.processCourseCount(tCourse.getCid(), (double)form.getDuration().intValue() / 60.0, TalkillaConstant.CourseCountType.ADMIN_ADD_AWARD_COURSE);
            if (form.getIsUseAward() == 1) {
                if (StringUtils.isNotBlank((String)form.getNote())) {
                    this.tAwardCourseService.process(tCourse.getStuId(), (double)form.getDuration().intValue() / 60.0, TalkillaConstant.CourseAward.MINUS_FOR_ADMIN, form.getNote(), form.getCid());
                } else {
                    this.tAwardCourseService.process(tCourse.getStuId(), (double)form.getDuration().intValue() / 60.0, TalkillaConstant.CourseAward.MINUS_FOR_ADMIN, "\u540e\u53f0\u7ba1\u7406\u5458\u65b0\u589e\u5355\u8282\u8bfe\u76f4\u63a5\u6838\u9500", form.getCid());
                }
            } else if (StringUtils.isNotBlank((String)form.getNote())) {
                this.tAwardCourseService.process(tCourse.getStuId(), (double)form.getDuration().intValue() / 60.0, TalkillaConstant.CourseAward.AWARD_FOR_ADMIN, form.getNote(), form.getCid());
                this.tAwardCourseService.process(tCourse.getStuId(), (double)form.getDuration().intValue() / 60.0, TalkillaConstant.CourseAward.MINUS_FOR_ADMIN, form.getNote(), form.getCid());
            } else {
                this.tAwardCourseService.process(tCourse.getStuId(), (double)form.getDuration().intValue() / 60.0, TalkillaConstant.CourseAward.AWARD_FOR_ADMIN, "\u540e\u53f0\u7ba1\u7406\u5458\u65b0\u589e\u5355\u8282\u8bfe\u76f4\u63a5\u5956\u52b1", form.getCid());
                this.tAwardCourseService.process(tCourse.getStuId(), (double)form.getDuration().intValue() / 60.0, TalkillaConstant.CourseAward.MINUS_FOR_ADMIN, "\u540e\u53f0\u7ba1\u7406\u5458\u65b0\u589e\u5355\u8282\u8bfe\u76f4\u63a5\u6838\u9500", form.getCid());
            }
            try {
                WeChatTimeRewardNoticeForm _form = new WeChatTimeRewardNoticeForm();
                TStudent _tStudent = this.tStudentService.findOne(tCourse.getStuId());
                TWechat tWechat = this.tWechatService.getTWechatInfoByLoginId(_tStudent.getLoginId());
                TAwardCourse awardCourse = this.tAwardCourseDao.findOneByStuId(tCourse.getStuId());
                _form.setStudentRealName(_tStudent.getRealName());
                _form.setHourAwarded(String.valueOf((double)form.getDuration().intValue() / 60.0));
                _form.setHourAwardedPool(new BigDecimal(awardCourse.getCourseNum()).stripTrailingZeros().toString());
                _form.setType(2);
                _form.setComment(form.getNote());
                TCourse _tCourse = this.tCourseDao.findOne(form.getCid());
                _form.setCoursePackageId(_tCourse.getClassid());
                _form.setCoursePackageName(_tCourse.getClassname());
                _form.setOpenId(tWechat.getOpenid());
                this.commonEvent.publishTimeRewardNoticeEvent(_form);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            this.tCourseService.processCourseCount(tCourse.getCid(), (double)form.getDuration().intValue() / 60.0, TalkillaConstant.CourseCountType.ADMIN_ADD_NORMAL_COURSE);
        }
        return result;
    }

    @Override
    @Transactional(rollbackFor={Throwable.class}, propagation=Propagation.REQUIRED)
    public ReturnMessageResult studentCoursesessionDelete(UserDto user, Integer sessionid) {
        ReturnMessageResult messageResult = new ReturnMessageResult();
        TConsultant tConsultant = this.tConsultantDao.findByLoginId(user.getLoginId());
        if (tConsultant != null) {
            messageResult.setFlag(Integer.valueOf(1));
            messageResult.setMessage("\u8bfe\u7a0b\u987e\u95ee\u4e0d\u53ef\u4ee5\u5220\u9664\u8bfe\u7a0b");
            return messageResult;
        }
        TCoursesession tCoursesession = this.tCoursesessionDao.findOne(sessionid);
        if (tCoursesession == null || tCoursesession.getIsDelete() != 0) {
            messageResult.setFlag(Integer.valueOf(1));
            messageResult.setMessage("\u8be5\u8bfe\u7a0b\u5df2\u7ecf\u5220\u9664");
            return messageResult;
        }
        tCoursesession.setIsDelete(DateUtils.getNowSeconds());
        tCoursesession.setUpdateTime(new Date());
        this.tCoursesessionDao.updateByIdSelective(tCoursesession);
        if (TalkillaConstant.COURSESESSION_FREE_TYPE.equals(tCoursesession.getIspay())) {
            if (tCoursesession.getStatus() == null || tCoursesession.getStatus() == 0 || tCoursesession.getStatus().equals(TalkillaConstant.COURSE_STATUS_UMCONFIRMED)) {
                this.tCourseService.processCourseCount(tCoursesession.getCid(), (double)tCoursesession.getDuration().intValue() / 60.0, TalkillaConstant.CourseCountType.ADMIN_DELETE_AWARD_COURSE_2);
            } else if (tCoursesession.getStatus().equals(TalkillaConstant.COURSE_STATUS_ABSENT_STUDENT) || tCoursesession.getStatus().equals(TalkillaConstant.COURSE_STATUS_COMPLETED)) {
                this.tCourseService.processCourseCount(tCoursesession.getCid(), (double)tCoursesession.getDuration().intValue() / 60.0, TalkillaConstant.CourseCountType.ADMIN_DELETE_AWARD_COURSE_1);
            } else if (tCoursesession.getStatus().equals(TalkillaConstant.COURSE_STATUS_ABSENT_TEACHER)) {
                this.tCourseService.processCourseCount(tCoursesession.getCid(), (double)tCoursesession.getDuration().intValue() / 60.0, TalkillaConstant.CourseCountType.TEACHER_ABSENT);
            } else {
                this.logger.info("\u5176\u4ed6\u60c5\u51b5\u4e0d\u7528\u53d8\u66f4\u8bfe\u65f6\u6570");
            }
        } else if (tCoursesession.getStatus() == null || tCoursesession.getStatus() == 0 || tCoursesession.getStatus().equals(TalkillaConstant.COURSE_STATUS_UMCONFIRMED)) {
            this.tCourseService.processCourseCount(tCoursesession.getCid(), (double)tCoursesession.getDuration().intValue() / 60.0, TalkillaConstant.CourseCountType.ADMIN_DELETE_NORMAL_COURSE_2);
        } else if (tCoursesession.getStatus().equals(TalkillaConstant.COURSE_STATUS_ABSENT_STUDENT) || tCoursesession.getStatus().equals(TalkillaConstant.COURSE_STATUS_COMPLETED)) {
            this.tCourseService.processCourseCount(tCoursesession.getCid(), (double)tCoursesession.getDuration().intValue() / 60.0, TalkillaConstant.CourseCountType.ADMIN_DELETE_NORMAL_COURSE_1);
        } else if (tCoursesession.getStatus().equals(TalkillaConstant.COURSE_STATUS_ABSENT_TEACHER)) {
            this.tCourseService.processCourseCount(tCoursesession.getCid(), (double)tCoursesession.getDuration().intValue() / 60.0, TalkillaConstant.CourseCountType.ADMIN_DELETE_TEACHER_ABSENT_COURSE);
        } else {
            this.logger.info("\u5176\u4ed6\u60c5\u51b5\u4e0d\u7528\u53d8\u66f4\u8bfe\u65f6\u6570");
        }
        messageResult.setFlag(Integer.valueOf(0));
        messageResult.setMessage("\u5220\u9664\u6210\u529f");
        return messageResult;
    }

    @Override
    public PageObj studentSummaryList(AdminStudentSummaryListForm form) {
        Integer pageNo = form.getPageNo();
        Integer pageSize = form.getPageSize();
        if (pageNo == null || pageNo < 1) {
            pageNo = 1;
        }
        if (pageSize == null || pageSize < 0) {
            pageSize = 20;
        }
        Page page = PageHelper.startPage((int)pageNo, (int)pageSize);
        this.tStudentSummaryDao.studentSummaryList(form);
        PageObj pageObj = new PageObj();
        pageObj.setCurrPageNumber(pageNo);
        pageObj.setFirstPageNumber(Integer.valueOf(1));
        pageObj.setLastPageNumber(pageObj.processTotalPage(page.getTotal(), Integer.valueOf(page.getPageSize())));
        pageObj.setPreviousPageNumber(pageObj.processPreviousPage(pageNo));
        pageObj.setNextPageNumber(pageObj.processNextPage());
        pageObj.setPageElements(page.getResult());
        pageObj.setPageSize(pageSize);
        pageObj.setTotalCount(Long.valueOf(page.getTotal()));
        return pageObj;
    }

    @Override
    @Transactional(rollbackFor={Throwable.class}, propagation=Propagation.REQUIRED)
    public ReturnMessageResult studentSummaryEdit(AdminStudentSummaryEditForm form) {
        ReturnMessageResult messageResult = new ReturnMessageResult();
        TStudentSummary tStudentSummary = this.tStudentSummaryDao.findOne(form.getId());
        tStudentSummary.setSummary(form.getSummary());
        tStudentSummary.setStatus(form.getStatus());
        this.tStudentSummaryDao.updateByIdSelective(tStudentSummary);
        messageResult.setFlag(Integer.valueOf(0));
        messageResult.setMessage("\u66f4\u65b0\u6210\u529f");
        return messageResult;
    }

    @Override
    public TStudentSummary studentSummaryDetail(Integer id) {
        return this.tStudentSummaryDao.findOne(id);
    }

    @Override
    public AdminFindCourseResult findCourse(Integer cid) {
        return this.tCourseDao.findCourse(cid);
    }

    @Override
    public void deleteStudent(Integer stuId) {
        TStudent student = this.tStudentDao.findOne(stuId);
        if (null != student) {
            student.setIsDelete(DateUtils.getNowSeconds());
            this.tStudentDao.updateByIdSelective(student);
        }
        if (Objects.nonNull(student)) {
            TLogin tLogin = this.tLoginDao.findOne(student.getLoginId());
            tLogin.setIsDelete(DateUtils.getNowSeconds());
            this.tLoginDao.updateByIdSelective(tLogin);
        }
    }

    @Override
    public StudentRecommendDetailResult getStudentRecommendDetailByIdAndType(Integer recommendId, Integer recommendType) {
        StudentRecommendDetailResult result = new StudentRecommendDetailResult();
        if (recommendId == null || recommendId == 0 || recommendType == null || recommendType == 0) {
            return result;
        }
        if (recommendType == TalkillaConstant.RECOMMEND_TYPE_STUDENT) {
            TStudent student = this.tStudentDao.findOne(recommendId);
            TLogin login = this.tLoginDao.findOne(student.getLoginId());
            result.setEmail(login.getLoginName());
            result.setName(student.getRealName());
            result.setPhone(student.getPhone());
            result.setType(recommendType);
            result.setParentName(student.getParentName());
        } else if (recommendType == TalkillaConstant.RECOMMEND_TYPE_SCHOOL) {
            TDistributionUser distributionUser = this.tDistributionUserDao.findOne(recommendId);
            result.setType(recommendType);
            result.setPhone(distributionUser.getPhone());
            result.setName(distributionUser.getName());
            result.setEmail(distributionUser.getEmail());
        } else {
            return result;
        }
        return result;
    }

    @Override
    public ReturnMessageResult awardSave(StudentAwardForm form) {
        ReturnMessageResult result = new ReturnMessageResult();
        if (form.getStuId() == null || form.getStuId() == 0) {
            result.setFlag(Integer.valueOf(0));
            result.setMessage("\u5b66\u751f\u4e0d\u80fd\u4e3a\u7a7a");
            return result;
        }
        if (form.getCourseNum() == null || form.getCourseNum() == 0.0) {
            result.setFlag(Integer.valueOf(0));
            result.setMessage("\u5956\u52b1\u8bfe\u65f6\u4e3a\u7a7a");
            return result;
        }
        if (StringUtils.isBlank((String)form.getComment())) {
            result.setFlag(Integer.valueOf(0));
            result.setMessage("\u5907\u6ce8\u4e0d\u80fd\u4e3a\u7a7a");
            return result;
        }
        this.tAwardCourseService.process(form.getStuId(), form.getCourseNum(), TalkillaConstant.CourseAward.AWARD_FOR_ADMIN, form.getComment(), null);
        result.setFlag(Integer.valueOf(1));
        result.setMessage("\u4fdd\u5b58\u6210\u529f");
        return result;
    }

    @Override
    public PageObj awardList(Integer stuId, Integer pageNo, Integer pageSize) {
        Page page;
        if (pageNo != null && pageNo != 0 && pageSize != null && pageSize != 1) {
            page = PageHelper.startPage((int)pageNo, (int)pageSize);
        } else {
            pageNo = 1;
            pageSize = 20;
            page = PageHelper.startPage((int)pageNo, (int)pageSize);
        }
        this.tAwardCourseRecordDao.findByStuId(stuId);
        PageObj pageObj = new PageObj();
        pageObj.setCurrPageNumber(pageNo);
        pageObj.setFirstPageNumber(Integer.valueOf(1));
        pageObj.setLastPageNumber(pageObj.processTotalPage(page.getTotal(), Integer.valueOf(page.getPageSize())));
        pageObj.setPreviousPageNumber(pageObj.processPreviousPage(pageNo));
        pageObj.setNextPageNumber(pageObj.processNextPage());
        pageObj.setPageElements(page.getResult());
        pageObj.setPageSize(pageSize);
        pageObj.setTotalCount(Long.valueOf(page.getTotal()));
        return pageObj;
    }

    @Override
    public PageObj findTAwardCourseRecordList(Integer stuId, Integer pageNo, Integer pageSize) {
        Page page;
        if (pageNo != null && pageNo != 0 && pageSize != null && pageSize != 1) {
            page = PageHelper.startPage((int)pageNo, (int)pageSize);
        } else {
            pageNo = 1;
            pageSize = 10;
            page = PageHelper.startPage((int)pageNo, (int)pageSize);
        }
        TAwardCourseRecordForm form = new TAwardCourseRecordForm();
        form.setPageNo(pageNo);
        form.setPageSize(pageSize);
        form.setStuId(stuId);
        List _result = this.tAwardCourseRecordDao.findTAwardCourseRecordList(form);
        Collections.sort(_result, new Comparator<TAwardCourseRecord>(){

            @Override
            public int compare(TAwardCourseRecord o1, TAwardCourseRecord o2) {
                if (o1.getCreateTime().getTime() > o2.getCreateTime().getTime()) {
                    return 1;
                }
                if (o1.getCreateTime().getTime() == o2.getCreateTime().getTime()) {
                    return 0;
                }
                return -1;
            }
        });
        PageObj pageObj = new PageObj();
        pageObj.setCurrPageNumber(pageNo);
        pageObj.setFirstPageNumber(Integer.valueOf(1));
        pageObj.setLastPageNumber(pageObj.processTotalPage(page.getTotal(), Integer.valueOf(page.getPageSize())));
        pageObj.setPreviousPageNumber(pageObj.processPreviousPage(pageNo));
        pageObj.setNextPageNumber(pageObj.processNextPage());
        pageObj.setPageElements(page.getResult());
        pageObj.setPageSize(pageSize);
        pageObj.setTotalCount(Long.valueOf(page.getTotal()));
        return pageObj;
    }
}

