/*
 * Decompiled with CFR 0.152.
 */
package com.talkilla.service.impl.admin;

import com.talkilla.constant.TalkillaConstant;
import com.talkilla.form.admin.AdminLoginForm;
import com.talkilla.mysql.domain.TLogin;
import com.talkilla.mysql.domain.TMenu;
import com.talkilla.mysql.domain.TZonecode;
import com.talkilla.mysql.mapper.TCourseDao;
import com.talkilla.mysql.mapper.TLoginDao;
import com.talkilla.mysql.mapper.TMenuDao;
import com.talkilla.mysql.mapper.TStudentDao;
import com.talkilla.mysql.mapper.TZonecodeDao;
import com.talkilla.otherbean.CalendarDto;
import com.talkilla.otherbean.ZTreeNode;
import com.talkilla.result.admin.base.PageObj;
import com.talkilla.service.admin.AdminService;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.nestframework.commons.utils.StringUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="adminService")
public class AdminServiceImpl
implements AdminService {
    @Autowired
    TLoginDao tLoginDao;
    @Autowired
    TCourseDao tCourseDao;
    @Autowired
    TMenuDao tMenuDao;
    @Autowired
    TStudentDao tStudentDao;
    @Autowired
    TZonecodeDao tZonecodeDao;

    @Override
    public TLogin userLogin(AdminLoginForm form) {
        return this.tLoginDao.userLogin(form.getUsername(), form.getPassword());
    }

    @Override
    public String[] processAdminInfosByLoginId() {
        String[] res = new String[10];
        Calendar c = Calendar.getInstance();
        c.set(7, c.getActualMinimum(7));
        c.set(11, 0);
        c.set(12, 0);
        c.set(13, 0);
        Timestamp min = new Timestamp(c.getTime().getTime());
        c.setTime(new Date());
        c.add(5, 1);
        c.set(11, 0);
        c.set(12, 0);
        c.set(13, 0);
        Timestamp max = new Timestamp(c.getTime().getTime());
        res[0] = "" + this.tCourseDao.countThisWeekCoursessions(min, max);
        res[1] = "" + this.tCourseDao.countThisWeekConfirmCoursessions(min, max);
        res[2] = "" + this.tCourseDao.countThisWeekAutoMakeCoursessions();
        return res;
    }

    @Override
    public List<ZTreeNode> getMenuByLoginId(Integer loginId) {
        ArrayList<ZTreeNode> list = new ArrayList<ZTreeNode>();
        List menus = this.tMenuDao.findListByRoleId(Integer.valueOf(2));
        ZTreeNode znode = null;
        for (TMenu menu : menus) {
            znode = new ZTreeNode();
            znode.setId("" + menu.getMenuId());
            znode.setpId("" + menu.getParentId());
            znode.setName(menu.getMenuName());
            znode.setUrl(menu.getMenuUrl());
            list.add(znode);
        }
        return list;
    }

    @Override
    public List<ZTreeNode> getMenuByConsult() {
        ArrayList<ZTreeNode> list = new ArrayList<ZTreeNode>();
        List menus = this.tMenuDao.findListByRoleId(TalkillaConstant.KEY_LOGIN_TYPE_CONSULTANT);
        ZTreeNode znode = null;
        for (TMenu menu : menus) {
            znode = new ZTreeNode();
            znode.setId("" + menu.getMenuId());
            znode.setpId("" + menu.getParentId());
            znode.setName(menu.getMenuName());
            znode.setUrl(menu.getMenuUrl());
            list.add(znode);
        }
        return list;
    }

    @Override
    public List<CalendarDto> findAllCalendarsByLoginIdAndType(Integer id, Integer type) {
        return new ArrayList<CalendarDto>();
    }

    @Override
    public PageObj findQueryStudentList(Map querymap) {
        return null;
    }

    @Override
    public List<Map<String, String>> findAllBZone(String name) {
        ArrayList<Map<String, String>> res = null;
        if (res == null) {
            res = new ArrayList<Map<String, String>>();
            String sql = "SELECT zonecode ,name from zonecode  ";
            HashMap<String, String> mp = null;
            List allBZone = this.tZonecodeDao.findAllBZone();
            ArrayList<String[]> a = new ArrayList<String[]>();
            String[] s = null;
            for (TZonecode zonecode : allBZone) {
                s = new String[]{zonecode.getZonecode(), zonecode.getName()};
                a.add(s);
            }
            int len = a.size();
            for (int i = 0; i < len; ++i) {
                mp = new HashMap<String, String>();
                mp.put("id", ((String[])a.get(i))[0]);
                mp.put("text", ((String[])a.get(i))[1]);
                res.add(mp);
            }
        }
        if (StringUtil.isNotEmpty((String)name)) {
            ArrayList<Map<String, String>> r = new ArrayList<Map<String, String>>();
            int len = res.size();
            for (int i = 0; i < len; ++i) {
                if (!((String)((Map)res.get(i)).get("text")).contains(name)) continue;
                r.add((Map<String, String>)res.get(i));
            }
            return r;
        }
        return res;
    }
}

