/*
 * Decompiled with CFR 0.152.
 */
package com.talkilla.service.impl;

import com.talkilla.constant.ConstantBean;
import com.talkilla.exception.BusinessException;
import com.talkilla.service.UploadPhotoService;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service(value="uploadPhotoService")
public class UploadPhotoServiceImpl
implements UploadPhotoService {
    private static final Logger logger = LoggerFactory.getLogger(UploadPhotoServiceImpl.class);
    private ConstantBean constantBean;

    public void setConstantBean(ConstantBean constantBean) {
        this.constantBean = constantBean;
    }

    @Override
    public String checkPhoto(MultipartFile fileItem, String minphotosize, String photosize, String photopattern) {
        String fileName;
        String msg = "";
        if (fileItem != null && fileItem.getName() != null) {
            long filesize = fileItem.getSize();
            if (minphotosize != null && filesize / 1024L < new Long(minphotosize)) {
                msg = "\u5bf9\u4e0d\u8d77\uff0c\u60a8\u63d0\u4f9b\u7684\u7167\u7247\u5c3a\u5bf8\u5c0f\u4e8e" + minphotosize + "KB\uff0c\u65e0\u6cd5\u4e0a\u4f20\u3002\u8bf7\u60a8\u63d0\u4f9b\u5c3a\u5bf8\u5728" + minphotosize + "\u2014" + photosize + "KB\u4e4b\u95f4\u7684\u7167\u7247\uff01";
            } else if (photosize != null && filesize / 1024L > new Long(photosize)) {
                msg = "\u5bf9\u4e0d\u8d77\uff0c\u60a8\u63d0\u4f9b\u7684\u7167\u7247\u5c3a\u5bf8\u5927\u4e8e" + photosize + "KB\uff0c\u65e0\u6cd5\u4e0a\u4f20\u3002\u8bf7\u60a8\u63d0\u4f9b\u5c3a\u5bf8\u5728" + minphotosize + "\u2014" + photosize + "KB\u4e4b\u95f4\u7684\u7167\u7247\uff01";
            }
        }
        if (fileItem != null && fileItem.getName() != null && photopattern.indexOf(this.getExtName(fileName = fileItem.getName())) < 0) {
            msg = "\u5bf9\u4e0d\u8d77\uff0c\u60a8\u63d0\u4f9b\u7684\u7167\u7247\u683c\u5f0f\u4e0d\u5bf9\uff0c\u65e0\u6cd5\u4e0a\u4f20\u3002\u8bf7\u60a8\u63d0\u4f9b" + photopattern + "\u683c\u5f0f\u7684\u7167\u7247\u6587\u4ef6\uff01";
        }
        return msg;
    }

    @Override
    public String checkPhotoEn(MultipartFile fileItem, String minphotosize, String photosize, String photopattern) {
        String fileName;
        String msg = "";
        if (fileItem != null && fileItem.getName() != null) {
            long filesize = fileItem.getSize();
            if (minphotosize != null && filesize / 1024L < new Long(minphotosize)) {
                msg = "Sorry, the file size of your photo shall be between" + minphotosize + "KB and " + photosize + "KB.";
            } else if (photosize != null && filesize / 1024L > new Long(photosize)) {
                msg = "Sorry, the file size of your photo shall be between" + minphotosize + "KB and " + photosize + "KB.";
            }
        }
        if (fileItem != null && fileItem.getOriginalFilename() != null && photopattern.indexOf(this.getExtName(fileName = fileItem.getOriginalFilename())) < 0) {
            msg = "\u5bf9\u4e0d\u8d77\uff0c\u60a8\u63d0\u4f9b\u7684\u7167\u7247\u683c\u5f0f\u4e0d\u5bf9\uff0c\u65e0\u6cd5\u4e0a\u4f20\u3002\u8bf7\u60a8\u63d0\u4f9b" + photopattern + "\u683c\u5f0f\u7684\u7167\u7247\u6587\u4ef6\uff01";
        }
        return msg;
    }

    private String getExtName(String filename) {
        String extName = "";
        if (filename != null) {
            extName = filename.substring(filename.lastIndexOf(".") + 1);
        }
        return extName;
    }

    @Override
    public String savePhoto(File photoFile, String oldPhotoPath, String photoDirInPar, String generatePath) {
        try {
            String filePath = "";
            String photoDir = ConstantBean.get((String)"photopath");
            if (logger.isDebugEnabled()) {
                logger.info("\u5b58\u7167\u7247\u7684\u8def\u5f84photoDir=" + photoDir);
            }
            if (photoFile != null && photoFile.getName() != null) {
                int b;
                File file;
                File parent;
                String absolutePath = "";
                if (null != oldPhotoPath && !"".equals(oldPhotoPath)) {
                    absolutePath = photoDir + oldPhotoPath;
                    try {
                        File tempFile = new File(absolutePath);
                        if (tempFile.exists()) {
                            tempFile.delete();
                        }
                    }
                    catch (Exception e) {
                        throw new BusinessException((Object)"8888", "\u56fe\u7247\u4e0a\u4f20\u5931\u8d25");
                    }
                }
                if (!(parent = (file = new File(filePath = photoDir + File.separator + generatePath)).getParentFile()).exists()) {
                    parent.mkdirs();
                }
                BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(file));
                BufferedInputStream in = new BufferedInputStream(new FileInputStream(photoFile));
                while ((b = in.read()) != -1) {
                    out.write(b);
                }
                in.close();
                out.close();
                filePath = generatePath;
                if (logger.isDebugEnabled()) {
                    logger.info(filePath);
                }
            }
            return filePath;
        }
        catch (FileNotFoundException e) {
            logger.error(e.getMessage() + e.fillInStackTrace());
        }
        catch (IOException ioe) {
            logger.error(ioe.getMessage() + ioe.fillInStackTrace());
        }
        catch (Exception ep) {
            logger.error("\u4fdd\u5b58\u7167\u7247\u5f02\u5e38", (Throwable)ep);
        }
        return null;
    }

    @Override
    public String savePhoto(MultipartFile photo, String oldPhotoPath, String photoDirInPar, String generatePath) {
        try {
            String filePath = "";
            String photoDir = ConstantBean.get((String)"photopath");
            if (logger.isDebugEnabled()) {
                logger.info("\u5b58\u7167\u7247\u7684\u8def\u5f84photoDir=" + photoDir);
            }
            if (photo != null && photo.getOriginalFilename() != null) {
                String absolutePath = "";
                if (null != oldPhotoPath && !"".equals(oldPhotoPath)) {
                    absolutePath = photoDir + File.separator + oldPhotoPath;
                    try {
                        File tempFile = new File(absolutePath);
                        if (tempFile.exists()) {
                            tempFile.delete();
                        }
                    }
                    catch (Exception e) {
                        throw new BusinessException((Object)"8888", "\u56fe\u7247\u4e0a\u4f20\u5931\u8d25");
                    }
                }
                String res = generatePath + File.separator + System.currentTimeMillis() + "." + this.getExtName(photo.getOriginalFilename());
                filePath = photoDir + File.separator + res;
                File file = new File(filePath);
                if (!file.exists()) {
                    file.createNewFile();
                }
                photo.transferTo(file);
                filePath = res;
                if (logger.isDebugEnabled()) {
                    logger.info(filePath);
                }
            }
            return filePath;
        }
        catch (FileNotFoundException e) {
            logger.error(e.getMessage() + e.fillInStackTrace());
        }
        catch (IOException ioe) {
            logger.error(ioe.getMessage() + ioe.fillInStackTrace());
        }
        catch (Exception ep) {
            logger.error("\u4fdd\u5b58\u7167\u7247\u5f02\u5e38", (Throwable)ep);
        }
        return null;
    }

    @Override
    public String loadPhotoRootPath(String photo_url_prefix, String PhotoPath) {
        if (null == PhotoPath || PhotoPath.equals("")) {
            return "";
        }
        String mapUrlPrefix = ConstantBean.get((String)"photopath");
        if (!mapUrlPrefix.endsWith("/")) {
            mapUrlPrefix = mapUrlPrefix + "/";
        }
        return mapUrlPrefix + PhotoPath;
    }
}

