/*
 * Decompiled with CFR 0.152.
 */
package com.talkilla.service.impl;

import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.talkilla.constant.TalkillaConstant;
import com.talkilla.form.admin.AdminTeacherAddBonusForm;
import com.talkilla.form.student.QueryTeacherByTempCourseForm;
import com.talkilla.mysql.domain.TCoursesession;
import com.talkilla.mysql.domain.TSysdict;
import com.talkilla.mysql.domain.TTeacher;
import com.talkilla.mysql.mapper.TCoursesessionDao;
import com.talkilla.mysql.mapper.TLoginDao;
import com.talkilla.mysql.mapper.TTeacherDao;
import com.talkilla.result.ReturnMessageResult;
import com.talkilla.result.admin.TeacherListResult;
import com.talkilla.result.admin.base.PageObj;
import com.talkilla.service.TSysdictService;
import com.talkilla.service.TTeacherService;
import com.talkilla.serviceUtils.TalkillaEmailMessageUtils;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import org.apache.commons.httpclient.util.DateParseException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="tTeacherService")
public class TTeacherServiceImpl
implements TTeacherService {
    @Autowired
    private TTeacherDao tTeacherDao;
    @Autowired
    private TLoginDao tLoginDao;
    @Autowired
    TSysdictService tSysdictService;
    @Autowired
    TCoursesessionDao tCoursesessionDao;

    @Override
    public TTeacher findOne(Integer teacherId) {
        return this.tTeacherDao.findOne(teacherId);
    }

    @Override
    public List<TeacherListResult> getAllTeachers() {
        return this.tTeacherDao.getAllTeachers();
    }

    @Override
    public PageObj getTeacherList(QueryTeacherByTempCourseForm form) {
        List<TSysdict> teacherFenlei;
        Optional<TSysdict> reject;
        Integer pageNo = form.getPageNo();
        Integer pageSize = form.getPageSize();
        if (pageNo == null || pageNo == 0) {
            pageNo = 1;
        }
        if (pageSize == null || pageSize == 0) {
            pageSize = 10;
        }
        form.setRejectType(Integer.valueOf((reject = (teacherFenlei = this.tSysdictService.findTeacherFenlei()).stream().filter(tSysdict -> tSysdict.getDictname().equals("\u62d2\u7edd")).findAny()).isPresent() ? reject.get().getDictid() : 0));
        Page page = PageHelper.startPage((int)pageNo, (int)pageSize);
        this.tTeacherDao.teacherByTempCourseContion(form);
        List result = page.getResult();
        PageObj pageObj = new PageObj();
        pageObj.setCurrPageNumber(pageNo);
        pageObj.setFirstPageNumber(Integer.valueOf(1));
        pageObj.setLastPageNumber(pageObj.processTotalPage(page.getTotal(), Integer.valueOf(page.getPageSize())));
        pageObj.setPreviousPageNumber(pageObj.processPreviousPage(pageNo));
        pageObj.setNextPageNumber(pageObj.processNextPage());
        pageObj.setPageElements(result);
        pageObj.setPageSize(pageSize);
        pageObj.setTotalCount(Long.valueOf(page.getTotal()));
        return pageObj;
    }

    @Override
    public List<TTeacher> findByTeacherIds(List<Integer> teacherIds) {
        return this.tTeacherDao.findByTeacherIds(teacherIds);
    }

    @Override
    public ReturnMessageResult addTeacherBonus(AdminTeacherAddBonusForm form) throws DateParseException {
        TCoursesession record = new TCoursesession();
        record.setCid(TalkillaConstant.TeacherBonus.CID);
        record.setCourseType(Integer.valueOf(100001));
        record.setDuration(TalkillaConstant.TeacherBonus.DURATION);
        record.setIspay(TalkillaConstant.COURSESESSION_FREE_TYPE);
        record.setPrice(new BigDecimal(0));
        record.setRate(form.getBonus());
        record.setStatus(TalkillaConstant.COURSE_STATUS_COMPLETED);
        record.setStuId(TalkillaConstant.TeacherBonus.STU_ID);
        record.setStarttime(new Date(form.getBonusDate().getTime() + 3600000L));
        record.setStuEnName("Talkilla");
        record.setStuName("Talkilla");
        record.setTeacherId(form.getTeacherId());
        this.tCoursesessionDao.insertSelective(record);
        TTeacher teacher = this.tTeacherDao.findOne(form.getTeacherId());
        String email = this.tLoginDao.findByTeacherId(teacher.getTeacherId());
        TalkillaEmailMessageUtils.sendTeacherBonusEmail(email, teacher, form.getBonus(), form.getReason());
        ReturnMessageResult result = new ReturnMessageResult();
        result.setFlag(Integer.valueOf(0));
        result.setMessage("\u52a0\u5956\u6210\u529f");
        return result;
    }
}

