/*
 * Decompiled with CFR 0.152.
 */
package com.talkilla.service.impl;

import com.talkilla.constant.TalkillaConstant;
import com.talkilla.form.SearchStudentsForm;
import com.talkilla.form.admin.RecommendSaveForm;
import com.talkilla.mysql.domain.TStudent;
import com.talkilla.mysql.domain.TWechat;
import com.talkilla.mysql.mapper.TCourseStudentDao;
import com.talkilla.mysql.mapper.TStudentDao;
import com.talkilla.mysql.mapper.TWechatDao;
import com.talkilla.otherbean.StudentDto;
import com.talkilla.service.TStudentService;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="studentService")
public class TStudentServiceImpl
implements TStudentService {
    @Autowired
    private TStudentDao tStudentDao;
    @Autowired
    private TWechatDao tWechatDao;
    @Autowired
    private TCourseStudentDao tCourseStudentDao;

    @Override
    public TStudent findStudentByLoginId(Integer loginId) {
        return this.tStudentDao.findStudentByLoginId(loginId);
    }

    @Override
    public int updateByIdSelective(TStudent record) {
        return this.tStudentDao.updateByIdSelective(record);
    }

    @Override
    public TStudent findOne(Integer stuId) {
        return this.tStudentDao.findOne(stuId);
    }

    @Override
    public TStudent findStudentByOpenId(String openId) {
        TWechat wechat = this.tWechatDao.getTWechatByopenid(openId);
        if (wechat != null) {
            return this.tStudentDao.findStudentByLoginId(wechat.getLoginId());
        }
        return null;
    }

    @Override
    public List<StudentDto> findListsbyRemoveIds(SearchStudentsForm form) {
        return this.tStudentDao.findListsbyRemoveIds(form);
    }

    @Override
    public List<StudentDto> findByPids(SearchStudentsForm form) {
        return this.tStudentDao.findByPids(form);
    }

    @Override
    public void recommendSave(RecommendSaveForm form) {
        TStudent student = this.tStudentDao.findOne(form.getStuId());
        student.setRecommendId(form.getRecommendId());
        student.setRecommendType(TalkillaConstant.RECOMMEND_TYPE_STUDENT);
        student.setUpdateTime(new Date());
        this.tStudentDao.updateByIdSelective(student);
    }
}

